/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.repairitems.base;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.plugin.ICheckRepairPlugin;
import kd.imsc.dmw.utils.CommonUtils;

public class MeasurementPrecisionRepairPlugin
implements ICheckRepairPlugin {
    private static final Log logger = LogFactory.getLog(MeasurementPrecisionRepairPlugin.class);
    private static final String PRECISION = "precision";

    @Override
    public RepairResponse doExecute(RepairPluginParam param) {
        RepairResponse repairResponse = new RepairResponse();
        CheckItemLog checkItemLog = param.getCheckItemLog();
        Map<String, Object> paramMap = checkItemLog.getParamMap();
        String isSupport = (String)paramMap.get("isSupportRepair");
        String errMsg = "";
        if ("no".equals(isSupport)) {
            errMsg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e00\u952e\u4fee\u590d\uff0c\u8bf7\u5148\u521b\u5efa\u8ba1\u91cf\u5355\u4f4d", (String)"MeasurementPrecisionRepairPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            repairResponse.setDetail(errMsg);
            repairResponse.setFailCount(1L);
            repairResponse.setStauts("B");
            return repairResponse;
        }
        QFilter filter = new QFilter("number", "in", (Object)new String[]{"cm", "g", "kg", "m", "mm", "t"});
        DynamicObject[] currencyArray = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"id,number,name,precision", (QFilter[])filter.toArray());
        int sum = 0;
        for (DynamicObject currency : currencyArray) {
            String num = currency.getString("number");
            Object precision = paramMap.get(num);
            if (CommonUtils.isNull(precision)) continue;
            currency.set(PRECISION, precision);
            ++sum;
        }
        try {
            OperationResult result = SaveServiceHelper.saveOperate((String)"bd_measureunits", (DynamicObject[])currencyArray);
            if (result.isSuccess()) {
                repairResponse.setSuccessCount(Long.valueOf(sum));
                repairResponse.setStauts("A");
            } else {
                List errInfoList = result.getAllErrorOrValidateInfo();
                logger.error(errInfoList.toString());
                repairResponse.setStauts("B");
                repairResponse.setDetail(errInfoList.toString());
                repairResponse.setSuccessCount(Long.valueOf(sum - errInfoList.size()));
                repairResponse.setFailCount(Long.valueOf(errInfoList.size()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            repairResponse.setStauts("B");
            repairResponse.setDetail(e.getMessage());
        }
        return repairResponse;
    }
}

