/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.engine.multiimport.result.ImportSimpleResult;
import kd.imsc.dmw.enums.ImpFailCodeEnum;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.TimeUtils;

public class TaskExcuteReportHelper {
    private TaskExcuteReportHelper() {
    }

    public static DynamicObject save(Map<String, Object> basicInfo, Map<String, Object> excuteResults) {
        DynamicObject dynamicObject = TaskExcuteReportHelper.transExcuteReport(basicInfo, excuteResults);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u5efa\u4efb\u52a1\u6267\u884c\u62a5\u544a\u6570\u636e\u5305\u5931\u8d25\u3002", (String)"TaskExcuteReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        SaveServiceHelper.saveOperate((String)"dmw_task_excute_report", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        return dynamicObject;
    }

    private static DynamicObject transExcuteReport(Map<String, Object> basicInfo, Map<String, Object> excuteResults) {
        if (ObjectUtils.isEmpty(basicInfo) || ObjectUtils.isEmpty(excuteResults)) {
            return null;
        }
        DynamicObject data = DynamicObjectUtils.buildDynamicObject("dmw_task_excute_report");
        TaskExcuteReportHelper.setHeadInfo(data, basicInfo);
        DynamicObjectCollection collection = data.getDynamicObjectCollection("task_details");
        TaskExcuteReportHelper.setEntryEntity(collection, excuteResults);
        int totalSuccessCnt = 0;
        int totalFailCnt = 0;
        for (DynamicObject dynamicObject : collection) {
            if (dynamicObject.containsProperty("successcnt")) {
                totalSuccessCnt += dynamicObject.getInt("successcnt");
            }
            if (!dynamicObject.containsProperty("failcnt")) continue;
            totalFailCnt += dynamicObject.getInt("failcnt");
        }
        data.set("totalsuccesscnt", (Object)totalSuccessCnt);
        data.set("totalfailcnt", (Object)totalFailCnt);
        return data;
    }

    private static void setHeadInfo(DynamicObject data, Map<String, Object> basicInfo) {
        Object impEndTime;
        if (data == null || ObjectUtils.isEmpty(basicInfo)) {
            return;
        }
        String number = DynamicObjectUtils.autoNumber(data, "dmw_task_excute_report", null);
        data.set("billno", (Object)number);
        Object importTaskId = basicInfo.get("im_t_id");
        if (importTaskId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1ID\uff0c\u65e0\u6cd5\u751f\u6210\u4efb\u52a1\u6267\u884c\u62a5\u544a\u3002", (String)"TaskExcuteReportHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        data.set("taskno", importTaskId);
        Object impStatus = basicInfo.get("impstatus");
        if (impStatus != null) {
            data.set("impstatus", impStatus);
        }
        data.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        Object impDataTime = basicInfo.get("impdatetime");
        if (impDataTime != null) {
            data.set("impdatetime", impDataTime);
        }
        if ((impEndTime = basicInfo.get("endtime")) != null) {
            data.set("endtime", impEndTime);
        }
        String duration = TimeUtils.duration(impDataTime, impEndTime);
        data.set("duration", (Object)duration);
    }

    private static void setEntryEntity(DynamicObjectCollection collection, Map<String, Object> excuteResults) {
        if (collection == null || ObjectUtils.isEmpty(excuteResults)) {
            return;
        }
        for (Map.Entry<String, Object> entry : excuteResults.entrySet()) {
            String entityId = entry.getKey();
            if ("FCODE".equals(entityId) || "MSG".equals(entityId)) continue;
            ImportSimpleResult value = (ImportSimpleResult)entry.getValue();
            DynamicObject dynamicObject = collection.addNew();
            TaskExcuteReportHelper.setEntryDetails(dynamicObject, value, entityId);
        }
    }

    private static void setEntryDetails(DynamicObject dynamicObject, ImportSimpleResult excuteResult, String entityId) {
        if (dynamicObject == null || excuteResult == null || StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        String status = "B";
        if (excuteResult.getFailCode() == ImpFailCodeEnum.SUCCESS && excuteResult.getTotal() > 0 && excuteResult.getFail() <= 0) {
            status = "A";
        }
        dynamicObject.set("execstatus", (Object)status);
        dynamicObject.set("billentityno", (Object)entityId);
        dynamicObject.set("entityname", (Object)excuteResult.getFormName());
        dynamicObject.set("start", (Object)excuteResult.getStartTime());
        dynamicObject.set("end", (Object)excuteResult.getEndTime());
        dynamicObject.set("successcnt", (Object)(excuteResult.getTotal() - excuteResult.getFail()));
        dynamicObject.set("failcnt", (Object)excuteResult.getFail());
        dynamicObject.set("cnt", (Object)excuteResult.getTotal());
        dynamicObject.set("implog", excuteResult.getLogId());
        dynamicObject.set("failreason", (Object)excuteResult.getMsg());
    }
}

