/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.install;

import java.io.File;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.install.ISubDataImportHandler;
import kd.imsc.dmw.engine.multiimport.model.SubDataCheckResult;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallResult;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;

public abstract class AbstractSubDataImportHandler
implements ISubDataImportHandler {
    private static final Log logger = LogFactory.getLog(AbstractSubDataImportHandler.class);

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = new SubDataCheckResult();
        StringBuilder errorMsg = new StringBuilder();
        if (configInfo == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u5b50\u5305\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01", (String)"AbstractSubDataImportHandler_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            SubDataInstallInfo installInfo;
            String subFilePath;
            logger.info("\u5f00\u59cb\u6570\u636e\u5305{}\u57fa\u7840\u68c0\u67e5\uff0c\u6570\u636e\u5305\u5b58\u653e\u6587\u4ef6\u5939\u8def\u5f84\u4e3a{}", (Object)configInfo.getFileName(), (Object)configInfo.getFileDirectory());
            if (StringUtils.isEmpty((CharSequence)configInfo.getFileName())) {
                errorMsg.append(ResManager.loadKDString((String)"\u5b50\u5305\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01", (String)"AbstractSubDataImportHandler_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            if (!FileUtils.isFileExistWithFilePath((String)configInfo.getFileDirectory())) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u3010%1$s\u3011\u6587\u4ef6\u5b58\u653e\u8def\u5f84\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\uff01", (String)"AbstractSubDataImportHandler_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), configInfo.getFileName()));
            }
            if (!FileUtils.isFileExistWithFilePath((String)(subFilePath = configInfo.getFileDirectory() + File.separator + configInfo.getFileName()))) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u3010%1$s\u3011\u6587\u4ef6\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (String)"AbstractSubDataImportHandler_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), subFilePath));
            }
            if (configInfo.getInstallInfo() == null) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u3010%1$s\u3011\u65e0\u5b89\u88c5\u5177\u4f53\u914d\u7f6e\u6587\u4ef6\uff01", (String)"AbstractSubDataImportHandler_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), configInfo.getFileName()));
            }
            if (StringUtils.isEmpty((CharSequence)(installInfo = configInfo.getInstallInfo()).getFormId())) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u3010%1$s\u3011\u65e0\u5b89\u88c5\u5230\u6307\u5b9a\u9875\u9762\u5355\u636e\u6807\u8bc6\u5f53\u4e2d\uff01", (String)"AbstractSubDataImportHandler_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), configInfo.getFileName()));
            }
        }
        if (StringUtil.isEmpty(errorMsg.toString())) {
            checkResult.setSuccess(true);
        } else {
            checkResult.setFail(errorMsg.toString());
        }
        return checkResult;
    }

    public SubDataInstallResult executeImport(SubDataConfigureInfo configInfo, boolean waitResult) throws DmwImptException {
        SubDataCheckResult subDataCheckResult = this.checkSubDataPackageFile(configInfo);
        if (!subDataCheckResult.isSuccess()) {
            throw new DmwImptException(subDataCheckResult.getErrorMsg(), 404);
        }
        return this.installPacket(configInfo, waitResult);
    }
}

