/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.install;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.helper.StdImportHelper;
import kd.imsc.dmw.engine.multiimport.install.AbstractSubDataImportHandler;
import kd.imsc.dmw.engine.multiimport.model.SubDataCheckResult;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallResult;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.utils.FileUtils;

public class StdImportHandlerImpl
extends AbstractSubDataImportHandler {
    private static final Log logger = LogFactory.getLog(StdImportHandlerImpl.class);
    private static final String XLXS = ".xlsx";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cbExcel\u683c\u5f0f\u6570\u636e\u5305 {} \u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        if (!FileUtils.isFileZipFormatWithFileName((String)configInfo.getFileName()) && !configInfo.getFileName().endsWith(XLXS)) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u3010%1$s\u3011\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u6587\u4ef6\u683c\u5f0f\u53ea\u5141\u8bb8.zip\u6216.xlsx\u683c\u5f0f\uff01", (String)"StdImportHandlerImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, boolean waitResult) {
        SubDataInstallResult installResult = new SubDataInstallResult(configInfo.getFileName());
        SubDataInstallInfo installInfo = configInfo.getInstallInfo();
        String formId = installInfo.getFormId();
        List<Map<String, String>> fileInfoList = null;
        try {
            fileInfoList = this.uploadExcelsIntoFileService(configInfo.getFileName(), configInfo.getFileDirectory(), installInfo);
            logger.info("Upload std excel result {}", (Object)JSON.toJSONString(fileInfoList));
        }
        catch (DmwImptException e) {
            installResult.setSuccess(false);
            installResult.setError(e.getMessage());
            return installResult;
        }
        if (fileInfoList == null || fileInfoList.isEmpty()) {
            installResult.setError(ResManager.loadKDString((String)"\u7cfb\u7edf\u6807\u51c6\u5bfc\u5165\u5931\u8d25\uff0c\u5b50\u5305\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", (String)"StdImportHandlerImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return installResult;
        }
        HashMap<String, String> excelMap = new HashMap<String, String>(4);
        excelMap.put("KeyFields", installInfo.getKeyFields());
        excelMap.put("OverrideEntry", String.valueOf(true));
        excelMap.put("Type", installInfo.getDataImportType());
        String pageType = StdImportHelper.getPageTypeWithFormId(installInfo.getFormId());
        return StdImportHelper.batchExecuteExcelImport(fileInfoList.get(0), formId, pageType, excelMap, waitResult);
    }

    private List<Map<String, String>> uploadExcelsIntoFileService(String fileName, String filePath, SubDataInstallInfo installInfo) throws DmwImptException {
        return StdImportHelper.handleSimpleExcelIntoFileService(new File(filePath + File.separator + fileName), installInfo.getFormId());
    }
}

