/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.List;
import java.util.Map;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.model.AllEntityDataInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldMappingInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelRowInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelSheetMappingModel;
import kd.imsc.dmw.engine.multiimport.model.SheetDataInfoModel;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ReadSheetRowHandler
extends SheetHandler {
    private static final Log logger = LogFactory.getLog(ReadSheetRowHandler.class);
    private List<ExcelSheetMappingModel> sheetMappingList;
    private AllEntityDataInfoModel allEntityDataInfo;
    private int count = 0;
    private long time = System.currentTimeMillis();

    public ReadSheetRowHandler(List<ExcelSheetMappingModel> sheetMappingList) {
        super.setInterrupt(false);
        this.sheetMappingList = sheetMappingList;
        this.allEntityDataInfo = new AllEntityDataInfoModel();
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName().trim();
        for (ExcelSheetMappingModel excelSheetMappingModel : this.sheetMappingList) {
            String formId = excelSheetMappingModel.getFormIdMap().get(sheetName);
            List<ExcelFieldMappingInfoModel> fieldList = excelSheetMappingModel.getCustomFieldMap().get(sheetName);
            int rowIndex = row.getRowNum();
            if (rowIndex == 0 || CommonUtils.isNull(fieldList)) continue;
            String relValue = "";
            block1: for (ExcelFieldMappingInfoModel fieldMapInfo : fieldList) {
                boolean isRelField = false;
                if (excelSheetMappingModel.getRelSheetNameList().contains(sheetName) && fieldMapInfo.getCustomFieldKey().split("\\.")[1].equals(excelSheetMappingModel.getSheetRelField())) {
                    isRelField = true;
                }
                for (Map.Entry entry : row.getData().entrySet()) {
                    String value;
                    if (fieldMapInfo.getCustomColumnIndex() != ((Integer)entry.getKey()).intValue() || !StringUtil.isEmpty(value = (String)entry.getValue()) && !isRelField && !StringUtil.isEmpty(fieldMapInfo.getStdFieldKey())) continue;
                    relValue = value;
                    continue block1;
                }
            }
            if (!fieldList.isEmpty()) {
                this.allEntityDataInfo.setSheetDataInfoModel(formId);
                SheetDataInfoModel sheetModel = this.allEntityDataInfo.getSheetDataInfoModelByFormId(formId);
                ExcelRowInfoModel infoModel = ExcelRowInfoModel.getInstance();
                infoModel.setExcelFieldInfoModelList(fieldList, row.getData());
                if (sheetName.equals(excelSheetMappingModel.getMainSheetName())) {
                    sheetModel.addMainSheetDataRowList(infoModel);
                } else {
                    sheetModel.addRelSheetRowFieldMap(relValue, sheetName, infoModel);
                }
            }
            ++this.count;
            if (this.count % 100000 != 0) continue;
            logger.info("sheetName:" + sheetName + "totalcount:" + this.count + " handleRow end:" + (System.currentTimeMillis() - this.time));
            this.time = System.currentTimeMillis();
        }
    }

    public AllEntityDataInfoModel getAllEntityDataInfo() {
        return this.allEntityDataInfo;
    }
}

