/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.eas;

import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.OpenFileFormat;
import com.grapecity.documents.excel.PageOrientation;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.eas.core.log.ReportPushLog;
import kd.imsc.dmw.entity.RowDataInfo;
import kd.imsc.dmw.enums.MergeReportTypeEnum;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EasReportHelper {
    private static final Log logger = LogFactory.getLog(EasReportHelper.class);

    public static String getBgRptDownFileName(DynamicObject rptDynObj) {
        StringBuilder builder = new StringBuilder();
        builder.append(EasReportHelper.getDynString(rptDynObj, "bgschemename"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "bgschemenumber"));
        builder.append(EasReportHelper.getDynString(rptDynObj.getDynamicObject("orgunitid"), "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "number"));
        builder.append(rptDynObj.getPkValue());
        return builder.toString();
    }

    public static String getMergeBgRptDownFileName(DynamicObject rptDynObj) {
        StringBuilder builder = new StringBuilder();
        builder.append(EasReportHelper.getDynString(rptDynObj, "orgtreename"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "bgschemename"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "bgschemenumber"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "orgmergename"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "number"));
        builder.append(rptDynObj.getPkValue());
        return builder.toString();
    }

    public static String getFiRptDownFileName(DynamicObject rptDynObj) {
        StringBuilder builder = new StringBuilder();
        builder.append(EasReportHelper.getDynString(rptDynObj.getDynamicObject("org"), "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "reporttime"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "number"));
        builder.append(rptDynObj.getPkValue());
        return builder.toString();
    }

    public static String getFiMergeRptDownFileName(DynamicObject rptDynObj) {
        Date reportDate;
        StringBuilder builder = new StringBuilder();
        builder.append(EasReportHelper.getDynString(rptDynObj, "orgmergename"));
        String rpType = MergeReportTypeEnum.getName((String)rptDynObj.getString("rptype"));
        if (StringUtil.isNotEmpty(rpType)) {
            builder.append(rpType).append("-");
        }
        if ((reportDate = rptDynObj.getDate("reportdate")) != null) {
            builder.append(DateUtils.format((Date)rptDynObj.getDate("reportdate"), (String)"yyyy-MM-dd")).append("-");
        }
        builder.append(EasReportHelper.getDynString(rptDynObj, "name"));
        builder.append(EasReportHelper.getDynString(rptDynObj, "number"));
        builder.append(rptDynObj.getPkValue());
        return builder.toString();
    }

    private static String getDynString(DynamicObject rptDynObj, String key) {
        String value = DynamicObjectUtils.getString(rptDynObj, key);
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        return value + "-";
    }

    public static void exportRptDataToPdf(Map<String, List<Map<String, Object>>> attachments, String tempName, IFormView view) {
        if (CommonUtils.isNull(attachments)) {
            throw new DmwBizException(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u65e0\u62a5\u8868\u6570\u636e\u9644\u4ef6\u3002", (String)"EasReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        List<String> subPdfUrlsList = EasReportHelper.getSubPdfUrlsList(attachments);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        mergePdf.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        mergePdf.setAcroFormMergeMode(PDFMergerUtility.AcroFormMergeMode.JOIN_FORM_FIELDS_MODE);
        for (String f : subPdfUrlsList) {
            mergePdf.addSource(cache.getInputStream(f));
        }
        String currTimeFormat = DateUtils.getCurrTimeFormat((String)"yyyyMMddHHmmss");
        String targetPath = tempName + currTimeFormat + ".pdf";
        mergePdf.setDestinationFileName(targetPath);
        String pdfUrl = "";
        try (ByteArrayOutputStream pdfOutputStream = new ByteArrayOutputStream();){
            mergePdf.setDestinationStream((OutputStream)pdfOutputStream);
            mergePdf.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
            pdfUrl = cache.saveAsUrl(targetPath, pdfOutputStream.toByteArray(), 5000);
            PDDocument document = PDDocument.load((InputStream)cache.getInputStream(pdfUrl));
            int numberOfPages = document.getNumberOfPages();
            for (int i = 0; i < numberOfPages; ++i) {
                PDPage page = document.getPage(i);
                float width = page.getMediaBox().getWidth();
                PDPageContentStream pageContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                pageContentStream.beginText();
                pageContentStream.newLineAtOffset(width / 2.0f - 10.0f, 20.0f);
                try {
                    File file = new File(KDFont.getFontFilesDir());
                    if (!file.exists()) {
                        pageContentStream.setFont((PDFont)PDType1Font.SYMBOL, 8.0f);
                    } else {
                        pageContentStream.setFont((PDFont)PDType0Font.load((PDDocument)document, (File)file), 8.0f);
                    }
                }
                catch (Exception e) {
                    pageContentStream.setFont((PDFont)PDType1Font.SYMBOL, 8.0f);
                }
                pageContentStream.showText(String.format("%d/%s", i + 1, numberOfPages));
                pageContentStream.endText();
                pageContentStream.restoreGraphicsState();
                pageContentStream.close();
            }
            document.save((OutputStream)pdfOutputStream);
            pdfUrl = cache.saveAsUrl(targetPath, pdfOutputStream.toByteArray(), 5000);
            EasReportHelper.addDownloadPermission(pdfUrl, view);
            view.download(pdfUrl);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream readExcel(InputStream stream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (XSSFWorkbook workBook = new XSSFWorkbook(stream);){
            int sheetNumber = workBook.getNumberOfSheets();
            int maxColumn = 0;
            for (int index = 0; index < sheetNumber; ++index) {
                int last;
                int first;
                XSSFRow xRow;
                int i;
                XSSFSheet sheet = workBook.getSheetAt(index);
                int firstIndex = sheet.getFirstRowNum();
                int lastIndex = sheet.getLastRowNum();
                HashMap<Integer, HashMap<Integer, RowDataInfo>> rowIndexMap = new HashMap<Integer, HashMap<Integer, RowDataInfo>>(16);
                for (i = firstIndex; i <= lastIndex; ++i) {
                    xRow = sheet.getRow(i);
                    if (xRow == null) continue;
                    first = xRow.getFirstCellNum();
                    last = xRow.getLastCellNum();
                    maxColumn = maxColumn <= last ? last : maxColumn;
                    for (int j = first; j <= last; ++j) {
                        XSSFCell cell = xRow.getCell(j);
                        if (cell == null || !CellType.STRING.equals((Object)cell.getCellType())) continue;
                        HashMap<Integer, RowDataInfo> columnIndexMap = (HashMap<Integer, RowDataInfo>)rowIndexMap.get(i);
                        if (CommonUtils.isNull(columnIndexMap)) {
                            columnIndexMap = new HashMap<Integer, RowDataInfo>(16);
                            columnIndexMap.put(j, new RowDataInfo(j, cell.getStringCellValue(), (CellStyle)cell.getCellStyle(), first, last));
                            rowIndexMap.put(i, columnIndexMap);
                        } else {
                            columnIndexMap.put(j, new RowDataInfo(j, cell.getStringCellValue(), (CellStyle)cell.getCellStyle(), first, last));
                        }
                        xRow.removeCell((Cell)cell);
                    }
                }
                for (i = firstIndex; i <= lastIndex; ++i) {
                    xRow = sheet.getRow(i);
                    if (xRow == null) continue;
                    first = xRow.getFirstCellNum();
                    last = xRow.getLastCellNum();
                    Map columnIndexMap = (Map)rowIndexMap.get(i);
                    if (CommonUtils.isNull(columnIndexMap)) continue;
                    Integer columnIndex = (Integer)columnIndexMap.keySet().iterator().next();
                    for (Map.Entry integerRowDataInfoEntry : columnIndexMap.entrySet()) {
                        Integer key = (Integer)integerRowDataInfoEntry.getKey();
                        RowDataInfo value = (RowDataInfo)integerRowDataInfoEntry.getValue();
                        if (!key.equals(columnIndex)) continue;
                        first = value.getRowFirstCellNum();
                        last = value.getRowLastCellNum();
                    }
                    for (int j = first; j <= last; ++j) {
                        XSSFCell cell = xRow.getCell(j);
                        if (cell != null || !columnIndexMap.containsKey(j)) continue;
                        XSSFCell crateCell = xRow.createCell(j, CellType.STRING);
                        RowDataInfo info = (RowDataInfo)columnIndexMap.get(j);
                        crateCell.setCellValue(info.getCellValue());
                        crateCell.setCellStyle(info.getCellStyle());
                    }
                }
                for (i = 0; i < maxColumn; ++i) {
                    sheet.autoSizeColumn(i, true);
                }
            }
            workBook.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return outputStream;
    }

    private static List<String> getSubPdfUrlsList(Map<String, List<Map<String, Object>>> attachments) {
        ArrayList<String> subPdfUrlsList = new ArrayList<String>(16);
        for (Map.Entry<String, List<Map<String, Object>>> map : attachments.entrySet()) {
            List<Map<String, Object>> value = map.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            for (Map<String, Object> valuemap : value) {
                String filename = (String)valuemap.get("name");
                String type = "\\." + (String)valuemap.get("type");
                filename = filename.split(type)[0];
                String relativeUrl = (String)valuemap.get("relativeUrl");
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream, null);
                    ByteArrayInputStream stream = new ByteArrayInputStream(EasReportHelper.readExcel(new ByteArrayInputStream(outputStream.toByteArray())).toByteArray());
                    Throwable throwable = null;
                    try {
                        Workbook workbook = EasReportHelper.getWorkbook();
                        workbook.setEnableCalculation(false);
                        workbook.open((InputStream)stream, OpenFileFormat.Xlsx);
                        for (IWorksheet iWorksheet : workbook.getWorksheets()) {
                            iWorksheet.getPageSetup().setOrientation(PageOrientation.Landscape);
                            if (iWorksheet.getUsedRange() != null) {
                                iWorksheet.getUsedRange().setShrinkToFit(true);
                            }
                            iWorksheet.getPageSetup().setIsPercentScale(false);
                            iWorksheet.getPageSetup().setFitToPagesWide(1);
                            iWorksheet.getPageSetup().setFitToPagesTall(1);
                        }
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        workbook.save((OutputStream)out, SaveFileFormat.Pdf);
                        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        String dowmPdfUrl = cache.saveAsUrl(filename + ".pdf", out.toByteArray(), 5000);
                        subPdfUrlsList.add(dowmPdfUrl);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)stream).close();
                    }
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u65e0\u62a5\u8868\u6570\u636e\u9644\u4ef6\u3002", (String)"EasReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    logger.error(msg, (Throwable)e);
                    throw new DmwBizException(msg, (Throwable)e);
                }
            }
        }
        return subPdfUrlsList;
    }

    public static void viewRptAttachment(Object pkValue, String formId, String attachPanelKey, IFormView view) {
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkValue, (String)attachPanelKey);
        if (sourceFileList != null && !sourceFileList.isEmpty()) {
            view.previewAttachment((Map)sourceFileList.get(0));
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u65e0\u62a5\u8868\u6570\u636e\u9644\u4ef6\u3002", (String)"EasReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public static void singleRptDataExport(Object pkValue, String downFileName, String formId, String attachPanelKey, IFormView view) {
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkValue, (String)attachPanelKey, (boolean)true);
        if (CommonUtils.isNull(attachments)) {
            throw new DmwBizException(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u65e0\u62a5\u8868\u6570\u636e\u9644\u4ef6\u3002", (String)"EasReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        for (int i = 0; i < attachments.size(); ++i) {
            Map map = (Map)attachments.get(i);
            String relativeUrl = (String)map.get("relativeUrl");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(relativeUrl, (OutputStream)outputStream, null);
            String filename = downFileName;
            if (i > 0) {
                filename = filename + "(" + i + ")";
            }
            filename = filename + ".xlsx";
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String downUrl = cache.saveAsUrl(filename, outputStream.toByteArray(), 5000);
            EasReportHelper.addDownloadPermission(downUrl, view);
            view.download(downUrl);
        }
    }

    public static void batchRptDataExport(Map<Object, String> downFileNameMap, String zipFileName, String formId, String attachPanelKey, IFormView view) {
        if (CommonUtils.isNull(downFileNameMap)) {
            return;
        }
        ByteArrayOutputStream zipOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(zipOutputStream);){
            Map attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object[])downFileNameMap.keySet().toArray(), (String)attachPanelKey, (boolean)true);
            if (CommonUtils.isNull(attachments)) {
                throw new DmwBizException(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u65e0\u62a5\u8868\u6570\u636e\u9644\u4ef6\u3002", (String)"EasReportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            for (Map.Entry attachmentMap : attachments.entrySet()) {
                long pkId = Long.parseLong((String)attachmentMap.getKey());
                List value = (List)attachmentMap.getValue();
                for (int i = 0; i < value.size(); ++i) {
                    Map valuemap = (Map)value.get(i);
                    String url = (String)valuemap.get("url");
                    String relativeUrl = (String)valuemap.get("relativeUrl");
                    EasReportHelper.addDownloadPermission(url, view);
                    String filename = downFileNameMap.get(pkId);
                    if (i > 0) {
                        filename = filename + "(" + i + ")";
                    }
                    filename = filename + ".xlsx";
                    EasReportHelper.toZip(relativeUrl, zos, filename);
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u6267\u884c\u5931\u8d25\uff1a", (String)"EasReportHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            logger.error(msg, (Throwable)e);
            throw new DmwBizException(msg, (Throwable)e);
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String currTimeFormat = DateUtils.getCurrTimeFormat((String)"yyyyMMddHHmmss");
        String filename = zipFileName + currTimeFormat;
        String downUrl = cache.saveAsUrl(filename + ".zip", zipOutputStream.toByteArray(), 5000);
        EasReportHelper.addDownloadPermission(downUrl, view);
        view.download(downUrl);
    }

    private static void addDownloadPermission(String downUrl, IFormView view) {
        if (view instanceof ListView) {
            FileUtils.addDownloadPermission((String)((ListView)view).getBillFormId(), (String)downUrl, (String)view.getFormShowParameter().getServiceAppId());
        } else {
            FileUtils.addDownloadPermission((String)((BillView)view).getFormId(), (String)downUrl, (String)view.getFormShowParameter().getServiceAppId());
        }
    }

    private static void toZip(String url, ZipOutputStream zos, String filename) throws IOException {
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        zos.putNextEntry(new ZipEntry(filename));
        int n = 0;
        byte[] buf = new byte[1024];
        while ((n = inputStream.read(buf)) != -1) {
            zos.write(buf, 0, n);
        }
        zos.closeEntry();
    }

    public static Workbook getWorkbook() {
        EasReportHelper.setLicenseKey(false);
        return new Workbook();
    }

    private static void setLicenseKey(boolean isDev) {
        if (isDev) {
            String devLicense = "F1ZDDh96rNsdBmzbFxlPNeOQWfCdpQTgUOSe7jO8uEuQYW0lQhbzhCOtwQkcWn3me07oqOKaBOhwFEmU9FYxoPZZor/CxKWxPV3/QNa0Pj4VLZbIXvCMrRF57ICt5wPnuf/dHCQo/h/P2XHXb1xyTkmgtMy2wznPJ8WAdn6LA7NRlgpQ5i+Pxw5XFlwFigoPeqT/XCWW06j/EZavFu+bSeVx+bApXKas7wLShOVu+eDq5hG8KOHTzOBkYrTli2G23+YUDqE1CDRVBN13+K1NkY39fDXdpQPecD6HJZSecR6WQXco5n9SrnOl7OuyZTT+pi16InIv+3wqJVWY761xPC/lKlh8/QaTSDiadIha+GAhphb3fXRONDvM9g4WgLi1LriNEtIvApweEBS3vo84+ZJmOuthe03018U7FSDRLHcjrloUgqLjNIuqO3ZpB+WA3g/+LDlZx3mm58Xzm65HSPtk8mPUO3pZQJMzMcax5kVenULAlQZdv3WQQG0yLlwxXcUOHzZNp4r1ww1Xq8D2dg==";
            devLicense = EncrypterFactory.getAesEncrypter().decrypt(devLicense);
            Workbook.SetLicenseKey((String)devLicense);
        } else {
            String deployLicensestr = "s6cb0lCuZwk4iemdyhz8K2FmyuoET9bAKjVWA8ucCYP+F7fpMK2cJoJHhCBYKoOGNuAoi0dVgzqINPsx82101M9Fft0HYL4uAeHbGcRo5XhwsiIMnMSuxo/cxVRVjJjx1zk6P68bCsfx+xxt26pqAzx72fc5R27YiHI8aHKjr6VZm1LE2cXplf0z2kq43RO+trfciq2XSnPfdCf33L9fND0hR3emHl9pCzifW8HswSz/IPclS7VZ2isZYDOimjuvdkGEgWD2IiIdzp6pASvLcU8jSb9m1rMyzq+RpZLRKySq5qROU725Ia6PWqJP22lW/sFSULKKqzw7pKwCqowYVAizgKubc+R6ZivvcJZSLtL1LqyBO0KUf4Cf/bKkQ/30BR/PB/EAm0xoA4TjNMg02vetxvbAxMAtf/6fJ+rlDsOdq1LDrFwdwqLDVihY2AYJR2wOqy8dpJvORl8JQmePn4EyiOy2pAjqf39Bmlb2a5xo4Vmv/2Nrq/hHzUq5kLM0";
            deployLicensestr = EncrypterFactory.getAesEncrypter().decrypt(deployLicensestr);
            Workbook.SetLicenseKey((String)deployLicensestr);
        }
    }

    public static void updatePushRecordEntry(List<ReportPushLog> reportPushLogList) {
        if (CommonUtils.isNull(reportPushLogList)) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        String recordEntryTableName = newDynObj.getDynamicObjectCollection("entryentity").getDynamicObjectType().getAlias();
        updateSql.append(" update ").append(recordEntryTableName).append(" set fpushsubstatus=?,fsuberrorinfo=?,fsuberrorinfo_tag=?,fbcmreportid=? where fentryid=? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(8);
        HashSet<Long> reportIdSet = new HashSet<Long>();
        for (ReportPushLog reportPushLog : reportPushLogList) {
            String subStatus = reportPushLog.isSuccess() ? "3" : "4";
            String subErrorMsg = StringUtil.subDataDeal(reportPushLog.getPushResultMsg(), 255);
            paramsList.add(new Object[]{subStatus, subErrorMsg, reportPushLog.getPushResultMsg(), reportPushLog.getBcmReportIds(), reportPushLog.getPushRecordEntryId()});
            if (reportPushLog.getEasReportId() <= 0L) continue;
            reportIdSet.add(reportPushLog.getEasReportId());
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), paramsList);
        String recordTableName = newDynObj.getDynamicObjectType().getAlias();
        long pushRecordId = reportPushLogList.get(0).getPushRecordId();
        QFilter filter = new QFilter("id", "=", (Object)pushRecordId);
        DynamicObjectCollection recordDynObjColl = QueryServiceHelper.query((String)"dmw_reportpushrecord", (String)String.join((CharSequence)",", "pushstatus", "entryentity.pushsubstatus"), (QFilter[])filter.toArray());
        long count = recordDynObjColl.stream().filter(o -> "3".equals(o.getString("entryentity.pushsubstatus"))).count();
        String pushgrogress = count + "/" + recordDynObjColl.size();
        updateSql.setLength(0);
        updateSql.append(" update ").append(recordTableName).append(" set fpushgrogress=? where fid =? ");
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), (Object[])new Object[]{pushgrogress, pushRecordId});
        if (!reportIdSet.isEmpty()) {
            String formId = "1".equals(reportPushLogList.get(0).getEasReportType()) ? "dmw_fi_report_eas" : "dmw_fi_mergereport_eas";
            DynamicObject rptDynObj = BusinessDataServiceHelper.newDynamicObject((String)formId);
            String rptTableName = rptDynObj.getDynamicObjectType().getAlias();
            updateSql.setLength(0);
            updateSql.append(" update ").append(rptTableName).append(" set fispushreport='1' where fid in ").append(CommonUtils.getSqlInStr(reportIdSet.size()));
            ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>();
            paramsList2.add(reportIdSet.toArray());
            DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), paramsList2);
        }
    }

    public static void updatePushRecordBillStatusByEntry(long pushRecordId) {
        String status = EasReportHelper.getPushStatusByEntryStatus(pushRecordId);
        EasReportHelper.updatePushRecordBillStatus(pushRecordId, status);
    }

    public static void updatePushRecordBillStatus(long pushRecordId, String pushStatus) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        String recordTableName = newDynObj.getDynamicObjectType().getAlias();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" update ").append(recordTableName).append(" set fpushstatus=?,ferrorinfo=' ',ferrorinfo_tag=null where fid =? ");
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), (Object[])new Object[]{pushStatus, pushRecordId});
    }

    public static void repairEntryStatusByIn(long pushRecordId) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        String recordTableName = newDynObj.getDynamicObjectCollection("entryentity").getDynamicObjectType().getAlias();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" update ").append(recordTableName).append(" set fpushsubstatus=? where fid =? and fpushsubstatus=?");
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql.toString(), (Object[])new Object[]{"4", pushRecordId, "2"});
    }

    public static String getPushStatusByEntryStatus(long pushRecordId) {
        List allSuccessList;
        boolean hasIn;
        QFilter qFilter = new QFilter("id", "=", (Object)pushRecordId);
        DynamicObjectCollection pushRecordEntryColl = QueryServiceHelper.query((String)"dmw_reportpushrecord", (String)String.join((CharSequence)",", "pushstatus", "entryentity.pushsubstatus", "errorinfo"), (QFilter[])qFilter.toArray());
        String pushStatus = ((DynamicObject)pushRecordEntryColl.get(0)).getString("pushstatus");
        List entryStatus = pushRecordEntryColl.stream().map(e -> e.getString("entryentity.pushsubstatus")).collect(Collectors.toList());
        List allPlanList = entryStatus.stream().filter(s -> "1".equals(s)).collect(Collectors.toList());
        pushStatus = allPlanList.size() == entryStatus.size() ? (StringUtil.isNotEmpty(((DynamicObject)pushRecordEntryColl.get(0)).getString("errorinfo")) ? "4" : "1") : ((hasIn = entryStatus.stream().anyMatch(s -> "2".equals(s))) ? "2" : ((allSuccessList = entryStatus.stream().filter(s -> "3".equals(s)).collect(Collectors.toList())).size() == entryStatus.size() ? "3" : "4"));
        return pushStatus;
    }

    public static Map<String, List<Map<String, Object>>> getAttachments(String formId, Object[] pkIds, String attachKey, boolean enableTempAccess) {
        return AttachmentServiceHelper.getAttachments((String)formId, (Object[])pkIds, (String)attachKey, (boolean)enableTempAccess);
    }
}

