/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.checkdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.BalanceCheckdataTask;
import kd.imsc.dmw.plugin.formplugin.schedule.taskclick.BalanceCheckdataTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.AbstractImbdDymicPlugin;

public class BalanceCheckGuideFormPlugin
extends AbstractImbdDymicPlugin
implements ProgresssListener,
TabSelectListener {
    private static final String PARAM_TOBACKGROUNDCONFIRM = "toBackgroundConfirm";
    private static final String CONTROL_EXEC_PROGRESSBAR = "exec_progressbar";
    private static final String CONTROL_GUIDECONTENT = "guidecontent";
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CONTROL_BTNBACKGROUD = "btnbackgroud";
    private static final String CONTROL_TABPAGEAP1 = "tabpageap1";
    private static final String CONTROL_TOOLBARAP = "toolbarap";
    private static final String OP_CREATECHECKDATA = "createcheckdata";
    private static final String PARAM_TASKIDLIST = "taskIdList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONTROL_BTNOK, CONTROL_BTNBACKGROUD});
        this.addItemClickListeners(new String[]{CONTROL_TOOLBARAP});
        ProgressBar execProgressBar = (ProgressBar)this.getControl(CONTROL_EXEC_PROGRESSBAR);
        execProgressBar.addProgressListener((ProgresssListener)this);
        Tab tab = (Tab)this.getControl(CONTROL_GUIDECONTENT);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("easorg")) {
            Map orgMap = (Map)CommonUtils.getCustomParamValue(this.getView(), "easorg");
            MulBasedataDynamicObjectCollection orgColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue("easorg");
            if (!CommonUtils.isNull(orgMap)) {
                orgColl.clear();
                for (Map.Entry mapEntry : orgMap.entrySet()) {
                    DynamicObject orgDynObj = orgColl.addNew();
                    DynamicObject baseDataDynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    baseDataDynObj.set("number", ((Map)mapEntry.getValue()).get("number"));
                    baseDataDynObj.set("name", ((Map)mapEntry.getValue()).get("name"));
                    baseDataDynObj.set("id", mapEntry.getKey());
                    orgDynObj.set("fbasedataid", (Object)baseDataDynObj);
                    orgDynObj.set("fbasedataid_id", mapEntry.getKey());
                }
            }
            this.getModel().setValue("easorg", (Object)orgColl);
            this.getModel().setValue("booktypenumber", CommonUtils.getCustomParamValue(this.getView(), "booktypenumber"));
            this.getModel().setValue("startperiodnumber", CommonUtils.getCustomParamValue(this.getView(), "startperiodnumber"));
            this.getModel().setValue("endperiodnumber", CommonUtils.getCustomParamValue(this.getView(), "endperiodnumber"));
            this.getModel().setValue("checkcurrencynumber", CommonUtils.getCustomParamValue(this.getView(), "checkcurrencynumber"));
            this.getModel().setValue("taskid", CommonUtils.getCustomParamValue(this.getView(), "taskid"));
        }
    }

    public void afterBindData(EventObject e) {
        TaskInfo taskInfo;
        String taskId;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_EXEC_PROGRESSBAR});
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTNBACKGROUD});
        boolean frombackgroud = CommonUtils.getBooleanCustomParamValue(this.getView(), "frombackgroud");
        if (frombackgroud && StringUtils.isNotEmpty((CharSequence)(taskId = (String)this.getModel().getValue("taskid"))) && !(taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).isTaskEnd()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_EXEC_PROGRESSBAR});
            ProgressBar progressBar = (ProgressBar)this.getView().getControl(CONTROL_EXEC_PROGRESSBAR);
            progressBar.start();
        }
        Tab tab = (Tab)this.getView().getControl(CONTROL_GUIDECONTENT);
        tab.activeTab(CONTROL_TABPAGEAP1);
    }

    public void onProgress(ProgressEvent e) {
        ProgressBar progressBar = (ProgressBar)e.getSource();
        String progressBarKey = progressBar.getKey();
        if (CONTROL_EXEC_PROGRESSBAR.equals(progressBarKey)) {
            String pushTaskId = (String)this.getModel().getValue("taskid");
            if (StringUtils.isEmpty((CharSequence)pushTaskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)pushTaskId);
            Map<String, Object> taskCustomData = ScheduleHelper.getTaskCustomData(taskInfo);
            String errormsg = (String)taskCustomData.get("errormsg");
            if (taskInfo.isTaskEnd()) {
                ProgressBar bar = (ProgressBar)this.getView().getControl(CONTROL_EXEC_PROGRESSBAR);
                bar.stop();
                boolean isSuccess = StringUtil.isEmpty(errormsg);
                String colorStr = "#276FF5";
                colorStr = isSuccess ? "#1BA854" : "#FB2323";
                this.setProgressStyle(colorStr);
                if (!isSuccess || StringUtil.isNotEmpty(taskInfo.getFailureReason())) {
                    this.getView().showErrorNotification(errormsg + taskInfo.getFailureReason());
                } else {
                    this.showCheckdataListPage();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6838\u5bf9\u6570\u636e\u751f\u6210\u5b8c\u6210\u3002", (String)"BalanceCheckGuideFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
            }
            if (taskInfo.isTaskEnd()) {
                e.setProgress(100);
                this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_BTNOK});
                this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTNBACKGROUD});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTNOK});
                this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_BTNBACKGROUD});
                e.setProgress(taskInfo.getProgress());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (PARAM_TOBACKGROUNDCONFIRM.equals(callBackId)) {
            String taskId = (String)this.getModel().getValue("taskid");
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.toBackground(taskId);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CONTROL_BTNBACKGROUD.equals(key)) {
            String pushTaskId = (String)this.getModel().getValue("taskid");
            if (StringUtil.isEmpty(pushTaskId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u5f00\u59cb\uff0c\u65e0\u9700\u8f6c\u540e\u53f0\u3002", (String)"BalanceCheckGuideFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)pushTaskId);
            if (checkTask.isTaskEnd()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u8f6c\u540e\u53f0\u3002", (String)"BalanceCheckGuideFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            this.toBackgroundConfirm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        FormOperate op = (FormOperate)event.getSource();
        String opKey = op.getOperateKey();
        if (OP_CREATECHECKDATA.equals(opKey)) {
            if (!this.verifyData()) {
                return;
            }
            String taskId = this.dispatchPushTask();
            this.getView().getModel().setValue("taskid", (Object)taskId);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (CONTROL_TABPAGEAP1.equals(tabKey)) {
            this.showCheckdataListPage();
        }
    }

    public void pageRelease(EventObject e) {
        TaskInfo taskInfo;
        super.pageRelease(e);
        String taskId = "";
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null && jobFormInfo.getJobInfo() != null) {
            taskId = jobFormInfo.getJobInfo().getParams().get("taskid").toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)taskId) && !(taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).isTaskEnd()) {
            this.toBackground(taskId);
        }
    }

    private String dispatchPushTask() {
        String checkcurrencynumber = (String)this.getModel().getValue("checkcurrencynumber");
        Object easorgObj = this.getModel().getValue("easorg");
        ArrayList<String> orgNumberList = new ArrayList<String>(16);
        HashMap orgMap = new HashMap(16);
        if (easorgObj instanceof DynamicObjectCollection) {
            DynamicObjectCollection easorgObjColl = (DynamicObjectCollection)easorgObj;
            int size = easorgObjColl.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject orgDynObj = (DynamicObject)easorgObjColl.get(i);
                DynamicObject baseDataDynObj = orgDynObj.getDynamicObject("fbasedataid");
                orgNumberList.add(baseDataDynObj.getString("number"));
                HashMap<String, String> numberMap = new HashMap<String, String>(2);
                numberMap.put("number", baseDataDynObj.getString("number"));
                numberMap.put("name", baseDataDynObj.getString("name"));
                orgMap.put(baseDataDynObj.getString("id"), numberMap);
            }
        }
        String booktypenumber = (String)this.getModel().getValue("booktypenumber");
        String startperiodnumber = (String)this.getModel().getValue("startperiodnumber");
        String endperiodnumber = (String)this.getModel().getValue("endperiodnumber");
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("orgNumberList", orgNumberList);
        param.put("easorg", orgMap);
        param.put("booktypenumber", booktypenumber);
        param.put("startperiodnumber", startperiodnumber);
        param.put("endperiodnumber", endperiodnumber);
        param.put("checkcurrencynumber", checkcurrencynumber);
        JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo(ResManager.loadKDString((String)"EAS\u79d1\u76ee\u4f59\u989d\u6838\u5bf9\u4efb\u52a1", (String)"BalanceCheckGuideFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), BalanceCheckdataTask.class.getName(), BalanceCheckdataTaskClick.class.getName(), this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("dmw");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        jobFormInfo.getJobInfo().getParams().put("taskid", taskId);
        this.getModel().setValue("taskid", (Object)taskId);
        List<String> taskIdList = new ArrayList<String>(16);
        if (this.getView().getPageCache().get(PARAM_TASKIDLIST) != null) {
            taskIdList = (List)JSON.parseObject((String)this.getView().getPageCache().get(PARAM_TASKIDLIST), List.class);
        }
        taskIdList.add(taskId);
        jobFormInfo.getJobInfo().getParams().put(PARAM_TASKIDLIST, JSON.toJSONString(taskIdList));
        this.getView().getPageCache().put(PARAM_TASKIDLIST, JSON.toJSONString(taskIdList));
        this.getView().getPageCache().put("imsc_jobforminfo", JSON.toJSONString((Object)jobFormInfo));
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_EXEC_PROGRESSBAR, CONTROL_BTNBACKGROUD});
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTNOK});
        this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_BTNBACKGROUD});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CONTROL_EXEC_PROGRESSBAR);
        progressBar.start();
        progressBar.setPercent(0);
        this.setProgressStyle("#276FF5");
        return taskId;
    }

    private boolean verifyData() {
        Object easorgObj = this.getModel().getValue("easorg");
        if (easorgObj == null || CommonUtils.isNull((DynamicObjectCollection)easorgObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165EAS\u7ec4\u7ec7\u3002", (String)"BalanceCheckGuideFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtil.isEmpty(this.getModel().getValue("booktypenumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165EAS\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u3002", (String)"BalanceCheckGuideFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtil.isEmpty(this.getModel().getValue("startperiodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165EAS\u5f00\u59cb\u671f\u95f4\u3002", (String)"BalanceCheckGuideFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        if (StringUtil.isEmpty(this.getModel().getValue("endperiodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165EAS\u7ed3\u675f\u671f\u95f4\u3002", (String)"BalanceCheckGuideFormPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void toBackgroundConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5f53\u524d\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u540e\uff0c\u53ef\u4ee5\u518d\u6b21\u901a\u8fc7\u53f3\u4e0b\u89d2\u7684\u540e\u53f0\u8fd0\u884c\u8fdb\u5ea6\u7403\u518d\u6b21\u6253\u5f00\u3002", (String)"BalanceCheckGuideFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PARAM_TOBACKGROUNDCONFIRM, (IFormPlugin)this));
    }

    private void toBackground(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)(((Object)((Object)this)).getClass().getSimpleName() + "-background-monitor"), (Runnable)subscriber);
            }
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getPageCache().get("imsc_jobforminfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)JSONObject.parseObject((String)str, JobFormInfo.class);
    }

    private void setProgressStyle(String colorStr) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", colorStr);
        this.getView().updateControlMetadata(CONTROL_EXEC_PROGRESSBAR, map);
    }

    private void showCheckdataListPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("dmw_checkdatalist");
        listShowParameter.setFormId("dmw_bos_list");
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            listShowParameter.getCustomParams().put(PARAM_TASKIDLIST, jobFormInfo.getJobInfo().getParams().get(PARAM_TASKIDLIST));
        } else if (CommonUtils.getCustomParamValue(this.getView(), PARAM_TASKIDLIST) != null) {
            listShowParameter.getCustomParams().put(PARAM_TASKIDLIST, CommonUtils.getCustomParamValue(this.getView(), PARAM_TASKIDLIST));
            this.getView().getPageCache().put(PARAM_TASKIDLIST, CommonUtils.getCustomParamValue(this.getView(), PARAM_TASKIDLIST).toString());
        }
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("checkdataflexpanel");
        String pageId = UUID.randomUUID().toString().replace("-", "") + System.currentTimeMillis();
        listShowParameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

