/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.multiimport.scheme;

import com.alibaba.fastjson.JSONArray;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;
import kd.imsc.dmw.plugin.validator.SchemeImportValidator;

public class SchemeImportOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SchemeImportOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("creator");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        logger.info("onAddValidators");
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SchemeImportValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("beginOperationTransaction");
        super.beginOperationTransaction(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        logger.info("beforeExecuteOperationTransaction");
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        logger.info("operationKey {}", (Object)operationKey);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (operationKey.equals("tblexport")) {
            try {
                JSONArray array = new JSONArray();
                for (DynamicObject dataEntity : dataEntities) {
                    String exportUrl = MultiImpSchemeHelper.exportMultiImpScheme((Long)dataEntity.getPkValue());
                    array.add((Object)exportUrl);
                }
                this.getOption().setVariableValue("e_r", array.toJSONString());
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                e.setCancel(true);
                e.setCancelMessage(ex.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }
}

