/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class DmwSchemeSubValidator
extends AbstractImbdValidator {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String F_BASE_DATA_ID = "fbasedataid";

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("treeentryentity");
        fields.add("treeentryentity.migrateobject");
        fields.add("treeentryentity.sortnumdefault");
        fields.add("treeentryentity.sortnumexec");
        fields.add("treeentryentity.seq");
        return fields;
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            this.sortByExecNum(rowDataEntity);
            this.vertifyErrorSequence(rowDataEntity);
        }
    }

    private void sortByExecNum(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("treeentryentity");
        List entryList = entryEntity.stream().sorted(Comparator.comparing(n -> n.getInt("sortnumexec"))).collect(Collectors.toList());
        entryEntity.clear();
        entryEntity.addAll(entryList);
        for (int i = 0; i < entryEntity.size(); ++i) {
            ((DynamicObject)entryEntity.get(i)).set("seq", (Object)i);
        }
    }

    private void vertifyErrorSequence(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject item : entryEntity) {
            int sortNumExec = item.getInt("sortnumexec");
            if (sortNumExec != 0) continue;
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8d4b\u503c", (String)"DmwSchemeSubValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
            return;
        }
        Map<String, List<String>> errorSequenceMap = this.getErrorSequenceMap(entryEntity);
        if (!errorSequenceMap.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff01\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u6267\u884c\u987a\u5e8f\u5728\u540e\uff0c\u53ef\u80fd\u5bfc\u81f4\u8fc1\u79fb\u5931\u8d25", (String)"DmwSchemeSubValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            StringBuilder detail = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : errorSequenceMap.entrySet()) {
                String migObjName = entry.getKey();
                List<String> relyObjNameList = entry.getValue();
                for (String relyObjName : relyObjNameList) {
                    String tempMsg = String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u3010%1$s\u3011\u7684\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u3010%2$s\u3011\u6267\u884c\u8fc1\u79fb\u6392\u5e8f\u5728\u540e", (String)"DmwSchemeSubValidator_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), migObjName, relyObjName);
                    detail.append(tempMsg).append('\n');
                }
            }
            this.addMessage(dataEntity, title, detail.toString(), ErrorLevel.Warning);
        }
    }

    public Map<String, List<String>> getErrorSequenceMap(DynamicObjectCollection entryentity) {
        Map<String, Integer> idSortnumMap = this.getObjIdSequenceMap(entryentity);
        Map<String, String> objIdNameMap = this.getObjIdNameMap(entryentity);
        Map<String, List<String>> relyObjIdMap = this.getRelyObjIdMap(entryentity);
        HashMap<String, List<String>> errorSequenceMap = new HashMap<String, List<String>>(8);
        for (DynamicObject item : entryentity) {
            DynamicObject migObj = item.getDynamicObject("migrateobject");
            String migObjId = migObj.getString(ID);
            List<String> relyObjIdList = relyObjIdMap.get(migObjId);
            if (relyObjIdList == null) continue;
            Integer migObjNum = idSortnumMap.get(migObjId);
            String migObjName = objIdNameMap.get(migObjId);
            ArrayList<String> relyObjNameList = new ArrayList<String>(8);
            for (String relyId : relyObjIdList) {
                String relyName = objIdNameMap.get(relyId);
                Integer relyNum = idSortnumMap.get(relyId);
                if (!idSortnumMap.containsKey(relyId) || relyNum <= migObjNum) continue;
                relyObjNameList.add(relyName);
            }
            if (relyObjNameList.isEmpty()) continue;
            List tempList = (List)errorSequenceMap.get(migObjName);
            if (tempList != null) {
                relyObjNameList.addAll(tempList);
            }
            errorSequenceMap.put(migObjName, relyObjNameList);
        }
        return errorSequenceMap;
    }

    public Map<String, Integer> getObjIdSequenceMap(DynamicObjectCollection entryentity) {
        HashMap<String, Integer> idSortnumMap = new HashMap<String, Integer>(8);
        for (DynamicObject item : entryentity) {
            DynamicObject migObj = item.getDynamicObject("migrateobject");
            String id = migObj.getString(ID);
            Integer sortnumExec = item.getInt("sortnumexec");
            idSortnumMap.put(id, sortnumExec);
        }
        return idSortnumMap;
    }

    public Map<String, List<String>> getRelyObjIdMap(DynamicObjectCollection entryentity) {
        HashMap<String, List<String>> relyObjIdMap = new HashMap<String, List<String>>(8);
        for (DynamicObject item : entryentity) {
            DynamicObject migObj = (DynamicObject)item.get("migrateobject");
            DynamicObjectCollection relyObjList = (DynamicObjectCollection)migObj.get("easobjectrelys");
            if (relyObjList.isEmpty()) continue;
            ArrayList<String> relyObjIdList = new ArrayList<String>(8);
            for (int j = 0; j < relyObjList.size(); ++j) {
                DynamicObject relyObj = ((DynamicObject)relyObjList.get(j)).getDynamicObject(F_BASE_DATA_ID);
                if (relyObj == null) continue;
                String relyObjId = relyObj.getString(ID);
                relyObjIdList.add(relyObjId);
            }
            String id = migObj.getString(ID);
            relyObjIdMap.put(id, relyObjIdList);
        }
        return relyObjIdMap;
    }

    public Map<String, String> getObjIdNameMap(DynamicObjectCollection entryentity) {
        HashMap<String, String> idNameMap = new HashMap<String, String>(8);
        for (DynamicObject item : entryentity) {
            DynamicObject migObj = item.getDynamicObject("migrateobject");
            String id = migObj.getString(ID);
            String name = migObj.getString(NAME);
            idNameMap.put(id, name);
        }
        return idNameMap;
    }
}

