/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imbd.formplugin.tpl;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.imsc.imbd.formplugin.AbstractImbdBdEditPlugin;

public class ImbdBdTplEditPlugin
extends AbstractImbdBdEditPlugin {
    private static final String IS_SYS_PRESET = "issyspreset";
    private static final String CONENTPANEL = "conentpanel";
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final ThreadLocal<Boolean> triggerChangeEventLocal = new ThreadLocal();
    protected volatile boolean triggerChangeEvent = true;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        boolean isSysPreset = dynamicObject.getBoolean(IS_SYS_PRESET);
        this.getView().setEnable(Boolean.valueOf(!isSysPreset), new String[]{CONENTPANEL});
    }

    public Object getValue(String key) {
        return this.getModel().getValue(key);
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, -1);
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, -1);
    }

    public Object getF7PKValue(String f7Name) {
        return this.getF7PKValue(f7Name, -1);
    }

    public DynamicObject getF7Value(String f7Name) {
        return this.getModel().getDataEntity().getDynamicObject(f7Name);
    }

    public DynamicObjectCollection getMultiF7Value(String multiF7Name) {
        return this.getModel().getDataEntity().getDynamicObjectCollection(multiF7Name);
    }

    public Object getValue(String key, int i) {
        return this.getModel().getValue(key, i);
    }

    public String getStringValue(String key, int i) {
        Object value;
        Object object = value = i > 0 ? this.getValue(key, i) : this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ILocaleString) {
            return ((ILocaleString)value).getLocaleValue();
        }
        return null;
    }

    public boolean getBooleanValue(String key, int i) {
        Object value;
        Object object = value = i >= 0 ? this.getValue(key, i) : this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public Object getF7PKValue(String f7Name, int i) {
        DynamicObject val = this.getF7Value(f7Name, i);
        if (val == null) {
            return null;
        }
        return val.get("id");
    }

    public DynamicObject getF7Value(String f7Name, int i) {
        Object value;
        Object object = value = i >= 0 ? this.getValue(f7Name, i) : this.getF7Value(f7Name);
        if (value instanceof DynamicObject) {
            return value;
        }
        return null;
    }

    public DynamicObjectCollection getMultiF7Value(String multiF7Name, int i) {
        Object value;
        Object object = value = i > 0 ? this.getValue(multiF7Name, i) : this.getMultiF7Value(multiF7Name);
        if (value instanceof DynamicObjectCollection) {
            return value;
        }
        return null;
    }

    public void setValue(String key, Object value) {
        this.getModel().setValue(key, value);
    }

    public void setItemValueByID(String key, Object value) {
        this.getModel().setItemValueByID(key, value);
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        triggerChangeEventLocal.set(Boolean.FALSE);
        this.triggerChangeEvent = isTriggerChangeEvent;
        this.getModel().setValue(key, value);
        triggerChangeEventLocal.remove();
    }

    public void setItemValueByID(String key, Object value, boolean isTriggerChangeEvent) {
        triggerChangeEventLocal.set(Boolean.FALSE);
        this.triggerChangeEvent = isTriggerChangeEvent;
        this.getModel().setItemValueByID(key, value);
        triggerChangeEventLocal.remove();
    }

    public void setValue(String key, Object value, int i) {
        this.getModel().setValue(key, value, i);
    }

    public void setItemValueByID(String key, Object value, int rowIndex) {
        this.getModel().setItemValueByID(key, value, rowIndex);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        triggerChangeEventLocal.set(Boolean.FALSE);
        this.triggerChangeEvent = isTriggerChangeEvent;
        this.getModel().setValue(key, value, i);
        triggerChangeEventLocal.remove();
    }

    public void setItemValueByID(String key, Object value, int i, boolean isTriggerChangeEvent) {
        triggerChangeEventLocal.set(Boolean.FALSE);
        this.triggerChangeEvent = isTriggerChangeEvent;
        this.getModel().setItemValueByID(key, value, i);
        triggerChangeEventLocal.remove();
    }

    public boolean isFromImport() {
        IDataModel model = this.getModel();
        if (model instanceof IBillModel) {
            return ((IBillModel)model).isFromImport();
        }
        return false;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void addRowClickListener(RowClickEventListener form, String ... keys) {
        EntryGrid grid = null;
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            grid = (EntryGrid)this.getControl(keys[i]);
            if (grid == null) continue;
            grid.addRowClickListener(form);
        }
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void setF7Filter(String f7Name, QFilter filter) {
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl(f7Name);
        f7.setQFilter(filter);
    }

    public void setMustInput(String fieldName, boolean isMustInput) {
        FieldEdit fieldEdit = this.getFieldEdit(fieldName);
        if (fieldEdit != null) {
            fieldEdit.setMustInput(isMustInput);
        }
    }

    private FieldEdit getFieldEdit(String key) {
        return (FieldEdit)this.getView().getControl(key);
    }

    public boolean isNewCreate() {
        return !this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
    }

    public boolean isView() {
        return OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public boolean isEdit() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public boolean isAddNew() {
        return OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }
}

