/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.deliveryinitial;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.initscheme.InitQueryService;

public class InitQueryServiceImpl
implements InitQueryService {
    private static final Log logger = LogFactory.getLog(InitQueryServiceImpl.class);

    public Map<String, Object> queryBizAppProgress(String appId, String dimensionId) {
        logger.info("\u5e94\u7528id:{} \u7ef4\u5ea6id:{}", (Object)appId, (Object)dimensionId);
        Map<String, Object> result = this.getSchemeIdsByBizAppId(appId);
        boolean success = (Boolean)result.get("success");
        if (success) {
            StringBuilder message = new StringBuilder();
            List schemeIds = (List)result.get("data");
            long singleSchemeId = 0L;
            try {
                if (schemeIds.size() == 1) {
                    singleSchemeId = (Long)schemeIds.get(0);
                } else {
                    QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId);
                    qFilter.and(new QFilter("initialscheme", "in", (Object)schemeIds));
                    DynamicObject assignCord = QueryServiceHelper.queryOne((String)"imic_assignrecord", (String)"initialscheme", (QFilter[])qFilter.toArray());
                    if (assignCord != null) {
                        singleSchemeId = assignCord.getLong("initialscheme");
                    } else {
                        message.append(String.format(ResManager.loadKDString((String)"\u5728\u8be5\u5e94\u7528\u4e0b\u672a\u627e\u5230\u5206\u914d\u7ed9\u7ef4\u5ea6[%s]\u7684\u65b9\u6848", (String)"InitQueryServiceImpl_0", (String)"imsc-imic-platform", (Object[])new Object[0]), dimensionId));
                    }
                }
            }
            catch (KDException e) {
                logger.error(e.getStackTraceMessage());
                message.append(ResManager.loadKDString((String)"\u67e5\u8be2\u521d\u59cb\u5316\u5206\u914d\u8bb0\u5f55\u51fa\u9519\u3002", (String)"InitQueryServiceImpl_1", (String)"imsc-imic-platform", (Object[])new Object[0])).append(e.getStackTraceMessage());
            }
            if (singleSchemeId != 0L) {
                result = this.getSingleSchemeProgress(singleSchemeId, dimensionId);
            } else {
                result.put("success", Boolean.FALSE);
                result.put("message", message.toString());
            }
        }
        return result;
    }

    public Map<String, Object> querySingleSchemeProgress(long schemeId, String dimension) {
        return this.getSingleSchemeProgress(schemeId, dimension);
    }

    private Map<String, Object> getSingleSchemeProgress(long schemeId, String dimension) {
        logger.info("\u65b9\u6848id\uff1a{}\uff0c\u7ef4\u5ea6id\uff1a{}", (Object)schemeId, (Object)dimension);
        boolean success = false;
        StringBuilder message = new StringBuilder();
        Integer progress = null;
        try {
            if (schemeId == 0L) {
                message.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002\u65b9\u6848id\uff1a%s", (String)"InitQueryServiceImpl_2", (String)"imsc-imic-platform", (Object[])new Object[0]), schemeId));
            } else {
                ArrayList<QFilter> qFiltersList = new ArrayList<QFilter>(10);
                qFiltersList.add(new QFilter("id", "=", (Object)schemeId));
                qFiltersList.add(new QFilter("itemgroup.imic_initentry_items.itemenabled", "=", (Object)"1"));
                DynamicObjectCollection allItems = QueryServiceHelper.query((String)"imic_initialscheme", (String)"id, itemgroup.imic_initentry_items.itemname", (QFilter[])qFiltersList.toArray(new QFilter[0]));
                if (allItems.isEmpty()) {
                    message.append(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u65b9\u6848id\u3010%s\u3011\u672a\u627e\u5230\u8be5\u65b9\u6848\u4e0b\u542f\u7528\u7684\u521d\u59cb\u5316\u4efb\u52a1\u9879", (String)"InitQueryServiceImpl_3", (String)"imsc-imic-platform", (Object[])new Object[0]), schemeId));
                } else {
                    qFiltersList.clear();
                    qFiltersList.add(new QFilter("initialscheme", "=", (Object)schemeId));
                    if (dimension != null) {
                        qFiltersList.add(new QFilter("dimension", "=", (Object)dimension));
                    }
                    List progressUnits = QueryServiceHelper.queryPrimaryKeys((String)"imic_progressunit", (QFilter[])qFiltersList.toArray(new QFilter[0]), null, (int)-1);
                    success = true;
                    if (progressUnits.isEmpty()) {
                        progress = 0;
                    } else {
                        BigDecimal completeCount = new BigDecimal(progressUnits.size());
                        BigDecimal itemsSum = new BigDecimal(allItems.size());
                        progress = completeCount.divide(itemsSum, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).intValue();
                    }
                }
            }
        }
        catch (KDException e) {
            logger.error(e.getStackTraceMessage());
            message.append(ResManager.loadKDString((String)"\u67e5\u8be2\u521d\u59cb\u5316\u8fdb\u5ea6\u51fa\u9519\u3002", (String)"InitQueryServiceImpl_4", (String)"imsc-imic-platform", (Object[])new Object[0])).append(e.getStackTraceMessage());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("success", success);
        result.put("message", message.toString());
        result.put("data", progress);
        return result;
    }

    public Map<String, Object> querySchemesByBizAppId(String bizAppId) {
        return this.getSchemeIdsByBizAppId(bizAppId);
    }

    private Map<String, Object> getSchemeIdsByBizAppId(String appId) {
        boolean success = false;
        StringBuilder message = new StringBuilder();
        List schemeIds = null;
        try {
            if (StringUtils.isBlank(appId)) {
                message.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"InitQueryServiceImpl_5", (String)"imsc-imic-platform", (Object[])new Object[0]));
            } else {
                QFilter qFilter = new QFilter("bizapp_id", "=", (Object)appId);
                qFilter.and(new QFilter("enable", "=", (Object)"1"));
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"imic_initialscheme", (QFilter[])qFilter.toArray(), null, (int)-1);
                if (ids.size() == 0) {
                    message.append(String.format(ResManager.loadKDString((String)"\u672a\u901a\u8fc7\u5e94\u7528id[%s]\u627e\u5230\u521d\u59cb\u5316\u65b9\u6848", (String)"InitQueryServiceImpl_6", (String)"imsc-imic-platform", (Object[])new Object[0]), appId));
                } else {
                    success = true;
                    schemeIds = ids.stream().filter(Objects::nonNull).map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
                }
            }
        }
        catch (KDException e) {
            logger.error(e.getStackTraceMessage());
            message.append(ResManager.loadKDString((String)"\u901a\u8fc7\u5e94\u7528id[%s]\u67e5\u8be2\u521d\u59cb\u5316\u65b9\u6848\u51fa\u9519\u3002", (String)"InitQueryServiceImpl_7", (String)"imsc-imic-platform", (Object[])new Object[0])).append(e.getStackTraceMessage());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("success", success);
        result.put("message", message.toString());
        result.put("data", schemeIds);
        return result;
    }
}

