/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.common;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.StringUtils;

public class LockUtils {
    public static boolean requireLock(String lockId, String groupId, String entityKey, String opKey) {
        if (lockId == null) {
            return false;
        }
        LockUtils.releaseLock(lockId, groupId, entityKey, opKey);
        return MutexHelper.require((String)entityKey, (Object)lockId, (String)opKey, (boolean)true, (StringBuilder)new StringBuilder());
    }

    public static void releaseLock(String lockId, String groupId, String entityKey, String opKey) {
        DataMutexImpl dataMutex;
        Map lockInfo;
        if (StringUtils.isNotEmpty(lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, groupId, entityKey)) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)entityKey, (String)opKey, (String)lockId);
        }
    }

    public static boolean checkLock(String objectId, String groupId, String entityKey, IFormView view) {
        if (StringUtils.isEmpty(objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, groupId, entityKey);
        if (lockInfo != null) {
            String userId = (String)lockInfo.get("userid");
            Map<String, Object> userInfo = CommonUtil.getUserInfoById(Long.parseLong(userId));
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LockUtils_0", (String)"imsc-imic-platform", (Object[])new Object[0]), userInfo.getOrDefault("name", "")));
            return true;
        }
        return false;
    }
}

