/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.taskdispatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imbd.formplugin.AbstractImbdBdTreeListPlugin;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.common.FileUtils;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.fileimport.FileImportUtils;
import kd.imsc.imic.common.fileimport.Header;
import kd.imsc.imic.common.fileimport.ImportEntity;
import kd.imsc.imic.common.taskdispatch.DispatchTaskModel;
import kd.imsc.imic.common.taskdispatch.MarkStatusEnum;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MyTaskPlugin
extends AbstractImbdBdTreeListPlugin
implements FilterContainerInitListener,
TreeNodeClickListener,
RowClickEventListener,
SearchClickListener {
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String TASK_ENTRY = "taskentry";
    private static final String TASK_MODELMAP = "taskmodelmap";
    private static final String CONTAINER_FILTER = "containerfilter";
    private static final String NODE_FILTER = "nodefilter";
    private static final String FILTERCONTAINERAP = "filtercontainerap";
    private List<String> markTaskLabelKeys = Arrays.asList("all", "mark", "unmark");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TASK_ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"all", "mark", "unmark"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl(FILTERCONTAINERAP);
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId("imic_taskdispatchrecord");
            fc.addFilterContainerInitListener((FilterContainerInitListener)this);
            fc.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
            fc.addSearchClickListener((SearchClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.createSchemeTree();
        QFilter filter = new QFilter(TaskDispatchConst.CHARGEUSER_ID, "=", (Object)RequestContext.get().getCurrUserId()).and("dispatchstatus", "=", (Object)"1");
        this.initTaskEntry(filter, false, false, null, null);
    }

    private void createSchemeTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        TreeNode root = new TreeNode("", "rootNode", ResManager.loadKDString((String)"\u5168\u90e8", (String)"MyTaskPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]), (Object)"root");
        root.setIsOpened(true);
        root.setChildren(new ArrayList(1));
        TreeNode treeNode = TaskDispatchHelper.buildTreeNode(root);
        this.getPageCache().put(TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)root));
        treeView.addNode(treeNode);
        treeView.updateNode(treeNode);
        if (StringUtils.isNotBlank(focusNodeId)) {
            treeView.expand(focusNodeId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barclose": {
                this.getView().close();
                break;
            }
            case "barrefresh": {
                String containerFilterStr;
                QFilter filter = new QFilter(TaskDispatchConst.CHARGEUSER_ID, "=", (Object)RequestContext.get().getCurrUserId()).and("dispatchstatus", "=", (Object)"1");
                String nodeFilterStr = this.getPageCache().get(NODE_FILTER);
                if (StringUtils.isNotEmpty(nodeFilterStr)) {
                    filter.and(QFilter.fromSerializedString((String)nodeFilterStr));
                }
                if (StringUtils.isNotEmpty(containerFilterStr = this.getPageCache().get(CONTAINER_FILTER))) {
                    filter.and(QFilter.fromSerializedString((String)containerFilterStr));
                }
                this.initTaskEntry(filter, false, false, null, null);
                this.createSchemeTree();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "all": 
            case "mark": 
            case "unmark": {
                String taskMapStr = this.getPageCache().get(TASK_MODELMAP);
                if (StringUtils.isEmpty(taskMapStr)) {
                    return;
                }
                Map takModelMap = (Map)SerializationUtils.fromJsonString((String)taskMapStr, Map.class);
                List taskModels = (List)takModelMap.get(key);
                this.createTaskEntry(taskModels);
                for (String labelKey : this.markTaskLabelKeys) {
                    if (!key.equals(labelKey)) {
                        TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "#212121");
                        continue;
                    }
                    TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "themeColor");
                }
                break;
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        TaskDispatchHelper.searchTreeText(this.getView(), text);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String containerFilterStr;
        super.treeNodeClick(e);
        String nodeId = e.getNodeId().toString();
        String treeNodeCacheStr = this.getPageCache().get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        TreeNode clickNode = root.getTreeNode(nodeId, 10);
        QFilter filter = new QFilter(TaskDispatchConst.CHARGEUSER_ID, "=", (Object)RequestContext.get().getCurrUserId()).and("dispatchstatus", "=", (Object)"1");
        QFilter nodeClickFilter = TaskDispatchHelper.getNodeClickFilter(clickNode);
        if (nodeClickFilter != null) {
            this.getPageCache().put(NODE_FILTER, nodeClickFilter.toSerializedString());
            filter.and(nodeClickFilter);
        }
        if (StringUtils.isNotEmpty(containerFilterStr = this.getPageCache().get(CONTAINER_FILTER))) {
            filter.and(QFilter.fromSerializedString((String)containerFilterStr));
        }
        this.initTaskEntry(filter, false, false, null, null);
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        List commonFilterColumns = evt.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!TaskDispatchConst.CHARGEUSER_ID.equals(fieldName)) continue;
            ((CommonBaseDataFilterColumn)commonFilterColumn).setComboItems(new ArrayList());
            ((CommonBaseDataFilterColumn)commonFilterColumn).setMustInput(true);
            ((CommonBaseDataFilterColumn)commonFilterColumn).setMulti(false);
            commonFilterColumn.setDefaultValue(String.valueOf(RequestContext.get().getCurrUserId()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (TaskDispatchConst.CHARGEUSER_ID.equals(fieldName)) {
            QFilter filter = new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId());
            args.getQfilters().add(filter);
        }
    }

    private void initTaskEntry(QFilter recordFilter, boolean isFilterOrgId, boolean isFilterOrgName, List<Object> filterOrgIds, List<Object> filterOrgNames) {
        String selectRecordProperties = String.join((CharSequence)",", "initscheme", "bizapp", "stepid", "stepname", "inittask", "checkuser", "dispatchorg");
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectRecordProperties, (QFilter[])recordFilter.toArray());
        List schemeIds = Arrays.stream(records).filter(record -> record.getDynamicObject("initscheme") != null).map(record -> record.getDynamicObject("initscheme").getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("initialscheme", "in", schemeIds);
        String selectProperties = String.join((CharSequence)",", "initialscheme", "initialschemeentryid", "org");
        DynamicObject[] progresses = BusinessDataServiceHelper.load((String)"imic_progressunit", (String)selectProperties, (QFilter[])filter.toArray());
        HashMap<Long, List<Long>> taskOrgMarkMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject progress : progresses) {
            DynamicObject scheme = progress.getDynamicObject("initialscheme");
            boolean useDimension = scheme.getBoolean("usedimension");
            DynamicObject task = progress.getDynamicObject("initialschemeentryid");
            if (task == null) continue;
            long taskId = task.getLong("id");
            if (useDimension) {
                DynamicObject org = progress.getDynamicObject("org");
                if (org == null) continue;
                long orgId = org.getLong("id");
                taskOrgMarkMap.putIfAbsent(taskId, new ArrayList(16));
                ((List)taskOrgMarkMap.get(taskId)).add(orgId);
                continue;
            }
            taskOrgMarkMap.put(taskId, null);
        }
        Map<String, List<DispatchTaskModel>> taskModelMap = this.createTaskModelMap(records, taskOrgMarkMap, isFilterOrgId, isFilterOrgName, filterOrgIds, filterOrgNames);
        List<DispatchTaskModel> taskModels = taskModelMap.get("all");
        List<DispatchTaskModel> markTaskModels = taskModelMap.get("mark");
        List<DispatchTaskModel> unMarkTaskModels = taskModelMap.get("unmark");
        this.setTaskSizeLabelVal(taskModels.size(), markTaskModels.size(), unMarkTaskModels.size());
        TaskDispatchHelper.setLabelForceColor(this.getView(), "all", "themeColor");
        this.createTaskEntry(taskModels);
        this.getView().updateView(TASK_ENTRY);
    }

    private Map<String, List<DispatchTaskModel>> createTaskModelMap(DynamicObject[] records, Map<Long, List<Long>> taskOrgMarkMap, boolean isFilterOrgId, boolean isFilterOrgName, List<Object> filterOrgIds, List<Object> filterOrgNames) {
        ArrayList<DispatchTaskModel> taskModels = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> unMarkTaskModels = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> markTaskModels = new ArrayList<DispatchTaskModel>(16);
        HashMap<String, List<DispatchTaskModel>> takModelMap = new HashMap<String, List<DispatchTaskModel>>(4);
        for (DynamicObject record : records) {
            DynamicObject scheme = record.getDynamicObject("initscheme");
            DynamicObject bizApp = record.getDynamicObject("bizapp");
            if (scheme == null || bizApp == null) continue;
            Long schemeId = scheme.getLong("id");
            boolean useDimension = scheme.getBoolean("usedimension");
            long stepId = record.getLong("stepid");
            String stepName = record.getString("stepname");
            DynamicObject task = record.getDynamicObject("inittask");
            if (task == null) {
                return Collections.emptyMap();
            }
            Long taskId = task.getLong("id");
            String appId = bizApp.getString("id");
            DynamicObject bizCloud = bizApp.getDynamicObject("bizcloud");
            String cloudId = bizCloud.getString("id");
            DynamicObjectCollection checkUsers = record.getDynamicObjectCollection("checkuser");
            List<Long> checkerUserIds = checkUsers.stream().map(checker -> checker.getLong("fbasedataid_id")).collect(Collectors.toList());
            DynamicObjectCollection dispatchOrgs = record.getDynamicObjectCollection("dispatchorg");
            Map<Long, String> orgMap = dispatchOrgs.stream().collect(Collectors.toMap(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id"), dispatchOrg -> dispatchOrg.getDynamicObject("fbasedataid").getString("name")));
            if (useDimension) {
                for (Map.Entry<Long, String> orgEntry : orgMap.entrySet()) {
                    boolean mark;
                    boolean nameFilter;
                    Long dispatchOrgId = orgEntry.getKey();
                    String orgName = orgEntry.getValue();
                    boolean idFilter = isFilterOrgId && !filterOrgIds.contains(dispatchOrgId);
                    boolean matchName = false;
                    if (isFilterOrgName) {
                        for (Object filterOrgName : filterOrgNames) {
                            if (!orgName.contains((String)filterOrgName)) continue;
                            matchName = true;
                            break;
                        }
                    }
                    boolean bl = nameFilter = isFilterOrgName && !matchName;
                    if (idFilter || nameFilter) continue;
                    DispatchTaskModel taskModel = this.createTaskModel(appId, cloudId, schemeId, stepId, stepName, taskId, checkerUserIds, dispatchOrgId);
                    boolean bl2 = mark = taskOrgMarkMap.containsKey(taskId) && taskOrgMarkMap.get(taskId) != null && taskOrgMarkMap.get(taskId).contains(dispatchOrgId);
                    if (mark) {
                        taskModel.setMarkStatus("B");
                        markTaskModels.add(taskModel);
                    } else {
                        taskModel.setMarkStatus("A");
                        unMarkTaskModels.add(taskModel);
                    }
                    taskModels.add(taskModel);
                }
                continue;
            }
            DispatchTaskModel taskModel = this.createTaskModel(appId, cloudId, schemeId, stepId, stepName, taskId, checkerUserIds, 0L);
            if (taskOrgMarkMap.containsKey(taskId)) {
                taskModel.setMarkStatus("B");
                markTaskModels.add(taskModel);
            } else {
                taskModel.setMarkStatus("A");
                unMarkTaskModels.add(taskModel);
            }
            taskModels.add(taskModel);
        }
        takModelMap.put("all", taskModels);
        takModelMap.put("mark", markTaskModels);
        takModelMap.put("unmark", unMarkTaskModels);
        this.getPageCache().put(TASK_MODELMAP, SerializationUtils.toJsonString(takModelMap));
        return takModelMap;
    }

    private DispatchTaskModel createTaskModel(String appId, String cloudId, Long schemeId, Long stepId, String stepName, Long taskId, List<Long> checkerUserIds, Long dispatchOrgId) {
        DispatchTaskModel taskModel = new DispatchTaskModel();
        taskModel.setAppId(appId);
        taskModel.setCloudId(cloudId);
        taskModel.setSchemeId(schemeId);
        taskModel.setStepId(String.valueOf(stepId));
        taskModel.setStepName(stepName);
        taskModel.setTaskId(taskId);
        taskModel.setCheckerUserIds(checkerUserIds);
        taskModel.setDispatchOrgId(dispatchOrgId);
        return taskModel;
    }

    private void setTaskSizeLabelVal(int allTaskSize, int markTaskSize, int unMarkTaskSize) {
        String allTaskLabel = ResManager.loadKDString((String)"\u5168\u90e8\uff08%s\uff09\u4e2a", (String)"MyTaskPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[]{allTaskSize});
        String markTaskLabel = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09\u4e2a", (String)"MyTaskPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[]{markTaskSize});
        String unMarkTaskLabel = ResManager.loadKDString((String)"\u672a\u5b8c\u6210\uff08%s\uff09\u4e2a", (String)"MyTaskPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[]{unMarkTaskSize});
        TaskDispatchHelper.setLabelVal(this.getView(), "all", allTaskLabel);
        TaskDispatchHelper.setLabelVal(this.getView(), "mark", markTaskLabel);
        TaskDispatchHelper.setLabelVal(this.getView(), "unmark", unMarkTaskLabel);
    }

    private void createTaskEntry(List<DispatchTaskModel> taskModels) {
        this.getModel().deleteEntryData(TASK_ENTRY);
        this.getModel().beginInit();
        if (taskModels.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(TASK_ENTRY, taskModels.size());
        for (int i = 0; i < taskModels.size(); ++i) {
            DispatchTaskModel taskModel = taskModels.get(i) instanceof Map ? (DispatchTaskModel)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)taskModels.get(i)), DispatchTaskModel.class) : taskModels.get(i);
            Long schemeId = taskModel.getSchemeId();
            String stepId = taskModel.getStepId();
            String stepName = taskModel.getStepName();
            Long taskId = taskModel.getTaskId();
            List<Long> checkerUserIds = taskModel.getCheckerUserIds();
            Long dispatchOrgId = taskModel.getDispatchOrgId();
            String markStatus = taskModel.getMarkStatus();
            this.getModel().setValue("initscheme", (Object)schemeId, i);
            this.getModel().setValue("stepid", (Object)Long.valueOf(stepId), i);
            this.getModel().setValue("stepname", (Object)stepName, i);
            this.getModel().setValue("inittask", (Object)taskId, i);
            this.getModel().setValue("checkuser", (Object)checkerUserIds.toArray(), i);
            this.getModel().setValue("dispatchorg", (Object)dispatchOrgId, i);
            this.getModel().setValue("markstatus", (Object)markStatus, i);
        }
        this.getModel().endInit();
        this.getView().updateView(TASK_ENTRY);
    }

    public void click(SearchClickEvent evt) {
        boolean exists;
        Object value;
        FilterParameter filterParameter = evt.getFilterParameter();
        QFilter filter = new QFilter("1", "=", (Object)1);
        List qFilters = filterParameter.getQFilters();
        ArrayList<Object> filterOrgIds = new ArrayList<Object>(16);
        boolean isFilterOrgId = false;
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if ("dispatchorg.fbasedataid.id".equals(property)) {
                isFilterOrgId = true;
                Object value2 = qFilter.getValue();
                if (value2 instanceof List) {
                    filterOrgIds.addAll((List)value2);
                } else {
                    filterOrgIds.add(value2);
                }
            }
            filter.and(qFilter);
        }
        List fastFilters = evt.getFastQFilters();
        ArrayList<QFilter> andFilters = new ArrayList<QFilter>(16);
        ArrayList<QFilter> orFilters = new ArrayList<QFilter>(16);
        this.translateFastFilter(fastFilters, andFilters, orFilters);
        boolean isFilterOrgName = false;
        ArrayList<Object> filterOrgNames = new ArrayList<Object>(16);
        for (QFilter qFilter : andFilters) {
            String property = qFilter.getProperty();
            if ("dispatchorg.fbasedataid.name".equals(property)) {
                isFilterOrgName = true;
                value = qFilter.getValue();
                filterOrgNames.add(value);
            }
            filter.and(qFilter);
        }
        QFilter tempOrFilter = null;
        QFilter orgFilter = null;
        for (QFilter orFilter : orFilters) {
            String property = orFilter.getProperty();
            if ("dispatchorg.fbasedataid.name".equals(property)) {
                orgFilter = orFilter;
            }
            if (tempOrFilter == null) {
                tempOrFilter = orFilter;
                continue;
            }
            tempOrFilter.or(orFilter);
        }
        if (orgFilter != null && (exists = QueryServiceHelper.exists((String)"imic_taskdispatchrecord", (QFilter[])new QFilter[]{orgFilter}))) {
            isFilterOrgName = true;
            value = orgFilter.getValue();
            filterOrgNames.add(value);
        }
        if (tempOrFilter != null) {
            filter.and(tempOrFilter);
        }
        this.getPageCache().put(CONTAINER_FILTER, filter.toSerializedString());
        String nodeFilterStr = this.getPageCache().get(NODE_FILTER);
        if (StringUtils.isNotEmpty(nodeFilterStr)) {
            filter.and(QFilter.fromSerializedString((String)nodeFilterStr));
        }
        filter.and(TaskDispatchConst.CHARGEUSER_ID, "=", (Object)RequestContext.get().getCurrUserId()).and("dispatchstatus", "=", (Object)"1");
        this.initTaskEntry(filter, isFilterOrgId, isFilterOrgName, filterOrgIds, filterOrgNames);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("export".equals(opKey) && (selectRows = (entryGrid = (EntryGrid)this.getControl(TASK_ENTRY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"MyTaskPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        if ("toguide".equals(opKey)) {
            this.toGuide(currentRowIndex);
        } else if ("allexport".equals(opKey)) {
            DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
            ArrayList<DynamicObject> taskData = new ArrayList<DynamicObject>((Collection<DynamicObject>)taskEntrys);
            this.exportTaskData(taskData);
        } else if ("export".equals(opKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection taskEntry = this.getModel().getEntryEntity(TASK_ENTRY);
            List<DynamicObject> taskData = IntStream.of(selectRows).mapToObj(arg_0 -> taskEntry.get(arg_0)).collect(Collectors.toList());
            this.exportTaskData(taskData);
        }
    }

    private void toGuide(int currentRowIndex) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("initscheme", currentRowIndex);
        if (scheme == null) {
            return;
        }
        Long stepId = (Long)this.getModel().getValue("stepid", currentRowIndex);
        String initGuide = scheme.getString("initguide");
        initGuide = StringUtils.isNotBlank(initGuide) ? initGuide : "imic_initguide";
        DynamicObject bizApp = scheme.getDynamicObject("bizapp");
        String appNum = bizApp.getString("number");
        String appName = bizApp.getString("name");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5411\u5bfc_%s", (String)"MyTaskPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[]{appName}));
        formShowParameter.setCustomParam("initAppId", (Object)appNum);
        formShowParameter.setCustomParam("stepid", (Object)stepId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "toguide");
        formShowParameter.setCloseCallBack(closeCallBack);
        if ("pbd".equals(appNum)) {
            formShowParameter.setFormId("srm_init");
            formShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
            formShowParameter.setCustomParam("isFrom", (Object)"imic");
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("dispatchorg", currentRowIndex);
            DynamicObject initScheme = (DynamicObject)this.getModel().getValue("initscheme", currentRowIndex);
            formShowParameter.setFormId(initGuide);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (org != null) {
                formShowParameter.setCustomParam("dispatchOrgId", org.getPkValue());
                formShowParameter.setCustomParam("initAppId", initScheme.get("bizapp.number"));
                formShowParameter.setCustomParam("dispatchSchemeId", initScheme.getPkValue());
            }
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("toguide".equals(actionId)) {
            String containerFilterStr;
            QFilter filter = new QFilter(TaskDispatchConst.CHARGEUSER_ID, "=", (Object)RequestContext.get().getCurrUserId()).and("dispatchstatus", "=", (Object)"1");
            String nodeFilterStr = this.getPageCache().get(NODE_FILTER);
            if (StringUtils.isNotEmpty(nodeFilterStr)) {
                filter.and(QFilter.fromSerializedString((String)nodeFilterStr));
            }
            if (StringUtils.isNotEmpty(containerFilterStr = this.getPageCache().get(CONTAINER_FILTER))) {
                filter.and(QFilter.fromSerializedString((String)containerFilterStr));
            }
            this.initTaskEntry(filter, false, false, null, null);
        }
    }

    private void exportTaskData(List<DynamicObject> taskData) {
        if (taskData == null || taskData.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u5bfc\u51fa\u6570\u636e", (String)"MyTaskPlugin_6", (String)"imsc-imic-platform", (Object[])new Object[0]));
            return;
        }
        FileImportUtils fileImportUtils = FileImportUtils.getInstance(this.getTemplateData());
        XSSFWorkbook xssfWorkbook = fileImportUtils.createImportTemplate();
        XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
        int rowNum = 3;
        for (DynamicObject taskDatum : taskData) {
            DynamicObject dispatchOrg;
            XSSFRow row = fileImportUtils.getRow(sheet, rowNum);
            DynamicObject scheme = taskDatum.getDynamicObject("initscheme");
            String schemeNumber = scheme.getString("number");
            String schemeName = scheme.getString("name");
            String stepName = taskDatum.getString("stepname");
            DynamicObject task = taskDatum.getDynamicObject("inittask");
            String taskName = task.getString("itemname");
            String markStatus = taskDatum.getString("markstatus");
            String markStatusStr = MarkStatusEnum.getName(markStatus);
            ArrayList<String> checkerNums = new ArrayList<String>(16);
            ArrayList<String> checkerNames = new ArrayList<String>(16);
            DynamicObjectCollection checkers = taskDatum.getDynamicObjectCollection("checkuser");
            for (DynamicObject checker : checkers) {
                DynamicObject checkerDym = checker.getDynamicObject("fbasedataid");
                if (checkerDym == null) continue;
                String checkerName = StringUtils.isEmpty(checkerDym.getString("name")) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"MyTaskPlugin_22", (String)"imsc-imic-platform", (Object[])new Object[0]) : checkerDym.getString("name");
                String checkerNum = StringUtils.isEmpty(checkerDym.getString("number")) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u7a7a", (String)"MyTaskPlugin_23", (String)"imsc-imic-platform", (Object[])new Object[0]) : checkerDym.getString("number");
                checkerNums.add(checkerNum);
                checkerNames.add(checkerName);
            }
            fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 0), schemeNumber);
            fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 1), schemeName);
            fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 2), stepName);
            fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 3), taskName);
            fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 4), markStatusStr);
            if (!checkerNums.isEmpty()) {
                fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 5), String.join((CharSequence)",", checkerNums));
            }
            if (!checkerNames.isEmpty()) {
                fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 6), String.join((CharSequence)",", checkerNames));
            }
            if ((dispatchOrg = taskDatum.getDynamicObject("dispatchorg")) != null) {
                String orgNum = dispatchOrg.getString("number");
                String orgName = dispatchOrg.getString("name");
                fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 7), orgNum);
                fileImportUtils.setCellStringValue(fileImportUtils.getCell((Row)row, 8), orgName);
            }
            ++rowNum;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"MyTaskPlugin_7", (String)"imsc-imic-platform", (Object[])new Object[0]));
        String url = fileImportUtils.saveFileAsUrl(xssfWorkbook, ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1\u5bfc\u51fa\u6570\u636e", (String)"MyTaskPlugin_8", (String)"imsc-imic-platform", (Object[])new Object[0]));
        FileUtils.addDownloadPermission("imic_mytask", url, "imic");
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private ImportEntity getTemplateData() {
        ImportEntity importData = new ImportEntity();
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"*\u65b9\u6848\u7f16\u7801", (String)"MyTaskPlugin_9", (String)"imsc-imic-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801\u3002", (String)"MyTaskPlugin_10", (String)"imsc-imic-platform", (Object[])new Object[0])));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"MyTaskPlugin_11", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"\u6b65\u9aa4\u540d\u79f0", (String)"MyTaskPlugin_12", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("3", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u9879\u540d\u79f0", (String)"MyTaskPlugin_13", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("4", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001", (String)"MyTaskPlugin_14", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("5", new Header(ResManager.loadKDString((String)"\u68c0\u67e5\u4eba.\u5de5\u53f7", (String)"MyTaskPlugin_15", (String)"imsc-imic-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801\u3002", (String)"MyTaskPlugin_16", (String)"imsc-imic-platform", (Object[])new Object[0])));
        headerMap.put("6", new Header(ResManager.loadKDString((String)"\u68c0\u67e5\u4eba.\u59d3\u540d", (String)"MyTaskPlugin_17", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("7", new Header(ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7.\u7f16\u7801", (String)"MyTaskPlugin_18", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        headerMap.put("8", new Header(ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7.\u540d\u79f0", (String)"MyTaskPlugin_19", (String)"imsc-imic-platform", (Object[])new Object[0]), ""));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"MyTaskPlugin_20", (String)"imsc-imic-platform", (Object[])new Object[0]));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe", (String)"MyTaskPlugin_21", (String)"imsc-imic-platform", (Object[])new Object[0]));
        return importData;
    }

    private void translateFastFilter(List<QFilter> fastFilters, List<QFilter> andFilters, List<QFilter> orFilters) {
        for (QFilter fastFilter : fastFilters) {
            QFilter qFilter;
            String valueStr = (String)fastFilter.getValue();
            if (!StringUtils.isNotEmpty(valueStr)) continue;
            String property = valueStr.substring(0, valueStr.indexOf("#"));
            String value = valueStr.substring(valueStr.indexOf("#") + 1);
            if (property.contains(",")) {
                String[] propertySplit;
                for (String s : propertySplit = property.split(",")) {
                    if (value.contains("\b")) {
                        String[] strings;
                        for (String string : strings = value.split("\b")) {
                            QFilter qFilter2 = new QFilter(s, "LiKe", (Object)string);
                            orFilters.add(qFilter2);
                        }
                        continue;
                    }
                    qFilter = new QFilter(s, "LiKe", (Object)value);
                    orFilters.add(qFilter);
                }
                continue;
            }
            if (value.contains("\b")) {
                String[] strings;
                for (String string : strings = value.split("\b")) {
                    qFilter = new QFilter(property, "LiKe", (Object)string);
                    andFilters.add(qFilter);
                }
                continue;
            }
            QFilter qFilter3 = new QFilter(property, "LiKe", (Object)value);
            andFilters.add(qFilter3);
        }
    }
}

