/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.taskdispatch;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imsc.imbd.formplugin.AbstractImbdBdTreeListPlugin;
import kd.imsc.imic.business.ShowFormHelper;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.business.workbench.ImicWorkBenchCache;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;

public class TaskDispatchRecordListPlugin
extends AbstractImbdBdTreeListPlugin
implements RowClickEventListener,
TreeNodeClickListener,
SearchClickListener {
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String ALL_TASK_PANEL_AP = "alltaskpanelap";
    private static final String DISPATCH_PANEL_AP = "dispatchpanelap";
    private static final String UNDISPATCH_PANEL_AP = "undispatchpanelap";
    private static final String TASK_DISPATCH_AP = "taskdispatchap";
    private static final String TIP_PANEL_AP = "tippanelap";
    private static final String ABSTRACT_LABEL = "abstract";
    private static final String CONTAINER_FILTER = "containerfilter";
    private static final String FILTERCONTAINERAP = "filtercontainerap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl("taskentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        Vector closeVector = (Vector)this.getControl("vectorclose");
        closeVector.addClickListener((ClickListener)this);
        FilterContainer fc = (FilterContainer)this.getControl(FILTERCONTAINERAP);
        if (fc != null) {
            fc.addSearchClickListener((SearchClickListener)this);
        }
    }

    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getControl("treeview");
        TreeNode root = this.getTreeModel().getRoot();
        root.setChildren(new ArrayList(1));
        TreeNode treeNode = TaskDispatchHelper.buildTreeNode(root);
        this.getPageCache().put(TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)root));
        tree.addNode(treeNode);
    }

    public void refreshNode(RefreshNodeEvent e) {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        this.showTaskDispatchAp(currentNodeId.toString());
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refreshData();
        String treeNodeCacheStr = this.getPageCache().get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        TreeNode clickNode = root.getTreeNode(String.valueOf(currentNodeId), 10);
        e.setChildNodes(clickNode.getChildren());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            Long schemeId;
            String fieldName = commonFilterColumn.getFieldName();
            if (!TaskDispatchConst.INITSCHEME_ID.equals(fieldName) || (schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeid")) == null) continue;
            commonFilterColumn.setDefaultValue(schemeId.toString());
            QFilter filter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId);
            this.getPageCache().put(CONTAINER_FILTER, filter.toSerializedString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl("taskentry");
        cardEntry.setChildVisible(false, 0, new String[]{DISPATCH_PANEL_AP, UNDISPATCH_PANEL_AP});
        cardEntry.setChildVisible(false, 1, new String[]{ALL_TASK_PANEL_AP, UNDISPATCH_PANEL_AP});
        cardEntry.setChildVisible(false, 2, new String[]{ALL_TASK_PANEL_AP, DISPATCH_PANEL_AP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TASK_DISPATCH_AP});
        String closeTipBtn = ImicWorkBenchCache.queryRecord("closetipbtn", RequestContext.get().getCurrUserId());
        boolean showTipAp = StringUtils.isEmpty(closeTipBtn);
        this.getView().setVisible(Boolean.valueOf(showTipAp), new String[]{TIP_PANEL_AP});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("todispatch".equals(opKey)) {
            long currUserId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean permission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)"imic_initialscheme", (String)"4AQ5OZC07IJO");
            if (!permission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u521d\u59cb\u5316\u65b9\u6848\u201d\u7684\u201c\u4efb\u52a1\u4e0b\u8fbe\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskDispatchRecordListPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("delete".equals(opKey)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            this.showTaskDispatchAp(currentNodeId.toString());
        } else if ("refresh".equals(opKey)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            this.showTaskDispatchAp(currentNodeId.toString());
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refreshData();
        } else if ("todispatch".equals(opKey)) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            Object recordId = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"imic_taskdispatchrecord", (String)"initscheme", (QFilter[])new QFilter("id", "=", recordId).toArray());
            if (record == null) {
                return;
            }
            DynamicObject scheme = record.getDynamicObject("initscheme");
            if (scheme == null) {
                return;
            }
            long schemeId = scheme.getLong("id");
            customParams.put("schemeid", schemeId);
            FormShowParameter showParameter = ShowFormHelper.showFrom("imic_taskdispatch", null, null, ShowType.MainNewTabPage, null, customParams);
            this.getView().showForm(showParameter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("vectorclose".equalsIgnoreCase(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TIP_PANEL_AP});
            ImicWorkBenchCache.updateRecord("closetipbtn", key, RequestContext.get().getCurrUserId());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.showTaskDispatchAp(nodeId);
    }

    protected QFilter nodeClickFilter() {
        TreeNode focusNode = this.getFocusNode();
        return TaskDispatchHelper.getNodeClickFilter(focusNode);
    }

    private TreeNode getFocusNode() {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        String treeNodeCacheStr = this.getPageCache().get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return null;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        return root.getTreeNode((String)currentNodeId, 10);
    }

    private void showTaskDispatchAp(String nodeId) {
        String treeNodeCacheStr = this.getPageCache().get(TREE_NODE_CACHE);
        if (StringUtils.isEmpty(treeNodeCacheStr)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCacheStr, TreeNode.class);
        TreeNode clickNode = root.getTreeNode(nodeId, 10);
        List children = clickNode.getChildren();
        String closeTipBtn = ImicWorkBenchCache.queryRecord("closetipbtn", RequestContext.get().getCurrUserId());
        boolean showTaskAp = children == null || children.isEmpty();
        boolean showTipAp = !showTaskAp && StringUtils.isEmpty(closeTipBtn);
        this.getView().setVisible(Boolean.valueOf(showTaskAp), new String[]{TASK_DISPATCH_AP});
        this.getView().setVisible(Boolean.valueOf(showTipAp), new String[]{TIP_PANEL_AP});
        if (showTaskAp) {
            Long schemeId = Long.valueOf(nodeId);
            QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId);
            String containerFilterStr = this.getPageCache().get(CONTAINER_FILTER);
            if (StringUtils.isNotEmpty(containerFilterStr)) {
                recordFilter.and(QFilter.fromSerializedString((String)containerFilterStr));
            }
            this.setTaskDispatchInfo(recordFilter);
        }
        CardEntry cardEntry = (CardEntry)this.getControl("taskentry");
        cardEntry.selectRows(-1);
    }

    private void setTaskDispatchInfo(QFilter recordFilter) {
        String unDispatchTaskTip;
        String dispatchTaskTip;
        boolean useDimension = false;
        String recordProperties = String.join((CharSequence)",", "initscheme", "inittask", "dispatchstatus");
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)recordProperties, (QFilter[])recordFilter.toArray());
        HashMap taskMap = new HashMap(16);
        for (DynamicObject record : records) {
            DynamicObject initScheme = record.getDynamicObject("initscheme");
            useDimension = initScheme.getBoolean("usedimension");
            String dispatchStatus = record.getString("dispatchstatus");
            long taskId = record.getLong(TaskDispatchConst.INITTASK_ID);
            taskMap.putIfAbsent(dispatchStatus, new HashSet(16));
            ((Set)taskMap.get(dispatchStatus)).add(taskId);
        }
        int dispatchTaskSize = 0;
        int unDispatchTaskSize = 0;
        if (taskMap.containsKey("1") && taskMap.get("1") != null) {
            Set dispatchTasks = (Set)taskMap.get("1");
            dispatchTaskSize = dispatchTasks.size();
        }
        if (taskMap.containsKey("0") && taskMap.get("0") != null) {
            Set unDispatchTasks = (Set)taskMap.get("0");
            unDispatchTaskSize = unDispatchTasks.size();
        }
        int allTaskSize = dispatchTaskSize + unDispatchTaskSize;
        if (useDimension) {
            dispatchTaskTip = ResManager.loadKDString((String)"\u5df2\u5206\u914d\u4e86\u5168\u90e8\u7ec4\u7ec7\u5e76\u8bbe\u7f6e\u4e86\u8d23\u4efb\u4eba\u7684\u4efb\u52a1\u9879\u6570\u91cf\u3002", (String)"TaskDispatchRecordListPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
            unDispatchTaskTip = ResManager.loadKDString((String)"\u672a\u5206\u914d\u5168\u90e8\u7ec4\u7ec7\u6216\u672a\u8bbe\u7f6e\u8d23\u4efb\u4eba\u7684\u4efb\u52a1\u9879\u6570\u91cf\u3002", (String)"TaskDispatchRecordListPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[0]);
        } else {
            dispatchTaskTip = ResManager.loadKDString((String)"\u5df2\u5206\u914d\u8d23\u4efb\u4eba\u7684\u4efb\u52a1\u9879\u6570\u91cf\u3002", (String)"TaskDispatchRecordListPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[0]);
            unDispatchTaskTip = ResManager.loadKDString((String)"\u672a\u5206\u914d\u8d23\u4efb\u4eba\u7684\u4efb\u52a1\u9879\u6570\u91cf\u3002", (String)"TaskDispatchRecordListPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[0]);
        }
        IFormView view = this.getView();
        TaskDispatchHelper.setLabelVal(view, "dispatchtasksize", String.valueOf(dispatchTaskSize));
        TaskDispatchHelper.setLabelVal(view, "undispatchtasksize", String.valueOf(unDispatchTaskSize));
        TaskDispatchHelper.setLabelVal(view, "alltasksize", String.valueOf(allTaskSize));
        String abstractTip = ResManager.loadKDString((String)"\u5168\u90e8\u4efb\u52a1\uff08%s\uff09", (String)"TaskDispatchRecordListPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[]{allTaskSize});
        TaskDispatchHelper.setLabelVal(view, ABSTRACT_LABEL, abstractTip);
        TaskDispatchHelper.setLabelTip(view, "dispatchtasktip", dispatchTaskTip);
        TaskDispatchHelper.setLabelTip(view, "undispatchtasktip", unDispatchTaskTip);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TaskDispatchHelper.searchTreeText(this.getView(), searchText);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.filterBillList(row);
    }

    private void filterBillList(int row) {
        ArrayList<String> dispatchStatus = new ArrayList<String>(4);
        if (row == 0) {
            dispatchStatus.add("1");
            dispatchStatus.add("0");
        } else if (row == 1) {
            dispatchStatus.add("1");
        } else if (row == 2) {
            dispatchStatus.add("0");
        }
        QFilter dispatchStatusFilter = new QFilter("dispatchstatus", "in", dispatchStatus);
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        Long schemeId = Long.valueOf(currentNodeId.toString());
        QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId);
        String containerFilterStr = this.getPageCache().get(CONTAINER_FILTER);
        if (StringUtils.isNotEmpty(containerFilterStr)) {
            recordFilter.and(QFilter.fromSerializedString((String)containerFilterStr));
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        recordFilter.and(dispatchStatusFilter);
        billList.setQueryFilterParameter(new FilterParameter(recordFilter, null));
        billList.clearSelection();
        billList.refreshData();
    }

    public void click(SearchClickEvent evt) {
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        FilterParameter filterParameter = evt.getFilterParameter();
        List qFilters = filterParameter.getQFilters();
        List fastFilters = evt.getFastQFilters();
        QFilter filter = new QFilter("1", "=", (Object)1);
        for (QFilter qFilter : qFilters) {
            filter.and(qFilter);
        }
        this.getPageCache().put(CONTAINER_FILTER, filter.toSerializedString());
        this.showTaskDispatchAp(currentNodeId);
        if (!fastFilters.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TASK_DISPATCH_AP});
        }
    }
}

