/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.workbench;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.business.ShowFormHelper;
import kd.imsc.imic.business.workbench.ImicWorkBenchCache;
import kd.imsc.imic.business.workbench.ImicWorkBenchHelper;
import kd.imsc.imic.business.workbench.model.InitSchemeModel;
import kd.imsc.imic.business.workbench.model.InitStepModel;
import kd.imsc.imic.common.StringUtils;

public class ImicWorkBenchHomePlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List enableSchemeIds = QueryServiceHelper.queryPrimaryKeys((String)"imic_initialscheme", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray(), null, (int)-1);
        if (enableSchemeIds.isEmpty()) {
            String tip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u7528\u7684\u521d\u59cb\u5316\u65b9\u6848\u3002", (String)"ImicWorkBenchHomePlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(tip);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector moveTopVector = (Vector)this.getControl("movetop");
        moveTopVector.addClickListener((ClickListener)this);
        Vector moveDetailVector = (Vector)this.getControl("movedetail");
        moveDetailVector.addClickListener((ClickListener)this);
        EntryGrid cardEntry = (EntryGrid)this.getControl("homecardentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        BasedataEdit orgBaseData = (BasedataEdit)this.getControl("org");
        orgBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        long orgId = this.initOrg(currUserId);
        this.getModel().setValue("org", (Object)orgId);
        ImicWorkBenchCache.updateRecord("org", orgId, currUserId);
        List<String> schemeNums = ImicWorkBenchHelper.getSchemeNumList(orgId, currUserId, this.getView());
        this.getView().setVisible(Boolean.valueOf(!schemeNums.isEmpty()), new String[]{"flexpanelap1"});
        if (schemeNums.isEmpty()) {
            return;
        }
        List<InitSchemeModel> allSchemeInfos = ImicWorkBenchHelper.getAllSchemeInfos(schemeNums, orgId);
        Map<String, List<String>> stepPanelKeyMap = this.createCardEntry(allSchemeInfos);
        this.fillCardEntryData(allSchemeInfos, stepPanelKeyMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("movetop".equals(key)) {
            SetEntryTop setEntryTop = new SetEntryTop("homecardentry", this.getView());
            setEntryTop.invokeOperation();
        } else if ("movedetail".equals(key)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("homecardentry");
            this.showDetailForm(entryCurrentRowIndex);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.showDetailForm(row);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        long currUserId = RequestContext.get().getCurrUserId();
        if ("org".equals(key)) {
            String mark = this.getPageCache().get("mark");
            if (String.valueOf(true).equals(mark)) {
                this.getPageCache().put("mark", String.valueOf(false));
                return;
            }
            if (newValue == null) {
                this.getPageCache().put("mark", String.valueOf(true));
                this.getModel().setValue("org", oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImicWorkBenchHomePlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
                return;
            }
            long orgId = ((DynamicObject)newValue).getLong("id");
            ImicWorkBenchCache.updateRecord("org", orgId, currUserId);
            List<String> schemeNums = ImicWorkBenchHelper.getSchemeNumList(orgId, currUserId, null);
            Container cardEntryRowAp = (Container)this.getControl("cardentryrowap");
            this.deleteControl(cardEntryRowAp);
            this.getView().setVisible(Boolean.valueOf(!schemeNums.isEmpty()), new String[]{"flexpanelap1"});
            if (schemeNums.isEmpty()) {
                return;
            }
            List<InitSchemeModel> allSchemeInfos = ImicWorkBenchHelper.getAllSchemeInfos(schemeNums, orgId);
            Map<String, List<String>> stepPanelKeyMap = this.createCardEntry(allSchemeInfos);
            this.fillCardEntryData(allSchemeInfos, stepPanelKeyMap);
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        List<String> schemeNums = this.reCacheSchemeNums();
        int rowIndex = e.getRowIndexs()[0];
        int upRowIndex = rowIndex - 1;
        String schemeModelStr = this.getPageCache().get("schememodels");
        String stepPanelKeyStr = this.getPageCache().get("steppanelkeys");
        if (schemeModelStr != null && stepPanelKeyStr != null) {
            Map schemeModelMap = (Map)SerializationUtils.fromJsonString((String)schemeModelStr, Map.class);
            LinkedHashMap newSchemeModelMap = new LinkedHashMap(schemeModelMap.size());
            schemeNums.forEach(schemeNum -> {
                InitSchemeModel cfr_ignored_0 = (InitSchemeModel)newSchemeModelMap.put(schemeNum, schemeModelMap.get(schemeNum));
            });
            this.getPageCache().put("schememodels", SerializationUtils.toJsonString(newSchemeModelMap));
            Map stepPanelKeyMap = (Map)SerializationUtils.fromJsonString((String)stepPanelKeyStr, Map.class);
            this.reShowStepForm(rowIndex, schemeModelMap, stepPanelKeyMap);
            this.reShowStepForm(upRowIndex, schemeModelMap, stepPanelKeyMap);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        List<String> schemeNums = this.reCacheSchemeNums();
        int rowIndex = e.getRowIndexs()[0];
        int downRowIndex = rowIndex + 1;
        String schemeModelStr = this.getPageCache().get("schememodels");
        String stepPanelKeyStr = this.getPageCache().get("steppanelkeys");
        if (schemeModelStr != null && stepPanelKeyStr != null) {
            Map schemeModelMap = (Map)SerializationUtils.fromJsonString((String)schemeModelStr, Map.class);
            LinkedHashMap newSchemeModelMap = new LinkedHashMap(schemeModelMap.size());
            schemeNums.forEach(schemeNum -> {
                InitSchemeModel cfr_ignored_0 = (InitSchemeModel)newSchemeModelMap.put(schemeNum, schemeModelMap.get(schemeNum));
            });
            this.getPageCache().put("schememodels", SerializationUtils.toJsonString(newSchemeModelMap));
            Map stepPanelKeyMap = (Map)SerializationUtils.fromJsonString((String)stepPanelKeyStr, Map.class);
            this.reShowStepForm(rowIndex, schemeModelMap, stepPanelKeyMap);
            this.reShowStepForm(downRowIndex, schemeModelMap, stepPanelKeyMap);
        }
    }

    public void afterSetEntryTop(AfterMoveEntryEventArgs e) {
        List<String> schemeNums = this.reCacheSchemeNums();
        int rowIndex = e.getRowIndexs()[0];
        String schemeModelStr = this.getPageCache().get("schememodels");
        String stepPanelKeyStr = this.getPageCache().get("steppanelkeys");
        if (schemeModelStr != null && stepPanelKeyStr != null) {
            Map schemeModelMap = (Map)SerializationUtils.fromJsonString((String)schemeModelStr, Map.class);
            LinkedHashMap newSchemeModelMap = new LinkedHashMap(schemeModelMap.size());
            schemeNums.forEach(schemeNum -> {
                InitSchemeModel cfr_ignored_0 = (InitSchemeModel)newSchemeModelMap.put(schemeNum, schemeModelMap.get(schemeNum));
            });
            this.getPageCache().put("schememodels", SerializationUtils.toJsonString(newSchemeModelMap));
            Map stepPanelKeyMap = (Map)SerializationUtils.fromJsonString((String)stepPanelKeyStr, Map.class);
            for (int i = 0; i <= rowIndex; ++i) {
                this.reShowStepForm(i, schemeModelMap, stepPanelKeyMap);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (StringUtils.equals(key, "org")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setBillFormId("imic_workbenchorg");
        }
    }

    private long initOrg(long currUserId) {
        String cacheOrg = ImicWorkBenchCache.queryRecord("org", currUserId);
        long orgId = 0L;
        orgId = StringUtils.isNotEmpty(cacheOrg) ? Long.parseLong(cacheOrg) : RequestContext.get().getOrgId();
        return orgId;
    }

    private Map<String, List<String>> createCardEntry(List<InitSchemeModel> allSchemeInfos) {
        int i;
        CardEntry cardEntry = (CardEntry)this.getControl("homecardentry");
        Container cardEntryRowAp = (Container)this.getControl("cardentryrowap");
        Style entryPanelStyle = new Style();
        Margin entryPanelMargin = new Margin();
        entryPanelMargin.setLeft("8px");
        entryPanelMargin.setBottom("12px");
        entryPanelStyle.setMargin(entryPanelMargin);
        Style stepPanelStyle = new Style();
        Margin stepPanelMargin = new Margin();
        stepPanelMargin.setLeft("12px");
        stepPanelMargin.setTop("12px");
        stepPanelStyle.setMargin(stepPanelMargin);
        ArrayList<String> entryFlexPanelKeys = new ArrayList<String>(allSchemeInfos.size());
        ArrayList<Map> entryItems = new ArrayList<Map>(allSchemeInfos.size());
        LinkedHashMap<String, InitSchemeModel> schemeModelMap = new LinkedHashMap<String, InitSchemeModel>(16);
        HashMap<String, List<String>> stepPanelKeyMap = new HashMap<String, List<String>>(16);
        for (i = 0; i < allSchemeInfos.size(); ++i) {
            InitSchemeModel initSchemeModel = allSchemeInfos.get(i);
            String schemeNum = initSchemeModel.getSchemeNum();
            CardEntryFlexPanelAp cardEntryFlexPanelAp = this.createCardEntryFlexPanelAp(i, entryPanelStyle);
            String cardEntryFlexPanelApKey = cardEntryFlexPanelAp.getKey();
            entryFlexPanelKeys.add(cardEntryFlexPanelApKey);
            List<InitStepModel> initStepModels = initSchemeModel.getInitStepModels();
            ArrayList<FlexPanelAp> flexPanelAps = new ArrayList<FlexPanelAp>(initStepModels.size());
            ArrayList<String> stepFlexPanelApKeys = new ArrayList<String>(initStepModels.size());
            for (int j = 0; j < initStepModels.size(); ++j) {
                FlexPanelAp stepFlexPanelAp = this.createStepFlexPanelAp(j, cardEntryFlexPanelApKey, stepPanelStyle);
                flexPanelAps.add(stepFlexPanelAp);
                String stepFlexPanelApKey = stepFlexPanelAp.getKey();
                stepFlexPanelApKeys.add(stepFlexPanelApKey);
            }
            stepPanelKeyMap.put(schemeNum, stepFlexPanelApKeys);
            schemeModelMap.put(schemeNum, initSchemeModel);
            cardEntryFlexPanelAp.getItems().addAll(flexPanelAps);
            entryItems.add(cardEntryFlexPanelAp.createControl());
        }
        cardEntryRowAp.addControls(entryItems);
        this.getPageCache().put("schememodels", SerializationUtils.toJsonString(schemeModelMap));
        this.getPageCache().put("steppanelkeys", SerializationUtils.toJsonString(stepPanelKeyMap));
        this.getPageCache().put("entryPanelKeys", SerializationUtils.toJsonString(entryFlexPanelKeys));
        for (i = 0; i < entryFlexPanelKeys.size(); ++i) {
            String entryFlexPanelKey = (String)entryFlexPanelKeys.get(i);
            ArrayList newEntryFlexPanelKeys = new ArrayList(entryFlexPanelKeys);
            newEntryFlexPanelKeys.remove(entryFlexPanelKey);
            cardEntry.setChildVisible(false, i, newEntryFlexPanelKeys.toArray(new String[0]));
        }
        return stepPanelKeyMap;
    }

    private void deleteControl(Container cardEntryRowAp) {
        this.getModel().deleteEntryData("homecardentry");
        String entryPanelKeyStr = this.getPageCache().get("entryPanelKeys");
        if (StringUtils.isNotEmpty(entryPanelKeyStr)) {
            List cacheEntryFlexPanelKeys = (List)SerializationUtils.fromJsonString((String)entryPanelKeyStr, List.class);
            cardEntryRowAp.deleteControls(cacheEntryFlexPanelKeys.toArray(new String[0]));
        }
    }

    private void fillCardEntryData(List<InitSchemeModel> allSchemeInfos, Map<String, List<String>> stepPanelKeyMap) {
        CardEntry cardEntry = (CardEntry)this.getControl("homecardentry");
        this.getModel().batchCreateNewEntryRow("homecardentry", allSchemeInfos.size());
        for (int i = 0; i < allSchemeInfos.size(); ++i) {
            InitSchemeModel initSchemeModel = allSchemeInfos.get(i);
            String schemeName = initSchemeModel.getSchemeName();
            int initProgress = initSchemeModel.getInitProgress();
            String schemeNum = initSchemeModel.getSchemeNum();
            long schemeId = initSchemeModel.getSchemeId();
            this.getModel().setValue("schemenum", (Object)schemeNum, i);
            this.getModel().setValue("schemeid", (Object)schemeId, i);
            this.setLabelName(cardEntry, "schemename", schemeName, i);
            this.setLabelName(cardEntry, "schemeprogress", String.valueOf(initProgress), i);
            List<InitStepModel> initStepModels = initSchemeModel.getInitStepModels();
            List<String> stepFlexPanelApKeys = stepPanelKeyMap.get(schemeNum);
            for (int j = 0; j < initStepModels.size(); ++j) {
                InitStepModel initStepModel = initStepModels.get(j);
                String stepFlexPanelApKey = stepFlexPanelApKeys.get(j);
                HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                customParams.put("stepmodel", SerializationUtils.toJsonString((Object)initStepModel));
                FormShowParameter showParameter = ShowFormHelper.showFrom("imic_homestepcard", stepFlexPanelApKey, null, ShowType.InContainer, null, customParams);
                this.getView().showForm(showParameter);
            }
        }
    }

    private FlexPanelAp createStepFlexPanelAp(int j, String cardEntryFlexPanelApKey, Style stepPanelStyle) {
        String stepPanelApKey = cardEntryFlexPanelApKey + "steppanel" + j;
        FlexPanelAp stepPanelAp = new FlexPanelAp();
        stepPanelAp.setCollapsible(false);
        stepPanelAp.setShrink(0);
        stepPanelAp.setGrow(0);
        stepPanelAp.setRadius("5px");
        stepPanelAp.setWidth(new LocaleString("248px"));
        stepPanelAp.setHeight(new LocaleString("68px"));
        stepPanelAp.setKey(stepPanelApKey);
        stepPanelAp.setStyle(stepPanelStyle);
        return stepPanelAp;
    }

    private CardEntryFlexPanelAp createCardEntryFlexPanelAp(int i, Style entryPanelStyle) {
        String entryFlexPanelKey = "entryflexpanel" + i;
        CardEntryFlexPanelAp cardEntryFlexPanel = new CardEntryFlexPanelAp();
        cardEntryFlexPanel.setCollapsible(false);
        cardEntryFlexPanel.setShrink(0);
        cardEntryFlexPanel.setGrow(1);
        cardEntryFlexPanel.setKey(entryFlexPanelKey);
        cardEntryFlexPanel.setStyle(entryPanelStyle);
        cardEntryFlexPanel.setDirection("row");
        cardEntryFlexPanel.setWrap(true);
        cardEntryFlexPanel.setWidth(new LocaleString("90%"));
        cardEntryFlexPanel.setOverflow("visible");
        return cardEntryFlexPanel;
    }

    private void setLabelName(CardEntry cardEntry, String labelKey, Object labelValue, int rowIndex) {
        HashMap<String, Object> textMap = new HashMap<String, Object>(1);
        textMap.put("text", labelValue);
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
        map.put(labelKey, textMap);
        cardEntry.setCustomProperties(cardEntry.getKey(), rowIndex, map);
    }

    private List<String> reCacheSchemeNums() {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("homecardentry");
        List<String> schemeNums = entryEntity.stream().map(entry -> entry.getString("schemenum")).collect(Collectors.toList());
        ImicWorkBenchCache.updateRecord("schemeorders", SerializationUtils.toJsonString(schemeNums), currUserId);
        return schemeNums;
    }

    private void reShowStepForm(int rowIndex, Map<String, InitSchemeModel> schemeModelMap, Map<String, List<String>> stepPanelKeyMap) {
        String schemeNum = (String)this.getModel().getValue("schemenum", rowIndex);
        String schemeStr = SerializationUtils.toJsonString((Object)schemeModelMap.get(schemeNum));
        InitSchemeModel initSchemeModel = (InitSchemeModel)SerializationUtils.fromJsonString((String)schemeStr, InitSchemeModel.class);
        List<String> stepPanelKeys = stepPanelKeyMap.get(schemeNum);
        List<InitStepModel> initStepModels = initSchemeModel.getInitStepModels();
        for (int i = 0; i < initStepModels.size(); ++i) {
            InitStepModel initStepModel = initStepModels.get(i);
            String stepPanelKey = stepPanelKeys.get(i);
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("stepmodel", SerializationUtils.toJsonString((Object)initStepModel));
            FormShowParameter showParameter = ShowFormHelper.showFrom("imic_homestepcard", stepPanelKey, null, ShowType.InContainer, null, customParams);
            this.getView().showForm(showParameter);
        }
    }

    private void showDetailForm(int rowIndex) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        Object schemeId = this.getModel().getValue("schemeid", rowIndex);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("rowindex", rowIndex);
        customParams.put("orgId", orgId);
        customParams.put("schemeId", schemeId);
        String schemeModelStr = this.getPageCache().get("schememodels");
        if (schemeModelStr != null) {
            Map schemeModelMap = (Map)SerializationUtils.fromJsonString((String)schemeModelStr, LinkedHashMap.class);
            ArrayList schemeModelList = new ArrayList(schemeModelMap.values());
            customParams.put("schemeinfos", SerializationUtils.toJsonString(schemeModelList));
        }
        FormShowParameter showParameter = ShowFormHelper.showFrom("imic_workbenchdetail", null, null, ShowType.MainNewTabPage, null, customParams);
        this.getView().showForm(showParameter);
    }
}

