/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.imbd.opplugin.AbstractImbdOp;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.common.StringUtils;

public class TaskDispatchRecordSaveOp
extends AbstractImbdOp {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperateOption option = this.getOption();
        if (option.containsVariable("savetype")) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<DynamicObject> initSchemes = new HashSet<DynamicObject>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject[] initScheme = dataEntity.getDynamicObject("initscheme");
            if (initScheme == null) continue;
            initSchemes.add((DynamicObject)initScheme);
        }
        Map<Long, List<Long>> taskApplyOrgMap = TaskDispatchHelper.getTaskApplyOrgMap(initSchemes);
        String selectRecordProperties = String.join((CharSequence)",", "initscheme", "bizapp", "inittask", "dispatchstatus", "chargeuser", "dispatchorg");
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectRecordProperties, null);
        HashMap taskOrgMap = new HashMap(16);
        for (DynamicObject dynamicObject : records) {
            DynamicObject initScheme = dynamicObject.getDynamicObject("initscheme");
            boolean useDimension = initScheme.getBoolean("usedimension");
            if (!useDimension) continue;
            DynamicObject task = dynamicObject.getDynamicObject("inittask");
            long taskId = task.getLong("id");
            DynamicObjectCollection dispatchOrgs = dynamicObject.getDynamicObjectCollection("dispatchorg");
            List dipatchOrgIdList = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
            taskOrgMap.putIfAbsent(taskId, new ArrayList(16));
            ((List)taskOrgMap.get(taskId)).addAll(dipatchOrgIdList);
        }
        ArrayList<Long> disPatchedTaskIds = new ArrayList<Long>(16);
        ArrayList<Long> unDisPatchTaskIds = new ArrayList<Long>(16);
        for (Map.Entry entry : taskOrgMap.entrySet()) {
            Long taskId = (Long)entry.getKey();
            List newOrgList = (List)entry.getValue();
            List<Long> applyOrgList = taskApplyOrgMap.get(taskId);
            if (applyOrgList == null) continue;
            applyOrgList.removeAll(newOrgList);
            if (applyOrgList.isEmpty()) {
                disPatchedTaskIds.add(taskId);
                continue;
            }
            unDisPatchTaskIds.add(taskId);
        }
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject record : records) {
            DynamicObject initScheme = record.getDynamicObject("initscheme");
            DynamicObject bizApp = initScheme.getDynamicObject("bizapp");
            boolean useDimension = initScheme.getBoolean("usedimension");
            if (useDimension) {
                DynamicObject task = record.getDynamicObject("inittask");
                long taskId = task.getLong("id");
                if (disPatchedTaskIds.contains(taskId)) {
                    record.set("dispatchstatus", (Object)"1");
                    record.set("bizapp", (Object)bizApp);
                    updateRecords.add(record);
                    continue;
                }
                if (!unDisPatchTaskIds.contains(taskId)) continue;
                record.set("dispatchstatus", (Object)"0");
                record.set("bizapp", (Object)bizApp);
                updateRecords.add(record);
                continue;
            }
            String dispatchStatus = record.getString("dispatchstatus");
            if (!StringUtils.isEmpty(dispatchStatus)) continue;
            record.set("dispatchstatus", (Object)"1");
            record.set("bizapp", (Object)bizApp);
            updateRecords.add(record);
        }
        try {
            SaveServiceHelper.update((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7SaveServiceHelper.update()\u65b9\u6cd5\u66f4\u65b0\u4e0b\u8fbe\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\u3002", (String)"TaskDispatchRecordSaveOp_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
        }
    }
}

