/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ssc.task.mobile.common.MultiLangEnumBridge;
import kd.ssc.task.mobile.enums.Card;
import kd.ssc.task.mobile.enums.ICard;
import kd.ssc.task.mobile.formplugin.serviceap.SscAverageAgingDataProcessImpl;
import kd.ssc.task.mobile.formplugin.serviceap.SscServiceLotRejectRateDataProcessImpl;
import kd.ssc.task.mobile.formplugin.serviceap.SscServiceOverDueDataProcessImpl;
import kd.ssc.task.mobile.formplugin.serviceap.SscServiceSweepBackDataProcessImpl;
import kd.ssc.task.mobile.template.AbstractDataProcess;

public enum CardEnum implements ICard
{
    TaskPoolCard(new MultiLangEnumBridge("\u4efb\u52a1\u6c60", "CardEnum_0", "ssc-task-mobile"), "scc_taskpool_card_m"),
    ToDoTaskCard(new MultiLangEnumBridge("\u5f85\u5904\u7406\u4efb\u52a1", "CardEnum_1", "ssc-task-mobile"), "scc_todotask_card_m"),
    TaskStockTrendCard(new MultiLangEnumBridge("\u4efb\u52a1\u5b58\u91cf\u8d8b\u52bf", "CardEnum_2", "ssc-task-mobile"), "ssc_taskstock_trend_m"),
    UnqualifiedCard(new MultiLangEnumBridge("\u8d28\u68c0\u4e0d\u5408\u683c\u7387", "CardEnum_3", "ssc-task-mobile"), "ssc_unqualified_card_m"),
    UnqualifiedTrendCard(new MultiLangEnumBridge("\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u53d8\u5316\u8d8b\u52bf", "CardEnum_4", "ssc-task-mobile"), "ssc_unqualified_trend_m"),
    QualityProportionCard(new MultiLangEnumBridge("\u8d28\u68c0\u70b9\u4e0d\u5408\u683c\u5360\u6bd4", "CardEnum_5", "ssc-task-mobile"), "ssc_quality_proportion_m"),
    EfficiencyTrendCard(new MultiLangEnumBridge("\u4eba\u5747\u6548\u80fd\u53ca\u8d8b\u52bf", "CardEnum_6", "ssc-task-mobile"), "ssc_effic_analysis_m"),
    EfficiencyGroupCard(new MultiLangEnumBridge("\u7528\u6237\u7ec4\u6548\u80fd\u5206\u6790", "CardEnum_7", "ssc-task-mobile"), "ssc_effic_analysis_g_m"),
    EfficiencyTaskRankCard(new MultiLangEnumBridge("\u672c\u6708\u5b8c\u6210\u4efb\u52a1\u91cf\u6392\u884c", "CardEnum_8", "ssc-task-mobile"), "ssc_effic_taskrank_m"),
    InteAuditPercentCard(new MultiLangEnumBridge("\u667a\u80fd\u5ba1\u5355\u7387", "CardEnum_9", "ssc-task-mobile"), "ssc_inte_audit_card_m"),
    InteCheckItemPercentCard(new MultiLangEnumBridge("\u68c0\u67e5\u9879\u81ea\u52a8\u5316\u7387", "CardEnum_10", "ssc-task-mobile"), "ssc_checkitem_card_m"),
    InteQualAnalysisCard(new MultiLangEnumBridge("\u667a\u80fd\u8d28\u68c0\u5e94\u7528\u5206\u6790", "CardEnum_11", "ssc-task-mobile"), "ssc_intequal_analysis_m"),
    ServiceOrgDistributeCard(new MultiLangEnumBridge("\u670d\u52a1\u7ec4\u7ec7\u5206\u5e03", "CardEnum_12", "ssc-task-mobile"), "ssc_service_org_dist_m"),
    ServiceOrgSatisCard(new MultiLangEnumBridge("\u670d\u52a1\u7ec4\u7ec7\u6ee1\u610f\u5ea6\u5206\u6790", "CardEnum_13", "ssc-task-mobile"), "ssc_ser_org_satisf_card_m"),
    LotRejectRateCard(new MultiLangEnumBridge("\u6279\u9000\u7387", "CardEnum_14", "ssc-task-mobile"), "ssc_lot_reject_rate_m"),
    SweepRateBackCard(new MultiLangEnumBridge("\u9000\u626b\u7387", "CardEnum_15", "ssc-task-mobile"), "ssc_sweep_rate_back_m"),
    AverageAging(new MultiLangEnumBridge("\u5e73\u5747\u5904\u7406\u65f6\u957f", "CardEnum_16", "ssc-task-mobile"), "ssc_average_aging_m"),
    OverDueRateCard(new MultiLangEnumBridge("\u4efb\u52a1\u8d85\u671f\u7387", "CardEnum_17", "ssc-task-mobile"), "ssc_overdue_rate_m");

    private final String formId;
    private final MultiLangEnumBridge caption;

    private CardEnum(MultiLangEnumBridge caption, String formId) {
        this.caption = caption;
        this.formId = formId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public String getCaption() {
        return this.caption.loadKDString();
    }

    public static HashMap<String, ICard> toMap() {
        CardEnum[] values;
        LinkedHashMap<String, ICard> map = new LinkedHashMap<String, ICard>();
        for (CardEnum cardEnum : values = CardEnum.values()) {
            map.put(cardEnum.formId, new Card(cardEnum.getFormId(), cardEnum.getCaption()));
        }
        return map;
    }

    public static Set<String> toSet() {
        return Arrays.stream(CardEnum.values()).map(CardEnum::getFormId).collect(Collectors.toSet());
    }

    public AbstractDataProcess getDataProcess() {
        switch (this) {
            case LotRejectRateCard: {
                return new SscServiceLotRejectRateDataProcessImpl();
            }
            case SweepRateBackCard: {
                return new SscServiceSweepBackDataProcessImpl();
            }
            case OverDueRateCard: {
                return new SscServiceOverDueDataProcessImpl();
            }
        }
        return new SscAverageAgingDataProcessImpl();
    }
}

