/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.TeamLeaderApi;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyHelper;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;

public class SscEfficiencyGroupCardPlugin
extends SscDateSpanCardTemplatePlugin {
    private String[] colors = new String[]{"#281198", "#CD393B", "#5BC071", "#AA206C", "#FC93D7", "#F91121", "#EF7F88", "#1E49DB", "#CDD89C", "#8C53BC", "#E2CB05", "#BD003B", "#F1FA61", "#5B7664", "#03E53C", "#94FCDC", "#D6DDF2", "#D88A09", "#AFACA3", "#AF452E", "#FE39DE", "#403A04", "#799A8C", "#8670B9", "#B5D064", "#9E2729", "#82A311", "#C30D02", "#029292", "#DA489F", "#0AA9C6", "#7F51F0", "#0671F2", "#826A09", "#319381", "#B89F21", "#CD6698", "#7C19AA", "#7844BD", "#BF8FAA", "#F23394", "#400E85", "#B60E2E", "#E63DF1", "#5DDADE", "#0818D5", "#603563", "#E86E35", "#C3928E", "#A2367C"};

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        this.refreshEfficiencyScatterChart();
    }

    @Override
    protected Map<String, String> setDefaultDateType() {
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("date_span_panel", DateSpanEnum.CURRENT_MONTH.getNumber());
        return stringStringHashMap;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detailbtn"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("detailbtn".equals(key)) {
            this.jumpToGroupEfficiencyDetailPage();
        }
    }

    public void afterBindData(EventObject e) {
        String permItemId;
        String entityNum;
        String appId;
        long userId;
        boolean hasPerm;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!"true".equals(formShowParameter.getCustomParam("CARD_IS_SHARE")) && !(hasPerm = PermissionServiceHelper.hasSpecificPerm((long)(userId = RequestContext.get().getCurrUserId()), (String)(appId = AppMetadataCache.getAppInfo((String)"ssc").getId()), (String)(entityNum = "ssc_index_m"), (String)(permItemId = "1QK0=48VR690")))) {
            IFormView view = this.getView();
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "flexfilter", "detailbtn", "cc_icon_popover"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            ((Label)view.getControl("defaultlabel")).setText(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7528\u6237\u7ec4\u6548\u80fd\u5206\u6790\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"SscEfficiencyGroupCardPlugin_01", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return;
        }
        String sscIdStr = (String)formShowParameter.getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u672a\u6307\u5b9a\u3002", (String)"SscEfficiencyGroupCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.refreshEfficiencyScatterChart();
    }

    private void refreshEfficiencyScatterChart() {
        ArrayList<EfficiencyModel> EfficiencyModels = this.loadEfficiencyDataOfGroup();
        this.createScatterChart(EfficiencyModels);
    }

    private ArrayList<EfficiencyModel> loadEfficiencyDataOfGroup() {
        DynamicObjectCollection groups;
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        String dateSpanType = dateSpanPO.getDateSpanType();
        IPageCache pageCache = this.getPageCache();
        String dataStr = pageCache.get(dateSpanType);
        if (dataStr != null) {
            String errorCountStr = pageCache.get(dateSpanType + "errorCount");
            this.refreshErrorCountFP(StringUtils.isEmpty((String)errorCountStr) ? BigDecimal.ZERO : new BigDecimal(errorCountStr));
            return (ArrayList)SerializationUtils.fromJsonStringToList((String)dataStr, EfficiencyModel.class);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long sscId = Long.parseLong((String)formShowParameter.getCustomParam("sharecenter"));
        long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("createorg", "=", (Object)sscId);
        boolean isAdmin = TeamLeaderApi.isAdminRole(String.valueOf(sscId), userId, "HXLFBW8ZGNH");
        if (!isAdmin) {
            qFilter.and("task_usergroup.entryentity.userfield", "=", (Object)userId);
            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId))) {
                qFilter.and("task_usergroup.entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        if ((groups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter})).size() == 0) {
            return null;
        }
        QFilter dateFilter = DateSpanCommonUtils.timeSection("completetime", dateSpanPO.getStartDateSpan(), dateSpanPO.getEndDateSpan());
        QFilter filters = new QFilter("sscid", "=", (Object)sscId).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and(dateFilter);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,personid,usergroup.id,coefficient,expirestate", (QFilter[])filters.toArray());
        Map<Long, List<DynamicObject>> taskGroupByUserGroup = tasks.stream().collect(Collectors.groupingBy(e -> e.getLong("usergroup.id")));
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>(10);
        BigDecimal errorCount = BigDecimal.ZERO;
        int groupSize = 0;
        for (DynamicObject group : groups) {
            List<DynamicObject> taskOfOneGroup = taskGroupByUserGroup.get(group.getLong("id"));
            if (taskOfOneGroup == null) continue;
            ++groupSize;
            BigDecimal taskCount = BigDecimal.ZERO;
            BigDecimal onTimeTaskCount = BigDecimal.ZERO;
            for (DynamicObject task : taskOfOneGroup) {
                BigDecimal curTask = task.getBigDecimal("coefficient");
                if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                    curTask = BigDecimal.ONE;
                    errorCount = errorCount.add(BigDecimal.ONE);
                }
                taskCount = taskCount.add(curTask);
                if ("2".equals(task.getString("expirestate"))) continue;
                onTimeTaskCount = onTimeTaskCount.add(curTask);
            }
            BigDecimal onTimeRate = onTimeTaskCount.multiply(new BigDecimal("100")).divide(taskCount, 1, 4);
            Set<Long> userOfOneGroup = taskOfOneGroup.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))).keySet();
            int peopleCount = userOfOneGroup.size();
            BigDecimal efficiencyOfOneGroup = taskCount.divide(new BigDecimal(peopleCount), 1, 4);
            entryList.add(new EfficiencyModel(group.getString("name"), efficiencyOfOneGroup, peopleCount, onTimeRate, this.colors[groupSize % 50]));
        }
        entryList.sort((b, a) -> a.getEfficiency().compareTo(b.getEfficiency()));
        this.refreshErrorCountFP(errorCount);
        if (!DateSpanEnum.CUSTOM.getNumber().equals(dateSpanType)) {
            pageCache.put(dateSpanType, SerializationUtils.toJsonString(entryList));
            pageCache.put(dateSpanType + "errorCount", errorCount.toPlainString());
        }
        return entryList;
    }

    private void createScatterChart(ArrayList<EfficiencyModel> efficiencyModels) {
        IFormView view = this.getView();
        if (efficiencyModels == null || efficiencyModels.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover", "legendfp"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover", "legendfp"});
        view.setVisible(Boolean.FALSE, new String[]{"defaultflex"});
        BigDecimal maxEfficiency = BigDecimal.ZERO;
        ArrayList seriesData = new ArrayList();
        int itemCount = efficiencyModels.size();
        for (int i = 0; i < itemCount; ++i) {
            EfficiencyModel e = efficiencyModels.get(i);
            BigDecimal curEfficiency = e.getEfficiency();
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("value", new BigDecimal[]{e.getOnTimeRate(), curEfficiency});
            itemMap.put("g", e.getGroupName());
            itemMap.put("e", e.getEfficiency());
            itemMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", e.getColor())));
            seriesData.add(itemMap);
            if (curEfficiency.compareTo(maxEfficiency) <= 0) continue;
            maxEfficiency = curEfficiency;
        }
        BigDecimal maxValueOfYAxis = EfficiencyHelper.calcFitMaxValue(maxEfficiency);
        HashMap<String, Object> chartData = new HashMap<String, Object>();
        HashMap<String, String> gridMap = new HashMap<String, String>();
        gridMap.put("top", "12%");
        gridMap.put("right", "8%");
        gridMap.put("bottom", "10%");
        chartData.put("grid", gridMap);
        HashMap<String, Object> tooltipMap = new HashMap<String, Object>();
        tooltipMap.put("show", Boolean.TRUE);
        tooltipMap.put("position", "inside");
        tooltipMap.put("trigger", "item");
        String efficStr = ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd\uff1a", (String)"SscEfficiencyGroupCardPlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String onTimeRateStr = ResManager.loadKDString((String)"\u53ca\u65f6\u7387\uff1a", (String)"SscEfficiencyGroupCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
        tooltipMap.put("formatter", "function(i) {return i.data.g + '<br />" + efficStr + "' + i.data.e.toFixed(1) + '<br />" + onTimeRateStr + "' + i.data.value[0].toFixed(1) + '%';}");
        chartData.put("tooltip", tooltipMap);
        HashMap<String, Object> xAxisMap = new HashMap<String, Object>();
        xAxisMap.put("name", ResManager.loadKDString((String)"\u5904\u7406\u53ca\u65f6\u7387\uff08%\uff09", (String)"SscEfficiencyGroupCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        xAxisMap.put("nameLocation", "center");
        xAxisMap.put("nameGap", 24);
        xAxisMap.put("type", "value");
        xAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        xAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> xAxisLineMap = new HashMap<String, Object>();
        xAxisLineMap.put("show", Boolean.TRUE);
        xAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        xAxisLineMap.put("symbolSize", new int[]{8, 8});
        xAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        xAxisMap.put("axisLine", xAxisLineMap);
        xAxisMap.put("interval", 25);
        xAxisMap.put("max", 100);
        chartData.put("xAxis", new HashMap[]{xAxisMap});
        HashMap<String, Object> yAxisMap = new HashMap<String, Object>();
        yAxisMap.put("name", ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd", (String)"SscEfficiencyGroupCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
        yAxisMap.put("nameGap", 22);
        yAxisMap.put("type", "value");
        yAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        yAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> yAxisLineMap = new HashMap<String, Object>();
        yAxisLineMap.put("show", Boolean.TRUE);
        yAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        yAxisLineMap.put("symbolSize", new int[]{8, 8});
        yAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        yAxisMap.put("axisLine", yAxisLineMap);
        yAxisMap.put("max", maxValueOfYAxis);
        yAxisMap.put("interval", maxValueOfYAxis.divide(new BigDecimal(4), 1, 4));
        yAxisMap.put("axisLabel", Collections.singletonMap("formatter", "function(v, i) {return v.toFixed(1)}"));
        chartData.put("yAxis", new HashMap[]{yAxisMap});
        HashMap<String, Object> seriesMap = new HashMap<String, Object>();
        seriesMap.put("type", "scatter");
        seriesMap.put("data", seriesData);
        HashMap<String, Object> markAreaMap = new HashMap<String, Object>();
        markAreaMap.put("silent", Boolean.TRUE);
        markAreaMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#CDFEFC")));
        HashMap<String, String> beginPoint = new HashMap<String, String>();
        beginPoint.put("xAxis", "average");
        beginPoint.put("yAxis", "average");
        HashMap endPoint = new HashMap();
        markAreaMap.put("data", new Object[]{new Object[]{beginPoint, endPoint}});
        seriesMap.put("markArea", markAreaMap);
        HashMap<String, Object> markLineMap = new HashMap<String, Object>();
        markLineMap.put("silent", Boolean.TRUE);
        markLineMap.put("symbol", "none");
        markLineMap.put("precision", 1);
        markLineMap.put("tooltip", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> lineStyleMap = new HashMap<String, Object>();
        lineStyleMap.put("type", "dashed");
        lineStyleMap.put("normal", Collections.singletonMap("color", "#999999"));
        markLineMap.put("lineStyle", lineStyleMap);
        HashMap<String, String> markLineDataMap1 = new HashMap<String, String>();
        markLineDataMap1.put("type", "average");
        HashMap<String, Object> markLineDataMap2 = new HashMap<String, Object>();
        markLineDataMap2.put("type", "average");
        markLineDataMap2.put("valueIndex", 0);
        markLineMap.put("data", new HashMap[]{markLineDataMap1, markLineDataMap2});
        seriesMap.put("markLine", markLineMap);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        ArrayList<Object> yAxisLabelFuncPath = new ArrayList<Object>();
        yAxisLabelFuncPath.add("yAxis");
        yAxisLabelFuncPath.add(0);
        yAxisLabelFuncPath.add("axisLabel");
        yAxisLabelFuncPath.add("formatter");
        chartData.put("functions", new Object[]{toolTipFuncPath, yAxisLabelFuncPath});
        chartData.put("series", new HashMap[]{seriesMap});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        clientViewProxy.setFieldProperty("efficiencyscatterchart", "data", chartData);
    }

    private void refreshErrorCountFP(BigDecimal errorCount) {
        if (errorCount.compareTo(BigDecimal.ZERO) > 0) {
            ((Label)this.getControl("errorcountlabel")).setText(String.format(ResManager.loadKDString((String)"%s\u6761\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u91cf\u7cfb\u6570\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e3a\u6807\u51c6\u7cfb\u65701.00\u3002", (String)"SscEfficiencyGroupCardPlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0]), errorCount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"errorcountfp"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"errorcountfp"});
        }
    }

    private void jumpToGroupEfficiencyDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_effic_analysis_g_d_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u6548\u80fd\u5206\u6790", (String)"SscEfficiencyGroupCardPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        parameter.setCustomParam("sharecenter", formShowParameter.getCustomParam("sharecenter"));
        parameter.setCustomParam("usergroup", formShowParameter.getCustomParam("usergroup"));
        String dateSpanType = this.getDateSpanPO("date_span_panel").getDateSpanType();
        parameter.setCustomParam("dateSpanType", (Object)dateSpanType);
        if (DateSpanEnum.CUSTOM.getNumber().equals(dateSpanType)) {
            IPageCache pageCache = this.getPageCache();
            parameter.setCustomParam("startDate", (Object)pageCache.get("start_date_span_panel"));
            parameter.setCustomParam("endDate", (Object)pageCache.get("end_date_span_panel"));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.EfficiencyGroupCard.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"SscEfficiencyGroupCardPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }
}

