/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.TeamLeaderApi;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyHelper;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;

public class SscEfficiencyGroupDetailMobFormPlugin
extends SscDateSpanCardTemplatePlugin
implements TabSelectListener {
    private static final String ALGO_KEY = SscEfficiencyGroupDetailMobFormPlugin.class.getName();
    public static final String KEY_ENTRY = "entryentity";
    public static final String KEY_ALL_DATA = "0";
    public static final String KEY_AREA1 = "1";
    public static final String KEY_AREA2 = "2";
    public static final String KEY_AREA3 = "3";
    public static final String KEY_AREA4 = "4";
    private String[] colors = new String[]{"#281198", "#CD393B", "#5BC071", "#AA206C", "#FC93D7", "#F91121", "#EF7F88", "#1E49DB", "#CDD89C", "#8C53BC", "#E2CB05", "#BD003B", "#F1FA61", "#5B7664", "#03E53C", "#94FCDC", "#D6DDF2", "#D88A09", "#AFACA3", "#AF452E", "#FE39DE", "#403A04", "#799A8C", "#8670B9", "#B5D064", "#9E2729", "#82A311", "#C30D02", "#029292", "#DA489F", "#0AA9C6", "#7F51F0", "#0671F2", "#826A09", "#319381", "#B89F21", "#CD6698", "#7C19AA", "#7844BD", "#BF8FAA", "#F23394", "#400E85", "#B60E2E", "#E63DF1", "#5DDADE", "#0818D5", "#603563", "#E86E35", "#C3928E", "#A2367C"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        this.refreshEfficiencyScatterChart(subTabKey.substring(subTabKey.length() - 1));
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sscIdStr = (String)formShowParameter.getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscEfficiencyGroupDetailMobFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        if (DateSpanEnum.CUSTOM.getNumber().equals(formShowParameter.getCustomParam("dateSpanType"))) {
            String startDate = (String)formShowParameter.getCustomParam("startDate");
            String endDate = (String)formShowParameter.getCustomParam("endDate");
            IPageCache pageCache = this.getPageCache();
            pageCache.put("start_date_span_panel", startDate);
            pageCache.put("end_date_span_panel", endDate);
            Label dateSpanLabel = (Label)this.getView().getControl("date_span_panel_label");
            dateSpanLabel.setText(startDate + " ~ " + endDate);
        }
        this.refreshEfficiencyScatterChart(KEY_AREA1);
    }

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        if ("area1".equals(tab.getCurrentTab())) {
            this.refreshEfficiencyScatterChart(KEY_AREA1);
        } else {
            tab.activeTab("area1");
        }
    }

    @Override
    protected Map<String, String> setDefaultDateType() {
        String dateSpanType = (String)this.getView().getFormShowParameter().getCustomParam("dateSpanType");
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("date_span_panel", dateSpanType != null ? dateSpanType : DateSpanEnum.CURRENT_MONTH.getNumber());
        return stringStringHashMap;
    }

    private void refreshEfficiencyScatterChart(String area) {
        HashMap<String, ArrayList<EfficiencyModel>> dataMap = this.loadEfficiencyDataOfGroup();
        this.createScatterChart(dataMap, area);
        this.createRowsOfOneArea(dataMap, area);
    }

    private HashMap<String, ArrayList<EfficiencyModel>> loadEfficiencyDataOfGroup() {
        DynamicObjectCollection groups;
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        HashMap<String, ArrayList<EfficiencyModel>> dataMapFromCache = this.deserializeEfficiencyDataFromCache(dateSpanPO.getDateSpanType());
        if (dataMapFromCache != null) {
            String errorCountStr = this.getPageCache().get(dateSpanPO.getDateSpanType() + "errorCount");
            this.refreshErrorCountFP(StringUtils.isEmpty((String)errorCountStr) ? BigDecimal.ZERO : new BigDecimal(errorCountStr));
            return dataMapFromCache;
        }
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long sscId = Long.parseLong((String)formShowParameter.getCustomParam("sharecenter"));
        long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("createorg", "=", (Object)sscId);
        boolean isAdmin = TeamLeaderApi.isAdminRole(String.valueOf(sscId), userId, "HXLFBW8ZGNH");
        if (!isAdmin) {
            qFilter.and("task_usergroup.entryentity.userfield", "=", (Object)userId);
            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId))) {
                qFilter.and("task_usergroup.entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        if ((groups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter})).size() == 0) {
            return null;
        }
        DynamicObject sscName = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sscId)});
        ((Label)view.getControl("ssclabel")).setText(sscName.getString("name"));
        QFilter dateFilter = DateSpanCommonUtils.timeSection("completetime", dateSpanPO.getStartDateSpan(), dateSpanPO.getEndDateSpan());
        QFilter filters = new QFilter("sscid", "=", (Object)sscId).and("pooltype", "=", (Object)KEY_AREA2).and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and(dateFilter);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,personid,usergroup.id,coefficient,expirestate", (QFilter[])filters.toArray());
        Map<Long, List<DynamicObject>> taskGroupByUserGroup = tasks.stream().collect(Collectors.groupingBy(e -> e.getLong("usergroup.id")));
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>(10);
        BigDecimal totalEfficiency = BigDecimal.ZERO;
        BigDecimal totalOnTimeRate = BigDecimal.ZERO;
        BigDecimal errorCount = BigDecimal.ZERO;
        int groupSize = 0;
        Map<Long, Integer> integerMap = this.queryUserGroupActiveUser(taskGroupByUserGroup.keySet());
        for (DynamicObject group : groups) {
            long usergroup = group.getLong("id");
            List<DynamicObject> taskOfOneGroup = taskGroupByUserGroup.get(usergroup);
            if (taskOfOneGroup == null) continue;
            ++groupSize;
            BigDecimal taskCount = BigDecimal.ZERO;
            BigDecimal onTimeTaskCount = BigDecimal.ZERO;
            for (DynamicObject task : taskOfOneGroup) {
                BigDecimal curTask = task.getBigDecimal("coefficient");
                if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                    curTask = BigDecimal.ONE;
                    errorCount = errorCount.add(BigDecimal.ONE);
                }
                taskCount = taskCount.add(curTask);
                if (KEY_AREA2.equals(task.getString("expirestate"))) continue;
                onTimeTaskCount = onTimeTaskCount.add(curTask);
            }
            BigDecimal onTimeRate = onTimeTaskCount.multiply(new BigDecimal("100")).divide(taskCount, 1, 4);
            Set<Long> userOfOneGroup = taskOfOneGroup.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))).keySet();
            int peopleCount = userOfOneGroup.size();
            BigDecimal efficiency = taskCount.divide(new BigDecimal(peopleCount), 1, 4);
            entryList.add(new EfficiencyModel(group.getString("name"), efficiency, integerMap.getOrDefault(usergroup, 0), onTimeRate, this.colors[groupSize % 50]));
            totalEfficiency = totalEfficiency.add(efficiency);
            totalOnTimeRate = totalOnTimeRate.add(onTimeRate);
        }
        if (groupSize == 0) {
            return null;
        }
        this.refreshErrorCountFP(errorCount);
        this.getPageCache().put(dateSpanPO.getDateSpanType() + "errorCount", errorCount.toPlainString());
        entryList.sort((b, a) -> a.getEfficiency().compareTo(b.getEfficiency()));
        BigDecimal groupCount = new BigDecimal(groupSize);
        BigDecimal averageOnTimeRate = totalOnTimeRate.divide(groupCount, 1, 4);
        BigDecimal averageEfficiency = totalEfficiency.divide(groupCount, 1, 4);
        int initSize = entryList.size() / 2;
        ArrayList<EfficiencyModel> firstAreaData = new ArrayList<EfficiencyModel>(initSize);
        ArrayList<EfficiencyModel> secondAreaData = new ArrayList<EfficiencyModel>(initSize);
        ArrayList<EfficiencyModel> thirdAreaData = new ArrayList<EfficiencyModel>(initSize);
        ArrayList<EfficiencyModel> fourthAreaData = new ArrayList<EfficiencyModel>(initSize);
        for (EfficiencyModel e2 : entryList) {
            BigDecimal efficiency = e2.getEfficiency();
            BigDecimal onTimeRate = e2.getOnTimeRate();
            if (efficiency.compareTo(averageEfficiency) >= 0 && onTimeRate.compareTo(averageOnTimeRate) >= 0) {
                firstAreaData.add(e2);
                continue;
            }
            if (efficiency.compareTo(averageEfficiency) > 0 && onTimeRate.compareTo(averageOnTimeRate) < 0) {
                secondAreaData.add(e2);
                continue;
            }
            if (efficiency.compareTo(averageEfficiency) < 0 && onTimeRate.compareTo(averageOnTimeRate) < 0) {
                thirdAreaData.add(e2);
                continue;
            }
            fourthAreaData.add(e2);
        }
        HashMap<String, ArrayList<EfficiencyModel>> dataMap = new HashMap<String, ArrayList<EfficiencyModel>>();
        dataMap.put(KEY_ALL_DATA, entryList);
        dataMap.put(KEY_AREA1, firstAreaData);
        dataMap.put(KEY_AREA2, secondAreaData);
        dataMap.put(KEY_AREA3, thirdAreaData);
        dataMap.put(KEY_AREA4, fourthAreaData);
        if (!DateSpanEnum.CUSTOM.getNumber().equals(dateSpanPO.getDateSpanType())) {
            this.getPageCache().put(dateSpanPO.getDateSpanType(), SerializationUtils.toJsonString(dataMap));
        }
        return dataMap;
    }

    /*
     * Exception decompiling
     */
    private Map<Long, Integer> queryUserGroupActiveUser(Set<Long> usergoups) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createScatterChart(HashMap<String, ArrayList<EfficiencyModel>> dataMap, String area) {
        IFormView view = this.getView();
        if (dataMap == null || dataMap.get(KEY_ALL_DATA).isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "legendfp"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            return;
        }
        ArrayList<EfficiencyModel> efficiencyModels = dataMap.get(KEY_ALL_DATA);
        view.setVisible(Boolean.TRUE, new String[]{"contentflexcore", "legendfp"});
        view.setVisible(Boolean.FALSE, new String[]{"defaultflex"});
        BigDecimal maxEfficiency = BigDecimal.ZERO;
        ArrayList seriesData = new ArrayList();
        int itemCount = efficiencyModels.size();
        for (int i = 0; i < itemCount; ++i) {
            EfficiencyModel e = efficiencyModels.get(i);
            BigDecimal curEfficiency = e.getEfficiency();
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("value", new BigDecimal[]{e.getOnTimeRate(), curEfficiency});
            itemMap.put("g", e.getGroupName());
            itemMap.put("e", e.getEfficiency());
            itemMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", e.getColor())));
            seriesData.add(itemMap);
            if (curEfficiency.compareTo(maxEfficiency) <= 0) continue;
            maxEfficiency = curEfficiency;
        }
        BigDecimal maxValueOfYAxis = EfficiencyHelper.calcFitMaxValue(maxEfficiency);
        HashMap<String, Object> chartData = new HashMap<String, Object>();
        HashMap<String, String> gridMap = new HashMap<String, String>();
        gridMap.put("top", "12%");
        gridMap.put("right", "8%");
        gridMap.put("bottom", "10%");
        chartData.put("grid", gridMap);
        HashMap<String, Object> tooltipMap = new HashMap<String, Object>();
        tooltipMap.put("show", Boolean.TRUE);
        tooltipMap.put("position", "inside");
        tooltipMap.put("trigger", "item");
        String efficStr = ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd\uff1a", (String)"SscEfficiencyGroupDetailMobFormPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String onTimeRateStr = ResManager.loadKDString((String)"\u53ca\u65f6\u7387\uff1a", (String)"SscEfficiencyGroupDetailMobFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
        tooltipMap.put("formatter", "function(i) {return i.data.g + '<br />" + efficStr + "' + i.data.e.toFixed(1) + '<br />" + onTimeRateStr + "' + i.data.value[0].toFixed(1) + '%';}");
        chartData.put("tooltip", tooltipMap);
        HashMap<String, Object> xAxisMap = new HashMap<String, Object>();
        xAxisMap.put("name", ResManager.loadKDString((String)"\u5904\u7406\u53ca\u65f6\u7387\uff08%\uff09", (String)"SscEfficiencyGroupDetailMobFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        xAxisMap.put("nameLocation", "center");
        xAxisMap.put("nameGap", 24);
        xAxisMap.put("type", "value");
        xAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        xAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> xAxisLineMap = new HashMap<String, Object>();
        xAxisLineMap.put("show", Boolean.TRUE);
        xAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        xAxisLineMap.put("symbolSize", new int[]{8, 8});
        xAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        xAxisMap.put("axisLine", xAxisLineMap);
        xAxisMap.put("interval", 25);
        xAxisMap.put("max", 100);
        chartData.put("xAxis", new HashMap[]{xAxisMap});
        HashMap<String, Object> yAxisMap = new HashMap<String, Object>();
        yAxisMap.put("name", ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd", (String)"SscEfficiencyGroupDetailMobFormPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
        yAxisMap.put("nameGap", 22);
        yAxisMap.put("type", "value");
        yAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        yAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> yAxisLineMap = new HashMap<String, Object>();
        yAxisLineMap.put("show", Boolean.TRUE);
        yAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        yAxisLineMap.put("symbolSize", new int[]{8, 8});
        yAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        yAxisMap.put("axisLine", yAxisLineMap);
        yAxisMap.put("max", maxValueOfYAxis);
        yAxisMap.put("interval", maxValueOfYAxis.divide(new BigDecimal(4), 1, 4));
        yAxisMap.put("axisLabel", Collections.singletonMap("formatter", "function(v, i) {return v.toFixed(1)}"));
        chartData.put("yAxis", new HashMap[]{yAxisMap});
        HashMap<String, Object> seriesMap = new HashMap<String, Object>();
        seriesMap.put("type", "scatter");
        seriesMap.put("data", seriesData);
        seriesMap.put("markArea", this.markAreaBySelectedTag(area, maxValueOfYAxis));
        HashMap<String, Object> markLineMap = new HashMap<String, Object>();
        markLineMap.put("silent", Boolean.TRUE);
        markLineMap.put("symbol", "none");
        markLineMap.put("precision", 1);
        markLineMap.put("tooltip", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> lineStyleMap = new HashMap<String, Object>();
        lineStyleMap.put("type", "dashed");
        lineStyleMap.put("normal", Collections.singletonMap("color", "#999999"));
        markLineMap.put("lineStyle", lineStyleMap);
        HashMap<String, String> markLineDataMap1 = new HashMap<String, String>();
        markLineDataMap1.put("type", "average");
        HashMap<String, Object> markLineDataMap2 = new HashMap<String, Object>();
        markLineDataMap2.put("type", "average");
        markLineDataMap2.put("valueIndex", 0);
        markLineMap.put("data", new HashMap[]{markLineDataMap1, markLineDataMap2});
        seriesMap.put("markLine", markLineMap);
        chartData.put("series", new HashMap[]{seriesMap});
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        ArrayList<Object> yAxisLabelFuncPath = new ArrayList<Object>();
        yAxisLabelFuncPath.add("yAxis");
        yAxisLabelFuncPath.add(0);
        yAxisLabelFuncPath.add("axisLabel");
        yAxisLabelFuncPath.add("formatter");
        chartData.put("functions", new Object[]{toolTipFuncPath, yAxisLabelFuncPath});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        clientViewProxy.setFieldProperty("efficiencyscatterchart", "data", chartData);
    }

    private HashMap<String, Object> markAreaBySelectedTag(String area, BigDecimal yAxisMaxValue) {
        HashMap<String, Object> beginPoint = new HashMap<String, Object>();
        HashMap<String, Object> endPoint = new HashMap<String, Object>();
        if (KEY_AREA1.equals(area)) {
            beginPoint.put("xAxis", "average");
            beginPoint.put("yAxis", "average");
        } else if (KEY_AREA2.equals(area)) {
            beginPoint.put("xAxis", 0.5);
            beginPoint.put("yAxis", "average");
            endPoint.put("xAxis", "average");
            endPoint.put("yAxis", yAxisMaxValue);
        } else if (KEY_AREA3.equals(area)) {
            beginPoint.put("xAxis", 0.5);
            beginPoint.put("yAxis", 0);
            endPoint.put("xAxis", "average");
            endPoint.put("yAxis", "average");
        } else if (KEY_AREA4.equals(area)) {
            beginPoint.put("xAxis", "average");
            beginPoint.put("yAxis", 0);
            endPoint.put("xAxis", 100);
            endPoint.put("yAxis", "average");
        }
        HashMap<String, Object> markAreaMap = new HashMap<String, Object>();
        markAreaMap.put("silent", Boolean.TRUE);
        markAreaMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#CDFEFC")));
        markAreaMap.put("data", new Object[]{new Object[]{beginPoint, endPoint}});
        return markAreaMap;
    }

    private void createRowsOfOneArea(HashMap<String, ArrayList<EfficiencyModel>> dataMap, String area) {
        if (dataMap == null) {
            return;
        }
        List entryOfOneArea = dataMap.get(area);
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        if (entryOfOneArea != null && !entryOfOneArea.isEmpty()) {
            model.beginInit();
            int size = entryOfOneArea.size();
            model.batchCreateNewEntryRow(KEY_ENTRY, size);
            DynamicObjectCollection efficiencyEntryEntity = model.getEntryEntity(KEY_ENTRY);
            DynamicProperty groupName = efficiencyEntryEntity.getDynamicObjectType().getProperty("groupname");
            DynamicProperty efficiency = efficiencyEntryEntity.getDynamicObjectType().getProperty("efficiency");
            DynamicProperty peopleCount = efficiencyEntryEntity.getDynamicObjectType().getProperty("peoplecount");
            DynamicProperty onTimeRate = efficiencyEntryEntity.getDynamicObjectType().getProperty("ontimerate");
            DynamicProperty color = efficiencyEntryEntity.getDynamicObjectType().getProperty("color");
            for (int i = 0; i < size; ++i) {
                EfficiencyModel efficiencyModel = (EfficiencyModel)entryOfOneArea.get(i);
                DynamicObject entry = (DynamicObject)efficiencyEntryEntity.get(i);
                groupName.setValueFast((Object)entry, (Object)efficiencyModel.getGroupName());
                efficiency.setValueFast((Object)entry, (Object)efficiencyModel.getEfficiency());
                peopleCount.setValueFast((Object)entry, (Object)efficiencyModel.getPeopleCount());
                onTimeRate.setValueFast((Object)entry, (Object)(efficiencyModel.getOnTimeRate() + "%"));
                color.setValueFast((Object)entry, (Object)efficiencyModel.getColor());
            }
            model.endInit();
            IFormView view = this.getView();
            view.updateView(KEY_ENTRY);
        }
    }

    private HashMap<String, ArrayList<EfficiencyModel>> deserializeEfficiencyDataFromCache(String dateRange) {
        String dataStr = this.getPageCache().get(dateRange);
        if (dataStr != null) {
            ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
            TypeFactory typeFactory = objectMapper.getTypeFactory();
            SimpleType stringType = ReferenceType.constructUnsafe(String.class);
            CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, EfficiencyModel.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, (JavaType)stringType, (JavaType)collectionType);
            try {
                return (HashMap)objectMapper.readValue(dataStr, (JavaType)mapType);
            }
            catch (JsonProcessingException e) {
                throw new KDBizException("error to deserialize cache efficiency data");
            }
        }
        return null;
    }

    private void refreshErrorCountFP(BigDecimal errorCount) {
        if (errorCount.compareTo(BigDecimal.ZERO) > 0) {
            ((Label)this.getControl("errorcountlabel")).setText(String.format(ResManager.loadKDString((String)"%s\u6761\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u91cf\u7cfb\u6570\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e3a\u6807\u51c6\u7cfb\u65701.00\u3002", (String)"SscEfficiencyGroupDetailMobFormPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]), errorCount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"errorcountfp"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"errorcountfp"});
        }
    }

    private static /* synthetic */ Integer lambda$queryUserGroupActiveUser$4(Row row) {
        return row.getInteger("entryentity.userfield");
    }

    private static /* synthetic */ Long lambda$queryUserGroupActiveUser$3(Row row) {
        return row.getLong("entryentity.groupid");
    }
}

