/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscEfficiencyTaskRankCardPlugin
extends SscCardTemplatePlugin {
    public static final String KEY_ENTRY = "entryentity";

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("detailbtn".equals(key)) {
            this.jumpToTaskRankDetailPage();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detailbtn"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sscIdStr = (String)this.getView().getFormShowParameter().getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscEfficiencyTaskRankCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.refreshTaskRankList();
    }

    private void refreshTaskRankList() {
        Long sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        DynamicObjectCollection userEntry = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield userId, entryentity.userfield.name username, entryentity.userfield.picturefield picture", (QFilter[])new QFilter("createorg", "=", (Object)sscId).toArray());
        HashMap<Long, DynamicObject> userMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject ue : userEntry) {
            long userId = ue.getLong("userId");
            if (userId <= 0L || userMap.containsKey(userId)) continue;
            userMap.put(userId, ue);
        }
        IFormView view = this.getView();
        if (userMap.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            return;
        }
        LocalDate now = LocalDate.now();
        LocalDate firstDayOfLastMonth = now.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        Date beginQueryDate = CommonUtils.localDate2Date(firstDayOfLastMonth);
        Date endQueryDate = CommonUtils.localDate2Date(now.with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L));
        QFilter filters = new QFilter("sscid", "=", (Object)sscId).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and("completetime", ">=", (Object)beginQueryDate).and("completetime", "<", (Object)endQueryDate);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id, personid, coefficient, completetime", (QFilter[])filters.toArray());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Map<String, List<DynamicObject>> taskGroupByMonth = tasks.stream().collect(Collectors.groupingBy(t -> format.format(t.getDate("completetime"))));
        List<DynamicObject> taskOfCurMonth = taskGroupByMonth.get(format.format(new Date()));
        List<DynamicObject> taskOfLastMonth = taskGroupByMonth.get(format.format(beginQueryDate));
        if (taskOfCurMonth == null || taskOfCurMonth.isEmpty()) {
            String text = ResManager.loadKDString((String)"\u672c\u6708\u672a\u53d1\u73b0\u5df2\u5904\u7406\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5ba1\u6838\u5de5\u4f5c\u3002", (String)"SscEfficiencyTaskRankCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]);
            ((Label)view.getControl("defaultlabel")).setText(text);
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            return;
        }
        Map<Long, List<DynamicObject>> taskGroupByUserOfCurMonth = taskOfCurMonth.stream().collect(Collectors.groupingBy(e -> e.getLong("personid")));
        Map<Long, List<DynamicObject>> taskGroupByUserOfLastMonth = taskOfLastMonth != null ? taskOfLastMonth.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))) : Collections.EMPTY_MAP;
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>();
        HashMap<Long, EfficiencyModel> dataOfLastMonth = new HashMap<Long, EfficiencyModel>();
        BigDecimal zero = BigDecimal.ZERO.setScale(1, 4);
        BigDecimal errorCount = BigDecimal.ZERO;
        for (Map.Entry e2 : userMap.entrySet()) {
            Long userId = (Long)e2.getKey();
            DynamicObject user = (DynamicObject)e2.getValue();
            List<DynamicObject> taskOfOneUser = taskGroupByUserOfCurMonth.get(userId);
            List<DynamicObject> taskOfOneUserOfLastMonth = taskGroupByUserOfLastMonth.get(userId);
            BigDecimal taskCount = zero;
            if (taskOfOneUser != null) {
                for (DynamicObject task : taskOfOneUser) {
                    BigDecimal curTask = task.getBigDecimal("coefficient");
                    if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                        curTask = BigDecimal.ONE;
                        errorCount = errorCount.add(BigDecimal.ONE);
                    }
                    taskCount = taskCount.add(curTask);
                }
            }
            entryList.add(new EfficiencyModel(userId, user.getString("username"), user.getString("picture"), taskCount.setScale(1, 4)));
            BigDecimal taskCountOfLastMonth = zero;
            if (taskOfOneUserOfLastMonth != null) {
                taskCountOfLastMonth = taskOfOneUserOfLastMonth.stream().map(t -> t.getBigDecimal("coefficient")).reduce(BigDecimal::add).orElse(zero);
            }
            dataOfLastMonth.put(userId, new EfficiencyModel(userId, null, null, taskCountOfLastMonth.setScale(1, 4)));
        }
        this.refreshErrorCountFP(errorCount);
        if (!dataOfLastMonth.isEmpty()) {
            List sortedLastData = dataOfLastMonth.values().stream().sorted((a, b) -> b.getTaskOfUser().compareTo(a.getTaskOfUser())).collect(Collectors.toList());
            int size = sortedLastData.size();
            ((EfficiencyModel)sortedLastData.get(0)).setTaskRankOfUser(1);
            for (int i = 1; i < size; ++i) {
                EfficiencyModel cur = (EfficiencyModel)sortedLastData.get(i);
                EfficiencyModel last = (EfficiencyModel)sortedLastData.get(i - 1);
                if (cur.getTaskOfUser().compareTo(last.getTaskOfUser()) == 0) {
                    cur.setTaskRankOfUser(last.getTaskRankOfUser());
                    continue;
                }
                cur.setTaskRankOfUser(i + 1);
            }
        }
        entryList.sort((a, b) -> b.getTaskOfUser().compareTo(a.getTaskOfUser()));
        int size2 = entryList.size();
        for (int i = 0; i < size2; ++i) {
            EfficiencyModel cur = (EfficiencyModel)entryList.get(i);
            if (i == 0) {
                cur.setTaskRankOfUser(1);
            } else {
                EfficiencyModel last = entryList.get(i - 1);
                if (cur.getTaskOfUser().compareTo(last.getTaskOfUser()) == 0) {
                    cur.setTaskRankOfUser(last.getTaskRankOfUser());
                } else {
                    cur.setTaskRankOfUser(i + 1);
                }
            }
            EfficiencyModel compareData = (EfficiencyModel)dataOfLastMonth.get(cur.getUserId());
            if (compareData == null) continue;
            int rank = compareData.getTaskRankOfUser() - cur.getTaskRankOfUser();
            cur.setChangedTaskRankOfUser(rank < 0 ? rank + "" : (rank > 0 ? "+" + rank : "+0"));
        }
        this.fillEntry(entryList);
    }

    private void fillEntry(ArrayList<EfficiencyModel> entryList) {
        List top5EntryData = entryList.stream().limit(5L).collect(Collectors.toList());
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        model.beginInit();
        int size = top5EntryData.size();
        model.batchCreateNewEntryRow(KEY_ENTRY, size);
        DynamicObjectCollection efficiencyEntryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty rank = efficiencyEntryEntity.getDynamicObjectType().getProperty("rank");
        DynamicProperty username = efficiencyEntryEntity.getDynamicObjectType().getProperty("username");
        DynamicProperty taskCount = efficiencyEntryEntity.getDynamicObjectType().getProperty("taskcount");
        DynamicProperty rankChange = efficiencyEntryEntity.getDynamicObjectType().getProperty("rankchange");
        DynamicProperty picture = efficiencyEntryEntity.getDynamicObjectType().getProperty("picture");
        for (int i = 0; i < size; ++i) {
            EfficiencyModel efficiencyModel = (EfficiencyModel)top5EntryData.get(i);
            DynamicObject entry = (DynamicObject)efficiencyEntryEntity.get(i);
            rank.setValueFast((Object)entry, (Object)efficiencyModel.getTaskRankOfUser());
            username.setValueFast((Object)entry, (Object)efficiencyModel.getUserName());
            taskCount.setValueFast((Object)entry, (Object)efficiencyModel.getTaskOfUser());
            rankChange.setValueFast((Object)entry, (Object)efficiencyModel.getChangedTaskRankOfUser());
            picture.setValueFast((Object)entry, (Object)efficiencyModel.getPicture());
        }
        model.endInit();
        IFormView view = this.getView();
        view.updateView(KEY_ENTRY);
        this.setPropDataTag(1);
    }

    private void jumpToTaskRankDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_effic_taskrank_d_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u672c\u6708\u5b8c\u6210\u4efb\u52a1\u91cf\u6392\u884c", (String)"SscEfficiencyTaskRankCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("sharecenter", this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.EfficiencyTaskRankCard.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u672c\u6708\u5b8c\u6210\u4efb\u52a1\u91cf\u6392\u884c", (String)"SscEfficiencyTaskRankCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    private void refreshErrorCountFP(BigDecimal errorCount) {
        if (errorCount.compareTo(BigDecimal.ZERO) > 0) {
            ((Label)this.getControl("errorcountlabel")).setText(String.format(ResManager.loadKDString((String)"%s\u6761\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u91cf\u7cfb\u6570\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e3a\u6807\u51c6\u7cfb\u65701.00\u3002", (String)"SscEfficiencyTaskRankCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]), errorCount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"errorcountfp"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"errorcountfp"});
        }
    }
}

