/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscEfficiencyUserMobFormPlugin
extends SscCardTemplatePlugin {
    public static final String KEY_ENTRY = "entryentity";
    public static final String KEY_LISTFP = "listfp";
    public static final String KEY_SELECTED_DATE = "datefield";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (KEY_SELECTED_DATE.equals(e.getProperty().getName())) {
            this.refreshUserEfficiencyList();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String userGroupIdStr = (String)formShowParameter.getCustomParam("usergroup");
        String sscIdStr = (String)formShowParameter.getCustomParam("sharecenter");
        if (StringUtils.isEmpty((CharSequence)userGroupIdStr) || StringUtils.isEmpty((CharSequence)sscIdStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u548c\u7528\u6237\u7ec4\u3002", (String)"SscEfficiencyUserMobFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        String selectedDate = (String)formShowParameter.getCustomParam("selectedDate");
        this.getModel().setValue(KEY_SELECTED_DATE, (Object)selectedDate);
        this.getView().updateView(KEY_SELECTED_DATE);
        this.refreshUserEfficiencyList();
    }

    private void refreshUserEfficiencyList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long sscId = Long.parseLong((String)formShowParameter.getCustomParam("sharecenter"));
        long userGroupId = Long.parseLong((String)formShowParameter.getCustomParam("usergroup"));
        String userGroupName = (String)formShowParameter.getCustomParam("userGroupName");
        String sscName = (String)formShowParameter.getCustomParam("sscName");
        DynamicObjectCollection users = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield.id id,entryentity.userfield.name name", (QFilter[])new QFilter("id", "=", (Object)userGroupId).toArray());
        LocalDate selectedDate = ((Date)this.getModel().getValue(KEY_SELECTED_DATE)).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Date beginQueryDate = CommonUtils.localDate2Date(selectedDate.with(TemporalAdjusters.firstDayOfMonth()));
        Date endQueryDate = CommonUtils.localDate2Date(selectedDate.with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L));
        QFilter filters = new QFilter("usergroup", "=", (Object)userGroupId).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and("completetime", ">=", (Object)beginQueryDate).and("completetime", "<", (Object)endQueryDate);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,personid,usergroup.id,coefficient,completetime", (QFilter[])filters.toArray());
        Map<Long, List<DynamicObject>> taskGroupByUserGroup = tasks.stream().collect(Collectors.groupingBy(e -> e.getLong("personid")));
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>();
        BigDecimal totalTaskCount = BigDecimal.ZERO;
        BigDecimal zero = BigDecimal.ZERO.setScale(1, 4);
        for (DynamicObject user : users) {
            List<DynamicObject> taskOfOneUser = taskGroupByUserGroup.get(user.getLong("id"));
            if (taskOfOneUser != null) {
                BigDecimal taskCount = BigDecimal.ZERO;
                for (DynamicObject task : taskOfOneUser) {
                    BigDecimal curTask = task.getBigDecimal("coefficient");
                    if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                        curTask = BigDecimal.ONE;
                    }
                    taskCount = taskCount.add(curTask);
                }
                totalTaskCount = totalTaskCount.add(taskCount);
                entryList.add(new EfficiencyModel(user.getString("name"), taskCount.setScale(1, 4)));
                continue;
            }
            entryList.add(new EfficiencyModel(user.getString("name"), zero));
        }
        entryList.sort((a, b) -> b.getTaskOfUser().compareTo(a.getTaskOfUser()));
        this.createRows(entryList);
        BigDecimal totalEfficiency = taskGroupByUserGroup.size() > 0 ? totalTaskCount.divide(new BigDecimal(taskGroupByUserGroup.size()), 1, 4) : new BigDecimal("0.0");
        ((Label)this.getView().getControl("efficiency")).setText(totalEfficiency.toString());
        ((Label)this.getView().getControl("taskcount")).setText(totalTaskCount.setScale(1, 4).toString());
        ((Label)this.getView().getControl("peoplecount")).setText(taskGroupByUserGroup.size() + "");
        ((Label)this.getView().getControl("sscentername")).setText(sscName);
        ((Label)this.getView().getControl("usergrouplabel")).setText(userGroupName);
    }

    private void createRows(ArrayList<EfficiencyModel> entryList) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        model.beginInit();
        int size = entryList.size();
        model.batchCreateNewEntryRow(KEY_ENTRY, size);
        DynamicObjectCollection efficiencyEntryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty userName = efficiencyEntryEntity.getDynamicObjectType().getProperty("username");
        DynamicProperty taskOfUser = efficiencyEntryEntity.getDynamicObjectType().getProperty("taskcountofuser");
        for (int i = 0; i < size; ++i) {
            EfficiencyModel efficiencyModel = entryList.get(i);
            DynamicObject entry = (DynamicObject)efficiencyEntryEntity.get(i);
            userName.setValueFast((Object)entry, (Object)efficiencyModel.getUserName());
            taskOfUser.setValueFast((Object)entry, (Object)efficiencyModel.getTaskOfUser());
        }
        model.endInit();
        IFormView view = this.getView();
        this.getView().updateView(KEY_ENTRY);
        view.setVisible(Boolean.TRUE, new String[]{KEY_LISTFP});
    }
}

