/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.DateUtil;

public class SscDateSpanCardTemplatePlugin
extends SscCardTemplatePlugin {
    private static final Log log = LogFactory.getLog(SscDateSpanCardTemplatePlugin.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String pattern = "yyyy/MM/dd";
    public static final String DEFAULT_DATE_SPAN = "date_span_panel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.getPageCache().get("date_span_controls").split(","));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.saveNewDateSpanControls();
        this.saveDateType();
        this.initializeDateSpanLabel();
    }

    private void initializeDateSpanLabel() {
        Map<String, String> defaultDateTypes = this.getDefaultDateSpanTypeMap();
        List<String> dateSpanControlNames = this.getDateSpanContrlNames();
        for (String dateSpanControlName : dateSpanControlNames) {
            Label dateSpanLabel;
            String defaultDateType = defaultDateTypes.get(dateSpanControlName);
            if (StringUtils.isBlank((CharSequence)defaultDateType)) {
                defaultDateType = DateSpanEnum.TODAY.getNumber();
            }
            if ((dateSpanLabel = (Label)this.getView().getControl(dateSpanControlName + "_label")) != null) {
                dateSpanLabel.setText(DateSpanEnum.getNameByNumber(defaultDateType));
            }
            DateRangePO rangePO = DateSpanEnum.getDateSpanByType(defaultDateType);
            this.getPageCache().put("type_" + dateSpanControlName, defaultDateType);
            this.getPageCache().put("start_" + dateSpanControlName, rangePO.getStartDate() == null ? null : DateUtil.format(rangePO.getStartDate(), pattern));
            this.getPageCache().put("end_" + dateSpanControlName, rangePO.getEndDate() == null ? null : DateUtil.format(rangePO.getEndDate(), pattern));
        }
    }

    private void saveNewDateSpanControls() {
        Object[] controlNames = this.registerNewDateSpanControls();
        StringBuilder currentDateSpanControlNames = new StringBuilder(DEFAULT_DATE_SPAN);
        if (ArrayUtils.isNotEmpty((Object[])controlNames)) {
            for (Object controlName : controlNames) {
                currentDateSpanControlNames.append(',').append((String)controlName);
            }
        }
        this.getPageCache().put("date_span_controls", currentDateSpanControlNames.toString());
    }

    protected String[] registerNewDateSpanControls() {
        return new String[0];
    }

    private void saveDateType() {
        Map<String, String> defaultDateTypes = this.setDefaultDateType();
        if (CollectionUtils.isEmpty(defaultDateTypes)) {
            return;
        }
        this.saveDefaultDateSpanTypeMap(defaultDateTypes);
    }

    protected Map<String, String> setDefaultDateType() {
        HashMap<String, String> defaultDateTypeMap = new HashMap<String, String>();
        defaultDateTypeMap.put(DEFAULT_DATE_SPAN, DateSpanEnum.CURRENT_MONTH.getNumber());
        return defaultDateTypeMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getDateSpanContrlNames().contains(key)) {
            this.showDateSpanSelectModalPage(key);
        }
    }

    private void showDateSpanSelectModalPage(String key) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_datespan_select_m");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("position", "bottom");
        parameter.getOpenStyle().setCustParam(custParam);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        DateSpanPO dateSpanPO = this.getDateSpanPO(key);
        String dateSpanType = dateSpanPO.getDateSpanType();
        Date startSpanDate = dateSpanPO.getStartDateSpan();
        Date endSpanDate = dateSpanPO.getEndDateSpan();
        parameter.setCustomParam("span_date_type", (Object)dateSpanType);
        parameter.setCustomParam("start_span_date", startSpanDate == null ? null : DateUtil.format(startSpanDate, pattern));
        parameter.setCustomParam("end_span_date", endSpanDate == null ? null : DateUtil.format(endSpanDate, pattern));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.getDateSpanContrlNames().contains(actionId) && closedCallBackEvent.getReturnData() != null) {
            Label dateSpanLabel = (Label)this.getView().getControl(actionId + "_label");
            HashMap returnDataMap = (HashMap)closedCallBackEvent.getReturnData();
            String dateSpanType = (String)returnDataMap.get("dateSpanType");
            Date startTime = (Date)returnDataMap.get("startTime");
            Date endTime = (Date)returnDataMap.get("endTime");
            Map<String, String> defaultDateSpanTypeMap = this.getDefaultDateSpanTypeMap();
            this.getPageCache().put("start_" + actionId, startTime == null ? null : DateUtil.format(startTime, pattern));
            this.getPageCache().put("end_" + actionId, endTime == null ? null : DateUtil.format(endTime, pattern));
            if (DateSpanEnum.CUSTOM.getNumber().equals(dateSpanType)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
                this.getPageCache().put("type_" + actionId, DateSpanEnum.CUSTOM.getNumber());
                if (dateSpanLabel != null) {
                    dateSpanLabel.setText(dateFormat.format(startTime) + " ~ " + dateFormat.format(endTime));
                }
                defaultDateSpanTypeMap.put(actionId, DateSpanEnum.CUSTOM.getNumber());
            } else {
                this.getPageCache().put("type_" + actionId, dateSpanType);
                if (dateSpanLabel != null) {
                    dateSpanLabel.setText(DateSpanEnum.getNameByNumber(dateSpanType));
                }
                defaultDateSpanTypeMap.put(actionId, dateSpanType);
            }
            this.saveDefaultDateSpanTypeMap(defaultDateSpanTypeMap);
            this.operationAfterSwitchDateSpan(this.getDateSpanPO(actionId));
        }
    }

    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
    }

    protected List<String> getDateSpanContrlNames() {
        return new ArrayList<String>(Arrays.asList(this.getPageCache().get("date_span_controls").split(",")));
    }

    protected Map<String, String> getDefaultDateSpanTypeMap() {
        Map<String, String> defaultDateTypeMap = new HashMap<String, String>();
        String defaultDateTypes = this.getPageCache().get("defaultDateTypes");
        try {
            if (StringUtils.isNotBlank((CharSequence)defaultDateTypes)) {
                defaultDateTypeMap = (Map)this.objectMapper.reader().readValue(defaultDateTypes, Map.class);
            }
        }
        catch (Exception e) {
            log.error("\u5e8f\u5217\u5316\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        return defaultDateTypeMap;
    }

    private void saveDefaultDateSpanTypeMap(Map<String, String> defaultDateTypes) {
        ObjectWriter writer = this.objectMapper.writer();
        try {
            this.getPageCache().put("defaultDateTypes", writer.writeValueAsString(defaultDateTypes));
        }
        catch (JsonProcessingException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 \uff1a" + e.getMessage());
        }
    }

    protected DateSpanPO getDateSpanPO(String actionId) {
        String type = this.getPageCache().get("type_" + actionId);
        String startSpanDateStr = this.getPageCache().get("start_" + actionId);
        String endSpanDateStr = this.getPageCache().get("end_" + actionId);
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)startSpanDateStr)) {
                start = DateUtil.parse(startSpanDateStr, pattern);
            }
            if (StringUtils.isNotBlank((CharSequence)endSpanDateStr)) {
                end = DateUtil.parse(endSpanDateStr, pattern);
            }
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4Date\u89e3\u6790\u9519\u8bef \uff1a" + e.getMessage());
        }
        return new DateSpanPO(type, start, end);
    }

    protected DateSpanPO getDateSpanPO() {
        return this.getDateSpanPO(DEFAULT_DATE_SPAN);
    }

    protected void setDateSpanPO(String actionId, DateSpanPO dateSpanPO) {
        if (dateSpanPO == null) {
            return;
        }
        Date startDateSpan = dateSpanPO.getStartDateSpan();
        Date endDateSpan = dateSpanPO.getEndDateSpan();
        this.getPageCache().put("type_" + actionId, dateSpanPO.getDateSpanType());
        this.getPageCache().put("start_" + actionId, startDateSpan == null ? null : DateUtil.format(startDateSpan, pattern));
        this.getPageCache().put("end_" + actionId, endDateSpan == null ? null : DateUtil.format(endDateSpan, pattern));
    }

    protected void setDateSpanPO(DateSpanPO dateSpanPO) {
        this.setDateSpanPO(DEFAULT_DATE_SPAN, dateSpanPO);
    }
}

