/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.ssc.task.mobile.common.CustomCtrlPropHelper;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.enums.Card;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.enums.ICard;
import kd.ssc.task.mobile.utils.CastUtils;

public class SscIndexSelectCardPlugin
extends AbstractMobFormPlugin {
    public static final String FORMID = "ssc_index_select_card_m";
    public static final String CTRL_BTN_SAVE = "btn_save";
    public static final String CTRL_BTN_CANCEL = "btn_cancel";
    private static final String CONTROLID_CC_CARD_MANAGEMENT = "cc_card_management";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_SAVE, CTRL_BTN_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCustomCtrl();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_SAVE, (CharSequence)optKey)) {
            this.btnSave();
        } else if (StringUtils.equals((CharSequence)CTRL_BTN_CANCEL, (CharSequence)optKey)) {
            this.btnCancel();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if (CONTROLID_CC_CARD_MANAGEMENT.equals(key) && "submit".equals(eventName)) {
            List objects = SerializationUtils.fromJsonStringToList((String)e.getEventArgs(), Card.class);
            this.saveCards(objects);
            this.getView().returnDataToParent((Object)"refresh");
            this.getView().close();
        }
    }

    protected void initCustomCtrl() {
        HashMap<String, Object> data = this.getUserCardInfos();
        CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), CONTROLID_CC_CARD_MANAGEMENT, data, Boolean.FALSE);
    }

    protected HashMap<String, Object> getUserCardInfos() {
        HashMap<String, ICard> map = this.getCardMap();
        Collection<ICard> values = map.values();
        LinkedHashSet<ICard> seleted = new LinkedHashSet<ICard>();
        String customCardStr = UserParameterHelper.getCustomCard();
        if (StringUtils.isNotBlank((CharSequence)customCardStr)) {
            String[] formIds;
            for (String formId : formIds = customCardStr.split(",")) {
                ICard remove = map.remove(formId);
                if (remove == null) continue;
                seleted.add(remove);
            }
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("selected", seleted);
        data.put("more", values);
        return data;
    }

    public static void jumpMeBy(AbstractFormPlugin plugin, String actionId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    protected HashMap<String, ICard> getCardMap() {
        return CardEnum.toMap();
    }

    private void btnCancel() {
        this.getView().close();
    }

    private void btnSave() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("event", "getResult");
        data.put("datetime", String.valueOf(new Date().getTime()));
        CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), CONTROLID_CC_CARD_MANAGEMENT, data, Boolean.TRUE);
    }

    private void saveCards(List<?> objects) {
        String cardStrs = objects.stream().map(CastUtils::cast).map(Card::getId).distinct().collect(Collectors.joining(","));
        UserParameterHelper.saveCustomCard(cardStrs);
    }
}

