/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceAuditPercentDataHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscIntelligenceAuditConditionFormPlugin
extends SscDateSpanCardTemplatePlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DateSpanPO dateSpanPO = null;
        String dateSpanStr = (String)this.getView().getFormShowParameter().getCustomParam("dateSpan");
        if (StringUtils.isNotBlank((CharSequence)dateSpanStr)) {
            dateSpanPO = (DateSpanPO)SerializationUtils.fromJsonString((String)dateSpanStr, DateSpanPO.class);
        }
        this.setDateSpanPO(dateSpanPO);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        DataSet allCompletedTaskDataSet = this.getAllCompletedTaskDataSet();
        DataSet completedTaskDataSetofDateSpan = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime);
        this.initialPermPanel();
        this.initialTaskPanel(completedTaskDataSetofDateSpan);
        this.initialTaskConditionList(completedTaskDataSetofDateSpan);
    }

    private void initialTaskConditionList(DataSet completedTaskDataSetofDateSpan) {
        long billTypeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("billTypeId"));
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("billTypeId", billTypeId);
        DynamicObjectCollection completedDynamicObjectsOfBillId = ORM.create().toPlainDynamicObjectCollection(completedTaskDataSetofDateSpan.filter("billtype.id = billTypeId", params));
        this.fillBusinessBillPanel(completedDynamicObjectsOfBillId);
        QFilter sscIdfilter = new QFilter("createorg", "=", (Object)this.getSscId());
        QFilter groupNumberfilter = new QFilter("number", "=", (Object)"robots");
        DynamicObject robotGroup = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{sscIdfilter, groupNumberfilter});
        if (robotGroup == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        QFilter sscIdFilter = new QFilter("ssccenter", "=", (Object)this.getSscId());
        QFilter groupIdFilter = new QFilter("entryentity1.usergroup", "=", (Object)robotGroup.getLong("id"));
        DynamicObjectCollection disruleList = QueryServiceHelper.query((String)"task_disrule", (String)"id,tasktype.name,entryentity.billtype,entryentity.filterrule,entryentity.fremark", (QFilter[])new QFilter[]{sscIdFilter, groupIdFilter});
        List disruleListOfCurrentBillType = disruleList.stream().filter(dy -> dy.getLong("entryentity.billtype") == billTypeId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(disruleListOfCurrentBillType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
            IDataModel model = this.getModel();
            model.deleteEntryData("entryentity");
            model.beginInit();
            int size = disruleListOfCurrentBillType.size();
            model.batchCreateNewEntryRow("entryentity", size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
            DynamicProperty taskType = dynamicObjects.getDynamicObjectType().getProperty("tasktype");
            DynamicProperty condition = dynamicObjects.getDynamicObjectType().getProperty("condition");
            DynamicProperty remark = dynamicObjects.getDynamicObjectType().getProperty("fremark");
            for (int i = 0; i < size; ++i) {
                DynamicObject disrule = (DynamicObject)disruleListOfCurrentBillType.get(i);
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                taskType.setValueFast((Object)dynamicObject, (Object)disrule.getString("tasktype.name"));
                condition.setValueFast((Object)dynamicObject, disrule.get("entryentity.filterrule"));
                remark.setValueFast((Object)dynamicObject, disrule.get("entryentity.fremark"));
            }
            model.endInit();
            this.getView().updateView("entryentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private void fillBusinessBillPanel(DynamicObjectCollection completedDynamicObjectsOfBillId) {
        if (completedDynamicObjectsOfBillId.size() == 0) {
            DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("billTypeId"))).toArray());
            Label billNameLabel = (Label)this.getControl("bill_name");
            billNameLabel.setText(taskBill.getString("name"));
            Label inteAuditPercentBill = (Label)this.getControl("inte_audit_percent_bill");
            inteAuditPercentBill.setText("-");
            Label inteauditTotalcount = (Label)this.getControl("inteaudit_totalcount");
            inteauditTotalcount.setText("0/0");
        } else {
            DynamicObject dynamicObject = (DynamicObject)completedDynamicObjectsOfBillId.get(0);
            long inteAuditCount = completedDynamicObjectsOfBillId.stream().filter(dy -> dy.getBoolean("autoprocess")).count();
            Label billNameLabel = (Label)this.getControl("bill_name");
            billNameLabel.setText(dynamicObject.getString("billtype.name"));
            Label inteAuditPercentBill = (Label)this.getControl("inte_audit_percent_bill");
            inteAuditPercentBill.setText(new BigDecimal(inteAuditCount).multiply(new BigDecimal(100)).divide(new BigDecimal(completedDynamicObjectsOfBillId.size()), 1, 4) + "%");
            Label inteauditTotalcount = (Label)this.getControl("inteaudit_totalcount");
            inteauditTotalcount.setText(inteAuditCount + "/" + completedDynamicObjectsOfBillId.size());
        }
    }

    private void initialTaskPanel(DataSet completedTaskDataSetofDateSpan) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        Label timeLabel = (Label)this.getControl("inte_audit_time");
        timeLabel.setText(dateSpanPO.getSpanTypeDesc());
        int inteAuditTaskCount = completedTaskDataSetofDateSpan.copy().filter("autoprocess = true").count("id", true);
        Label inteAuditTaskCountLabel = (Label)this.getControl("inte_audit_task_count");
        inteAuditTaskCountLabel.setText(String.valueOf(inteAuditTaskCount));
        int allTaskCount = completedTaskDataSetofDateSpan.copy().count("id", true);
        Label allTaskCountLabel = (Label)this.getControl("total_task_count");
        allTaskCountLabel.setText(String.valueOf(allTaskCount));
        BigDecimal currentPercent = allTaskCount == 0 ? new BigDecimal("0.0000") : new BigDecimal(inteAuditTaskCount).divide(new BigDecimal(allTaskCount), 10, 4);
        Label percentLabel = (Label)this.getControl("inte_audit_percent");
        percentLabel.setText(currentPercent.multiply(new BigDecimal(100)).setScale(1, 4) + "%");
    }

    private DataSet getAllCompletedTaskDataSet() {
        return QueryServiceHelper.queryDataSet((String)"MobileTaskBusinessDataHelper_average", (String)"task_taskhistory", (String)"id,pooltype,costwaittime,autoprocess,createTime,completetime,personid,billtype.id,billtype.name", (QFilter[])new QFilter[]{new QFilter("pooltype", "=", (Object)"2"), new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK), this.userFilter(this.getSscId(), this.getGroupId())}, null);
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        if (this.getGroupId() == -1L) {
            groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscIntelligenceAuditConditionFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            groupLabel.setText(CommonQueryHelper.getNameById("task_usergroup", this.getGroupId()));
        }
    }

    private Long getSscId() {
        long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }
}

