/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscIntelligenceAuditPercentDataHelper {
    public static BigDecimal getInteAuditPercentCount(DataSet allCompletedTaskDataSet, LocalDate startTime, LocalDate endTime) {
        DataSet completedTaskDataSetofDateSpan = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime);
        int allInteAuditTaskCount = completedTaskDataSetofDateSpan.copy().filter("autoprocess = true").count("id", true);
        int allTaskCount = completedTaskDataSetofDateSpan.count("id", true);
        if (allTaskCount == 0) {
            return null;
        }
        return new BigDecimal(allInteAuditTaskCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allTaskCount), 10, 4);
    }

    public static DataSet getcompletedTaskDataSetOfSpan(DataSet allCompletedTaskDataSet, String timeField, LocalDate startTime, LocalDate endTime) {
        DataSet completedTaskDataSetofDateSpan;
        HashMap<String, Date> paramMap = new HashMap<String, Date>();
        if (startTime == null && endTime == null) {
            completedTaskDataSetofDateSpan = allCompletedTaskDataSet.copy();
        } else if (endTime == null) {
            paramMap.put("startTime", CommonUtils.localDate2Date(startTime));
            completedTaskDataSetofDateSpan = allCompletedTaskDataSet.filter(timeField + " >= startTime", paramMap);
        } else if (startTime == null) {
            paramMap.put("endTime", CommonUtils.localDate2Date(endTime.plusDays(1L)));
            completedTaskDataSetofDateSpan = allCompletedTaskDataSet.filter(timeField + " < endTime", paramMap);
        } else {
            paramMap.put("startTime", CommonUtils.localDate2Date(startTime));
            paramMap.put("endTime", CommonUtils.localDate2Date(endTime.plusDays(1L)));
            completedTaskDataSetofDateSpan = allCompletedTaskDataSet.filter("startTime <= " + timeField + " and " + timeField + " < endTime", paramMap);
        }
        return completedTaskDataSetofDateSpan;
    }

    public static BigDecimal compareRatio(BigDecimal thisData, BigDecimal priviousData) {
        BigDecimal yoyRatio = null;
        if (priviousData != null && thisData != null) {
            if (BigDecimal.ZERO.compareTo(priviousData) != 0) {
                yoyRatio = BigDecimal.ZERO.compareTo(thisData) != 0 ? thisData.subtract(priviousData).divide(priviousData, 10, 4) : new BigDecimal("-1");
            } else if (BigDecimal.ZERO.compareTo(thisData) == 0) {
                yoyRatio = new BigDecimal("0");
            }
        }
        return yoyRatio;
    }

    public static void setLabel(IFormView view, String labelKey, BigDecimal ratio, boolean isColorReverse) {
        Label label_rate_tb = (Label)view.getControl(labelKey);
        if (ratio != null) {
            BigDecimal ratio2 = ratio.multiply(new BigDecimal(100)).setScale(0, 4);
            String text = null;
            if (ratio2.compareTo(BigDecimal.ZERO) > 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                if (isColorReverse) {
                    ctrl.put("fc", "#FB2323");
                } else {
                    ctrl.put("fc", "#1BA854");
                }
                view.updateControlMetadata(labelKey, ctrl);
                text = "+" + ratio2 + "%";
            } else if (ratio2.compareTo(BigDecimal.ZERO) < 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                if (isColorReverse) {
                    ctrl.put("fc", "#1BA854");
                } else {
                    ctrl.put("fc", "#FB2323");
                }
                view.updateControlMetadata(labelKey, ctrl);
                text = ratio2 + "%";
            } else {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", "#666666");
                view.updateControlMetadata(labelKey, ctrl);
                text = "+" + ratio2 + "%";
            }
            label_rate_tb.setText(text);
        } else {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", "#666666");
            view.updateControlMetadata(labelKey, ctrl);
            label_rate_tb.setText("-");
        }
    }

    public static void setLabelNoColor(IFormView view, String labelKey, BigDecimal ratio) {
        Label label_rate_tb = (Label)view.getControl(labelKey);
        if (ratio != null) {
            BigDecimal ratio2 = ratio.multiply(new BigDecimal(100)).setScale(0, 4);
            String text = null;
            text = ratio2.compareTo(BigDecimal.ZERO) > 0 ? "+" + ratio2 + "%" : (ratio2.compareTo(BigDecimal.ZERO) < 0 ? ratio2 + "%" : "+" + ratio2 + "%");
            label_rate_tb.setText(text);
        } else {
            label_rate_tb.setText("-");
        }
    }

    public static BigDecimal getDecreaseTimeCostByDay(DataSet allCompletedTaskDataSet, LocalDate startTime, LocalDate endTime) {
        BigDecimal decreaseTimeCostByDay = null;
        int currentInteAuditTaskCont = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).filter("autoprocess = true").count("id", true);
        int personCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).filter("autoprocess = false").count("personid", true);
        DataSet dataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime).executeSql("select count(1) as taskcount,sum(costwaittime) as costwaittime where autoprocess = false");
        Iterator iterator = dataSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Integer taskcount = row.getInteger("taskcount");
            BigDecimal costwaittime = row.getBigDecimal("costwaittime");
            BigDecimal costWaittimeOfDay = costwaittime.multiply(new BigDecimal(personCount)).divide(new BigDecimal(8), 10, 4);
            if (costwaittime.compareTo(BigDecimal.ZERO) > 0 && taskcount != 0) {
                decreaseTimeCostByDay = new BigDecimal(currentInteAuditTaskCont).multiply(costWaittimeOfDay).divide(new BigDecimal(taskcount), 10, 4);
            }
        }
        dataSet.close();
        return decreaseTimeCostByDay;
    }

    public static BigDecimal getAuditTimeByAuditType(DataSet allCompletedTaskDataSet, LocalDate startTime, LocalDate endTime, String auditType) {
        BigDecimal AuditTimeByHour = null;
        String executeSql = null;
        switch (auditType) {
            case "0": {
                executeSql = "select count(1) as taskcount,sum(costwaittime) as costwaittime";
                break;
            }
            case "1": {
                executeSql = "select count(1) as taskcount,sum(costwaittime) as costwaittime where autoprocess = true";
                break;
            }
            case "2": {
                executeSql = "select count(1) as taskcount,sum(costwaittime) as costwaittime where autoprocess = false";
            }
        }
        DataSet dataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime).executeSql(executeSql);
        Iterator iterator = dataSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Integer taskcount = row.getInteger("taskcount");
            BigDecimal costwaittime = row.getBigDecimal("costwaittime");
            if (taskcount != 0) {
                AuditTimeByHour = costwaittime.divide(new BigDecimal(taskcount), 10, 4);
            }
        }
        dataSet.close();
        return AuditTimeByHour;
    }

    public static BigDecimal getUnqualifiedPercent(DataSet qualifiedDataSet, String auditType) {
        BigDecimal unQualifiedPercent = BigDecimal.ZERO;
        DataSet unqualifiedTasks = qualifiedDataSet.copy().filter("qualityresult='0'");
        int unQulifiedTaskCount = 0;
        int allQulifiedTaskCount = 0;
        switch (auditType) {
            case "0": {
                unQulifiedTaskCount = unqualifiedTasks.count("id", true);
                allQulifiedTaskCount = qualifiedDataSet.count("id", true);
                break;
            }
            case "1": {
                unQulifiedTaskCount = unqualifiedTasks.filter("autoprocess = '1'").count("id", true);
                allQulifiedTaskCount = qualifiedDataSet.filter("autoprocess = '1'").count("id", true);
                break;
            }
            case "2": {
                unQulifiedTaskCount = unqualifiedTasks.filter("autoprocess = '0'").count("id", true);
                allQulifiedTaskCount = qualifiedDataSet.filter("autoprocess = '0'").count("id", true);
            }
        }
        if (allQulifiedTaskCount != 0) {
            unQualifiedPercent = new BigDecimal(unQulifiedTaskCount).divide(new BigDecimal(allQulifiedTaskCount), 10, 4);
        } else if (unQulifiedTaskCount != 0) {
            unQualifiedPercent = null;
        }
        return unQualifiedPercent;
    }

    public static BigDecimal getCheckPercent(DataSet allCompletedTaskDataSet, DataSet qualifiedDataSet, LocalDate startTime, LocalDate endTime, String auditType) {
        BigDecimal unQualifiedPercent = BigDecimal.ZERO;
        DataSet allTasks = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime);
        DataSet allQulifiedTasks = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(qualifiedDataSet, "auditcompletetime", startTime, endTime);
        int unQulifiedTaskCount = 0;
        int allTasksCount = 0;
        switch (auditType) {
            case "0": {
                unQulifiedTaskCount = allQulifiedTasks.count("id", true);
                allTasksCount = allTasks.count("id", true);
                break;
            }
            case "1": {
                unQulifiedTaskCount = allQulifiedTasks.filter("autoprocess = '1'").count("id", true);
                allTasksCount = allTasks.filter("autoprocess = true").count("id", true);
                break;
            }
            case "2": {
                unQulifiedTaskCount = allQulifiedTasks.filter("autoprocess = '0'").count("id", true);
                allTasksCount = allTasks.filter("autoprocess = false").count("id", true);
            }
        }
        if (allTasksCount != 0) {
            unQualifiedPercent = new BigDecimal(unQulifiedTaskCount).divide(new BigDecimal(allTasksCount), 10, 4);
        } else if (unQulifiedTaskCount != 0) {
            unQualifiedPercent = null;
        }
        return unQualifiedPercent;
    }
}

