/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceQualificationAnalysisDataHelper;

public class SscIntelligenceQualificationAnalysisCardFormPlugin
extends SscCardTemplatePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detail_label", "vector_tip"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DataSet qualTaskWhetherIsSmart = SscIntelligenceQualificationAnalysisDataHelper.getQualTaskIsSmartBySscId(this.getSscid());
        DataSet qualTaskHistoryWhetherIsSmart = SscIntelligenceQualificationAnalysisDataHelper.getQualHistoryIsSmartBySscId(this.getSscid());
        int qualTaskCount = qualTaskWhetherIsSmart.copy().count("id", true) + qualTaskHistoryWhetherIsSmart.copy().count("id", true);
        if (qualTaskCount == 0) {
            String text = ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"SscIntelligenceQualificationAnalysisCardFormPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.setNoDataView(text);
            this.setPropDataTag(0);
            return;
        }
        int smartCount = qualTaskWhetherIsSmart.copy().filter("issmart = '1'").count("id", true) + qualTaskHistoryWhetherIsSmart.copy().filter("issmart = '1'").count("id", true);
        if (smartCount == 0) {
            String text = ResManager.loadKDString((String)"\u672a\u542f\u7528\u667a\u80fd\u8d28\u68c0\uff0c\u5efa\u8bae\u542f\u7528\u4ee5\u63d0\u9ad8\u8d28\u68c0\u6548\u7387\u548c\u5ba1\u5355\u8d28\u91cf\u3002", (String)"SscIntelligenceQualificationAnalysisCardFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.setNoDataView(text);
            this.setPropDataTag(0);
        } else {
            this.setPropDataTag(1);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initialIntelligenceQualificationAnalysis();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_tip")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u5e94\u7528\u5206\u6790", (String)"SscIntelligenceQualificationAnalysisCardFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u7684\u667a\u80fd\u8d28\u68c0\u5e94\u7528\u6bd4\u4f8b\u3001\u667a\u80fd\u8d28\u68c0\u4e0e\u666e\u901a\u8d28\u68c0\u7684\u6574\u6539\u7387\u5bf9\u6bd4", (String)"SscIntelligenceQualificationAnalysisCardFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
    }

    private void initialIntelligenceQualificationAnalysis() {
        DataSet qualTaskWhetherIsSmart = SscIntelligenceQualificationAnalysisDataHelper.getQualTaskIsSmartBySscId(this.getSscid());
        DataSet qualTaskHistoryWhetherIsSmart = SscIntelligenceQualificationAnalysisDataHelper.getQualHistoryIsSmartBySscId(this.getSscid());
        int smartCount = qualTaskWhetherIsSmart.copy().filter("issmart = '1'").count("id", true) + qualTaskHistoryWhetherIsSmart.copy().filter("issmart = '1'").count("id", true);
        int totalCount = qualTaskWhetherIsSmart.count("id", true) + qualTaskHistoryWhetherIsSmart.copy().count("id", true);
        BigDecimal intetQualTaskPercent = totalCount == 0 ? BigDecimal.ZERO.setScale(1, 4) : new BigDecimal(smartCount).multiply(new BigDecimal(100)).divide(new BigDecimal(totalCount), 1, 4);
        this.getPageCache().put("CACHE_SHARE_VALUE", intetQualTaskPercent + "%");
        Label labelIntequalPercent = (Label)this.getControl("label_intequal_percent");
        labelIntequalPercent.setText(intetQualTaskPercent + "%");
        ORM orm = ORM.create();
        DynamicObjectCollection qualTaskHistoryDYs = orm.toPlainDynamicObjectCollection(qualTaskHistoryWhetherIsSmart);
        Set allQualTaskHistoryIds = qualTaskHistoryDYs.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection qualityMessageRecords = QueryServiceHelper.query((String)"task_qualitymessagerecord", (String)"id,qualitycheck", (QFilter[])new QFilter[]{new QFilter("qualitycheck", "in", allQualTaskHistoryIds), new QFilter("handlemethod", "=", (Object)"1")});
        Set qualityCheckReformTaskIds = qualityMessageRecords.stream().map(dy -> dy.getLong("qualitycheck")).collect(Collectors.toSet());
        Set inteQualTaskHistoryIds = qualTaskHistoryDYs.stream().filter(dy -> dy.getLong("issmart") == 1L).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        int inteQualTaskHistoryCount = inteQualTaskHistoryIds.size();
        inteQualTaskHistoryIds.retainAll(qualityCheckReformTaskIds);
        int inteQualTaskHistoryReformCount = inteQualTaskHistoryIds.size();
        BigDecimal inteQualTaskReformPercent = inteQualTaskHistoryCount == 0 ? BigDecimal.ZERO.setScale(1, 4) : new BigDecimal(inteQualTaskHistoryReformCount).multiply(new BigDecimal(100)).divide(new BigDecimal(inteQualTaskHistoryCount), 1, 4);
        Label reformIntequalPercent = (Label)this.getControl("reform_intequal_percent");
        reformIntequalPercent.setText(inteQualTaskReformPercent + "%");
        Set commonQualTaskHistoryIds = qualTaskHistoryDYs.stream().filter(dy -> dy.getLong("issmart") != 1L).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        int commonQualTaskHistoryCount = commonQualTaskHistoryIds.size();
        commonQualTaskHistoryIds.retainAll(qualityCheckReformTaskIds);
        int commonQualTaskHistoryReformCount = commonQualTaskHistoryIds.size();
        Label reformCommonqualPercent = (Label)this.getControl("reform_commonqual_percent");
        if (commonQualTaskHistoryCount == 0) {
            reformCommonqualPercent.setText("-");
        } else {
            BigDecimal commonQualTaskReformPercent = new BigDecimal(commonQualTaskHistoryReformCount).multiply(new BigDecimal(100)).divide(new BigDecimal(commonQualTaskHistoryCount), 1, 4);
            reformCommonqualPercent.setText(commonQualTaskReformPercent + "%");
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.InteQualAnalysisCard.getCaption());
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5f53\u524d\u667a\u80fd\u8d28\u68c0\u5360\u6bd4\uff1a%s", (String)"SscIntelligenceQualificationAnalysisCardFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }
}

