/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplateSingleDateSpanPlugin;
import kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDataHelper;
import kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDetailPlugin;
import kd.ssc.task.mobile.formplugin.quality.dto.QualityPointCountResult;
import kd.ssc.task.mobile.formplugin.quality.dto.QualityPointCountResultData;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.FormatUtils;

public class SscQualityProportionCardPlugin
extends SscCardTemplateSingleDateSpanPlugin {
    private static final String CTRL_BTN_QPROPORTION_DETAIL = "btn_qproportion_detail";
    private static final String CTRL_CHART_PIE_QUALITY_PROPOR = "piechartap_quality_propor";
    private static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.QualityProportionCard.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8d28\u68c0\u70b9\u4e0d\u5408\u683c\u5360\u6bd4", (String)"SscQualityProportionCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_QPROPORTION_DETAIL});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dateRangeChange(this.getDateRange());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_QPROPORTION_DETAIL, (CharSequence)optKey)) {
            this.btnDetail();
        }
    }

    private void btnDetail() {
        Long sscid = this.getSscid();
        Long usergroup = this.getUsergroup();
        SscQualityProportionDetailPlugin.jumpMeBy(this.getView(), sscid.toString(), usergroup.toString(), this.getDateRangeStr());
    }

    @Override
    protected void dateRangeChange(DateRangePO dateRange) {
        Long usergroup;
        Long sscid = this.getSscid();
        QualityPointCountResultData data = SscQualityProportionDataHelper.getData(sscid, usergroup = this.getUsergroup(), dateRange.getStartDate(), dateRange.getEndDate());
        if (data.getCountQuality() == 0) {
            String text = ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"SscQualityProportionCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.setNoDataView(text);
            this.setPropDataTag(0);
            this.setPanelList(new ArrayList<QualityPointCountResult>());
            return;
        }
        if (data.getCountUnQuality() == 0) {
            String text = ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u8d28\u68c0\u4e0d\u5408\u683c\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8d28\u68c0\u5de5\u4f5c\u8fdb\u5ea6\u3002", (String)"SscQualityProportionCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.setNoDataView(text);
            this.setPropDataTag(0);
            this.setPanelList(new ArrayList<QualityPointCountResult>());
            return;
        }
        this.setPanelData(data.getResults());
        this.setPanelList(data.getResults());
    }

    protected void setPanelList(List<QualityPointCountResult> results) {
    }

    private void setPanelData(List<QualityPointCountResult> results) {
        PieChart pieChart = this.initPieChart();
        int sum = SscQualityProportionDataHelper.calculateQualityPointCountResult(results);
        this.createSeries(pieChart, results, sum);
        this.createLegend(results);
        this.getView().updateView();
    }

    private PieChart initPieChart() {
        PieChart pieChart = (PieChart)this.getControl(CTRL_CHART_PIE_QUALITY_PROPOR);
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        return pieChart;
    }

    private void createSeries(PieChart pieChart, List<QualityPointCountResult> results, int sum) {
        PieSeries series = pieChart.createPieSeries(CardEnum.QualityProportionCard.getCaption());
        ArrayList<M> data = new ArrayList<M>();
        int n = Math.min(results.size(), 3);
        int i = 0;
        while (i < n) {
            QualityPointCountResult result = results.get(i);
            int finalI = i++;
            data.add(M.map().kv("name", result.getPointname()).kv("value", result.getPointtimes()).kv("itemStyle", map -> map.kv("normal", M.map("color", COLORS_PIECHARTS[finalI % 4]))));
        }
        if (results.size() > 3) {
            int percentElse = 0;
            for (int i2 = 3; i2 < results.size(); ++i2) {
                percentElse += results.get(i2).getPointtimes();
            }
            String text = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SscQualityProportionCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
            data.add(M.map().kv("name", text).kv("value", percentElse).kv("itemStyle", M.map("normal", M.map("color", COLORS_PIECHARTS[3]))));
        }
        series.setPropValue("data", data);
        String text = ResManager.loadKDString((String)"\u603b\u6570", (String)"SscQualityProportionCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]);
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", "[ '{a|" + text + "}', '{b|" + sum + "}' ].join('\\n')").kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", "#212121").kv("fontSize", "12")).kv("b", map2 -> map2.kv("color", "#276FF5").kv("fontSize", "24"))).kv("position", "center")).kv("show", Boolean.TRUE));
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.FALSE);
        series.addFuncPath(M.arraylist("label", "normal", "formatter"));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    private void createLegend(List<QualityPointCountResult> results) {
        int allTimes = 0;
        this.setPropDataTag(results.size());
        int n = Math.min(results.size(), 3);
        for (int i = 0; i < n; ++i) {
            QualityPointCountResult result = results.get(i);
            ((Label)this.getControl("pieitemqplabeln" + i)).setText(result.getPointname());
            ((Label)this.getControl("pieitemqplabelv" + i)).setText(FormatUtils.format1dot(result.getPercent()) + "%");
            allTimes += result.getPointtimes();
        }
        if (results.size() > 3) {
            int elseTimes = 0;
            for (int i = 3; i < results.size(); ++i) {
                elseTimes += results.get(i).getPointtimes();
            }
            ((Label)this.getControl("pieitemqplabeln3")).setText(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SscQualityProportionCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
            BigDecimal elsePercent = CommonUtils.divide(elseTimes * 100, allTimes += elseTimes, 1);
            ((Label)this.getControl("pieitemqplabelv3")).setText(elsePercent + "%");
        }
    }
}

