/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDetailHelper;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountDetailResult;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.template.datespan.DateRangePO;

public class SscUnqualifiedDetailUserPlugin
extends AbstractMobFormPlugin {
    public static final String FORMID = "ssc_unqualified_detailu_m";
    private static final String LABEL_TIME = "labeltime";
    private static final String LABEL_RATIO = "labelratio";
    private static final String LABEL_UNQUALIFIED_COUNT = "labelunqualifiedcount";
    private static final String LABEL_COMPLETE_COUNT = "labelcompletecount";
    private static final String ENTRYENTITY = "entryentity";
    private static final String F_ITEM_USERNAME = "itemusername";
    private static final String F_ITEM_RATIO = "itemratio";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sharecenter = (String)parameter.getCustomParam("sharecenter");
        String usergroup = (String)parameter.getCustomParam("usergroup");
        if (sharecenter == null || usergroup == null) {
            return;
        }
        DateRangePO dateRangePO = this.getDateRangePO();
        this.initParams(sharecenter, usergroup, dateRangePO);
        this.refreshView(Long.valueOf(sharecenter), Long.valueOf(usergroup), dateRangePO);
    }

    private void refreshView(Long sharecenter, Long usergroup, DateRangePO dateRangePO) {
        UnqualifiedCountDetailResult dataResults = this.getDetailResultDataGroupByUser(sharecenter, usergroup, dateRangePO);
        this.setDataHeadView(dataResults.getHead());
        List<UnqualifiedCountResult> list = dataResults.getList();
        Map<Long, UnqualifiedCountResult> resultMap = list.stream().collect(Collectors.toMap(UnqualifiedCountResult::getGroupbyId, o -> o));
        QFilter groupFilter = new QFilter("id", "=", (Object)usergroup);
        QFilter statusFilter = new QFilter("entryentity.usestatus", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection users = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{groupFilter, statusFilter});
        if (users.size() == 1 && ((DynamicObject)users.get(0)).getString("entryentity.userfield").equals("0")) {
            users.remove(0);
        }
        Set longSet = users.stream().filter(Objects::nonNull).mapToLong(user -> user.getLong("entryentity.userfield")).boxed().collect(Collectors.toSet());
        longSet.addAll(list.stream().mapToLong(UnqualifiedCountResult::getGroupbyId).boxed().collect(Collectors.toSet()));
        DynamicObjectCollection allUsers = QueryServiceHelper.query((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)longSet.toArray()).toArray());
        List<UnqualifiedCountResult> collect = allUsers.stream().map(dynamicObject -> {
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            UnqualifiedCountResult result = (UnqualifiedCountResult)resultMap.get(id);
            if (result == null) {
                result = new UnqualifiedCountResult();
                result.setGroupbyId(id);
                result.setUnqualifiedCount(0);
                result.setCompleteCount(0);
            }
            result.setXnames(name);
            return result;
        }).sorted(SscUnqualifiedDetailHelper.newComparator()).collect(Collectors.toList());
        this.setListData(collect);
    }

    private void setListData(List<UnqualifiedCountResult> list) {
        int size = list.size();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(ENTRYENTITY);
            DynamicProperty pro_itemusername = dynamicObjects.getDynamicObjectType().getProperty(F_ITEM_USERNAME);
            DynamicProperty pro_itemratio = dynamicObjects.getDynamicObjectType().getProperty(F_ITEM_RATIO);
            for (int i = 0; i < size; ++i) {
                UnqualifiedCountResult result = list.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                pro_itemusername.setValueFast((Object)entry, (Object)result.getXnames());
                pro_itemratio.setValueFast((Object)entry, (Object)result.unqualifiedRatiotextPercent());
            }
            model.endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setDataHeadView(UnqualifiedCountResult head) {
        if (head != null) {
            Label label_ratio = (Label)this.getView().getControl(LABEL_RATIO);
            Label label_unqualified_count = (Label)this.getView().getControl(LABEL_UNQUALIFIED_COUNT);
            Label label_complete_count = (Label)this.getView().getControl(LABEL_COMPLETE_COUNT);
            label_ratio.setText(head.unqualifiedRatiotextPercent());
            label_unqualified_count.setText(head.getUnqualifiedCount() + "");
            label_complete_count.setText(head.getCompleteCount() + "");
        }
    }

    private UnqualifiedCountDetailResult getDetailResultDataGroupByUser(Long sharecenter, Long usergroup, DateRangePO dateRangePO) {
        return SscUnqualifiedDetailHelper.getData(sharecenter, usergroup, dateRangePO.getStartDate(), dateRangePO.getEndDate(), "personid");
    }

    private void initParams(String sharecenter, String usergroup, DateRangePO value) {
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(Long.valueOf(sharecenter)));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(Long.valueOf(usergroup)));
        Label label_time = (Label)this.getView().getControl(LABEL_TIME);
        label_time.setText(value.getSpanTypeDesc());
    }

    private DateRangePO getDateRangePO() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String poJson = (String)parameter.getCustomParam("dateRange");
        return (DateRangePO)SerializationUtils.fromJsonString((String)poJson, DateRangePO.class);
    }

    public static void jumpMeBy(IFormView formView, String sharecenter, String usergroup, String dateRangeStr) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u5206\u5e03", (String)"SscUnqualifiedDetailUserPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("sharecenter", (Object)sharecenter);
        parameter.setCustomParam("usergroup", (Object)usergroup);
        parameter.setCustomParam("dateRange", (Object)dateRangeStr);
        formView.showForm((FormShowParameter)parameter);
    }
}

