/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.serviceap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplateSingleDateSpanPlugin;
import kd.ssc.task.mobile.formplugin.serviceap.SscServiceOrgDistributeDetailPlugin;
import kd.ssc.task.mobile.formplugin.serviceap.dto.CountDataResult;
import kd.ssc.task.mobile.formplugin.serviceap.dto.CountItemResult;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.FormatUtils;

public class SscServiceOrgDistributeCardPlugin
extends SscCardTemplateSingleDateSpanPlugin {
    protected static final String CTRL_BTN_DETAIL = "btn_detail";
    protected static final String CTRL_CHART_PIE = "piechartap";
    protected static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_DETAIL, "vectorap"});
    }

    @Override
    protected DateRangePO getDefaultDateRangePO() {
        return new DateRangePO(DateSpanEnum.UNLIMIT);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dateRangeChange(this.getDateRange());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_DETAIL, (CharSequence)optKey)) {
            this.btnDetail();
        } else if (StringUtils.equals((CharSequence)"vectorap", (CharSequence)optKey)) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u670d\u52a1\u7ec4\u7ec7\u5206\u5e03", (String)"SscServiceOrgDistributeCardPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u548c\u7528\u6237\u7ec4\uff0c\u4efb\u52a1\u521b\u5efa\u65f6\u95f4\u5728\u6240\u9009\u65f6\u95f4\u8303\u56f4\u5185\u7684\u5ba1\u5355\u4efb\u52a1\uff0c\u901a\u8fc7\u5355\u636e\u7684\u5de5\u4f5c\u91cf\u7cfb\u6570\u8ba1\u7b97\u5f97\u51fa\u4efb\u52a1\u91cf\u3002", (String)"SscServiceOrgDistributeCardPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
    }

    protected PieChart initPieChart() {
        PieChart pieChart = (PieChart)this.getControl(CTRL_CHART_PIE);
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        return pieChart;
    }

    protected void setPanelList(List<CountItemResult> results) {
    }

    protected void createSeries(PieChart pieChart, List<CountItemResult> results, String labelText, int sum) {
        PieSeries series = pieChart.createPieSeries(CardEnum.ServiceOrgDistributeCard.getCaption());
        ArrayList<M> data = new ArrayList<M>();
        int n = Math.min(results.size(), 3);
        int i = 0;
        while (i < n) {
            CountItemResult result = results.get(i);
            int finalI = i++;
            data.add(M.map().kv("name", result.getGroupbyName()).kv("value", result.getNumber()).kv("itemStyle", map -> map.kv("normal", M.map("color", COLORS_PIECHARTS[finalI % 4]))));
        }
        if (results.size() > 3) {
            BigDecimal elseNumber = BigDecimal.ZERO;
            for (int i2 = 3; i2 < results.size(); ++i2) {
                elseNumber = elseNumber.add(results.get(i2).getNumber());
            }
            String text = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SscServiceOrgDistributeCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]);
            data.add(M.map().kv("name", text).kv("value", elseNumber).kv("itemStyle", M.map("normal", M.map("color", COLORS_PIECHARTS[3]))));
        }
        series.setPropValue("data", data);
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", "[ '{a|" + labelText + "}', '{b|" + sum + "}' ].join('\\n')").kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", "#212121").kv("fontSize", "12").kv("lineHeight", "24")).kv("b", map2 -> map2.kv("color", "#276FF5").kv("fontSize", "24"))).kv("position", "center")).kv("show", Boolean.TRUE));
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.FALSE);
        series.addFuncPath(M.arraylist("label", "normal", "formatter"));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    protected void calculatePercent(List<CountItemResult> results) {
        double sum = results.stream().mapToDouble(value -> value.getNumber().doubleValue()).sum();
        for (CountItemResult result : results) {
            result.setPercent(result.getNumber().multiply(new BigDecimal("100")).divide(BigDecimal.valueOf(sum), 1, RoundingMode.HALF_UP));
        }
    }

    protected void createLegend(List<CountItemResult> results) {
        BigDecimal allNumber = BigDecimal.ZERO;
        this.setPropDataTag(results.size());
        int n = Math.min(results.size(), 3);
        for (int i = 0; i < n; ++i) {
            CountItemResult result = results.get(i);
            ((Label)this.getControl("pieitemqplabeln" + i)).setText(result.getGroupbyName());
            ((Label)this.getControl("pieitemqplabelv" + i)).setText(FormatUtils.format1dot(result.getPercent()) + "%");
            allNumber = allNumber.add(result.getNumber());
        }
        if (results.size() > 3) {
            BigDecimal elseNumber = BigDecimal.ZERO;
            for (int i = 3; i < results.size(); ++i) {
                elseNumber = elseNumber.add(results.get(i).getNumber());
            }
            allNumber = allNumber.add(elseNumber);
            BigDecimal elsePercent = elseNumber.multiply(new BigDecimal("100")).divide(allNumber, 1, RoundingMode.HALF_UP);
            ((Label)this.getControl("pieitemqplabeln3")).setText(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SscServiceOrgDistributeCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
            ((Label)this.getControl("pieitemqplabelv3")).setText(elsePercent + "%");
        }
    }

    protected void btnDetail() {
        Long sscid = this.getSscid();
        Long usergroup = this.getUsergroup();
        this.jumpToDetail(sscid, usergroup);
    }

    protected void jumpToDetail(Long sscid, Long usergroup) {
        SscServiceOrgDistributeDetailPlugin.jumpMeBy(this.getView(), sscid.toString(), usergroup.toString(), this.getDateRangeStr());
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.ServiceOrgDistributeCard.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u63a5\u6536\u4efb\u52a1\u7684\u7ec4\u7ec7\u5206\u5e03\u3002", (String)"SscServiceOrgDistributeCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    protected void setPanelData(CountDataResult data) {
        PieChart pieChart = this.initPieChart();
        String text = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570", (String)"SscServiceOrgDistributeCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]);
        this.createSeries(pieChart, data.getResults(), text, data.getResults().size());
        this.createLegend(data.getResults());
        this.getView().updateView();
    }

    @Override
    protected void dateRangeChange(DateRangePO dateRange) {
        Long sscid = this.getSscid();
        Long usergroup = this.getUsergroup();
        CountDataResult data = SscServiceOrgDistributeCardPlugin.getData(sscid, usergroup, dateRange.getStartDate(), dateRange.getEndDate());
        this.calculatePercent(data.getResults());
        this.setPanelList(data.getResults());
        if (data.getResults().size() == 0) {
            String text = ResManager.loadKDString((String)"\u672a\u63a5\u6536\u5230\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5ba1\u6838\u5de5\u4f5c", (String)"SscServiceOrgDistributeCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.setNoDataView(text);
            this.setPropDataTag(0);
            return;
        }
        this.setPanelData(data);
    }

    public static CountDataResult getData(Long sscid, Long usergroup, Date startDate, Date endDate) {
        CountDataResult dataResult = new CountDataResult();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("sscid", "=", (Object)sscid));
        if (!usergroup.equals(-1L)) {
            qFilters.add(new QFilter("usergroup.id", "=", (Object)usergroup));
        }
        if (startDate != null) {
            qFilters.add(new QFilter("taskcreatetime", ">=", (Object)startDate));
        }
        if (endDate != null) {
            qFilters.add(new QFilter("taskcreatetime", "<", (Object)CommonUtils.nextDate(endDate)));
        }
        qFilters.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        qFilters.add(new QFilter("coefficient", ">", (Object)0));
        try (DataSet dsTask = QueryServiceHelper.queryDataSet((String)SscServiceOrgDistributeCardPlugin.class.getName(), (String)"task_task", (String)"id,orgid.id,orgid.name,coefficient", (QFilter[])qFilters.toArray(new QFilter[0]), null);
             DataSet dsTaskHis = QueryServiceHelper.queryDataSet((String)SscServiceOrgDistributeCardPlugin.class.getName(), (String)"task_taskhistory", (String)"id,orgid.id,orgid.name,coefficient", (QFilter[])qFilters.toArray(new QFilter[0]), null);
             DataSet union = dsTask.union(dsTaskHis);){
            DataSet dsCoefficient = union.groupBy(new String[]{"orgid.id", "orgid.name"}).sum("coefficient").finish().orderBy(new String[]{"coefficient desc", "orgid.id asc"});
            for (Row row : dsCoefficient) {
                CountItemResult result = new CountItemResult();
                result.setGroupby(row.getLong("orgid.id"));
                result.setGroupbyName(row.getString("orgid.name"));
                result.setNumber(row.getBigDecimal("coefficient"));
                dataResult.getResults().add(result);
            }
        }
        return dataResult;
    }
}

