/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.serviceap;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.serviceap.SscServiceOrgDistributeCardPlugin;
import kd.ssc.task.mobile.formplugin.serviceap.dto.CountItemResult;
import kd.ssc.task.mobile.utils.FormatUtils;

public class SscServiceOrgDistributeDetailPlugin
extends SscServiceOrgDistributeCardPlugin {
    public static final String FORMID = "ssc_service_org_detail_m";
    private static final String CTRL_ENTRY_KEY_LIST = "entryentity";
    private static final String ENTRY_ITEM_NAME = "itemname";
    private static final String ENTRY_ITEM_VALUE = "itemvalue";
    private static final String ENTRY_ITEM_VALUE2 = "itemvalue2";

    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sharecenter = (String)parameter.getCustomParam("sharecenter");
        String usergroup = (String)parameter.getCustomParam("usergroup");
        if (sharecenter == null || usergroup == null) {
            return;
        }
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(Long.valueOf(sharecenter)));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(Long.valueOf(usergroup)));
        super.afterCreateNewData(e);
    }

    @Override
    protected void setPanelList(List<CountItemResult> results) {
        IDataModel model = this.getModel();
        model.deleteEntryData(CTRL_ENTRY_KEY_LIST);
        int size = results.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(CTRL_ENTRY_KEY_LIST, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(CTRL_ENTRY_KEY_LIST);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            DynamicProperty itemvalue = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE);
            DynamicProperty itemvalue2 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE2);
            String text = ResManager.loadKDString((String)"\u63a5\u6536\u4efb\u52a1\u91cf\uff1a", (String)"SscServiceOrgDistributeDetailPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]);
            for (int i = 0; i < size; ++i) {
                CountItemResult result = results.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemname.setValueFast((Object)entry, (Object)result.getGroupbyName());
                itemvalue.setValueFast((Object)entry, (Object)(FormatUtils.format1dot(result.getPercent()) + "%"));
                itemvalue2.setValueFast((Object)entry, (Object)(text + FormatUtils.format1dot(result.getNumber())));
            }
            model.endInit();
        }
        this.getView().updateView(CTRL_ENTRY_KEY_LIST);
    }

    public static void jumpMeBy(IFormView formView, String sharecenter, String usergroup, String dateRangeDesc) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(CardEnum.ServiceOrgDistributeCard.getCaption());
        parameter.setCustomParam("sharecenter", (Object)sharecenter);
        parameter.setCustomParam("usergroup", (Object)usergroup);
        parameter.setCustomParam("dateRange", (Object)dateRangeDesc);
        formView.showForm((FormShowParameter)parameter);
    }
}

