/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;

public class SscToDoTaskCardFormPlugin
extends SscCardTemplatePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"button_detail"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initialTaskData();
    }

    private void initialTaskData() {
        List<DynamicObject> toDoTasks = this.filterTaskDataByWorkStatus(this.getToDoTasks());
        this.initTaskLabel(toDoTasks);
        this.initTaskDealerNumberLabel(toDoTasks);
        this.initAverageTaskLabel(toDoTasks);
    }

    private List<DynamicObject> filterTaskDataByWorkStatus(DynamicObjectCollection tasks) {
        switch ((String)this.getModel().getValue("radiogroupfield")) {
            case "1": {
                return tasks;
            }
            case "2": {
                return this.doFitlerByWorkStatus(tasks);
            }
            case "3": {
                tasks.removeAll(this.doFitlerByWorkStatus(tasks));
                return tasks;
            }
        }
        return new ArrayList<DynamicObject>();
    }

    private List<DynamicObject> doFitlerByWorkStatus(DynamicObjectCollection tasks) {
        List<Object> filterTask = new ArrayList<DynamicObject>();
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)this.getGroupId())) {
            DynamicObjectCollection groups = CommonQueryHelper.getAllGroupBySscId(this.getSscId(), this.getUserId());
            Map<String, List<DynamicObject>> tasksMapByGroupId = tasks.stream().collect(Collectors.groupingBy(dy -> dy.getString("usergroup.id")));
            if (!CollectionUtils.isEmpty((Collection)groups)) {
                for (DynamicObject group : groups) {
                    Map<Long, Boolean> workStatusMapOfGroudId = SscWorkCalendarApi.isPersonsWork(this.getSscId().toString(), group.getString("id"));
                    if (CollectionUtils.isEmpty(workStatusMapOfGroudId) || CollectionUtils.isEmpty((Collection)tasksMapByGroupId.get(group.getString("id")))) continue;
                    List taskOfGroudId = tasksMapByGroupId.get(group.getString("id")).stream().filter(task -> Boolean.TRUE.equals(workStatusMapOfGroudId.get(task.getLong("personid")))).collect(Collectors.toList());
                    filterTask.addAll(taskOfGroudId);
                }
            }
        } else {
            Map<Long, Boolean> workStatusMapOfGroudId = SscWorkCalendarApi.isPersonsWork(this.getSscId().toString(), this.getGroupId());
            if (!CollectionUtils.isEmpty(workStatusMapOfGroudId)) {
                filterTask = tasks.stream().filter(task -> Boolean.TRUE.equals(workStatusMapOfGroudId.get(task.getLong("personid")))).collect(Collectors.toList());
            }
        }
        return filterTask;
    }

    private void initAverageTaskLabel(List<DynamicObject> toDoTasks) {
        long TaskDealerNumber = toDoTasks.stream().map(dy -> dy.getLong("personid")).distinct().count();
        BigDecimal average = TaskDealerNumber == 0L ? (toDoTasks.size() == 0 ? new BigDecimal("0.0") : new BigDecimal("-1.0")) : new BigDecimal(toDoTasks.size()).divide(new BigDecimal(TaskDealerNumber), 1, 3);
        Label taskNumberLabel = (Label)this.getView().getControl("average_task_number");
        taskNumberLabel.setText(String.valueOf(average));
    }

    private void initTaskDealerNumberLabel(List<DynamicObject> toDoTasks) {
        long TaskDealerNumber = toDoTasks.stream().map(dy -> dy.getLong("personid")).distinct().count();
        Label taskNumberLabel = (Label)this.getView().getControl("dealer_number");
        taskNumberLabel.setText(String.valueOf(TaskDealerNumber));
    }

    private void initTaskLabel(List<DynamicObject> toDoTasks) {
        int taskNumer = CollectionUtils.isEmpty(toDoTasks) ? 0 : toDoTasks.size();
        Label taskNumberLabel = (Label)this.getView().getControl("task_number");
        taskNumberLabel.setText(String.valueOf(taskNumer));
        if (this.getPageCache().get("CACHE_SHARE_VALUE") == null) {
            this.getPageCache().put("CACHE_SHARE_VALUE", taskNumer + "");
        }
    }

    private DynamicObjectCollection getToDoTasks() {
        QFilter userFilter = SscToDoTaskCardFormPlugin.userFilter(this.getSscId(), this.getGroupId());
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        return QueryServiceHelper.query((String)"task_task", (String)"id,personid,usergroup.id", (QFilter[])new QFilter[]{userFilter, statusFilter, notQuaCheckTask});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"button_detail", (CharSequence)key)) {
            this.jumpToToDoTaskDetailPage();
        }
    }

    private void jumpToToDoTaskDetailPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_todotask_detail_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u4efb\u52a1\u5206\u5e03", (String)"SscToDoTaskCardFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("sharecenter", (Object)this.getSscId().toString());
        parameter.setCustomParam("usergroup", (Object)this.getGroupId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getGroupId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("usergroup");
    }

    private Long getSscId() {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    protected Long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    private static QFilter userFilter(Long sscId, String userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (StringUtils.isBlank((CharSequence)userGroupId) || "-1".equals(userGroupId)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.parseLong(userGroupId));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        if ("radiogroupfield".equals(keyName)) {
            this.initialTaskData();
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.ToDoTaskCard.getCaption());
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5904\u7406\uff1a%s", (String)"SscToDoTaskCardFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }
}

