/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.task;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.enums.TaskPoolTypeEnum;

public class TaskPoolWarningNoticeTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        try (DataSet allUserWarningDataSet = this.getAllUserWarningDataSet();){
            DynamicObjectCollection allTasks = this.getAllTasks();
            HashMap<Long, Map<String, String>> filterWarningDataMap = new HashMap<Long, Map<String, String>>();
            for (Row next : allUserWarningDataSet) {
                long userId = next.getLong(0);
                String jsonStr = next.getString(1);
                filterWarningDataMap.put(userId, this.translateToNoticeMap(jsonStr, allTasks));
            }
            if (CollectionUtils.isEmpty(filterWarningDataMap)) {
                return;
            }
            List<MessageInfo> messageInfos = this.translateWarningDataMapToMessgeInfos(filterWarningDataMap, allTasks);
            messageInfos.forEach(MessageCenterServiceHelper::sendMessage);
            this.updateNoticeDate(filterWarningDataMap);
        }
        catch (Exception var6) {
            throw new KDException((Throwable)var6, BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"[\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\u79fb\u52a8\u7aef]\u4efb\u52a1\u6c60\u9884\u8b66\u503c\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1\uff0c\u53d1\u9001\u6d88\u606f\u5931\u8d25\u3002", (String)"TaskPoolWarningNoticeTask_2", (String)"ssc-task-mobile", (Object[])new Object[0])});
        }
    }

    private void updateNoticeDate(Map<Long, Map<String, String>> filterWarningDataMap) {
        for (Map.Entry<Long, Map<String, String>> entry : filterWarningDataMap.entrySet()) {
            Long userId = entry.getKey();
            Map<String, String> userWarningMapData = this.getUserCurrentWarningMapData(userId);
            this.updateNoticeDateByUser(userWarningMapData, entry);
        }
    }

    private void updateNoticeDateByUser(Map<String, String> userWarningMapData, Map.Entry<Long, Map<String, String>> noticeSendEntry) {
        Map<String, String> warningKeyValueMap = noticeSendEntry.getValue();
        if (CollectionUtils.isEmpty(warningKeyValueMap)) {
            return;
        }
        Long userId = noticeSendEntry.getKey();
        for (Map.Entry<String, String> entry : warningKeyValueMap.entrySet()) {
            String[] beforeUpdateDateStrArray = userWarningMapData.get(entry.getKey()).split("#");
            if (beforeUpdateDateStrArray.length != 3) continue;
            String afterUpdateDateStr = beforeUpdateDateStrArray[0] + "#" + beforeUpdateDateStrArray[1] + "#" + LocalDate.now();
            userWarningMapData.put(entry.getKey(), afterUpdateDateStr);
        }
        String jsonData = SerializationUtils.toJsonString(userWarningMapData);
        ParameterHelper.saveUserCustParameter((long)userId, (String)"ssc_index_m", (String)"SSC_USERPARAMETER_KEY", (String)jsonData);
    }

    private List<MessageInfo> translateWarningDataMapToMessgeInfos(Map<Long, Map<String, String>> filterWarningDataMap, DynamicObjectCollection allTasks) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        for (Map.Entry<Long, Map<String, String>> entry : filterWarningDataMap.entrySet()) {
            Long userId = entry.getKey();
            Map<String, String> WarningKeyValueMap = entry.getValue();
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userId);
            for (Map.Entry<String, String> WarningKeyValueEntry : WarningKeyValueMap.entrySet()) {
                String[] warningKeyValueSplit = WarningKeyValueEntry.getKey().split("#");
                String cardName = warningKeyValueSplit[0];
                if (!"scc_taskpool_card_m".equals(cardName)) continue;
                String sscId = warningKeyValueSplit[1];
                String groupId = warningKeyValueSplit[2];
                MessageInfo messageInfo = new MessageInfo();
                messageInfo.setTag(ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf", (String)"TaskPoolWarningNoticeTask_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
                messageInfo.setTitle(ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf\uff1a\u4efb\u52a1\u6c60\u5b58\u91cf\u9884\u8b66\uff08\u5f53\u5929\u4e0d\u518d\u63d0\u9192\uff09", (String)"TaskPoolWarningNoticeTask_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
                messageInfo.setContent(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u91cf\u201c%1$d\u201d\uff0c\u5df2\u8d85\u8fc7\u9884\u8b66\u503c\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u67e5\u770b\u3002", (String)"TaskPoolWarningNoticeTask_1", (String)"ssc-task-mobile", (Object[])new Object[0]), this.filterCurrentStockBySscIdAndGroupId(sscId, groupId, allTasks)));
                messageInfo.setUserIds(userIds);
                messageInfo.setType("message");
                String accountId = RequestContext.get().getAccountId();
                messageInfo.setMobContentUrl(String.format("%s/mobile.html?accountId=%s&form=ssc_subject_card_m?notice=1&accountId=%s&sharecenter=%s&usergroup=%s&formIds=scc_taskpool_card_m", UrlService.getDomainContextUrl(), accountId, accountId, sscId, groupId));
                messageInfo.setNotifyType("");
                messageInfos.add(messageInfo);
            }
        }
        return messageInfos;
    }

    private DynamicObjectCollection getAllTasks() {
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        return QueryServiceHelper.query((String)"task_task", (String)"id,sscid,usergroup.id", (QFilter[])new QFilter[]{statusFilter, notQuaCheckTask});
    }

    private Map<String, String> translateToNoticeMap(String jsonStr, DynamicObjectCollection allCurrentTaskObjects) {
        HashMap<String, String> noticeWarningMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return noticeWarningMap;
        }
        Map warningMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        for (Map.Entry entry : warningMap.entrySet()) {
            String[] keySplit = ((String)entry.getKey()).split("#");
            if (keySplit.length != 3) continue;
            String sscId = keySplit[1];
            String groupId = keySplit[2];
            String[] valueSplit = ((String)entry.getValue()).split("#");
            if (valueSplit.length != 3) continue;
            String warningValue = valueSplit[0];
            String isNotice = valueSplit[1];
            String noticeDate = valueSplit[2];
            if (!this.isExceedWarningValue(sscId, groupId, warningValue, allCurrentTaskObjects).booleanValue() || !StringUtils.equals((CharSequence)isNotice, (CharSequence)"1") || LocalDate.now().toString().equals(noticeDate)) continue;
            noticeWarningMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return noticeWarningMap;
    }

    private Boolean isExceedWarningValue(String sscId, String groupId, String warningValue, DynamicObjectCollection allCurrentTaskObjects) {
        if (StringUtils.equals((CharSequence)"0", (CharSequence)warningValue)) {
            return Boolean.FALSE;
        }
        long currentCountBySscIdAndGroupId = this.filterCurrentStockBySscIdAndGroupId(sscId, groupId, allCurrentTaskObjects);
        BigDecimal percent = new BigDecimal(currentCountBySscIdAndGroupId).divide(new BigDecimal(warningValue), 1, 3);
        return percent.compareTo(new BigDecimal("1")) >= 0;
    }

    private long filterCurrentStockBySscIdAndGroupId(String sscId, String groupId, DynamicObjectCollection allCurrentTaskObjects) {
        return allCurrentTaskObjects.stream().filter(dy -> StringUtils.equals((CharSequence)sscId, (CharSequence)dy.getString("sscid")) && ("-1".equals(groupId) || StringUtils.equals((CharSequence)groupId, (CharSequence)dy.getString("usergroup.id")))).count();
    }

    private DataSet getAllUserWarningDataSet() {
        String sql = " SELECT FUSERID,FDATA FROM T_BAS_USERPARAMETER WHERE FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FFORMID", 12, (Object)"ssc_index_m"));
        params.add(new SqlParameter(":FEXTEND", 12, (Object)"SSC_USERPARAMETER_KEY"));
        params.add(new SqlParameter(":FISLISTOPTION", 16, (Object)Boolean.FALSE));
        return DB.queryDataSet((String)"kd.ssc.task.mobile.task.TaskPoolWarningNoticeTask", (DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    private Map<String, String> getUserCurrentWarningMapData(Long userId) {
        Map<String, String> jsonMap = new HashMap<String, String>();
        String sql = " SELECT FDATA FROM T_BAS_USERPARAMETER WHERE FUSERID=? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FUSERID", -5, (Object)userId));
        params.add(new SqlParameter(":FFORMID", 12, (Object)"ssc_index_m"));
        params.add(new SqlParameter(":FEXTEND", 12, (Object)"SSC_USERPARAMETER_KEY"));
        params.add(new SqlParameter(":FISLISTOPTION", 16, (Object)Boolean.FALSE));
        ResultSetHandler action = rs -> rs.next() ? rs.getString(1) : null;
        String jsonData = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)action);
        if (StringUtils.isNotBlank((CharSequence)jsonData)) {
            jsonMap = (Map)SerializationUtils.fromJsonString((String)jsonData, Map.class);
        }
        return jsonMap;
    }
}

