/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ssc.task.mobile.template.AbstractTemplatePlugin;
import kd.ssc.task.mobile.template.DynamicTabTemplatePlugin;
import kd.ssc.task.mobile.template.ITemplateDataProcess;
import kd.ssc.task.mobile.template.SelectListModalPlugin;
import kd.ssc.task.mobile.template.data.GNode;
import kd.ssc.task.mobile.template.data.ItemModel;
import kd.ssc.task.mobile.template.data.ListDataModel;
import kd.ssc.task.mobile.template.data.SelectItemData;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.utils.CastUtils;
import kd.ssc.task.mobile.utils.InvokeUtil;

public abstract class AbstractListTemplatePlugin
extends AbstractTemplatePlugin
implements RowClickEventListener {
    private static final String TRANSFER_KEY = "transfer_key";
    private static final String CTRL_ENTRY_KEY_LIST = "entryentity";
    private static final String ENTRY_ITEM_NAME = "itemname";
    private static final String ENTRY_ITEM_VALUE = "itemvalue";
    private static final String ENTRY_ITEM_VALUE1 = "itemvalue1";
    private static final String ENTRY_ITEM_VALUE2 = "itemvalue2";

    protected abstract void setChart(ListDataModel var1);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferData transferData = this.getTransferData();
        this.initView(transferData);
        this.loadData(transferData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl(CTRL_ENTRY_KEY_LIST);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (CTRL_ENTRY_KEY_LIST.equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(CTRL_ENTRY_KEY_LIST);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(CTRL_ENTRY_KEY_LIST).get(currIndex);
            String groupby = dynamicObject.getString("groupby");
            Long groupid = dynamicObject.getLong("groupid");
            int havemore = dynamicObject.getInt("havemore");
            if (havemore == 1) {
                this.jumpNext(groupby, groupid);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectlist".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            SelectItemData data = (SelectItemData)CastUtils.cast(closedCallBackEvent.getReturnData());
            TransferData param = this.getTransferData();
            param.getGroupbys().add(data.getId());
            Map<String, Object> extra = data.getExtra();
            param.getFilterMap().put(String.valueOf(extra.get("groupby")), Long.valueOf(String.valueOf(extra.get("groupid"))));
            DynamicTabTemplatePlugin.jumpMeBy(this.getView(), null, param);
        }
    }

    protected void initView(TransferData param) {
    }

    protected void loadData(TransferData transferData) {
        List<String> groupbys = transferData.getGroupbys();
        ITemplateDataProcess process = this.getDataProcess(transferData);
        GNode gNode = process.getGroupNode(transferData.getKey());
        List<GNode> gNodes = gNode.selectNextList(groupbys);
        ListDataModel data = process.getListData(transferData);
        if (data.getDatas().isEmpty()) {
            this.setPropDataTag(0, data.getNoDataTip());
            return;
        }
        this.setPropDataTag(data.getDatas().size());
        data.setHaveMore(gNodes.size() > 0 ? 1 : 0);
        this.setData(data);
    }

    protected ITemplateDataProcess getDataProcess(TransferData transferData) {
        return (ITemplateDataProcess)InvokeUtil.getInstance(transferData.getDataProcessClassName());
    }

    protected void setData(ListDataModel data) {
        this.setChart(data);
        this.setListPanel(data);
    }

    protected void setListPanel(ListDataModel dataModel) {
        List<ItemModel> datas = dataModel.getDatas();
        IDataModel model = this.getModel();
        model.deleteEntryData(CTRL_ENTRY_KEY_LIST);
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(CTRL_ENTRY_KEY_LIST, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(CTRL_ENTRY_KEY_LIST);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            DynamicProperty itemvalue = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE);
            DynamicProperty itemvalue1 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE1);
            DynamicProperty itemvalue2 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE2);
            DynamicProperty groupby = dynamicObjects.getDynamicObjectType().getProperty("groupby");
            DynamicProperty groupid = dynamicObjects.getDynamicObjectType().getProperty("groupid");
            DynamicProperty havemore = dynamicObjects.getDynamicObjectType().getProperty("havemore");
            for (int i = 0; i < size; ++i) {
                ItemModel item = datas.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemname.setValueFast((Object)entry, (Object)item.getItemname());
                itemvalue.setValueFast((Object)entry, (Object)item.getItemvalue());
                itemvalue1.setValueFast((Object)entry, (Object)item.getItemvalue1());
                itemvalue2.setValueFast((Object)entry, (Object)item.getItemvalue2());
                groupid.setValueFast((Object)entry, (Object)item.getGroupid());
                groupby.setValueFast((Object)entry, (Object)dataModel.getGroupby());
                havemore.setValueFast((Object)entry, (Object)dataModel.getHaveMore());
            }
            model.endInit();
        }
        this.getView().updateView(CTRL_ENTRY_KEY_LIST);
    }

    protected void jumpNext(String groupby, Long groupid) {
        TransferData param = this.getTransferData();
        List<String> groupbys = param.getGroupbys();
        ITemplateDataProcess process = this.getDataProcess(param);
        GNode gNode = process.getGroupNode(param.getKey());
        List<GNode> gNodes = gNode.selectNextList(groupbys);
        if (gNodes.size() == 1) {
            param.getGroupbys().add(gNodes.get(0).getGroupby());
            param.getFilterMap().put(groupby, groupid);
            DynamicTabTemplatePlugin.jumpMeBy(this.getView(), null, param);
            return;
        }
        if (gNodes.size() > 1) {
            this.showSelectNextLitView(groupby, groupid, gNodes);
        }
    }

    private void showSelectNextLitView(String groupby, Long groupid, List<GNode> gNodes) {
        List<SelectItemData> collect = gNodes.stream().map(gNode -> {
            SelectItemData item = new SelectItemData();
            item.setId(gNode.getGroupby());
            item.setName(String.format(ResManager.loadKDString((String)"\u6309%s\u5c55\u5f00", (String)"AbstractListTemplatePlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]), gNode.getGroupName()));
            item.getExtra().put("groupby", groupby);
            item.getExtra().put("groupid", groupid);
            return item;
        }).collect(Collectors.toList());
        SelectListModalPlugin.jumpMeBy((AbstractFormPlugin)this, "selectlist", collect);
    }

    protected TransferData getTransferData() {
        String transfer = this.getPageCache().get(TRANSFER_KEY);
        if (transfer == null) {
            transfer = (String)this.getView().getFormShowParameter().getCustomParam(TRANSFER_KEY);
            this.getPageCache().put(TRANSFER_KEY, transfer);
        }
        return (TransferData)SerializationUtils.fromJsonString((String)transfer, TransferData.class);
    }

    protected void saveTransferData(TransferData data) {
        String transfer = SerializationUtils.toJsonString((Object)data);
        this.getPageCache().put(TRANSFER_KEY, transfer);
    }
}

