/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.OrgRelationQueryHelper;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;

public class BaseDataHelper {
    public static List<DynamicObject> getBaseData(String groupby, Long usergroup, Long parentid, Set<Long> ids) {
        DynamicObjectCollection baseData = BaseDataHelper.getBaseData(groupby, parentid, ids);
        if ("usergroup".equals(groupby) && baseData != null) {
            return baseData.stream().filter(dynamicObject -> {
                if (usergroup.equals(-1L)) {
                    return true;
                }
                return usergroup.equals(dynamicObject.getLong("id"));
            }).collect(Collectors.toList());
        }
        return baseData;
    }

    public static DynamicObjectCollection getBaseData(String groupby, Long parentid, Set<Long> ids) {
        if ("usergroup".equals(groupby)) {
            Long userId = RequestContext.get().getCurrUserId();
            return CommonQueryHelper.getAllGroupBySscId(parentid, userId);
        }
        if ("orgid".equals(groupby)) {
            List<Long> allToOrg = OrgRelationQueryHelper.getFromOrgList(parentid);
            ids.addAll(allToOrg);
            return QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "in", ids).toArray());
        }
        if ("billType".equals(groupby)) {
            return QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("ssccenter", "=", (Object)parentid).toArray());
        }
        if ("personid".equals(groupby)) {
            QFilter groupFilter = new QFilter("id", "=", (Object)parentid);
            QFilter statusFilter = new QFilter("entryentity.usestatus", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection users = QueryServiceHelper.query((String)"task_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{groupFilter, statusFilter});
            if (users.size() == 1 && ((DynamicObject)users.get(0)).getString("entryentity.userfield").equals("0")) {
                users.remove(0);
            }
            Set longSet = users.stream().filter(Objects::nonNull).mapToLong(user -> user.getLong("entryentity.userfield")).boxed().collect(Collectors.toSet());
            longSet.addAll(ids);
            return QueryServiceHelper.query((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)longSet.toArray()).toArray());
        }
        return null;
    }
}

