/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.template.AbstractListTemplatePlugin;
import kd.ssc.task.mobile.template.data.ItemModel;
import kd.ssc.task.mobile.template.data.ListDataModel;

public abstract class ChartListTemplatePlugin
extends AbstractListTemplatePlugin {
    protected static final String CTRL_CHART_AP = "echartap";

    protected abstract Series createSeries(Chart var1, ListDataModel var2);

    @Override
    protected void setChart(ListDataModel data) {
        List<ItemModel> models = data.getDatas().stream().limit(data.getChartLimit()).collect(Collectors.toList());
        if (this.allEmpty(models)) {
            this.setPropDataTag(1);
            return;
        }
        Chart chart = this.getChart();
        this.setChartMargin(chart);
        this.setLegend(chart, data);
        this.setTooltip(chart, data.getTooltipFormatter());
        this.setXAxis(chart, data.getxName(), models);
        this.setYAxis(chart, data.getyName(), data.getyAxisLineFormatter(), models);
        Series series = this.createSeries(chart, data);
        List list = models.stream().map(ItemModel::getValue).collect(Collectors.toList());
        series.setPropValue("data", list);
        chart.refresh();
    }

    protected boolean allEmpty(List<ItemModel> models) {
        for (ItemModel model : models) {
            if (model.getValue() == null) continue;
            return false;
        }
        return true;
    }

    protected Chart getChart() {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        return chart;
    }

    protected void setChartMargin(Chart chart) {
        chart.setMargin(Position.left, "5%");
        chart.setMargin(Position.top, "15%");
        chart.setMargin(Position.right, "6%");
        chart.setMargin(Position.bottom, "6%");
    }

    protected void setLegend(Chart chart, ListDataModel data) {
        chart.setShowLegend(false);
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    protected void setTooltip(Chart chart, String tooltipFormatter) {
        if (tooltipFormatter == null) {
            chart.setShowTooltip(false);
        } else {
            chart.setShowTooltip(true);
            chart.addTooltip("trigger", (Object)"axis");
            chart.addTooltip("formatter", (Object)tooltipFormatter);
            chart.addFuncPath(M.arraylist("tooltip", "formatter"));
        }
    }

    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items) {
        Axis axis = chart.createXAxis(xName, AxisType.category);
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", 0).kv("rotate", -30).kv("color", "#999999"));
        axis.setPropValue("axisTick", M.map("show", Boolean.FALSE));
        axis.setPropValue("axisLine", (Object)M.map().kv("show", Boolean.FALSE).kv("lineStyle", map -> map.kv("color", "#999").kv("width", 1)));
        List collect = items.stream().map(result -> M.map().kv("value", this.disposeXaxisValue(result.getItemname())).kv("textStyle", M.map("fontSize", 12))).collect(Collectors.toList());
        axis.setPropValue("data", collect);
        return axis;
    }

    protected Object disposeXaxisValue(String value) {
        return value;
    }

    protected BigDecimal getFixMaxValue(List<ItemModel> items) {
        double maxV = items.stream().mapToDouble(value -> value.getValue() == null ? 0.0 : value.getValue().doubleValue()).max().orElse(1.0);
        if (maxV <= 0.4) {
            return new BigDecimal("0.4");
        }
        return null;
    }

    protected Axis setYAxis(Chart chart, String yName, String yAxisLineFormatter, List<ItemModel> models) {
        Axis yAxis = chart.createYAxis(yName, AxisType.value);
        BigDecimal fixMaxValue = this.getFixMaxValue(models);
        if (fixMaxValue != null) {
            yAxis.setPropValue("max", (Object)fixMaxValue);
            yAxis.setPropValue("interval", (Object)fixMaxValue.divide(new BigDecimal(4), 1, 4));
        }
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", "#999").kv("fontSize", 12).kv("align", "left").list("padding", 0, 0, 0, -10));
        yAxis.setPropValue("type", (Object)"value");
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", "#999").kv("fontSize", 12).kv("formatter", yAxisLineFormatter));
        chart.addFuncPath(M.arraylist("yAxis", 0, "axisLabel", "formatter"));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", "dashed").kv("color", "#e8e8e8")));
        yAxis.setPropValue("axisLine", M.map("show", Boolean.FALSE));
        yAxis.setPropValue("axisTick", M.map("show", Boolean.FALSE));
        return yAxis;
    }

    protected void setSeriesProp(Series series, ListDataModel data) {
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", "rgba(10,154,255,1)")));
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("show", Boolean.FALSE)));
    }
}

