/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GNode {
    private final String groupby;
    private final String groupName;
    private final GNode parent;
    private final Map<String, GNode> nexts = new LinkedHashMap<String, GNode>();

    public GNode() {
        this.groupby = "root";
        this.groupName = "root";
        this.parent = this;
    }

    public GNode(String groupby) {
        this(groupby, null, null);
    }

    public GNode(String groupby, String groupbyName, GNode parent) {
        this.groupby = groupby;
        this.groupName = groupbyName;
        this.parent = parent;
    }

    public String getGroupby() {
        return this.groupby;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Map<String, GNode> getNexts() {
        return this.nexts;
    }

    public Collection<GNode> nexts() {
        return this.nexts.values();
    }

    public List<GNode> brothers() {
        ArrayList<GNode> brothers = new ArrayList<GNode>(this.parent.nexts.values());
        brothers.remove(this);
        return brothers;
    }

    public GNode nextNode(String key) {
        return this.nexts.get(key);
    }

    private GNode brothernode(String key) {
        return this.parent.nexts.get(key);
    }

    private GNode select(List<String> keys) {
        GNode gNode = null;
        for (String key : keys) {
            gNode = this.nextNode(key);
            if (gNode != null) continue;
            gNode = this.brothernode(key);
        }
        return gNode;
    }

    public List<GNode> selectSwichList(List<String> keys) {
        GNode gNode = this.select(keys);
        if (gNode == null) {
            return Collections.emptyList();
        }
        ArrayList<GNode> nodes = new ArrayList<GNode>(this.parent.nexts.values());
        for (String key : keys) {
            if (key.equals(gNode.groupby)) continue;
            nodes.remove(new GNode(key));
        }
        return nodes;
    }

    public List<GNode> selectNextList(List<String> keys) {
        GNode gNode = this.select(keys);
        if (gNode == null) {
            return Collections.emptyList();
        }
        List<GNode> brothers = gNode.brothers();
        for (String key : keys) {
            brothers.remove(new GNode(key));
        }
        brothers.addAll(gNode.nexts());
        return brothers;
    }

    public String toString() {
        return this.groupName + "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GNode gNode = (GNode)o;
        return this.groupby.equals(gNode.groupby);
    }

    public int hashCode() {
        return Objects.hash(this.groupby);
    }
}

