/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ssc.enums.approveRebuild.ApproveOriginEnum;
import kd.ssc.task.approveRebuild.helper.TaskApproveFailureHelper;
import kd.ssc.task.common.TaskApprevalUtil;
import org.apache.commons.lang3.StringUtils;

public class BillOperationHelper {
    private static final Log log = LogFactory.getLog(BillOperationHelper.class);

    public static Map<String, Object> doBillOperationResult(Map<String, Object> paramMap) {
        Map<String, Object> billOpResultMap;
        Map<String, Object> failureResult;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("origin", (String)paramMap.get("origin"));
        map.put("subPageId", (String)paramMap.get("subPageId"));
        map.put("appId", (String)paramMap.get("appId"));
        if (paramMap.containsKey("ignoreWarn")) {
            map.put("ignoreWarn", (String)paramMap.get("ignoreWarn"));
        }
        Long billTypeId = (Long)paramMap.get("billTypeId");
        Long taskTypeId = (Long)paramMap.get("taskTypeId");
        String operation = (String)paramMap.get("operation");
        String erpNumber = (String)paramMap.get("erpNumber");
        if ("KDCC".equalsIgnoreCase(erpNumber) && (failureResult = BillOperationHelper.tranServiceResultMap(billOpResultMap = BillOperationHelper.saveKDCCBillData(map, billTypeId, taskTypeId, operation))) != null) {
            return failureResult;
        }
        return null;
    }

    public static Map<String, Object> tranServiceResultMap(Map<String, Object> billOpResultMap) {
        Object opResultObj;
        OperationResult opResult;
        String opResultStr;
        if (billOpResultMap != null && billOpResultMap.size() != 0 && StringUtils.isNotEmpty((CharSequence)(opResultStr = (String)billOpResultMap.get("operationResult"))) && (opResult = (OperationResult)(opResultObj = DataEntitySerializer.deSerializerFromString((String)opResultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class)))) != null && !opResult.isSuccess()) {
            String opResultMessage = opResult.getMessage();
            if (StringUtils.isEmpty((CharSequence)opResultMessage)) {
                opResultMessage = ResManager.loadKDString((String)"\u8c03\u7528\u6e90\u5355\u64cd\u4f5c\u5931\u8d25\u3002", (String)"BillOperationHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                opResult.setMessage(opResultMessage);
                log.info("BillOperationHelper.tranServiceResultMap(): {}, billOpResultMap = {}", (Object)opResultMessage, (Object)JSONObject.toJSONString(billOpResultMap));
            }
            Map<String, Object> failureResult = TaskApproveFailureHelper.getFailureResult("SSC_2005", opResultMessage);
            failureResult.put("billOpResult", opResult);
            List actionResult = (List)billOpResultMap.get("actionResult");
            failureResult.put("billActionResult", actionResult);
            return failureResult;
        }
        return null;
    }

    public static Map<String, Object> saveKDCCBillData(Map<String, String> map, Long taskBillId, Long taskTypeId, String operation) {
        String origin = map.get("origin");
        if (origin == null || ApproveOriginEnum.LIST.getValue().equals(origin)) {
            return null;
        }
        String subPageId = map.get("subPageId");
        String appId = map.get("appId");
        if (StringUtils.isEmpty((CharSequence)subPageId) || StringUtils.isEmpty((CharSequence)appId)) {
            log.info("\u672a\u8bfb\u53d6\u5230subPageId\u548cappId\u53c2\u6570\uff0c\u4e0d\u6267\u884c\u539f\u5355\u64cd\u4f5c");
            return null;
        }
        String operationKey = TaskApprevalUtil.getOriginBillOp(taskBillId, taskTypeId, operation, false);
        if (StringUtils.isEmpty((CharSequence)operationKey)) {
            log.info("\u672a\u8bfb\u53d6\u5230\u5ba1\u6279\u64cd\u4f5c\u914d\u7f6e\uff0c\u4e0d\u6267\u884c\u539f\u5355\u64cd\u4f5c");
            return null;
        }
        log.info("\u8bfb\u53d6\u5230\u5ba1\u6279\u64cd\u4f5c\u914d\u7f6e\uff1a" + operationKey);
        try {
            HashMap<String, String> variable = new HashMap<String, String>(1);
            variable.put("ishasright", String.valueOf(true));
            String ignoreWarn = map.get("ignoreWarn");
            if (StringUtils.isNotEmpty((CharSequence)ignoreWarn)) {
                variable.put("ignorewarn", ignoreWarn);
            }
            Map billOpResultMap = (Map)DispatchServiceHelper.invokeBOSService((String)appId, (String)FormService.class.getSimpleName(), (String)"invokeOperationFromService", (Object[])new Object[]{subPageId, operationKey, variable});
            return billOpResultMap;
        }
        catch (Exception e) {
            log.error("Error on invoking \"{}\" operation", (Object)operationKey, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\u3002", (String)"TaskApprevalUtil_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

