/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.helper.TaskCreditHelper;
import kd.ssc.task.business.helper.WorkFlowCreditHelper;
import kd.ssc.task.common.workcalendar.CalRemainingTime;
import kd.ssc.task.util.SSCBosUtil;

public class TaskApproveSuccessHelper {
    private static final Log log = LogFactory.getLog(TaskApproveSuccessHelper.class);

    public static Map<String, Object> getSuccessResult(Map<String, Object> data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", "true");
        resultMap.put("data", data);
        return resultMap;
    }

    public static void calCompletedTime(List<Long> taskIds) {
        CalRemainingTime cal = new CalRemainingTime();
        cal.calCompletedTimeOfTaskApprove(taskIds);
    }

    public static long updateStateAndRecord(String key, Long taskid, Map<String, String> map) {
        DynamicObject task = TaskApproveSuccessHelper.updateTaskStatus(key, taskid, map);
        if (task == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230ID\u4e3a\u201c%1$s\u201d\u7684\u4efb\u52a1\u3002", (String)"TaskApproveSuccessHelper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskid));
        }
        boolean deleteTask = true;
        DynamicObject taskHis = TaskApproveSuccessHelper.insertDataToHistoryTask(taskid, task, deleteTask, map);
        TaskApproveSuccessHelper.insertWFTask(taskHis);
        long hisID = taskHis.getLong("ID");
        DynamicObject auditStateChange = TaskApproveSuccessHelper.createAuditStateChange(key, taskid, map);
        TaskApproveSuccessHelper.insertDataToHistoryState(taskid, hisID, auditStateChange, deleteTask);
        TaskApproveSuccessHelper.insertTaskHistExtParam(taskid, hisID);
        TaskApproveSuccessHelper.updatePredictResult(taskHis, map);
        TaskApproveSuccessHelper.insertEvaluateIntermediate(taskid, task);
        return hisID;
    }

    public static void insertEvaluateIntermediate(long taskId, DynamicObject task) {
        try {
            if (!TaskApproveSuccessHelper.getEnableEvaluateParam()) {
                log.info("enableevaluate param not open,taskId:{}", (Object)taskId);
            }
            long billId = Long.parseLong(task.getString("billid"));
            String billNo = task.getString("billnumber");
            QFilter filter = new QFilter("billid", "=", (Object)billId);
            QFilter evaluatedFilter = new QFilter("status", "=", (Object)EvaluateStatusEnum.EVALUATED_STATE.getStatus());
            if (QueryServiceHelper.exists((String)"som_evaluating_data", (QFilter[])new QFilter[]{filter, evaluatedFilter})) {
                log.info("bill evaluated id:{},taskId:{}", (Object)billId, (Object)taskId);
                return;
            }
            String status = EvaluateStatusEnum.INIT_STATE.getStatus();
            QFilter evaluatingFilter = new QFilter("status", "=", (Object)EvaluateStatusEnum.EVALUATING_STATE.getStatus());
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"som_evaluating_data", (String)"waitevaluatetime", (QFilter[])new QFilter[]{filter, evaluatingFilter});
            DynamicObject evaluateIntermediate = BusinessDataServiceHelper.newDynamicObject((String)"som_evaluating_data");
            evaluateIntermediate.set("taskid", (Object)taskId);
            evaluateIntermediate.set("billid", (Object)billId);
            evaluateIntermediate.set("billno", (Object)billNo);
            long personId = task.getLong("personid.id");
            if (personId == 0L) {
                personId = RequestContext.get().getCurrUserId();
            }
            evaluateIntermediate.set("handlerid", (Object)personId);
            evaluateIntermediate.set("entitynumber", (Object)task.getString("billtype.bindbill.number"));
            if (dynamicObject != null) {
                status = EvaluateStatusEnum.EVALUATING_STATE.getStatus();
                evaluateIntermediate.set("waitevaluatetime", (Object)dynamicObject.getDate("waitevaluatetime"));
            }
            evaluateIntermediate.set("status", (Object)status);
            evaluateIntermediate.set("sscid", (Object)task.getDynamicObject("sscid").getLong("id"));
            evaluateIntermediate.set("org", (Object)task.getDynamicObject("orgid").getLong("id"));
            evaluateIntermediate.set("billtype", (Object)task.getLong("billtype.id"));
            evaluateIntermediate.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{evaluateIntermediate});
        }
        catch (Exception e) {
            log.error("bill evaluated id:{},taskId:{},e:{}", new Object[]{task.getString("billid"), taskId, e});
        }
    }

    public static boolean getEnableEvaluateParam() {
        Object params = SSCBosUtil.getSscSettingInfo((String)"enableevaluate", (boolean)false);
        if (params == null || !(params instanceof Boolean)) {
            return false;
        }
        return (Boolean)params;
    }

    private static DynamicObject updateTaskStatus(String key, Long taskId, Map<String, String> map) {
        String innermsg = map.get("innermsg");
        String apprevalmessage = map.get("opinion");
        String decisionitem = map.get("decisionitem");
        String operatorId = map.get("operatorId");
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        if (task != null) {
            task.set("pooltype", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
            if ("bd_nopass".equals(key) || "bar_repulse".equals(key)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            } else if ("bar_pass".equals(key)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_PASSED.getValue());
            }
            if ("1".equals(decisionitem) || "2".equals(decisionitem) || "4".equals(decisionitem)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            }
            task.set("completetime", (Object)new Date());
            task.set("innermsg", (Object)innermsg);
            task.set("apprevalmessage", (Object)(apprevalmessage.length() > 2000 ? apprevalmessage.substring(0, 2000) : apprevalmessage));
            if (StringUtils.isNotEmpty((CharSequence)operatorId)) {
                task.set("operatorId", (Object)Long.parseLong(operatorId));
            }
        }
        return task;
    }

    public static DynamicObject insertDataToHistoryTask(Long taskId, DynamicObject taskData, boolean deleteTask, Map<String, String> map) {
        ORM orm = ORM.create();
        DynamicObject historyTask = orm.newDynamicObject("task_taskhistory");
        historyTask.set("sourcetaskid", (Object)taskId);
        historyTask.set("decisionitem", (Object)map.get("decisionitem"));
        if (map.get("decisionitemid") != null) {
            historyTask.set("decisionitemnew", (Object)Long.parseLong(map.get("decisionitemid")));
        }
        String itemId = map.get("nodeItemId");
        historyTask.set("itemid", (Object)itemId);
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("state", taskData.get("state"));
        historyTask.set("innermsg", taskData.get("innermsg"));
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("apprevalmessage", taskData.get("apprevalmessage"));
        long personid = taskData.getLong("personid.id");
        if (personid == 0L) {
            RequestContext requestContext = RequestContext.get();
            Long currentUserId = Long.valueOf(requestContext.getUserId());
            historyTask.set("receivetime", (Object)new Date());
            historyTask.set("completetime", (Object)new Date());
            historyTask.set("personid", (Object)currentUserId);
        } else {
            historyTask.set("receivetime", taskData.get("receivetime"));
            historyTask.set("completetime", taskData.get("completetime"));
            historyTask.set("personid", taskData.get("personid"));
        }
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", taskData.get("pooltype"));
        historyTask.set("expirestate", taskData.get("expirestate"));
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("applytime", taskData.get("applytime"));
        historyTask.set("createtime", taskData.get("createtime"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("costwaittime", taskData.get("costwaittime"));
        historyTask.set("resttime", taskData.get("resttime"));
        historyTask.set("waittime", (Object)new BigDecimal(0));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("firstcostwaittime", taskData.get("firstcostwaittime"));
        historyTask.set("pausewaittime", taskData.get("pausewaittime"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        String state = taskData.getString("state");
        if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
            historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        }
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("iscalculated", (Object)"0");
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        if (StringUtils.isNotEmpty((CharSequence)map.get("innermsg"))) {
            historyTask.set("innermsg", (Object)map.get("innermsg"));
        }
        if (StringUtils.isNotEmpty((CharSequence)map.get("opinion"))) {
            String opinion = map.get("opinion");
            historyTask.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
        }
        if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state) && StringUtils.isNotEmpty((CharSequence)map.get("withdrawal"))) {
            historyTask.set("unpassreasondesc", (Object)map.get("withdrawal"));
        }
        historyTask.set("matchrule", taskData.get("matchrule"));
        historyTask.set("autoprocessresult", taskData.get("autoprocessresult"));
        historyTask.set("operatorId", taskData.get("operatorId"));
        TaskApproveSuccessHelper.setBillInfoEntry(taskData, historyTask);
        historyTask.set("workgroup", (Object)DataHelper.getWorkgroupId((Long)taskData.getLong("usergroup_id")));
        DynamicObject[] hisTasks = new DynamicObject[]{historyTask};
        SaveServiceHelper.save((DynamicObject[])hisTasks);
        historyTask = hisTasks[0];
        if (deleteTask) {
            QFilter taskIDQfilter = new QFilter("id", "=", (Object)taskId);
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskIDQfilter});
        }
        return historyTask;
    }

    private static void setBillInfoEntry(DynamicObject taskData, DynamicObject historyTask) {
        DynamicObjectCollection billInfoEntry = taskData.getDynamicObjectCollection("billinfoentry");
        DynamicObjectCollection hisBillInfoEntry = historyTask.getDynamicObjectCollection("billinfoentry");
        for (DynamicObject dynObj : billInfoEntry) {
            DynamicObject hisDynObj = hisBillInfoEntry.addNew();
            hisDynObj.set("costdept", dynObj.get("costdept"));
            hisDynObj.set("expenseitem", dynObj.get("expenseitem"));
            hisDynObj.set("expenseamount", dynObj.get("expenseamount"));
            hisDynObj.set("supplier", dynObj.get("supplier"));
        }
    }

    private static void insertWFTask(DynamicObject taskHis) {
        try {
            long taskId = taskHis.getLong("id");
            long assignId = taskHis.getLong("assignid");
            Date completeTime = taskHis.getDate("completetime");
            DynamicObject wfTask = QueryServiceHelper.queryOne((String)"wf_hitaskinst", (String)"processdefinitionid, processinstanceid, taskdefinitionkey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignId)});
            if (wfTask != null) {
                long processdefinitionid = wfTask.getLong("processdefinitionid");
                long processinstanceid = wfTask.getLong("processinstanceid");
                String taskdefinitionkey = wfTask.getString("taskdefinitionkey");
                DynamicObject taskWFtask = BusinessDataServiceHelper.newDynamicObject((String)"task_wftask");
                taskWFtask.set("taskhistoryid", (Object)taskId);
                taskWFtask.set("assignid", (Object)assignId);
                taskWFtask.set("processdefinitionid", (Object)processdefinitionid);
                taskWFtask.set("processinstanceid", (Object)processinstanceid);
                taskWFtask.set("taskdefinitionkey", (Object)taskdefinitionkey);
                taskWFtask.set("completetime", (Object)completeTime);
                log.info("\u8bb0\u5f55\u4efb\u52a1\u5de5\u4f5c\u6d41\u5173\u7cfb\u8868\uff0ctaskWFtask\uff1a{}", (Object)taskWFtask);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskWFtask});
            } else {
                log.info("\u8bb0\u5f55\u4efb\u52a1\u5de5\u4f5c\u6d41\u5173\u7cfb\u8868\uff0c\u67e5\u8be2\u5de5\u4f5c\u6d41\u4efb\u52a1\u4e3a\u7a7aassignid\uff1a{}", (Object)assignId);
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u6d41\u7a0b\u4efb\u52a1\u5173\u7cfb\u8868\u5931\u8d25\uff1a{}" + e.getMessage());
        }
    }

    private static DynamicObject createAuditStateChange(String key, Long taskid, Map<String, String> map) {
        long billtype = Long.parseLong(map.get("billtypeid"));
        long oldState = Long.parseLong(map.get("state"));
        long tasktypeid = Long.parseLong(map.get("tasktypeid"));
        Long personid = Long.parseLong(map.get("personid"));
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject("task_statechange");
        if ("bd_nopass".equals(key) || "bar_repulse".equals(key) || "bar_repulse_mytask".equals(key)) {
            obj.set("newjobstate", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            obj.set("operation", (Object)"2");
        } else if ("bar_pass".equals(key)) {
            obj.set("newjobstate", (Object)TaskStateEnum.AUDIT_PASSED.getValue());
            obj.set("operation", (Object)"1");
        }
        obj.set("oldjobstate", (Object)oldState);
        obj.set("changetime", (Object)new Date());
        obj.set("operatorid", (Object)personid);
        obj.set("tasktype", (Object)tasktypeid);
        obj.set("billtype", (Object)billtype);
        obj.set("message", (Object)map.get("opinion"));
        obj.set("innermsg", (Object)map.get("innermsg"));
        obj.set("jobid", (Object)taskid);
        return obj;
    }

    private static void insertTaskHistExtParam(Long taskid, long hisID) {
        QFilter extParamFilter = new QFilter("taskid", "=", (Object)taskid);
        DynamicObject extParam = BusinessDataServiceHelper.loadSingle((String)"task_ext_param", (String)"creator,createdate,taskid,extparam,extparam_tag,isstoredindb", (QFilter[])new QFilter[]{extParamFilter});
        if (extParam != null) {
            ORM orm = ORM.create();
            DynamicObject hisTaskExtParam = orm.newDynamicObject("taskhis_ext_param");
            hisTaskExtParam.set("taskid", (Object)hisID);
            hisTaskExtParam.set("createdate", extParam.get("createdate"));
            hisTaskExtParam.set("creator", extParam.get("creator"));
            hisTaskExtParam.set("extparam_tag", extParam.get("extparam_tag"));
            hisTaskExtParam.set("isstoredindb", extParam.get("isstoredindb"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisTaskExtParam});
        }
    }

    public static void insertDataToHistoryState(long taskId, long hisID, DynamicObject stateChange, boolean deleteTask) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("jobid", "=", (Object)taskId);
        DynamicObjectCollection col = orm.query("task_statechange", filter.toArray());
        col.add((Object)stateChange);
        ArrayList<DynamicObject> hisTaskStateList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject historyTaskState = orm.newDynamicObject("task_statechangehis");
            DynamicObject taskState = (DynamicObject)col.get(i);
            historyTaskState.set("jobid", (Object)hisID);
            historyTaskState.set("newjobstate", taskState.get("newjobstate"));
            historyTaskState.set("operation", taskState.get("operation"));
            historyTaskState.set("oldjobstate", taskState.get("oldjobstate"));
            historyTaskState.set("changetime", taskState.get("changetime"));
            historyTaskState.set("operatorid", taskState.get("operatorid"));
            historyTaskState.set("allocatedpersonid", taskState.get("allocatedpersonid"));
            historyTaskState.set("tasktype", taskState.get("tasktype"));
            historyTaskState.set("billtype", taskState.get("billtype"));
            historyTaskState.set("message", taskState.get("message"));
            historyTaskState.set("innermsg", taskState.get("innermsg"));
            DynamicObjectCollection hisEnties = historyTaskState.getDynamicObjectCollection("entry");
            DynamicObjectCollection entries = taskState.getDynamicObjectCollection("entry");
            for (DynamicObject e : entries) {
                DynamicObject e_ = hisEnties.addNew();
                e_.set("attid", e.get("attid"));
            }
            hisTaskStateList.add(historyTaskState);
        }
        if (!hisTaskStateList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])hisTaskStateList.toArray(new DynamicObject[0]));
        }
        if (deleteTask) {
            DeleteServiceHelper.delete((String)"task_statechange", (QFilter[])filter.toArray());
        }
    }

    public static Map<String, Object> saveArtiCheckPointInfo(Long taskId, IDataModel model, String operation) {
        DynamicObjectCollection entryEntity;
        log.info("saveArtiCheckPointInfo, taskId = {}, operation = {}", (Object)taskId, (Object)operation);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        if ("1".equals(operation)) {
            paramMap.put("allPass", Boolean.TRUE);
        }
        ArrayList recordList = new ArrayList();
        if (model != null && !CollectionUtils.isEmpty((Collection)(entryEntity = model.getEntryEntity("entryentity")))) {
            for (DynamicObject entry : entryEntity) {
                HashMap<String, Constable> recordMap = new HashMap<String, Constable>(8);
                recordMap.put("artiCheckPointId", Long.valueOf(entry.getLong("articheckpointid")));
                recordMap.put("isContented", Boolean.valueOf(entry.getBoolean("checkboxfield")));
                recordList.add(recordMap);
            }
        }
        paramMap.put("recordList", recordList);
        return (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"saveArtiCheckPointInfo", (Object[])new Object[]{paramMap});
    }

    public static DynamicObject getTaskHistoryDo(Long taskId) {
        String entityName = "task_taskhistory";
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, billtype.id";
        QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
        DynamicObject taskHistoryDo = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        return taskHistoryDo;
    }

    public static void creditSubScore(String operation, DynamicObject taskHistoryDo, Map<String, String> map) {
        Boolean openCreditControl;
        if (taskHistoryDo == null) {
            return;
        }
        Long historyTaskId = taskHistoryDo.getLong("id");
        if ("1".equals(operation)) {
            TaskCreditHelper.saveBreakRuleRecord((Long)historyTaskId, map);
        }
        if ((openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByHisTask((long)historyTaskId)) == null) {
            if ("1".equals(operation)) {
                TaskCreditHelper.passedButFlawed(map, (long)historyTaskId);
            } else if ("2".equals(operation)) {
                TaskCreditHelper.approvalFailed(map, (long)historyTaskId);
            }
        }
    }

    private static void updatePredictResult(DynamicObject taskHis, Map<String, String> map) {
        try {
            DynamicObject approvalRes = BusinessDataServiceHelper.loadSingle((String)"task_approval_result", (String)"billnumber,subject,realpass,realbreakrule,realoperation,realwithdrawal,predictpass,breakrule,operation,withdrawal,realpredictresult,breakrulepredictresult,operationpredictresult,withdrawalpredictresult,newrealbreakrule,newrealwithdrawal", (QFilter[])new QFilter("taskid", "=", (Object)taskHis.getLong("sourcetaskid")).toArray());
            approvalRes.set("billnumber", (Object)taskHis.getString("billnumber"));
            approvalRes.set("subject", (Object)taskHis.getString("subject"));
            String state = taskHis.getString("state");
            if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state)) {
                approvalRes.set("realpass", (Object)"1");
                approvalRes.set("realpredictresult", (Object)("1".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                String breakRule = map.getOrDefault("subscorerule", " ");
                if (StringUtils.isBlank((CharSequence)breakRule)) {
                    approvalRes.set("breakrulepredictresult", (Object)"1");
                } else {
                    String breakRulePredictRes = "0";
                    JSONArray array = JSON.parseArray((String)breakRule);
                    for (Object id : array) {
                        if (!approvalRes.getString("breakrule").contains("\"" + id + "\"")) continue;
                        breakRulePredictRes = "1";
                        break;
                    }
                    TaskApproveSuccessHelper.putMulDynamicObject(approvalRes, "newrealbreakrule", (Collection<Object>)array);
                    approvalRes.set("breakrulepredictresult", (Object)breakRulePredictRes);
                }
                if (breakRule.length() > 1000) {
                    breakRule = breakRule.substring(0, 1000);
                    breakRule = breakRule.substring(0, breakRule.lastIndexOf(44)) + ']';
                }
                approvalRes.set("realbreakrule", (Object)breakRule);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approvalRes});
                return;
            }
            if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
                approvalRes.set("realpass", (Object)"0");
                approvalRes.set("realpredictresult", (Object)("0".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                String withdrawalIds = map.getOrDefault("withdrawalids", " ");
                if (StringUtils.isBlank((CharSequence)withdrawalIds)) {
                    approvalRes.set("withdrawalpredictresult", (Object)"1");
                } else {
                    String withdrawalPredictRes = "0";
                    JSONArray array = JSON.parseArray((String)withdrawalIds);
                    for (Object id : array) {
                        if (!approvalRes.getString("withdrawal").contains("\"" + id + "\"")) continue;
                        withdrawalPredictRes = "1";
                        break;
                    }
                    TaskApproveSuccessHelper.putMulDynamicObject(approvalRes, "newrealwithdrawal", (Collection<Object>)array);
                    approvalRes.set("withdrawalpredictresult", (Object)withdrawalPredictRes);
                }
                if (withdrawalIds.length() > 1000) {
                    withdrawalIds = withdrawalIds.substring(0, 1000);
                    withdrawalIds = withdrawalIds.substring(0, withdrawalIds.lastIndexOf(44)) + ']';
                }
                approvalRes.set("realwithdrawal", (Object)withdrawalIds);
                String operation = map.getOrDefault("decisionitem", " ");
                approvalRes.set("realoperation", (Object)operation);
                if (StringUtils.isBlank((CharSequence)operation) || approvalRes.getString("operation").contains("\"" + operation + "\"")) {
                    approvalRes.set("operationpredictresult", (Object)"1");
                } else {
                    approvalRes.set("operationpredictresult", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approvalRes});
            }
        }
        catch (Exception e) {
            log.error("Error on saving approval info to t_tk_approval_result", (Throwable)e);
        }
    }

    private static void putMulDynamicObject(DynamicObject approvalRes, String property, Collection<Object> collection) {
        DynamicObjectCollection newrealwithdrawal = approvalRes.getDynamicObjectCollection(property);
        for (Object o : collection) {
            DynamicObject dynamicObject = newrealwithdrawal.addNew();
            dynamicObject.set("fbasedataid", approvalRes.get("id"));
            dynamicObject.set("fbasedataid_id", o);
        }
        approvalRes.set(property, (Object)newrealwithdrawal);
    }

    public static void updateTaskIdMap(Map<Long, List<Long>> taskIdMap, Long sscId, Long taskId) {
        if (taskIdMap == null || sscId == null || taskId == null) {
            log.error("updateTaskIdMap error, taskIdMap = {}, sscId = {}, taskId = {}", new Object[]{taskIdMap, sscId, taskId});
            return;
        }
        if (taskIdMap.containsKey(sscId)) {
            List<Long> taskIdList = taskIdMap.get(sscId);
            taskIdList.add(taskId);
        } else {
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            taskIdList.add(taskId);
            taskIdMap.put(sscId, taskIdList);
        }
    }

    public static void taskSyncDataByToHistory(Map<Long, List<Long>> taskIdMap, Map<Long, List<Long>> hisTaskIdMap) {
        Iterator<Map.Entry<Long, List<Long>>> iterator;
        if (taskIdMap.size() != 0 && (iterator = taskIdMap.entrySet().iterator()).hasNext()) {
            Map.Entry<Long, List<Long>> entry = iterator.next();
            Long sscId = entry.getKey();
            List<Long> taskIdList = entry.getValue();
            List<Long> hisTaskIList = hisTaskIdMap.get(sscId);
            if (CollectionUtils.isNotEmpty(taskIdList) && CollectionUtils.isNotEmpty(hisTaskIList) && taskIdList.size() == hisTaskIList.size()) {
                SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.DELETE, (Long)sscId, taskIdList);
                SscEventDistributor.taskSyncData((String)"task_taskhistory", (DataChangeTypeEnum)DataChangeTypeEnum.INSERT, (Long)sscId, hisTaskIList);
            } else {
                log.error("taskSyncDataByToHistory size error, sscId = {}, taskIdList = {}, hisTaskIList = {}", new Object[]{sscId, JSONObject.toJSONString(taskIdList), JSONObject.toJSONString(hisTaskIList)});
            }
        }
    }

    public static void taskSyncDataByDelete(Map<Long, List<Long>> taskIdMap) {
        Iterator<Map.Entry<Long, List<Long>>> iterator;
        if (taskIdMap.size() != 0 && (iterator = taskIdMap.entrySet().iterator()).hasNext()) {
            Map.Entry<Long, List<Long>> entry = iterator.next();
            Long sscId = entry.getKey();
            List<Long> taskIdList = entry.getValue();
            if (CollectionUtils.isNotEmpty(taskIdList)) {
                SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.DELETE, (Long)sscId, taskIdList);
            } else {
                log.error("taskSyncDataByDelete size error, sscId = {}, taskIdList = {}", (Object)sscId, (Object)JSONObject.toJSONString(taskIdList));
            }
        }
    }
}

