/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeOp;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;

public class WorkCalendarServiceHelper {
    private static final Log log = LogFactory.getLog(WorkCalendarServiceHelper.class);

    public static void updateUserWorkTime(Long sscid, Long userGroupId, Long userId, Date startDate, Date endDate, SscTimeOp timeOp, List<String> timeIntervals) {
        WorkCalendarServiceHelper.updateUserWorkTime(sscid, userGroupId, Collections.singletonList(userId), startDate, endDate, timeOp, timeIntervals);
    }

    public static void updateUserWorkTime(Long sscid, Long userGroupId, List<Long> userIds, Date startDate, Date endDate, SscTimeOp timeOp, List<String> timeIntervals) {
        if (!WorkCalendarServiceHelper.saveDb(sscid, userGroupId, userIds, startDate, endDate, timeOp, timeIntervals)) {
            return;
        }
        WorkCalendarServiceHelper.sendMq(sscid, userGroupId, userIds, startDate, endDate);
    }

    public static boolean saveDb(Long sscid, Long userGroupId, List<Long> userIds, Date startDate, Date endDate, SscTimeOp timeOp, List<String> timeIntervals) {
        if (CollectionUtils.isEmpty(timeIntervals)) {
            String timeIntervalJson = "";
            log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6e \u4e2d\u6b62: sscid = {}, userGroupId = {}, userIds = {}, startDate = {}, endDate = {}, timeOp = {}, timeIntervals = {}", new Object[]{sscid, userGroupId, userIds, startDate, endDate, timeOp, timeIntervalJson});
            return false;
        }
        String timeIntervalJson = JSONObject.toJSONString(timeIntervals);
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6estart: sscid = {}, userGroupId = {}, userIds = {}, startDate = {}, endDate = {}, timeOp = {}, timeIntervals = {}", new Object[]{sscid, userGroupId, userIds, startDate, endDate, timeOp, timeIntervalJson});
        DynamicObject[] workCalenObjs = WorkCalendarServiceHelper.loadWorkCalendarDynObjs(sscid, startDate, endDate);
        HashMap<Date, DynamicObject> sscDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, DynamicObject> groupDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, Map<Long, DynamicObject>> userDateEntries = new HashMap<Date, Map<Long, DynamicObject>>(8);
        WorkCalendarServiceHelper.groupByLevel(workCalenObjs, sscDateEntries, groupDateEntries, userDateEntries, sscid, userGroupId, userIds);
        if (sscDateEntries.isEmpty()) {
            log.info(String.format("sscDateEntries.size = %s, groupDateEntries.size = %s, userDateEntries.size = %s", sscDateEntries.size(), groupDateEntries.size(), userDateEntries.size()));
            return false;
        }
        for (DynamicObject workCalenObj : workCalenObjs) {
            DynamicObjectCollection dateEntries = workCalenObj.getDynamicObjectCollection("dateentry");
            int size = dateEntries.size();
            for (int i = 0; i < size; ++i) {
                Date day;
                DynamicObject dateEntry = (DynamicObject)dateEntries.get(i);
                if (!SscLevelType.SSCCENTER.getValue().equals(dateEntry.getString("level")) || (day = dateEntry.getDate("date")).before(startDate) || day.after(endDate)) continue;
                Map userDateEntryMap = (Map)userDateEntries.get(day);
                for (Long userId : userIds) {
                    if (userDateEntryMap == null || userDateEntryMap.get(userId) == null) {
                        if (SscTimeOp.CANCLELEAVE == timeOp || SscTimeOp.CANCLEOVERTIME == timeOp) {
                            log.info("\u65e5\u671f\uff1a" + day + "\uff0c\u8be5\u7528\u6237\u6ca1\u6709\u8bf7\u5047\u6216\u52a0\u73ed\u6570\u636e\uff0c\u6240\u4ee5\u65e0\u9700\u9500\u5047\u6216\u53d6\u6d88\u52a0\u73ed");
                            continue;
                        }
                        String dateType = dateEntry.getString("datetype");
                        if (groupDateEntries.get(day) != null) {
                            dateType = ((DynamicObject)groupDateEntries.get(day)).getString("datetype");
                        }
                        DynamicObject userDateEntry = WorkCalendarServiceHelper.addNewDateEntry(dateEntries, sscid, userGroupId, userId, dateType, day, timeOp.getTimeType(), timeIntervals);
                        userDateEntries.computeIfAbsent(day, v -> new HashMap(userIds.size())).put(userId, userDateEntry);
                        continue;
                    }
                    WorkCalendarServiceHelper.updateDateEntry((DynamicObject)userDateEntryMap.get(userId), timeOp, timeIntervals);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])workCalenObjs);
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6eend: workCalenObjs size() = {}", workCalenObjs == null ? null : Integer.valueOf(workCalenObjs.length));
        return true;
    }

    public static void sendMq(Long sscid, Long userGroupId, List<Long> userIds, Date startDate, Date endDate) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            pub.publish((Object)new WorkCalendarTaskMessage(String.valueOf(sscid), String.valueOf(userGroupId), userIds, startDate, endDate, "user"));
        }
    }

    private static DynamicObject[] loadWorkCalendarDynObjs(Long sscid, Date startDate, Date endDate) {
        QFilter[] filters = new QFilter[]{new QFilter("dateentry.ssc", "=", (Object)sscid), new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()), new QFilter("dateentry.date", ">=", (Object)startDate), new QFilter("dateentry.date", "<=", (Object)endDate)};
        List workCalendarIds = QueryServiceHelper.queryPrimaryKeys((String)"ssc_workcalendarsetting", (QFilter[])filters, null, (int)-1);
        return BusinessDataServiceHelper.load((Object[])workCalendarIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_workcalendarsetting"));
    }

    private static void groupByLevel(DynamicObject[] workCalenObjs, Map<Date, DynamicObject> sscDateEntries, Map<Date, DynamicObject> userGroupDateEntries, Map<Date, Map<Long, DynamicObject>> userDateEntries, Long sscid, Long userGroupId, List<Long> userIds) {
        for (DynamicObject workCalenObj : workCalenObjs) {
            DynamicObjectCollection dateEntries = workCalenObj.getDynamicObjectCollection("dateentry");
            for (DynamicObject dateEntry : dateEntries) {
                String level = dateEntry.getString("level");
                switch (SscLevelType.getSscLevelType((String)level)) {
                    case SSCCENTER: {
                        if (sscid.longValue() != dateEntry.getLong("ssc.id")) break;
                        sscDateEntries.put(dateEntry.getDate("date"), dateEntry);
                        break;
                    }
                    case GROUP: {
                        if (userGroupId.longValue() != dateEntry.getLong("usergroup.id")) break;
                        userGroupDateEntries.put(dateEntry.getDate("date"), dateEntry);
                        break;
                    }
                    case EMPLOYEE: {
                        Long userId = dateEntry.getLong("user.id");
                        if (userGroupId.longValue() != dateEntry.getLong("usergroup.id") || !userIds.contains(userId)) break;
                        userDateEntries.computeIfAbsent(dateEntry.getDate("date"), v -> new HashMap(userIds.size())).put(userId, dateEntry);
                        break;
                    }
                }
            }
        }
    }

    private static DynamicObject addNewDateEntry(DynamicObjectCollection dateEntries, Long sscid, Long userGroupId, Long userId, String dateType, Date day, String timeType, List<String> timeIntervals) {
        if (CollectionUtils.isEmpty(timeIntervals)) {
            return null;
        }
        DynamicObject newDateEntry = dateEntries.addNew();
        newDateEntry.set("ssc", (Object)sscid);
        newDateEntry.set("usergroup", (Object)userGroupId);
        newDateEntry.set("user", (Object)userId);
        newDateEntry.set("level", (Object)SscLevelType.EMPLOYEE.getValue());
        newDateEntry.set("date", (Object)day);
        newDateEntry.set("datetype", (Object)dateType);
        List<Integer> minutes = WorkCalendarServiceHelper.getMinutes(timeIntervals);
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = WorkCalendarServiceHelper.convertArray01(minutes);
        List<String> newTimeIntervals = WorkCalendarServiceHelper.buildNewTimeIntervals(array01, min);
        DynamicObjectCollection timeEnties = newDateEntry.getDynamicObjectCollection("timeentry");
        WorkCalendarServiceHelper.addNewTimeEntry(timeEnties, timeType, newTimeIntervals);
        return newDateEntry;
    }

    private static void addNewTimeEntry(DynamicObjectCollection timeEnties, String timeType, List<String> timeIntervals) {
        for (String timeInterval : timeIntervals) {
            DynamicObject newTimeEntry = timeEnties.addNew();
            newTimeEntry.set("timetype", (Object)timeType);
            String[] timeArr = timeInterval.split("-");
            newTimeEntry.set("begintimeam", (Object)timeArr[0]);
            newTimeEntry.set("endtimeam", (Object)timeArr[1]);
        }
    }

    private static void updateDateEntry(DynamicObject dateEntry, SscTimeOp timeOpType, List<String> timeIntervals) {
        if (CollectionUtils.isEmpty(timeIntervals)) {
            return;
        }
        DynamicObjectCollection timeEnties = dateEntry.getDynamicObjectCollection("timeentry");
        List<DynamicObject> oldData = timeEnties.stream().filter(p -> timeOpType.getTimeType().equals(p.getString("timetype"))).collect(Collectors.toList());
        List<Integer> minutes = WorkCalendarServiceHelper.getMinutes(oldData, timeOpType, timeIntervals);
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = WorkCalendarServiceHelper.convertArray01(minutes);
        List<String> newTimeIntervals = WorkCalendarServiceHelper.buildNewTimeIntervals(array01, min);
        timeEnties.removeAll(oldData);
        WorkCalendarServiceHelper.addNewTimeEntry(timeEnties, timeOpType.getTimeType(), newTimeIntervals);
    }

    private static List<Integer> getMinutes(List<String> timeIntervals) {
        ArrayList<Integer> minutes = new ArrayList<Integer>(timeIntervals.size() * 2);
        for (String timeInterval : timeIntervals) {
            String[] timeArr = timeInterval.split("-");
            String[] beginArr_ = timeArr[0].split(":");
            String[] endArr_ = timeArr[1].split(":");
            minutes.add(Integer.parseInt(beginArr_[0]) * 60 + Integer.parseInt(beginArr_[1]));
            minutes.add(Integer.parseInt(endArr_[0]) * 60 + Integer.parseInt(endArr_[1]));
        }
        return minutes;
    }

    private static List<Integer> getMinutes(List<DynamicObject> oldData, SscTimeOp timeOpType, List<String> timeIntervals) {
        ArrayList<Integer> minutes = new ArrayList<Integer>(oldData.size() * 2 + timeIntervals.size() * 2);
        for (DynamicObject data : oldData) {
            String[] beginArr = data.getString("begintimeam").split(":");
            String[] endArr = data.getString("endtimeam").split(":");
            minutes.add(Integer.parseInt(beginArr[0]) * 60 + Integer.parseInt(beginArr[1]));
            minutes.add(Integer.parseInt(endArr[0]) * 60 + Integer.parseInt(endArr[1]));
        }
        int sign = SscTimeOp.ASKFORLEAVE == timeOpType || SscTimeOp.OVERTIME == timeOpType ? 1 : -1;
        for (String timeInterval : timeIntervals) {
            String[] timeArr = timeInterval.split("-");
            String[] beginArr_ = timeArr[0].split(":");
            String[] endArr_ = timeArr[1].split(":");
            minutes.add((Integer.parseInt(beginArr_[0]) * 60 + Integer.parseInt(beginArr_[1])) * sign);
            minutes.add((Integer.parseInt(endArr_[0]) * 60 + Integer.parseInt(endArr_[1])) * sign);
        }
        return minutes;
    }

    private static int[] convertArray01(List<Integer> minutes) {
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int max = Math.abs(minutes.stream().max(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = new int[max - min + 1];
        int size = minutes.size();
        for (int i = 0; i < size; i += 2) {
            int begin = minutes.get(i);
            int end = minutes.get(i + 1);
            int flag = begin >= 0 && end >= 0 ? 1 : 0;
            Arrays.fill(array01, Math.abs(begin) - min, Math.abs(end) - min + 1, flag);
        }
        return array01;
    }

    private static List<String> buildNewTimeIntervals(int[] array01, int min) {
        ArrayList<String> newTimeIntervals = new ArrayList<String>(8);
        int fromIndex = -1;
        int toIndex = -1;
        int len = array01.length;
        for (int i = 0; i < len; ++i) {
            if (array01[i] < 1) {
                if (fromIndex <= -1 || toIndex <= -1) continue;
                String beginTime = SscWorkCalendarUtil.getTimeShow((fromIndex + min) * 60);
                String endTime = SscWorkCalendarUtil.getTimeShow((toIndex + min) * 60);
                newTimeIntervals.add(beginTime + '-' + endTime);
                fromIndex = -1;
                toIndex = -1;
                continue;
            }
            if (fromIndex < 0) {
                fromIndex = i;
                toIndex = i;
                continue;
            }
            toIndex = i;
        }
        if (fromIndex > -1 && toIndex > -1) {
            String beginTime = SscWorkCalendarUtil.getTimeShow((fromIndex + min) * 60);
            String endTime = SscWorkCalendarUtil.getTimeShow((toIndex + min) * 60);
            newTimeIntervals.add(beginTime + '-' + endTime);
        }
        return newTimeIntervals;
    }

    public static List<Long> queryUserGroupIdByUseId(String userId, String sscId, String userGroupId) {
        QFilter userFilter;
        QFilter enableFilter;
        String selectFields = "id";
        QFilter idFilter = new QFilter("id", "!=", (Object)Long.parseLong(userGroupId));
        QFilter sscIdFilter = new QFilter("orgfield", "=", (Object)Long.parseLong(sscId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{sscIdFilter, enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')), userFilter = new QFilter("entryentity.userfield", "=", (Object)Long.parseLong(userId)), idFilter});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return new ArrayList<Long>();
        }
        return dynamicObjects.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }

    public static Map<Long, List<Long>> batchQueryUserGroupIdByUseId(List<Long> userIds, Long sscId) {
        QFilter userFilter;
        String selectFields = "entryentity.userfield,id";
        QFilter sscIdFilter = new QFilter("orgfield", "=", (Object)sscId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{sscIdFilter, enableFilter, userFilter = new QFilter("entryentity.userfield", "in", userIds)});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return new HashMap<Long, List<Long>>();
        }
        HashMap<Long, List<Long>> userIdMap = new HashMap<Long, List<Long>>();
        for (DynamicObject dynObj : dynamicObjects) {
            long userId = dynObj.getLong("entryentity.userfield");
            long userGroupId = dynObj.getLong("id");
            userIdMap.computeIfAbsent(userId, p -> new ArrayList(8)).add(userGroupId);
        }
        return userIdMap;
    }

    public static Map<Long, DynamicObject> batchQueryUserGroupInfoByGroupId(List<Long> userGroupIds) {
        DynamicObject[] userGroupDyns = BusinessDataServiceHelper.load((Object[])userGroupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_usergroup"));
        HashMap<Long, DynamicObject> userGroupMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject dynObj : userGroupDyns) {
            long userGroupId = dynObj.getLong("id");
            userGroupMap.put(userGroupId, dynObj);
        }
        return userGroupMap;
    }

    public static void askForLeaveAndCancel(Long sscid, Long userGroupId, List<Long> userIds, Date startDate, String startTime, Date endDate, String endTime, SscTimeOp timeOp) {
        if (!WorkCalendarServiceHelper.saveDb4AskForLeaveAndCancel(sscid, userGroupId, userIds, startDate, startTime, endDate, endTime, timeOp)) {
            return;
        }
        WorkCalendarServiceHelper.sendMq(sscid, userGroupId, userIds, startDate, endDate);
    }

    public static boolean saveDb4AskForLeaveAndCancel(Long sscid, Long userGroupId, List<Long> userIds, Date startDate, String startTime, Date endDate, String endTime, SscTimeOp timeOp) {
        Date endDate_;
        Date startDate_;
        if (SscTimeOp.ASKFORLEAVE != timeOp && SscTimeOp.CANCLELEAVE != timeOp) {
            log.warn("saveDb4AskForLeaveAndCancel()#1. not support SscTimeOp = " + timeOp);
            return false;
        }
        try {
            startDate_ = DateUtil.getCurDateForm((Date)startDate, (boolean)true);
            endDate_ = DateUtil.getCurDateForm((Date)endDate, (boolean)false);
        }
        catch (ParseException e) {
            log.error("saveDb4AskForLeaveAndCancel()#2 convert date occured exception.", (Throwable)e);
            return false;
        }
        if (StringUtils.isEmpty((String)startTime) || StringUtils.isEmpty((String)endTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            startTime = sdf.format(startDate);
            endTime = sdf.format(endDate);
        }
        DynamicObject[] workCalenObjs = WorkCalendarServiceHelper.loadWorkCalendarDynObjs(sscid, startDate_, endDate_);
        HashMap<Date, DynamicObject> sscDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, DynamicObject> groupDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, Map<Long, DynamicObject>> userDateEntries = new HashMap<Date, Map<Long, DynamicObject>>(8);
        WorkCalendarServiceHelper.groupByLevel(workCalenObjs, sscDateEntries, groupDateEntries, userDateEntries, sscid, userGroupId, userIds);
        if (sscDateEntries.isEmpty()) {
            log.info(String.format("saveDb4AskForLeaveAndCancel()#sscDateEntries.size = %s, groupDateEntries.size = %s, userDateEntries.size = %s", sscDateEntries.size(), groupDateEntries.size(), userDateEntries.size()));
            return true;
        }
        for (DynamicObject workCalenObj : workCalenObjs) {
            DynamicObjectCollection dateEntries = workCalenObj.getDynamicObjectCollection("dateentry");
            int size = dateEntries.size();
            for (int i = 0; i < size; ++i) {
                Date day;
                DynamicObject dateEntry = (DynamicObject)dateEntries.get(i);
                if (!SscLevelType.SSCCENTER.getValue().equals(dateEntry.getString("level")) || (day = dateEntry.getDate("date")).before(startDate) || day.after(endDate)) continue;
                DynamicObject groupDateEntry = (DynamicObject)groupDateEntries.get(day);
                Map userDateEntryMap = (Map)userDateEntries.get(day);
                List<String> timeIntervals = WorkCalendarServiceHelper.getTimeIntervals(startDate, startTime, endDate, endTime, day, dateEntry, groupDateEntry, timeOp);
                if (CollectionUtils.isEmpty(timeIntervals = timeIntervals.stream().filter(p -> !"-".equals(p.trim())).collect(Collectors.toList()))) continue;
                for (Long userId : userIds) {
                    if (userDateEntryMap == null || userDateEntryMap.get(userId) == null) {
                        if (SscTimeOp.CANCLELEAVE == timeOp) {
                            log.info("\u65e5\u671f\uff1a" + day + "\uff0c\u8be5\u7528\u6237\u6ca1\u6709\u8bf7\u5047\uff0c\u6240\u4ee5\u65e0\u9700\u9500\u5047");
                            continue;
                        }
                        String dateType = dateEntry.getString("datetype");
                        if (groupDateEntry != null) {
                            dateType = groupDateEntry.getString("datetype");
                        }
                        DynamicObject userDateEntry = WorkCalendarServiceHelper.addNewDateEntry(dateEntries, sscid, userGroupId, userId, dateType, day, timeOp.getTimeType(), timeIntervals);
                        userDateEntries.computeIfAbsent(day, v -> new HashMap(userIds.size())).put(userId, userDateEntry);
                        continue;
                    }
                    WorkCalendarServiceHelper.updateDateEntry((DynamicObject)userDateEntryMap.get(userId), timeOp, timeIntervals);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])workCalenObjs);
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6eend saveDb4AskForLeaveAndCancel()#: workCalenObjs size() = {}", workCalenObjs == null ? null : Integer.valueOf(workCalenObjs.length));
        return true;
    }

    private static List<String> getTimeIntervals(Date startDate, String startTime, Date endDate, String endTime, Date curDate, DynamicObject sscDateEntry, DynamicObject groupDateEntry, SscTimeOp timeOp) {
        int endtimepm_;
        ArrayList<String> timeIntervals = new ArrayList<String>(4);
        long d1 = DateUtil.diffDay((Date)startDate, (Date)curDate);
        long d2 = DateUtil.diffDay((Date)curDate, (Date)endDate);
        if (SscTimeOp.CANCLELEAVE == timeOp) {
            if (d1 == 0L && d2 == 0L) {
                timeIntervals.add(startTime + "-" + endTime);
            } else if (d1 == 0L && d2 > 0L) {
                timeIntervals.add(startTime + "-23:59");
            } else if (d1 > 0L && d2 > 0L) {
                timeIntervals.add("00:00-23:59");
            } else if (d1 > 0L && d2 == 0L) {
                timeIntervals.add("00:00-" + endTime);
            }
            return timeIntervals;
        }
        DynamicObjectCollection sscTimeEnties = sscDateEntry.getDynamicObjectCollection("timeentry");
        DynamicObject timeEntry = (DynamicObject)sscTimeEnties.get(0);
        if (groupDateEntry != null) {
            DynamicObjectCollection gourpTimeEnties = groupDateEntry.getDynamicObjectCollection("timeentry");
            timeEntry = (DynamicObject)gourpTimeEnties.get(0);
        }
        timeEntry.getString("begintimeam");
        String begtimeam = timeEntry.getString("begintimeam");
        String endtimeam = timeEntry.getString("endtimeam");
        String begtimepm = timeEntry.getString("begintimepm");
        String endtimepm = timeEntry.getString("endtimepm");
        int begtimeam_ = StringUtils.isEmpty((String)begtimeam) ? -1 : Integer.parseInt(begtimeam.replace(":", ""));
        int endtimeam_ = StringUtils.isEmpty((String)endtimeam) ? -1 : Integer.parseInt(endtimeam.replace(":", ""));
        int begtimepm_ = StringUtils.isEmpty((String)begtimepm) ? -1 : Integer.parseInt(begtimepm.replace(":", ""));
        int n = endtimepm_ = StringUtils.isEmpty((String)endtimepm) ? -1 : Integer.parseInt(endtimepm.replace(":", ""));
        if (begtimeam_ > endtimeam_ || begtimepm_ > endtimepm_ || begtimepm_ != -1 && endtimeam_ > begtimepm_) {
            log.error("getTimeIntervals()#1 data error. begtimeam_ = {}, endtimeam_ = {}, begtimepm_ = {}, endtimepm = {}", new Object[]{begtimeam_, endtimeam_, begtimeam_, endtimepm_});
            return timeIntervals;
        }
        int startTime_ = Integer.parseInt(startTime.replace(":", ""));
        int endTime_ = Integer.parseInt(endTime.replace(":", ""));
        if (d1 == 0L && d2 == 0L) {
            if (startTime_ <= begtimeam_) {
                if (endTime_ >= endtimepm_) {
                    timeIntervals.add(begtimeam + "-" + endtimeam);
                    timeIntervals.add(begtimepm + "-" + endtimepm);
                    return timeIntervals;
                }
                if (endTime_ > begtimepm_ && endTime_ < endtimepm_) {
                    timeIntervals.add(begtimeam + "-" + endtimeam);
                    timeIntervals.add(begtimepm + "-" + endTime);
                    return timeIntervals;
                }
                if (endTime_ >= endtimeam_ && endTime_ < begtimepm_) {
                    timeIntervals.add(begtimeam + "-" + endtimeam);
                    return timeIntervals;
                }
                if (endTime_ > begtimeam_ && endTime_ < endtimeam_) {
                    timeIntervals.add(begtimeam + "-" + endTime);
                    return timeIntervals;
                }
                return timeIntervals;
            }
            if (startTime_ > begtimeam_ && startTime_ < endtimeam_) {
                if (endTime_ >= endtimepm_) {
                    timeIntervals.add(startTime + "-" + endtimeam);
                    timeIntervals.add(begtimepm + "-" + endtimepm);
                    return timeIntervals;
                }
                if (endTime_ > begtimepm_ && endTime_ < endtimepm_) {
                    timeIntervals.add(startTime + "-" + endtimeam);
                    timeIntervals.add(begtimepm + "-" + endTime);
                    return timeIntervals;
                }
                if (endTime_ >= endtimeam_ && endTime_ < begtimepm_) {
                    timeIntervals.add(startTime + "-" + endtimeam);
                    return timeIntervals;
                }
                if (endTime_ > startTime_ && endTime_ < endtimeam_) {
                    timeIntervals.add(startTime + "-" + endTime_);
                    return timeIntervals;
                }
                return timeIntervals;
            }
            if (startTime_ >= endtimeam_ && startTime_ < begtimepm_) {
                if (endTime_ >= endtimepm_) {
                    timeIntervals.add(begtimepm + "-" + endtimepm);
                    return timeIntervals;
                }
                if (endTime_ > begtimepm_ && endTime_ < endtimepm_) {
                    timeIntervals.add(begtimepm + "-" + endTime);
                    return timeIntervals;
                }
                return timeIntervals;
            }
            if (startTime_ >= begtimepm_ && startTime_ < endtimepm_) {
                if (endTime_ >= endtimepm_) {
                    timeIntervals.add(startTime + "-" + endtimepm);
                    return timeIntervals;
                }
                if (endTime_ > startTime_ && endTime_ < endtimepm_) {
                    timeIntervals.add(startTime + "-" + endTime);
                    return timeIntervals;
                }
                return timeIntervals;
            }
        } else if (d1 == 0L && d2 > 0L) {
            if (startTime_ <= begtimeam_) {
                timeIntervals.add(begtimeam + "-" + endtimeam);
                timeIntervals.add(begtimepm + "-" + endtimepm);
                return timeIntervals;
            }
            if (startTime_ > begtimeam_ && startTime_ < endtimeam_) {
                timeIntervals.add(startTime + "-" + endtimeam);
                timeIntervals.add(begtimepm + "-" + endtimepm);
                return timeIntervals;
            }
            if (startTime_ >= endtimeam_ && startTime_ < begtimepm_) {
                timeIntervals.add(begtimepm + "-" + endtimepm);
                return timeIntervals;
            }
            if (startTime_ >= begtimepm_ && startTime_ < endtimepm_) {
                timeIntervals.add(startTime + "-" + endtimepm);
                return timeIntervals;
            }
        } else {
            if (d1 > 0L && d2 > 0L) {
                timeIntervals.add(begtimeam + "-" + endtimeam);
                timeIntervals.add(begtimepm + "-" + endtimepm);
                return timeIntervals;
            }
            if (d1 > 0L && d2 == 0L) {
                if (endTime_ <= begtimeam_) {
                    return timeIntervals;
                }
                if (endTime_ > begtimeam_ && endTime_ < endtimeam_) {
                    timeIntervals.add(begtimeam + "-" + endTime);
                    return timeIntervals;
                }
                if (endTime_ >= endtimeam_ && endTime_ < begtimepm_) {
                    timeIntervals.add(begtimeam + "-" + endtimeam);
                    return timeIntervals;
                }
                if (endTime_ >= begtimepm_ && endTime_ <= endtimepm_) {
                    timeIntervals.add(begtimeam + "-" + endtimeam);
                    timeIntervals.add(begtimepm + "-" + endTime);
                    return timeIntervals;
                }
            }
        }
        return timeIntervals;
    }
}

