/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.formplugin.pojo.workcalendar.DailyWorkPeriod;
import kd.ssc.task.formplugin.pojo.workcalendar.UserWorkInfo;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.DateUtil;

public class WorkCalendarTaskUtil {
    private static final Log logger = LogFactory.getLog(WorkCalendarTaskUtil.class);

    public static void saveUserDailyWorkPeriod(WorkCalendarTaskMessage message) {
        WorkCalendarTaskUtil.saveUserDailyWorkPeriod2(message);
    }

    public static void saveUserDailyWorkPeriod2(WorkCalendarTaskMessage message) {
        DynamicObjectCollection userDatas;
        DynamicObjectCollection groupData;
        Map<String, UserWorkInfo[]> userWorkPeriods;
        String ssc = message.getSscId();
        String groupId = message.getUserGroupId();
        List<Long> userIds = message.getUserIds();
        Object startDate = message.getStartDate();
        Object endDate = message.getEndDate();
        if (startDate == null) {
            Date now = new Date();
            startDate = new Date(now.getYear(), now.getMonth(), now.getDate());
        }
        if (endDate == null) {
            DynamicObjectCollection sscWorkCalenderDates = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.id,dateentry.date", (QFilter[])new QFilter[]{new QFilter("ssccenter", "=", (Object)Long.parseLong(ssc)), QFilter.isNotNull((String)"dateentry.date")}, (String)"dateentry.date desc", (int)1);
            endDate = sscWorkCalenderDates.size() > 0 ? ((DynamicObject)sscWorkCalenderDates.get(0)).getDate("dateentry.date") : startDate;
        }
        boolean isLog = WorkCalendarTaskUtil.isPrintLog();
        Map<String, Object> dates = WorkCalendarTaskUtil.getStartAndEndDate(startDate, endDate);
        if (isLog) {
            logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u540c\u6b65\u65f6\u95f4\u8303\u56f4\uff1a" + SerializationUtils.toJsonString(dates));
        }
        if ((userWorkPeriods = WorkCalendarTaskUtil.getUserWorkPeriods(ssc, groupId, userIds, startDate = dates.get("startDate"), endDate = dates.get("endDate"))).isEmpty()) {
            if (isLog) {
                logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65e5\u6570\u7ec4\u521d\u59cb\u5316\u4e3a\u7a7a");
            }
            return;
        }
        DynamicObjectCollection sscData = WorkCalendarTaskUtil.getData(ssc, null, new ArrayList(), startDate, endDate);
        if (sscData.isEmpty()) {
            QFilter qFilter = new QFilter("sscid", "=", (Object)Long.parseLong(ssc)).and(new QFilter("usergroup", "=", (Object)Long.parseLong(groupId))).and(new QFilter("user", "in", userIds)).and(new QFilter("monthofyear", "in", WorkCalendarTaskUtil.getMonthOfYear(startDate, endDate)));
            DeleteServiceHelper.delete((String)"ssc_userworkperiod", (QFilter[])new QFilter[]{qFilter});
            if (isLog) {
                logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u5171\u4eab\u4e2d\u5fc3\u65e0\u5de5\u4f5c\u65e5\u5386\u6570\u636e\uff1a" + ssc);
            }
            return;
        }
        if (isLog) {
            logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\uff1a" + SerializationUtils.toJsonString((Object)sscData));
        }
        WorkCalendarTaskUtil.getSscData(sscData, userWorkPeriods);
        if (isLog) {
            logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65e5\u6570\u7ec4ssc\uff1a" + SerializationUtils.toJsonString(userWorkPeriods));
        }
        if (!(groupData = WorkCalendarTaskUtil.getData(ssc, groupId, new ArrayList(), startDate, endDate)).isEmpty()) {
            WorkCalendarTaskUtil.getGroupData(groupData, userWorkPeriods);
            if (isLog) {
                logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65e5\u6570\u7ec4group\uff1a" + SerializationUtils.toJsonString(userWorkPeriods));
            }
        }
        if (!(userDatas = WorkCalendarTaskUtil.getData(ssc, groupId, userIds, startDate, endDate)).isEmpty()) {
            WorkCalendarTaskUtil.getUserData(userDatas, userWorkPeriods);
            if (isLog) {
                logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65e5\u6570\u7ec4user\uff1a" + SerializationUtils.toJsonString(userWorkPeriods));
            }
        }
        ArrayList<DynamicObject> userWorkPeriodList = new ArrayList<DynamicObject>(10);
        ArrayList<String> monthOfYearOfGroup = new ArrayList<String>(10);
        ArrayList<String> monthOfYearOfSsc = new ArrayList<String>(10);
        for (Map.Entry<String, UserWorkInfo[]> userWorkInfo : userWorkPeriods.entrySet()) {
            String[] key = userWorkInfo.getKey().split("-");
            UserWorkInfo[] userWorkDailyInfos = userWorkInfo.getValue();
            String sscId = key[0];
            String group = key[1];
            String userId = key[2];
            String monthOfYear = key[3];
            Map<String, List<DailyWorkPeriod>> dailyWorkPeriods = WorkCalendarTaskUtil.getPeriodOfDay(userWorkDailyInfos);
            List<DailyWorkPeriod> sscDailyWorkPeriods = dailyWorkPeriods.get("ssc");
            List<DailyWorkPeriod> userGroupDailyWorkPeriods = dailyWorkPeriods.get("userGroup");
            List<DailyWorkPeriod> userDailyWorkPeriods = dailyWorkPeriods.get("user");
            if (!monthOfYearOfSsc.contains(monthOfYear) && sscDailyWorkPeriods.size() > 0 && message.getType().equals("ssc")) {
                DynamicObject sscWorkPeriod = BusinessDataServiceHelper.newDynamicObject((String)"ssc_userworkperiod");
                sscWorkPeriod.set("sscid", (Object)sscId);
                sscWorkPeriod.set("monthofyear", (Object)monthOfYear);
                sscWorkPeriod.set("monthlyworkperiod_tag", (Object)JSONObject.toJSONString(sscDailyWorkPeriods));
                userWorkPeriodList.add(sscWorkPeriod);
                monthOfYearOfSsc.add(monthOfYear);
            }
            if (!monthOfYearOfGroup.contains(monthOfYear) && userGroupDailyWorkPeriods.size() > 0 && (message.getType().equals("ssc") || message.getType().equals("usergroup"))) {
                DynamicObject userGroupWorkPeriod = BusinessDataServiceHelper.newDynamicObject((String)"ssc_userworkperiod");
                userGroupWorkPeriod.set("sscid", (Object)sscId);
                userGroupWorkPeriod.set("usergroup", (Object)group);
                userGroupWorkPeriod.set("monthofyear", (Object)monthOfYear);
                userGroupWorkPeriod.set("monthlyworkperiod_tag", (Object)JSONObject.toJSONString(userGroupDailyWorkPeriods));
                userWorkPeriodList.add(userGroupWorkPeriod);
                monthOfYearOfGroup.add(monthOfYear);
            }
            if (userDailyWorkPeriods.size() <= 0) continue;
            DynamicObject userWorkPeriod = BusinessDataServiceHelper.newDynamicObject((String)"ssc_userworkperiod");
            userWorkPeriod.set("sscid", (Object)sscId);
            userWorkPeriod.set("usergroup", (Object)group);
            userWorkPeriod.set("user", (Object)userId);
            userWorkPeriod.set("monthofyear", (Object)monthOfYear);
            userWorkPeriod.set("monthlyworkperiod_tag", (Object)JSONObject.toJSONString(userDailyWorkPeriods));
            userWorkPeriodList.add(userWorkPeriod);
        }
        QFilter userFilter = new QFilter("user", "in", userIds);
        QFilter userGroupFilter = new QFilter("usergroup", "=", (Object)Long.parseLong(groupId));
        if (message.getType().equals("ssc")) {
            userGroupFilter.or(new QFilter("usergroup", "=", (Object)0));
        }
        if (message.getType().equals("ssc") || message.getType().equals("usergroup")) {
            userFilter.or(new QFilter("user", "=", (Object)0));
        }
        QFilter qFilter = new QFilter("sscid", "=", (Object)Long.parseLong(ssc)).and(userGroupFilter).and(userFilter).and(new QFilter("monthofyear", "in", WorkCalendarTaskUtil.getMonthOfYear(startDate, endDate)));
        if (isLog) {
            logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u5220\u9664\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65f6\u6bb5\u6570\u7ec4\uff1a" + SerializationUtils.toJsonString((Object)qFilter));
        }
        DeleteServiceHelper.delete((String)"ssc_userworkperiod", (QFilter[])new QFilter[]{qFilter});
        if (isLog) {
            logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u4fdd\u5b58\u81ea\u7136\u6708\u7684\u5de5\u4f5c\u65f6\u6bb5\u6570\u7ec4\uff1a" + SerializationUtils.toJsonString(userWorkPeriodList));
        }
        if (userWorkPeriodList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])userWorkPeriodList.toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, List<DailyWorkPeriod>> getPeriodOfDay(UserWorkInfo[] userWorkDailyInfos) {
        HashMap<String, List<DailyWorkPeriod>> dailyWorkPeriodsMap = new HashMap<String, List<DailyWorkPeriod>>(16);
        dailyWorkPeriodsMap.put("ssc", new ArrayList(10));
        dailyWorkPeriodsMap.put("userGroup", new ArrayList(10));
        dailyWorkPeriodsMap.put("user", new ArrayList(10));
        boolean isPrintLog = WorkCalendarTaskUtil.isPrintLog();
        for (int day = 0; day < userWorkDailyInfos.length; ++day) {
            UserWorkInfo data = userWorkDailyInfos[day];
            if (data == null) continue;
            List<String> groupData = data.getWorkPeriod();
            List<String> userData = data.getUserData();
            List<String> sscData = data.getSscData();
            if (sscData.isEmpty() && groupData.isEmpty() && userData.isEmpty()) {
                if (!isPrintLog) continue;
                logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u540c\u6b65\uff1a\u8fd9\u5929\u4f11\u606f\u65e0\u5de5\u4f5c\u65e5\u5386\uff1a" + day);
                continue;
            }
            WorkCalendarTaskUtil.setSscOrGroupWorkPeriodData(sscData, day, dailyWorkPeriodsMap, "ssc");
            WorkCalendarTaskUtil.setSscOrGroupWorkPeriodData(groupData, day, dailyWorkPeriodsMap, "userGroup");
            int timeMin = data.getTimeMin();
            int timeMax = data.getTimeMax();
            int minToMax = WorkCalendarTaskUtil.getMinutes(timeMin + "", timeMax + "") + 1;
            if (minToMax < 1) continue;
            int[] timeArray = new int[minToMax];
            for (String time : groupData) {
                if (StringUtils.isBlank((CharSequence)time)) continue;
                String beginTime = time.split("-")[0];
                String endTime = time.split("-")[1];
                int beginIndex = WorkCalendarTaskUtil.getMinutes(timeMin + "", beginTime);
                int endIndex = WorkCalendarTaskUtil.getMinutes(timeMin + "", endTime);
                Arrays.fill(timeArray, beginIndex, endIndex, 1);
            }
            for (String timeData : userData) {
                if (StringUtils.isBlank((CharSequence)timeData)) continue;
                String[] timeDataArray = timeData.split(":");
                String timeType = timeDataArray[0];
                String beginTime = timeDataArray[1].split("-")[0];
                String endTime = timeDataArray[1].split("-")[1];
                int beginIndex = WorkCalendarTaskUtil.getMinutes(timeMin + "", beginTime);
                int endIndex = WorkCalendarTaskUtil.getMinutes(timeMin + "", endTime);
                if (timeType.equals(SscTimeType.OFFTIME.getValue())) {
                    Arrays.fill(timeArray, beginIndex, endIndex, 0);
                    continue;
                }
                if (!timeType.equals(SscTimeType.OVERTIME.getValue())) continue;
                Arrays.fill(timeArray, beginIndex, endIndex, 1);
            }
            List<Map<String, Integer>> periodsOfDay = WorkCalendarTaskUtil.getPeriodsOfDay(timeMin, timeArray);
            if (periodsOfDay.size() <= 0) continue;
            ((List)dailyWorkPeriodsMap.get("user")).add(new DailyWorkPeriod(day + 1, periodsOfDay));
        }
        return dailyWorkPeriodsMap;
    }

    private static void setSscOrGroupWorkPeriodData(List<String> data, int day, Map<String, List<DailyWorkPeriod>> dailyWorkPeriodsMap, String type) {
        ArrayList<Map<String, Integer>> periodsOfDay = new ArrayList<Map<String, Integer>>(10);
        for (String time : data) {
            if (StringUtils.isBlank((CharSequence)time)) continue;
            HashMap<String, Integer> period = new HashMap<String, Integer>(2);
            int beginTime = Integer.parseInt(time.split("-")[0]);
            int endTime = Integer.parseInt(time.split("-")[1]);
            period.put("start", beginTime);
            period.put("end", endTime);
            periodsOfDay.add(period);
        }
        if (periodsOfDay.size() > 0) {
            dailyWorkPeriodsMap.get(type).add(new DailyWorkPeriod(day + 1, periodsOfDay));
        }
    }

    private static List<Map<String, Integer>> getPeriodsOfDay(int timeMin, int[] timeArray) {
        String timeString = Arrays.toString(timeArray).trim().replaceAll("\\[|\\]|\\, ", "");
        int index = timeString.indexOf(49);
        ArrayList<Map<String, Integer>> periodsOfDay = new ArrayList<Map<String, Integer>>(10);
        while (index != -1) {
            HashMap<String, Integer> period = new HashMap<String, Integer>(2);
            period.put("start", WorkCalendarTaskUtil.getTimes(timeMin + "", index, "up"));
            int endIndex = timeString.indexOf(48, index);
            if (endIndex == -1) {
                index = endIndex;
                endIndex = timeString.length() - 1;
            } else {
                index = timeString.indexOf(49, endIndex);
            }
            period.put("end", WorkCalendarTaskUtil.getTimes(timeMin + "", endIndex, "up"));
            periodsOfDay.add(period);
        }
        return periodsOfDay;
    }

    private static void getUserData(DynamicObjectCollection userData, Map<String, UserWorkInfo[]> userWorkPeriods) {
        StringBuilder sBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        for (DynamicObject dym : userData) {
            calendar.setTime(dym.getDate("dateentry.date"));
            String monthOfYear = DateUtil.format(calendar.getTime(), "yyyyMM");
            Object timeType = dym.get("dateentry.timeentry.timetype");
            Object begintimeamObj = dym.get("dateentry.timeentry.begintimeam");
            Object endtimeamObj = dym.get("dateentry.timeentry.endtimeam");
            if (StringUtils.isBlank((Object)timeType) || StringUtils.isBlank((Object)begintimeamObj) || StringUtils.isBlank((Object)endtimeamObj)) continue;
            int day = calendar.get(5);
            String ssc = dym.getString("dateentry.ssc");
            String groupId = dym.getString("dateentry.usergroup");
            String userId = dym.getString("dateentry.user");
            sBuilder.append(ssc).append('-').append(groupId).append('-').append(userId).append('-').append(monthOfYear);
            UserWorkInfo[] userWorkInfos = userWorkPeriods.get(sBuilder.toString());
            sBuilder.setLength(0);
            int begintimeam = Integer.parseInt((begintimeamObj + "").replace(":", ""));
            int endtimeam = Integer.parseInt((endtimeamObj + "").replace(":", ""));
            UserWorkInfo userWorkInfo = userWorkInfos[day - 1];
            if (userWorkInfo.getTimeMin() > begintimeam) {
                userWorkInfo.setTimeMin(begintimeam);
            }
            if (userWorkInfo.getTimeMax() < endtimeam) {
                userWorkInfo.setTimeMax(endtimeam);
            }
            sBuilder.append(timeType).append(':').append(begintimeam).append('-').append(endtimeam);
            userWorkInfo.getUserData().add(sBuilder.toString());
            sBuilder.setLength(0);
        }
    }

    private static void getGroupData(DynamicObjectCollection groupData, Map<String, UserWorkInfo[]> userWorkPeriods) {
        Calendar calendar = Calendar.getInstance();
        if (!groupData.isEmpty()) {
            for (Map.Entry<String, UserWorkInfo[]> info : userWorkPeriods.entrySet()) {
                String sscid = info.getKey().split("-")[0];
                String groupid = info.getKey().split("-")[1];
                String monthofyear = info.getKey().split("-")[3];
                for (DynamicObject dym : groupData) {
                    UserWorkInfo workInfo;
                    calendar.setTime(dym.getDate("dateentry.date"));
                    String dateType = dym.getString("dateentry.datetype");
                    switch (SscDateType.getSscDateType((String)dateType)) {
                        case RESTDATE: 
                        case HOLIDAY: {
                            dym.set("dateentry.timeentry.begintimepm", (Object)"");
                            dym.set("dateentry.timeentry.endtimepm", (Object)"");
                            dym.set("dateentry.timeentry.begintimeam", (Object)"");
                            dym.set("dateentry.timeentry.endtimeam", (Object)"");
                            break;
                        }
                        case HALFWORKDATEAM: {
                            dym.set("dateentry.timeentry.begintimepm", (Object)"");
                            dym.set("dateentry.timeentry.endtimepm", (Object)"");
                            break;
                        }
                        case HALFWORKDATEPM: {
                            dym.set("dateentry.timeentry.begintimeam", (Object)"");
                            dym.set("dateentry.timeentry.endtimeam", (Object)"");
                        }
                    }
                    int day = calendar.get(5);
                    String monthOfYear = DateUtil.format(calendar.getTime(), "yyyyMM");
                    String ssc = dym.getString("dateentry.ssc");
                    String groupId = dym.getString("dateentry.usergroup");
                    if (!ssc.equals(sscid) || !groupId.equals(groupid) || !monthofyear.equals(monthOfYear) || (workInfo = info.getValue()[day - 1]) == null) continue;
                    workInfo.setWorkPeriod(WorkCalendarTaskUtil.getDayInfo(dym, "group", workInfo).getWorkPeriod());
                }
            }
        }
    }

    private static UserWorkInfo getDayInfo(DynamicObject dym, String type, UserWorkInfo info) {
        StringBuilder sBuilder = new StringBuilder();
        String begintimepm = dym.getString("dateentry.timeentry.begintimepm").replace(":", "");
        String endtimepm = dym.getString("dateentry.timeentry.endtimepm").replace(":", "");
        String begintimeam = dym.getString("dateentry.timeentry.begintimeam").replace(":", "");
        String endtimeam = dym.getString("dateentry.timeentry.endtimeam").replace(":", "");
        if (info == null) {
            info = new UserWorkInfo();
        }
        if (type.equals("group")) {
            info.getWorkPeriod().clear();
        }
        if (StringUtils.isNotBlank((CharSequence)begintimeam)) {
            info.setTimeMax(Integer.parseInt(endtimeam));
            info.setTimeMin(Integer.parseInt(begintimeam));
            sBuilder.append(begintimeam).append('-').append(endtimeam);
            if (type.equals("ssc")) {
                info.getSscData().add(sBuilder.toString());
                info.getWorkPeriod().add(sBuilder.toString());
            } else {
                info.getWorkPeriod().add(sBuilder.toString());
            }
            sBuilder.setLength(0);
        }
        if (StringUtils.isNotBlank((CharSequence)begintimepm)) {
            sBuilder.append(begintimepm).append('-').append(endtimepm);
            info.setTimeMax(Integer.parseInt(endtimepm));
            if (StringUtils.isBlank((CharSequence)begintimeam)) {
                info.setTimeMin(Integer.parseInt(begintimepm));
            }
            if (type.equals("ssc")) {
                info.getSscData().add(sBuilder.toString());
                info.getWorkPeriod().add(sBuilder.toString());
            } else {
                info.getWorkPeriod().add(sBuilder.toString());
            }
            sBuilder.setLength(0);
        }
        return info;
    }

    private static void getSscData(DynamicObjectCollection sscData, Map<String, UserWorkInfo[]> userWorkPeriods) {
        Calendar calendar = Calendar.getInstance();
        for (Map.Entry<String, UserWorkInfo[]> info : userWorkPeriods.entrySet()) {
            String monthofyear = info.getKey().split("-")[3];
            for (DynamicObject dym : sscData) {
                String dateType = dym.getString("dateentry.datetype");
                switch (SscDateType.getSscDateType((String)dateType)) {
                    case RESTDATE: 
                    case HOLIDAY: {
                        dym.set("dateentry.timeentry.begintimepm", (Object)"");
                        dym.set("dateentry.timeentry.endtimepm", (Object)"");
                        dym.set("dateentry.timeentry.begintimeam", (Object)"");
                        dym.set("dateentry.timeentry.endtimeam", (Object)"");
                        break;
                    }
                    case HALFWORKDATEAM: {
                        dym.set("dateentry.timeentry.begintimepm", (Object)"");
                        dym.set("dateentry.timeentry.endtimepm", (Object)"");
                        break;
                    }
                    case HALFWORKDATEPM: {
                        dym.set("dateentry.timeentry.begintimeam", (Object)"");
                        dym.set("dateentry.timeentry.endtimeam", (Object)"");
                    }
                }
                calendar.setTime(dym.getDate("dateentry.date"));
                String monthOfYear = DateUtil.format(calendar.getTime(), "yyyyMM");
                int day = calendar.get(5);
                UserWorkInfo dayInfo = WorkCalendarTaskUtil.getDayInfo(dym, "ssc", null);
                if (!monthofyear.equals(monthOfYear)) continue;
                info.getValue()[day - 1] = dayInfo;
            }
        }
    }

    private static DynamicObjectCollection getData(String orgId, String groupId, List userIds, Object startDate, Object endDate) {
        QFilter filters = new QFilter("ssccenter", "=", (Object)Long.parseLong(orgId));
        if (StringUtils.isBlank((CharSequence)groupId)) {
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        } else if (userIds.isEmpty()) {
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)Long.parseLong(groupId)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        } else {
            filters.and(new QFilter("dateentry.user", "in", (Object)userIds));
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)Long.parseLong(groupId)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        }
        filters.and(new QFilter("dateentry.date", ">=", startDate));
        filters.and(new QFilter("dateentry.date", "<=", endDate));
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.ssc,dateentry.usergroup,dateentry.user,dateentry.id,dateentry.datetype,dateentry.date,dateentry.timeentry.*", (QFilter[])new QFilter[]{filters}, (String)"dateentry.timeentry.id asc");
    }

    private static Map<String, UserWorkInfo[]> getUserWorkPeriods(String ssc, String groupId, List userIds, Object startDate, Object enDate) {
        List<Long> monthOfYears = WorkCalendarTaskUtil.getMonthOfYear(startDate, enDate);
        HashMap<String, UserWorkInfo[]> data = new HashMap<String, UserWorkInfo[]>(10);
        StringBuilder sBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        userIds.forEach(userId -> {
            for (Long monthOfYear : monthOfYears) {
                Date date = null;
                try {
                    date = DateUtil.parse(monthOfYear + "", "yyyyMM");
                }
                catch (ParseException e) {
                    logger.error("\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    continue;
                }
                calendar.setTime(date);
                int dayCount = calendar.getActualMaximum(5);
                sBuilder.append(ssc).append('-').append(groupId).append('-').append(userId).append('-').append(monthOfYear);
                data.put(sBuilder.toString(), new UserWorkInfo[dayCount]);
                sBuilder.setLength(0);
            }
        });
        return data;
    }

    public static int getMinutes(String beginTime, String endTime) {
        while (beginTime.length() < 4) {
            beginTime = "0" + beginTime;
        }
        while (endTime.length() < 4) {
            endTime = "0" + endTime;
        }
        int beginHour = Integer.parseInt(beginTime.substring(0, 2));
        int beginMinute = Integer.parseInt(beginTime.substring(2, 4));
        int endHour = Integer.parseInt(endTime.substring(0, 2));
        int endMinute = Integer.parseInt(endTime.substring(2, 4));
        return endHour * 60 + endMinute - (beginHour * 60 + beginMinute);
    }

    public static Integer getTimes(String time, int difMinute, String type) {
        while (time.length() < 4) {
            time = "0" + time;
        }
        StringBuilder sBuilder = new StringBuilder();
        int hour = Integer.parseInt(sBuilder.append(time.charAt(0)).append(time.charAt(1)).toString());
        sBuilder.setLength(0);
        int minute = Integer.parseInt(sBuilder.append(time.charAt(2)).append(time.charAt(3)).toString());
        sBuilder.setLength(0);
        int totalMinute = 0;
        if (type.equals("up")) {
            totalMinute = hour * 60 + minute + difMinute;
        } else if (type.equals("down")) {
            totalMinute = hour * 60 + minute - difMinute;
        }
        sBuilder.append(totalMinute / 60);
        minute = totalMinute % 60;
        if (minute < 10) {
            sBuilder.append('0');
        }
        return Integer.parseInt(sBuilder.append(minute).toString());
    }

    private static Map<String, Object> getStartAndEndDate(Object startDate, Object endDate) {
        HashMap<String, Object> dates = new HashMap<String, Object>(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)startDate);
        calendar.add(2, 0);
        calendar.set(5, 1);
        dates.put("startDate", calendar.getTime());
        calendar.setTime((Date)endDate);
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        dates.put("endDate", calendar.getTime());
        return dates;
    }

    public static List<Long> getMonthOfYear(Object startDate, Object enDate) {
        ArrayList<Long> monthOfYears = new ArrayList<Long>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime((Date)startDate);
        start.set(start.get(1), start.get(2), 1);
        end.setTime((Date)enDate);
        end.set(end.get(1), end.get(2), 2);
        Calendar curr = start;
        while (curr.before(end)) {
            monthOfYears.add(Long.parseLong(DateUtil.format(curr.getTime(), "yyyyMM")));
            curr.add(2, 1);
        }
        return monthOfYears;
    }

    private static boolean isPrintLog() {
        boolean result = false;
        QFilter printLogFlter = new QFilter("number", "=", (Object)"workCalendarSynLog");
        DynamicObject logParam = BusinessDataServiceHelper.loadSingle((String)"task_paramcontrol", (String)"number,paramvalue", (QFilter[])new QFilter[]{printLogFlter});
        result = logParam == null ? false : "true".equals(logParam.getString("paramvalue"));
        return result;
    }
}

