/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.ssc.enums.TaskDisModeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.business.helper.WorkFlowInfoHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.dis.RobortRepulseRule;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.service.distask.WorkLoadService;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.ArrayUtils;

public class WorkLoad
implements WorkLoadService {
    private static final Log log = LogFactory.getLog(WorkLoad.class);
    private static final String TASK_USERGROUPMETA = "task_usergroup";
    private Map<Long, List<WorkerStatusPojo>> groupPersonMap = new HashMap<Long, List<WorkerStatusPojo>>();
    private Map<String, WorkerStatusPojo> personWorkload = new HashMap<String, WorkerStatusPojo>();
    private RobortRepulseRule robortRepulseRule = null;
    private boolean printLog;
    private List<QFilter> usergroupFilterList;
    private List<WorkerStatusPojo> deletedPersons = new ArrayList<WorkerStatusPojo>();
    private HashMap<Long, Set<Long>> personsExistedInWorkflow;
    private HashMap<Long, Integer> groupId2Priority;
    private Long applierOfCurTask = 0L;
    private SecureRandom secureRandom = new SecureRandom();

    @Override
    public void prepareWorkflowPersons(DynamicObject[] tasks) {
        DynamicObjectCollection taskCollection = new DynamicObjectCollection();
        taskCollection.addAll(Arrays.asList(tasks));
        this.personsExistedInWorkflow = TaskApprevalHelper.getPersonsExistedInWorkflow(taskCollection);
    }

    @Override
    public void deletePerson(Long groupId, DynamicObject task) {
        this.deletePerson4Return(groupId, task);
    }

    @Override
    public Set<Long> deletePerson4Return(Long groupId, DynamicObject task) {
        if (task == null || groupId == null) {
            return new HashSet<Long>();
        }
        List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
        if (workloadList.size() == 0) {
            return new HashSet<Long>();
        }
        HashSet<Long> removePersons = new HashSet<Long>();
        boolean isSame = WorkFlowInfoHelper.getIsSame((long)task.getLong("billtype.id"), (long)task.getLong("tasktypeid.id"));
        if (isSame) {
            Set aheadHandlerOfSSCNode;
            Set<Long> persons = this.personsExistedInWorkflow.get(task.getLong("assignid"));
            if (persons != null) {
                removePersons.addAll(persons);
            }
            if ((aheadHandlerOfSSCNode = WorkFlowInfoHelper.getAheadHandlerOfSSCNode((long)task.getLong("assignid"))) != null) {
                removePersons.addAll(aheadHandlerOfSSCNode);
            }
        }
        if (CollectionUtil.isNotEmpty(removePersons)) {
            Iterator<WorkerStatusPojo> iterator = workloadList.iterator();
            while (iterator.hasNext()) {
                WorkerStatusPojo person = iterator.next();
                if (!removePersons.contains(person.getUserId())) continue;
                this.deletedPersons.add(person);
                iterator.remove();
            }
        }
        this.groupPersonMap.put(groupId, workloadList);
        return removePersons;
    }

    @Override
    public void deleteApplier(Long groupId, Long applier) {
        List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
        if (workloadList.isEmpty()) {
            return;
        }
        Iterator<WorkerStatusPojo> iterator = workloadList.iterator();
        while (iterator.hasNext()) {
            WorkerStatusPojo person = iterator.next();
            if (!person.getUserId().equals(applier)) continue;
            this.deletedPersons.add(person);
            iterator.remove();
        }
        this.groupPersonMap.put(groupId, workloadList);
    }

    @Override
    public WorkerStatusPojo deleteQTaskSPerson(Long groupId, Long qTaskSourcePerson) {
        if (qTaskSourcePerson == null) {
            return null;
        }
        List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
        Iterator<WorkerStatusPojo> iterator = workloadList.iterator();
        WorkerStatusPojo personCopy = null;
        while (iterator.hasNext()) {
            WorkerStatusPojo person = iterator.next();
            if (person == null || !qTaskSourcePerson.equals(person.getUserId())) continue;
            personCopy = person;
            iterator.remove();
            break;
        }
        return personCopy;
    }

    @Override
    public void addQTaskSPerson(Long groupId, WorkerStatusPojo qTaskSourcePerson) {
        List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
        workloadList.add(qTaskSourcePerson);
    }

    @Override
    public void prepareData() {
        this.groupPersonMap = this.buildGroupPersonMap();
        this.personWorkload = this.buildUserWorkingJobLoad();
    }

    @Override
    public void addPerson(Long groupId) {
        if (groupId == null || groupId == 0L) {
            return;
        }
        if (this.deletedPersons != null && !this.deletedPersons.isEmpty()) {
            List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
            workloadList.addAll(this.deletedPersons);
            this.deletedPersons.clear();
            this.groupPersonMap.put(groupId, workloadList);
        }
    }

    public void setUsergroupFilterList(List<QFilter> usergroupFilterList) {
        this.usergroupFilterList = usergroupFilterList;
    }

    public Map<String, WorkerStatusPojo> getPersonWorkload() {
        return this.personWorkload;
    }

    public void setPersonWorkload(Map<String, WorkerStatusPojo> personWorkload) {
        this.personWorkload = personWorkload;
    }

    public WorkerStatusPojo getMatchAndLeastPerson() {
        Collection<WorkerStatusPojo> values = this.personWorkload.values();
        if (values.size() == 0) {
            return null;
        }
        WorkerStatusPojo workerStatusPojo = null;
        for (WorkerStatusPojo value : values) {
            if (value.getTaskTotal() >= value.getTaskUpper() || value.getTaskTotalUpperOfDay() == -1 && value.getTaskTotalOfMonth() >= value.getTaskTotalUpperOfMonth() || value.getTaskTotalUpperOfDay() != -1 && value.getTaskTotalOfDay() >= value.getTaskTotalUpperOfDay() || value.getUserId().equals(this.applierOfCurTask)) continue;
            if (workerStatusPojo == null || this.groupId2Priority.get(value.getUserGroupId()) < this.groupId2Priority.get(workerStatusPojo.getUserGroupId())) {
                workerStatusPojo = value;
                continue;
            }
            if (!this.groupId2Priority.get(value.getUserGroupId()).equals(this.groupId2Priority.get(workerStatusPojo.getUserGroupId())) || value.getTaskTotalOnAbility().compareTo(workerStatusPojo.getTaskTotalOnAbility()) >= 0) continue;
            workerStatusPojo = value;
        }
        return workerStatusPojo;
    }

    @Override
    public long getMatchPerson(Long groupId, String billNumber) {
        List<WorkerStatusPojo> workloadList = this.buildWorkLoadByGroup(groupId);
        if (workloadList == null || workloadList.size() == 0) {
            this.logInfo(billNumber + "this group no on work user :" + groupId);
            return -1L;
        }
        Iterator<WorkerStatusPojo> it = workloadList.iterator();
        while (it.hasNext()) {
            WorkerStatusPojo workerStatusPojo = it.next();
            this.logInfo(billNumber + "dealUser status info:" + workerStatusPojo);
            if (workerStatusPojo.getTaskTotal() >= workerStatusPojo.getTaskUpper()) {
                it.remove();
                continue;
            }
            if (workerStatusPojo.getTaskTotalUpperOfDay() == -1 && workerStatusPojo.getTaskTotalOfMonth() >= workerStatusPojo.getTaskTotalUpperOfMonth()) {
                it.remove();
                continue;
            }
            if (workerStatusPojo.getTaskTotalUpperOfDay() == -1 || workerStatusPojo.getTaskTotalOfDay() < workerStatusPojo.getTaskTotalUpperOfDay()) continue;
            it.remove();
        }
        if (workloadList.isEmpty()) {
            this.logInfo(billNumber + "this group everyone workload maxinum:" + groupId);
            return -1L;
        }
        List<Object> mixWorkloadList = new ArrayList();
        String disMode = WorkLoad.getDisMode(workloadList.get(0).getSscId());
        if (disMode.equals(TaskDisModeEnum.INTELLIGENT_DISTRIBUTION.getValue())) {
            Collections.sort(workloadList, new UserWorkLoadCompare());
            mixWorkloadList = workloadList.stream().filter(v -> v.getTaskTotalOnAbility().compareTo(((WorkerStatusPojo)workloadList.get(0)).getTaskTotalOnAbility()) == 0).collect(Collectors.toList());
        } else if (disMode.equals(TaskDisModeEnum.EQUAL_DISTRIBUTION.getValue())) {
            Collections.sort(workloadList, new UserWorkLoadComparatorOfAssignedOfDay());
            mixWorkloadList = workloadList.stream().filter(v -> v.getAssignedTaskTotalOfDayOnAbility().compareTo(((WorkerStatusPojo)workloadList.get(0)).getAssignedTaskTotalOfDayOnAbility()) == 0).collect(Collectors.toList());
        } else if (disMode.equals(TaskDisModeEnum.HOURLY_AVERAGE_DISTRIBUTION.getValue())) {
            Collections.sort(workloadList, new UserWorkLoadComparatorOfAssignedOfHour());
            mixWorkloadList = workloadList.stream().filter(v -> v.getAssignedTaskTotalOfHourOnAbility().compareTo(((WorkerStatusPojo)workloadList.get(0)).getAssignedTaskTotalOfHourOnAbility()) == 0).collect(Collectors.toList());
        }
        if (mixWorkloadList.size() > 0) {
            WorkerStatusPojo randomElement = (WorkerStatusPojo)mixWorkloadList.get(this.secureRandom.nextInt(mixWorkloadList.size()));
            long toJudgePerson = randomElement.getUserId();
            this.modifyWorkStatus(toJudgePerson + "_" + groupId);
            return toJudgePerson;
        }
        this.logInfo(billNumber + "this group everyone workload maxinum:" + groupId);
        return -1L;
    }

    @Override
    public boolean isPresent(String personidAndGroup, String billNumber) {
        if (this.personWorkload.containsKey(personidAndGroup)) {
            return this.personWorkload.containsKey(personidAndGroup);
        }
        this.logInfo(billNumber + "not exist in usergroup:" + personidAndGroup);
        return false;
    }

    @Override
    public void modifyWorkStatus(String personidAndGroup) {
        WorkerStatusPojo oldWorkerStatusPojo = this.personWorkload.get(personidAndGroup);
        oldWorkerStatusPojo.setTaskTotalOfDay(oldWorkerStatusPojo.getTaskTotalOfDay() + 1);
        oldWorkerStatusPojo.setTaskTotalOfMonth(oldWorkerStatusPojo.getTaskTotalOfMonth() + 1);
        oldWorkerStatusPojo.setTaskTotal(oldWorkerStatusPojo.getTaskTotal() + 1);
        oldWorkerStatusPojo.setTaskTotalOnAbility(new BigDecimal(oldWorkerStatusPojo.getTaskTotal()).divide(oldWorkerStatusPojo.getAbilityValue(), 1, RoundingMode.HALF_UP));
        oldWorkerStatusPojo.setAssignedTaskTotalOfDay(oldWorkerStatusPojo.getAssignedTaskTotalOfDay() + 1);
        oldWorkerStatusPojo.setAssignedTaskTotalOfDayOnAbility(new BigDecimal(oldWorkerStatusPojo.getAssignedTaskTotalOfDay()).divide(oldWorkerStatusPojo.getAbilityValue(), 1, RoundingMode.HALF_UP));
        oldWorkerStatusPojo.setAssignedTaskTotalOfHour(oldWorkerStatusPojo.getAssignedTaskTotalOfHour() + 1);
        oldWorkerStatusPojo.setAssignedTaskTotalOfHourOnAbility(new BigDecimal(oldWorkerStatusPojo.getAssignedTaskTotalOfHour()).divide(oldWorkerStatusPojo.getAbilityValue(), 1, RoundingMode.HALF_UP));
        this.personWorkload.put(personidAndGroup, oldWorkerStatusPojo);
    }

    private static String getDisMode(Long sscId) {
        if (sscId == null || sscId == 0L) {
            return TaskDisModeEnum.INTELLIGENT_DISTRIBUTION.getValue();
        }
        QFilter qFilter = new QFilter("scenter.id", "=", (Object)sscId);
        Object[] disModes = BusinessDataServiceHelper.load((String)"task_dis_mode", (String)"id, dismode", (QFilter[])new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])disModes)) {
            return disModes[0].getString("dismode");
        }
        return TaskDisModeEnum.INTELLIGENT_DISTRIBUTION.getValue();
    }

    private List<WorkerStatusPojo> buildWorkLoadByGroup(Long matchGourps) {
        List<WorkerStatusPojo> workLoadList = new ArrayList<WorkerStatusPojo>(10);
        if (this.groupPersonMap.isEmpty()) {
            this.logInfo("workload is null");
            return workLoadList;
        }
        this.logInfo("input match group id is:" + matchGourps);
        workLoadList = this.groupPersonMap.get(matchGourps);
        if (workLoadList == null) {
            workLoadList = new ArrayList(10);
        }
        return workLoadList;
    }

    private Map<Long, List<WorkerStatusPojo>> buildGroupPersonMap() {
        this.logInfo(ResManager.loadKDString((String)"kd.ssc.task.formplugin.TaskAutoDisTask.buildGroupPersonMap() \u5f00\u59cb\u6784\u5efa\u7528\u6237\u7ec4\uff0c\u4eba\u5458\u6620\u5c04", (String)"TaskAutoDisTask_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        HashMap<Long, List<WorkerStatusPojo>> groupPersonMap = new HashMap<Long, List<WorkerStatusPojo>>(16);
        QFilter enableQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter userEnabled = new QFilter("entryentity.usestatus", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(enableQF);
        filters.add(userEnabled);
        if (this.usergroupFilterList != null) {
            filters.addAll(this.usergroupFilterList);
        }
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)TASK_USERGROUPMETA, (String)"id,number,createorg,workperiod,entryentity.userfield,entryentity.usestatus,entryentity.ability,entryentity.curtasknum_e,entryentity.taskallnum_e", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        BigDecimal ZERO = new BigDecimal(0);
        for (DynamicObject usergroup : userGroups) {
            DynamicObjectCollection usergroupColl = usergroup.getDynamicObjectCollection("entryentity");
            Long userGroupID = usergroup.getLong("id");
            Long sscId = usergroup.getLong("createorg.id");
            DynamicObject timeZone = usergroup.getDynamicObject("createorg.timezone");
            String timezonenumber = null;
            if (timeZone != null) {
                timezonenumber = timeZone.getString("number");
            }
            int workperiod = usergroup.getInt("workperiod");
            for (DynamicObject user : usergroupColl) {
                BigDecimal ability;
                if (!user.getBoolean("userfield.enable") || !user.getBoolean("usestatus") || ZERO.compareTo(ability = user.getBigDecimal("ability")) == 0) continue;
                int curtasknum_e = user.getInt("curtasknum_e");
                int taskallnum_day = workperiod == 1 ? user.getInt("taskallnum_e") : -1;
                int taskallnum_month = workperiod == 2 ? user.getInt("taskallnum_e") : -1;
                Long userID = user.getLong("userfield.id");
                ArrayList<WorkerStatusPojo> personList = (ArrayList<WorkerStatusPojo>)groupPersonMap.get(userGroupID);
                if (personList != null) {
                    personList.add(new WorkerStatusPojo(userID, ability, curtasknum_e, taskallnum_day, taskallnum_month, userGroupID, sscId, timezonenumber));
                    continue;
                }
                personList = new ArrayList<WorkerStatusPojo>(1);
                personList.add(new WorkerStatusPojo(userID, ability, curtasknum_e, taskallnum_day, taskallnum_month, userGroupID, sscId, timezonenumber));
                groupPersonMap.put(userGroupID, personList);
            }
        }
        Map collect = groupPersonMap.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(WorkerStatusPojo::getTimezoneNumber, Collectors.mapping(WorkerStatusPojo::getUserGroupId, Collectors.toSet())));
        HashMap userMapOnWork = new HashMap(16);
        Date date = new Date();
        collect.forEach((k, v) -> {
            Map<Long, Set<Long>> setMap = SscWorkCalendarApi.queryUserOnWork(v, DateUtil.changeTimeZone((Date)date, (String)k));
            userMapOnWork.putAll(setMap);
        });
        for (Map.Entry entry : groupPersonMap.entrySet()) {
            Long groupId = (Long)entry.getKey();
            List workerStatusPojoList = (List)entry.getValue();
            Set userIds = (Set)userMapOnWork.get(groupId);
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                workerStatusPojoList.clear();
                continue;
            }
            Iterator iterator = workerStatusPojoList.iterator();
            while (iterator.hasNext()) {
                WorkerStatusPojo next = (WorkerStatusPojo)iterator.next();
                if (userIds.contains(next.getUserId())) continue;
                this.logInfo(next.getUserId() + "not on work");
                iterator.remove();
            }
        }
        this.logInfo(ResManager.loadKDString((String)"kd.ssc.task.formplugin.TaskAutoDisTask.buildGroupPersonMap() \u6784\u5efa\u7528\u6237\u7ec4\uff0c\u4eba\u5458\u6620\u5c04\u7ed3\u675f", (String)"TaskAutoDisTask_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        return groupPersonMap;
    }

    private Map<String, WorkerStatusPojo> buildUserWorkingJobLoad() {
        WorkerStatusPojo tempWorkerStatus;
        Integer total;
        Long usergroup;
        Long personid;
        Throwable throwable;
        DataSet result1DataSet2;
        Throwable throwable2;
        DataSet historyDS2;
        Date nowDate;
        this.logInfo("TaskAutoDisTask buildUserWorkingJobLoad begin");
        ORM orm = ORM.create();
        HashMap<String, WorkerStatusPojo> workloadMap = new HashMap<String, WorkerStatusPojo>(16);
        if (this.groupPersonMap.isEmpty()) {
            this.logInfo("userGroup is null");
            return workloadMap;
        }
        for (List<WorkerStatusPojo> group : this.groupPersonMap.values()) {
            for (WorkerStatusPojo workerStatusPojo : group) {
                workloadMap.put(workerStatusPojo.getUserId() + "_" + workerStatusPojo.getUserGroupId(), workerStatusPojo);
            }
        }
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        Date curDayStartTime = nowDate = new Date();
        try {
            curDayStartTime = DateUtil.getCurDateForm((Date)nowDate, (boolean)true);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u83b7\u53d6\u9519\u8bef");
        }
        Date curMonthStartTime = DateUtil.getCurMonthStartTime();
        QFilter dayTimeReceiveFilter = new QFilter("receivetime", ">=", (Object)curDayStartTime);
        QFilter dayTimeCompleteFilter = new QFilter("completetime", ">=", (Object)curDayStartTime);
        QFilter monthTimeReceiveFilter = new QFilter("receivetime", ">=", (Object)curMonthStartTime);
        QFilter monthTimeCompleteFilter = new QFilter("completetime", ">=", (Object)curMonthStartTime);
        try (DataSet taskAfterGroupDS = orm.queryDataSet(this.getClass().getName() + ".query task", "task_task", "personid,usergroup", new QFilter[]{disedTKFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish().orderBy(new String[]{"workload desc"});){
            for (Row taskAfterOrderRow : taskAfterGroupDS) {
                Long personid2 = taskAfterOrderRow.getLong("personid");
                Long usergroup2 = taskAfterOrderRow.getLong("usergroup");
                if (workloadMap.containsKey(personid2 + "_" + usergroup2)) {
                    Integer workload = taskAfterOrderRow.getInteger("workload");
                    WorkerStatusPojo tempWorkerStatus2 = (WorkerStatusPojo)workloadMap.get(personid2 + "_" + usergroup2);
                    tempWorkerStatus2.setTaskTotal(workload);
                    tempWorkerStatus2.setTaskTotalOnAbility(new BigDecimal(workload).divide(tempWorkerStatus2.getAbilityValue(), 1, RoundingMode.HALF_UP));
                    workloadMap.put(personid2 + "_" + usergroup2, tempWorkerStatus2);
                    continue;
                }
                log.info("\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u5728\u7528\u6237\u7ec4\u4e2d\uff1a" + personid2);
            }
        }
        var13_14 = null;
        try (DataSet taskDS = orm.queryDataSet("task_task", "task_task", "personid,usergroup", new QFilter[]{disedTKFilter, dayTimeReceiveFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();){
            historyDS2 = orm.queryDataSet("task_taskhistory", "task_taskhistory", "personid,usergroup", new QFilter[]{dayTimeCompleteFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
            throwable2 = null;
            try {
                result1DataSet2 = taskDS.union(historyDS2).groupBy(new String[]{"personid", "usergroup"}).sum("workload", "total").finish();
                throwable = null;
                try {
                    for (Row result1 : result1DataSet2) {
                        personid = result1.getLong("personid");
                        usergroup = result1.getLong("usergroup");
                        if (workloadMap.containsKey(personid + "_" + usergroup)) {
                            total = result1.getInteger("total");
                            tempWorkerStatus = (WorkerStatusPojo)workloadMap.get(personid + "_" + usergroup);
                            tempWorkerStatus.setTaskTotalOfDay(total);
                            workloadMap.put(personid + "_" + usergroup, tempWorkerStatus);
                            continue;
                        }
                        log.info("\u5904\u7406\u4eba\u4e0d\u5728\u7528\u6237\u7ec4\u4e2d\uff1a" + personid);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (result1DataSet2 != null) {
                        if (throwable != null) {
                            try {
                                result1DataSet2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            result1DataSet2.close();
                        }
                    }
                }
            }
            catch (Throwable result1DataSet2) {
                throwable2 = result1DataSet2;
                throw result1DataSet2;
            }
            finally {
                if (historyDS2 != null) {
                    if (throwable2 != null) {
                        try {
                            historyDS2.close();
                        }
                        catch (Throwable result1DataSet2) {
                            throwable2.addSuppressed(result1DataSet2);
                        }
                    } else {
                        historyDS2.close();
                    }
                }
            }
        }
        catch (Throwable historyDS2) {
            var13_14 = historyDS2;
            throw historyDS2;
        }
        taskDS = orm.queryDataSet("task_task", "task_task", "personid,usergroup", new QFilter[]{disedTKFilter, monthTimeReceiveFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
        var13_14 = null;
        try {
            historyDS2 = orm.queryDataSet("task_taskhistory", "task_taskhistory", "personid,usergroup", new QFilter[]{monthTimeCompleteFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
            throwable2 = null;
            try {
                throwable = null;
                try (DataSet result2DataSet = taskDS.union(historyDS2).groupBy(new String[]{"personid", "usergroup"}).sum("workload", "total").finish();){
                    for (Row result2 : result2DataSet) {
                        personid = result2.getLong("personid");
                        usergroup = result2.getLong("usergroup");
                        if (workloadMap.containsKey(personid + "_" + usergroup)) {
                            total = result2.getInteger("total");
                            tempWorkerStatus = (WorkerStatusPojo)workloadMap.get(personid + "_" + usergroup);
                            tempWorkerStatus.setTaskTotalOfMonth(total);
                            workloadMap.put(personid + "_" + usergroup, tempWorkerStatus);
                            continue;
                        }
                        log.info("\u5904\u7406\u4eba\u4e0d\u5728\u7528\u6237\u7ec4\u4e2d\uff1a" + personid);
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable result2DataSet) {
                throwable2 = result2DataSet;
                throw result2DataSet;
            }
            finally {
                if (historyDS2 != null) {
                    if (throwable2 != null) {
                        try {
                            historyDS2.close();
                        }
                        catch (Throwable result2DataSet) {
                            throwable2.addSuppressed(result2DataSet);
                        }
                    } else {
                        historyDS2.close();
                    }
                }
            }
        }
        catch (Throwable historyDS3) {
            var13_14 = historyDS3;
            throw historyDS3;
        }
        finally {
            if (taskDS != null) {
                if (var13_14 != null) {
                    try {
                        taskDS.close();
                    }
                    catch (Throwable historyDS3) {
                        var13_14.addSuppressed(historyDS3);
                    }
                } else {
                    taskDS.close();
                }
            }
        }
        taskDS = orm.queryDataSet("task_task", "task_task", "personid,usergroup", new QFilter[]{disedTKFilter, dayTimeReceiveFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
        var13_14 = null;
        try {
            historyDS2 = orm.queryDataSet("task_taskhistory", "task_taskhistory", "personid,usergroup", new QFilter[]{dayTimeReceiveFilter}).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
            throwable2 = null;
            try {
                result1DataSet2 = taskDS.union(historyDS2).groupBy(new String[]{"personid", "usergroup"}).sum("workload", "total").finish();
                throwable = null;
                try {
                    for (Row result1 : result1DataSet2) {
                        personid = result1.getLong("personid");
                        usergroup = result1.getLong("usergroup");
                        if (workloadMap.containsKey(personid + "_" + usergroup)) {
                            total = result1.getInteger("total");
                            tempWorkerStatus = (WorkerStatusPojo)workloadMap.get(personid + "_" + usergroup);
                            tempWorkerStatus.setAssignedTaskTotalOfDay(total);
                            tempWorkerStatus.setAssignedTaskTotalOfDayOnAbility(new BigDecimal(total).divide(tempWorkerStatus.getAbilityValue(), 1, RoundingMode.HALF_UP));
                            workloadMap.put(personid + "_" + usergroup, tempWorkerStatus);
                            continue;
                        }
                        log.info("\u5904\u7406\u4eba\u4e0d\u5728\u7528\u6237\u7ec4\u4e2d\uff1a" + personid);
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (result1DataSet2 != null) {
                        if (throwable != null) {
                            try {
                                result1DataSet2.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            result1DataSet2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (historyDS2 != null) {
                    if (throwable2 != null) {
                        try {
                            historyDS2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                    } else {
                        historyDS2.close();
                    }
                }
            }
        }
        catch (Throwable throwable10) {
            var13_14 = throwable10;
            throw throwable10;
        }
        finally {
            if (taskDS != null) {
                if (var13_14 != null) {
                    try {
                        taskDS.close();
                    }
                    catch (Throwable throwable11) {
                        var13_14.addSuppressed(throwable11);
                    }
                } else {
                    taskDS.close();
                }
            }
        }
        WorkLoad.initHourlyAverageWorkload(workloadMap, disedTKFilter);
        this.logInfo("TaskAutoDisTask buildUserWorkingJobLoad end");
        return workloadMap;
    }

    public static void initHourlyAverageWorkload(Map<String, WorkerStatusPojo> workloadMap, QFilter disedTKFilter) {
        if (workloadMap == null || workloadMap.size() == 0) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime minHour = now.truncatedTo(ChronoUnit.HOURS);
        LocalDateTime maxHour = minHour.plusHours(1L);
        QFilter minHourFilter = new QFilter("receivetime", ">=", (Object)minHour);
        QFilter maxHourFilter = new QFilter("receivetime", "<", (Object)maxHour);
        try (DataSet taskDS = QueryServiceHelper.queryDataSet((String)"task_task", (String)"task_task", (String)"personid,usergroup", (QFilter[])new QFilter[]{disedTKFilter, minHourFilter, maxHourFilter}, null).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
             DataSet historyDS = QueryServiceHelper.queryDataSet((String)"task_taskhistory", (String)"task_taskhistory", (String)"personid,usergroup", (QFilter[])new QFilter[]{minHourFilter, maxHourFilter}, null).groupBy(new String[]{"personid", "usergroup"}).count("workload").finish();
             DataSet result1DataSet = taskDS.union(historyDS).groupBy(new String[]{"personid", "usergroup"}).sum("workload", "total").finish();){
            for (Row result : result1DataSet) {
                Long personId = result.getLong("personid");
                Long userGroup = result.getLong("usergroup");
                String workloadKey = personId + "_" + userGroup;
                if (workloadMap.containsKey(workloadKey)) {
                    Integer total = result.getInteger("total");
                    WorkerStatusPojo tempWorkerStatus = workloadMap.get(personId + "_" + userGroup);
                    tempWorkerStatus.setAssignedTaskTotalOfHour(total);
                    BigDecimal ability = tempWorkerStatus.getAbilityValue();
                    tempWorkerStatus.setAssignedTaskTotalOfHourOnAbility(new BigDecimal(total).divide(ability, 1, RoundingMode.HALF_UP));
                    workloadMap.put(workloadKey, tempWorkerStatus);
                    continue;
                }
                log.info("WorkLoad.initHourlyAverageWorkload \uff0cpersonId = {} not in the userGroup = {}", (Object)personId, (Object)userGroup);
            }
        }
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    @Override
    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public boolean getPrintLog() {
        return this.printLog;
    }

    @Override
    public void setRobortRepulseRule(RobortRepulseRule robortRepulseRule) {
        this.robortRepulseRule = robortRepulseRule;
    }

    public RobortRepulseRule getRobortRepulseRule() {
        return this.robortRepulseRule;
    }

    @Override
    public Map<Long, List<WorkerStatusPojo>> getGroupPersonMap() {
        return this.groupPersonMap;
    }

    public void setGroupPersonMap(Map<Long, List<WorkerStatusPojo>> groupPersonMap) {
        this.groupPersonMap = groupPersonMap;
    }

    protected List<WorkerStatusPojo> getDeletedPersonsList() {
        return this.deletedPersons;
    }

    public HashMap<Long, Integer> getGroupId2Priority() {
        return this.groupId2Priority;
    }

    public void setGroupId2Priority(HashMap<Long, Integer> groupId2Priority) {
        this.groupId2Priority = groupId2Priority;
    }

    public void setApplierOfCurTask(Long applierOfCurTask) {
        this.applierOfCurTask = applierOfCurTask;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    private static class UserWorkLoadComparatorOfAssignedOfHour
    implements Comparator<WorkerStatusPojo> {
        private UserWorkLoadComparatorOfAssignedOfHour() {
        }

        @Override
        public int compare(WorkerStatusPojo o1, WorkerStatusPojo o2) {
            return o1.getAssignedTaskTotalOfHourOnAbility().compareTo(o2.getAssignedTaskTotalOfHourOnAbility());
        }
    }

    private static class UserWorkLoadComparatorOfAssignedOfDay
    implements Comparator<WorkerStatusPojo> {
        private UserWorkLoadComparatorOfAssignedOfDay() {
        }

        @Override
        public int compare(WorkerStatusPojo o1, WorkerStatusPojo o2) {
            return o1.getAssignedTaskTotalOfDayOnAbility().compareTo(o2.getAssignedTaskTotalOfDayOnAbility());
        }
    }

    private static class UserWorkLoadCompare
    implements Comparator<WorkerStatusPojo> {
        private UserWorkLoadCompare() {
        }

        @Override
        public int compare(WorkerStatusPojo o1, WorkerStatusPojo o2) {
            return o1.getTaskTotalOnAbility().compareTo(o2.getTaskTotalOnAbility());
        }
    }
}

