/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.core;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.INotifyWfService;
import kd.sdk.fi.ssc.extpoint.disRebuild.IStateChangeService;
import kd.sdk.fi.ssc.extpoint.disRebuild.ITaskSaveService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.OrgSetUserGroupPojo;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;
import kd.ssc.task.disRebuild.disenum.MatchRulePluginTypeEnum;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.service.impl.DefaultMatchRuleResult;
import kd.ssc.task.disRebuild.service.impl.after.IAfterDisServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.INotifyWfServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.IStateChangeServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.ITaskSaveServiceImpl;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.service.distask.WorkLoadService;

public class CoreDistribution {
    private static final Log log = LogFactory.getLog(CoreDistribution.class);

    public int distribute(DisRequestCtx requestCtx, List<Long> taskIdSet) {
        int successCount = 0;
        ArrayList<DynamicObject> disTaskList = new ArrayList<DynamicObject>(16);
        log.info("CoreDistribution.distribute() start, sscId = {}, size = {}", (Object)requestCtx.getSscid(), (Object)taskIdSet.size());
        for (Long taskId : taskIdSet) {
            boolean result = this.distribute4Single(requestCtx, taskId);
            if (!result) continue;
            disTaskList.add(requestCtx.getDisTask());
            ++successCount;
        }
        OtherUtil.afterDisBatch(requestCtx.getDisType(), disTaskList);
        log.info("CoreDistribution.distribute() end, sscId = {}, successCount = {}", (Object)requestCtx.getSscid(), (Object)successCount);
        return successCount;
    }

    public boolean distribute4Single(DisRequestCtx requestCtx, long taskId) {
        requestCtx.setDisTaskId(taskId);
        MatchRuleResult result = this.matchRule(requestCtx.getSscid(), requestCtx, taskId);
        result.save();
        if (result.isSuccess()) {
            this.transDynBySuccess(requestCtx, result);
        } else {
            if (requestCtx.getDisType() == DisTypeEnum.MANUAL_GET) {
                throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), this.getMatchField(taskId)), new Object[0]);
            }
            this.transDynByFailure(requestCtx, result);
        }
        this.notifyWf(requestCtx, result);
        try (TXHandle h = TX.requiresNew((String)"distribute4Single");){
            try {
                this.saveTask(requestCtx, result);
                this.stateChange(requestCtx, result);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.afterDisSingle(requestCtx, result);
        if (!result.isSuccess()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), this.getMatchField(taskId)), new Object[0]);
        }
        return true;
    }

    private void transDynBySuccess(DisRequestCtx requestCtx, MatchRuleResult result) {
        String state;
        DynamicObject disTask = requestCtx.getDisTask();
        HashMap<String, Object> disTaskOldValueMap = new HashMap<String, Object>(8);
        if (OtherUtil.isUpImageTask(disTask)) {
            disTaskOldValueMap.put("usergroup", disTask.getLong("usergroup.id"));
            disTaskOldValueMap.put("state", disTask.getString("state"));
            requestCtx.setDisTaskOldValueMap(disTaskOldValueMap);
            disTask.set("usergroup", (Object)result.getMatchGroupId());
            disTask.set("state", (Object)TaskStateEnum.TO_UPLOAD_IMAGE.getValue());
            return;
        }
        disTaskOldValueMap.put("usergroup", disTask.getLong("usergroup.id"));
        disTaskOldValueMap.put("personid", disTask.getLong("personid.id"));
        disTaskOldValueMap.put("pooltype", disTask.getString("pooltype"));
        disTaskOldValueMap.put("state", disTask.getString("state"));
        long allocatedPersonId = result.getMatchPersonId();
        disTaskOldValueMap.put("allocatedpersonid", allocatedPersonId);
        requestCtx.setDisTaskOldValueMap(disTaskOldValueMap);
        boolean isQuality = disTask.getLong("qualitysamplelibrary.id") > 0L;
        long matchGroupId = result.getMatchGroupId();
        long matchPersonId = result.getMatchPersonId();
        Date date = new Date();
        disTask.set("receivetime", (Object)date);
        if (isQuality) {
            state = TaskStateEnum.CHECKING.getValue();
            disTask.set("orignalperson", (Object)matchPersonId);
        } else {
            state = TaskStateEnum.TO_BE_AUDIT.getValue();
            if (RobertUserGroupUtil.isRobort(requestCtx.getSscid(), matchGroupId)) {
                disTask.set("autoprocess", (Object)Character.valueOf('1'));
            } else {
                disTask.set("autoprocess", (Object)Character.valueOf('0'));
            }
            Object firstreceivetime = disTask.get("firstreceivetime");
            if (firstreceivetime == null) {
                disTask.set("firstreceivetime", (Object)date);
            }
        }
        disTask.set("expirestate", (Object)Character.valueOf('1'));
        disTask.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        disTask.set("matchrule", (Object)result.getMatchRuleId());
        disTask.set("usergroup", (Object)matchGroupId);
        disTask.set("personid", (Object)matchPersonId);
        disTask.set("oldtaskstate", (Object)disTask.getString("state"));
        disTask.set("state", (Object)state);
    }

    private void transDynByFailure(DisRequestCtx requestCtx, MatchRuleResult result) {
        String newState;
        DisTypeEnum disType = requestCtx.getDisType();
        DynamicObject disTask = requestCtx.getDisTask();
        if (disType == DisTypeEnum.NOPASS_DIS || OtherUtil.isUpImageTask(disTask)) {
            requestCtx.setDisTaskOldValueMap(new HashMap<String, Object>(8));
            return;
        }
        HashMap<String, Object> disTaskOldValueMap = new HashMap<String, Object>(8);
        String pooltype = disTask.getString("pooltype");
        long matchGroupId = result.getMatchGroupId();
        String curState = disTask.getString("state");
        String oldState = disTask.getString("oldtaskstate");
        disTaskOldValueMap.put("usergroup", disTask.getLong("usergroup.id"));
        disTaskOldValueMap.put("personid", disTask.getLong("personid.id"));
        disTaskOldValueMap.put("pooltype", pooltype);
        disTaskOldValueMap.put("state", curState);
        requestCtx.setDisTaskOldValueMap(disTaskOldValueMap);
        long matchedRule = 0L;
        long matchedGroup = 0L;
        if (result.getMatchRuleId() == 0L || matchGroupId == 0L) {
            newState = TaskStateEnum.DIS_EXCEPTION.getValue();
        } else {
            String manualDis = TaskStateEnum.TO_BE_MANUAL_DIS.getValue();
            newState = manualDis.equals(curState) || manualDis.equals(oldState) ? manualDis : TaskStateEnum.TO_BE_DIS.getValue();
            Map<Long, List<Long>> matchedRuleAndGroups = result.getMatchedRuleAndGroups();
            if (matchedRuleAndGroups != null && !matchedRuleAndGroups.isEmpty() && (matchedRule = this.getHigherPriorityRule(requestCtx, matchedRuleAndGroups.keySet())) != 0L) {
                matchedGroup = matchedRuleAndGroups.get(matchedRule).get(0);
            }
        }
        if (TaskStateEnum.TO_BE_MANUAL_DIS.getValue().equals(curState)) {
            disTask.set("oldtaskstate", (Object)curState);
        }
        disTask.set("hasallocated", (Object)"1");
        disTask.set("state", (Object)newState);
        disTask.set("matchrule", (Object)matchedRule);
        disTask.set("usergroup", (Object)matchedGroup);
        disTask.set("personid", (Object)0L);
    }

    private long getHigherPriorityRule(DisRequestCtx requestCtx, Set<Long> keySet) {
        Map<Long, CusDisrulePojo> rules = requestCtx.getRuleInfos();
        if (rules == null) {
            return 0L;
        }
        long higherPriorityRule = 0L;
        int maxPriority = Integer.MAX_VALUE;
        for (Map.Entry<Long, CusDisrulePojo> rule : rules.entrySet()) {
            CusDisrulePojo pojo;
            Long ruleId = rule.getKey();
            if (!keySet.contains(ruleId) || (pojo = rule.getValue()).getPriority() >= maxPriority) continue;
            higherPriorityRule = ruleId;
            maxPriority = pojo.getPriority();
        }
        return higherPriorityRule;
    }

    private String getMatchField(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5206\u914d\u8be6\u60c5\u5e76\u68c0\u67e5\u5206\u914d\u89c4\u5219\u914d\u7f6e\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"CoreDistribution_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    public Map<Long, Set<Long>> singleDis4Group(DisRequestCtx requestCtx, long taskId, List<Long> errRuleDyns) {
        boolean isQuality;
        Map<String, List<MatchRuleService>> allPlugins;
        requestCtx.setDisTaskId(taskId);
        HashMap<Long, Set<Long>> matchedResult = new HashMap<Long, Set<Long>>();
        MatchRuleResult result = new DefaultMatchRuleResult(taskId, requestCtx.getDisType());
        if (requestCtx.getQualityTaskIds().contains(taskId)) {
            allPlugins = requestCtx.getAllQualityPlugins();
            isQuality = true;
        } else {
            allPlugins = requestCtx.getAllAuditPlugins();
            isQuality = false;
        }
        List<MatchRuleService> rulePlugins = allPlugins.get(MatchRulePluginTypeEnum.RULE.getValue());
        Map<Long, CusDisrulePojo> rules = requestCtx.getRuleInfos();
        if (rules == null || rules.isEmpty()) {
            JSONObject detail = ResultBuildUtil.getOrDefault_Detail(result.getDetail());
            detail.put("message", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5339\u914d\u89c4\u5219", (String)"CoreDistribution_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            result.setSuccess(false);
            return new HashMap<Long, Set<Long>>();
        }
        List<Long> ruleIdSet = this.getRuleIdsOrderByPriority(rules);
        for (long ruleId : ruleIdSet) {
            List<Long> matchGroups;
            boolean exception = false;
            for (MatchRuleService plugin : rulePlugins) {
                requestCtx.setCurrentRuleId(ruleId);
                try {
                    result = plugin.match(taskId, result);
                }
                catch (Exception e) {
                    exception = true;
                    log.error("\u4efb\u52a1\u5206\u914d\u6761\u4ef6\u5339\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u5206\u914d\u89c4\u5219id\uff1a" + ruleId, (Throwable)e);
                    break;
                }
                if (result.isSuccess()) continue;
                break;
            }
            if (exception) {
                exception = false;
                errRuleDyns.add(ruleId);
                continue;
            }
            if (!result.isSuccess() || (matchGroups = this.matchGroup(requestCtx, result, isQuality)).isEmpty()) continue;
            matchedResult.put(ruleId, new HashSet<Long>(matchGroups));
        }
        result.save();
        return matchedResult;
    }

    private MatchRuleResult matchRule(long sscid, DisRequestCtx requestCtx, long taskId) {
        MatchRuleResult result = requestCtx.getQualityTaskIds().contains(taskId) ? this.getQulityMatchRuleResult(sscid, requestCtx, taskId) : this.getAuditMatchRuleResult(sscid, requestCtx, taskId);
        return result;
    }

    private MatchRuleResult getQulityMatchRuleResult(long sscid, DisRequestCtx requestCtx, long taskId) {
        return this.getMatchRuleResult(sscid, requestCtx, taskId, true);
    }

    private MatchRuleResult getAuditMatchRuleResult(long sscid, DisRequestCtx requestCtx, long taskId) {
        return this.getMatchRuleResult(sscid, requestCtx, taskId, false);
    }

    private MatchRuleResult getMatchRuleResult(long sscid, DisRequestCtx requestCtx, long taskId, boolean isQuality) {
        Map<String, List<MatchRuleService>> allPlugins = isQuality ? requestCtx.getAllQualityPlugins() : requestCtx.getAllAuditPlugins();
        MatchRuleResult result = new DefaultMatchRuleResult(taskId, requestCtx.getDisType());
        if (requestCtx.getDisType() != DisTypeEnum.MANUAL_GET) {
            List<MatchRuleService> sysPlugins = allPlugins.get(MatchRulePluginTypeEnum.SYSTEM.getValue());
            for (MatchRuleService plugin : sysPlugins) {
                result = plugin.match(taskId, result);
                if (!result.isSuccess()) continue;
                if (OtherUtil.isUpImageTask(requestCtx.getDisTask())) {
                    result.setMatchPersonId(0L);
                } else {
                    boolean isRobot = RobertUserGroupUtil.isRobort(sscid, result.getMatchGroupId(), result.getMatchPersonId());
                    if (!isRobot) {
                        this.modifyWorkStatus(sscid, requestCtx, result);
                    }
                }
                return result;
            }
        }
        if (!result.isSuccess()) {
            List<MatchRuleService> rulePlugins = allPlugins.get(MatchRulePluginTypeEnum.RULE.getValue());
            Map<Long, CusDisrulePojo> rules = requestCtx.getRuleInfos();
            if (rules == null || rules.isEmpty()) {
                JSONObject detail = ResultBuildUtil.getOrDefault_Detail(result.getDetail());
                detail.put("message", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5339\u914d\u89c4\u5219", (String)"CoreDistribution_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                result.setSuccess(false);
                return result;
            }
            List<Long> ruleIdSet = this.getRuleIdsOrderByPriority(rules);
            for (long ruleId : ruleIdSet) {
                List<Long> matchGroups;
                MatchRuleService plugin;
                requestCtx.setCurrentRuleId(ruleId);
                Iterator<MatchRuleService> iterator = rulePlugins.iterator();
                while (iterator.hasNext() && (result = (plugin = iterator.next()).match(taskId, result)).isSuccess()) {
                }
                if (!result.isSuccess() || (matchGroups = this.matchGroup(requestCtx, result, isQuality)).isEmpty()) continue;
                this.resortUserGroups(matchGroups);
                if (OtherUtil.isUpImageTask(requestCtx.getDisTask())) {
                    result.setMatchRuleId(ruleId);
                    result.setMatchGroupId(matchGroups.get(0));
                    result.setMatchPersonId(0L);
                    result.setSuccess(true);
                    return result;
                }
                List<MatchRuleService> userMatchPlugins = allPlugins.get(MatchRulePluginTypeEnum.USER.getValue());
                for (long groupId : matchGroups) {
                    MatchRuleService plugin2;
                    requestCtx.setUsergroupId(groupId);
                    Iterator<MatchRuleService> iterator2 = userMatchPlugins.iterator();
                    if (!iterator2.hasNext() || !(result = (plugin2 = iterator2.next()).match(taskId, result)).isSuccess()) continue;
                    return result;
                }
            }
        }
        result.setSuccess(false);
        return result;
    }

    private List<Long> getRuleIdsOrderByPriority(Map<Long, CusDisrulePojo> rules) {
        return rules.values().stream().sorted(new Comparator<CusDisrulePojo>(){

            @Override
            public int compare(CusDisrulePojo o1, CusDisrulePojo o2) {
                return o1.getPriority() - o2.getPriority();
            }
        }).map(CusDisrulePojo::getId).collect(Collectors.toList());
    }

    private void modifyWorkStatus(long sscid, DisRequestCtx requestCtx, MatchRuleResult result) {
        long personId;
        WorkLoadService workload = requestCtx.getWorkload();
        long groupId = result.getMatchGroupId();
        if (!RobertUserGroupUtil.isRobort(sscid, groupId, personId = result.getMatchPersonId())) {
            workload.modifyWorkStatus(personId + "_" + groupId);
        }
    }

    private List<Long> matchGroup(DisRequestCtx requestCtx, MatchRuleResult result, boolean isQuality) {
        ArrayList<Long> matchGroups = new ArrayList<Long>();
        List<Long> allGroups = this.getAllGroups4Rule(requestCtx);
        Map<String, List<MatchRuleService>> allPlugins = isQuality ? requestCtx.getAllQualityPlugins() : requestCtx.getAllAuditPlugins();
        List<MatchRuleService> groupPlugins = allPlugins.get(MatchRulePluginTypeEnum.GROUP.getValue());
        for (long groupId : allGroups) {
            MatchRuleService plugin;
            if (requestCtx.getDisType() == DisTypeEnum.NOPASS_DIS && RobertUserGroupUtil.isRobort(requestCtx.getSscid(), groupId) || requestCtx.getDisType() == DisTypeEnum.MANUAL_GET && RobertUserGroupUtil.isRobort(requestCtx.getSscid(), groupId) || requestCtx.getDisType() == DisTypeEnum.PRE_DIS && RobertUserGroupUtil.isRobort(requestCtx.getSscid(), groupId)) continue;
            requestCtx.setUsergroupId(groupId);
            Iterator<MatchRuleService> iterator = groupPlugins.iterator();
            while (iterator.hasNext() && (result = (plugin = iterator.next()).match(requestCtx.getDisTaskId(), result)).isSuccess()) {
            }
            if (!result.isSuccess()) continue;
            matchGroups.add(groupId);
        }
        return matchGroups;
    }

    private List<Long> getAllGroups4Rule(DisRequestCtx requestCtx) {
        long ruleId = requestCtx.getCurrentRuleId();
        List<OrgSetUserGroupPojo> pojos = requestCtx.getRuleInfos().get(ruleId).getOrgSetUserGroupPojoList();
        return pojos.stream().filter(OrgSetUserGroupPojo::isEnable).map(OrgSetUserGroupPojo::getGroup).collect(Collectors.toList());
    }

    private void notifyWf(DisRequestCtx requestCtx, MatchRuleResult result) {
        boolean success = result.isSuccess() && !OtherUtil.isUpImageTask(requestCtx.getDisTask());
        DisTypeEnum disType = requestCtx.getDisType();
        PluginProxy pluginProxy = requestCtx.getProxy().getNfPluginProxy();
        if (pluginProxy == null) {
            INotifyWfServiceImpl iNotifyWfService = new INotifyWfServiceImpl();
            pluginProxy = PluginProxy.create((Object)iNotifyWfService, INotifyWfService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.notifyWfExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.notifyWf(disType, requestCtx.getDisTask(), success);
            return null;
        });
    }

    private void saveTask(DisRequestCtx requestCtx, MatchRuleResult result) {
        DisTypeEnum disType = requestCtx.getDisType();
        PluginProxy pluginProxy = requestCtx.getProxy().getSvPluginProxy();
        if (pluginProxy == null) {
            ITaskSaveServiceImpl iTaskSaveService = new ITaskSaveServiceImpl();
            pluginProxy = PluginProxy.create((Object)iTaskSaveService, ITaskSaveService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.saveTaskExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.saveTask(disType, requestCtx.getDisTask(), result.isSuccess());
            return null;
        });
    }

    private void stateChange(DisRequestCtx requestCtx, MatchRuleResult result) {
        boolean success = result.isSuccess() && !OtherUtil.isUpImageTask(requestCtx.getDisTask());
        DisTypeEnum disType = requestCtx.getDisType();
        PluginProxy pluginProxy = requestCtx.getProxy().getStPluginProxy();
        if (pluginProxy == null) {
            IStateChangeServiceImpl iStateChangeService = new IStateChangeServiceImpl();
            pluginProxy = PluginProxy.create((Object)iStateChangeService, IStateChangeService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.stateChangeExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.stateChange(disType, requestCtx.getDisTask(), success, requestCtx.getDisTaskOldValueMap());
            return null;
        });
    }

    private void afterDisSingle(DisRequestCtx requestCtx, MatchRuleResult result) {
        boolean success = result.isSuccess() && !OtherUtil.isUpImageTask(requestCtx.getDisTask());
        DisTypeEnum disType = requestCtx.getDisType();
        PluginProxy pluginProxy = requestCtx.getProxy().getAdPluginProxy();
        if (pluginProxy == null) {
            IAfterDisServiceImpl iAfterDisService = new IAfterDisServiceImpl();
            pluginProxy = PluginProxy.create((Object)iAfterDisService, IAfterDisService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.afterDisExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterDisSingle(disType, requestCtx.getDisTask(), success);
            return null;
        });
    }

    private void resortUserGroups(List<Long> matchGroups) {
        Collections.shuffle(matchGroups);
    }
}

