/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.helper.WorkFlowInfoHelper;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.disRebuild.engine.Distribution4Redist;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;

public class Distribution4Predist {
    private static final Log log = LogFactory.getLog(Distribution4Predist.class);

    public static boolean preDistribution(Long taskId, DisRequestCtx ctx) {
        Map<Long, Set<Long>> rtn = Distribution4Redist.matchAllRule4Single(ctx, taskId, false, new ArrayList<Long>());
        if (rtn == null || rtn.isEmpty()) {
            return false;
        }
        return Distribution4Predist.saveMatchResult(ctx, rtn);
    }

    private static boolean saveMatchResult(DisRequestCtx ctx, Map<Long, Set<Long>> rtn) {
        try {
            ArrayList<DynamicObject> saveResults = new ArrayList<DynamicObject>(128);
            DynamicObject task = ctx.getDisTask();
            long typeId = task.getLong("tasktypeid.id");
            long bizBillId = task.getLong("billtype.id");
            long taskId = task.getLong("id");
            long sscId = task.getLong("sscid.id");
            long applier = task.getLong("creator.id");
            List<Long> beforeDealers = Distribution4Predist.getBeforeDealer(task);
            Map<Long, CusDisrulePojo> ruleInfos = ctx.getRuleInfos();
            for (Map.Entry<Long, Set<Long>> entry : rtn.entrySet()) {
                long disRuleId = entry.getKey();
                CusDisrulePojo ruleInfo = ruleInfos.get(disRuleId);
                if (ruleInfo == null) continue;
                int priority = ruleInfo.getPriority();
                for (long groupId : entry.getValue()) {
                    DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_predis_result");
                    newDyo.set("tasktypeid", (Object)typeId);
                    newDyo.set("billtype", (Object)bizBillId);
                    newDyo.set("taskid", (Object)taskId);
                    newDyo.set("sscid", (Object)sscId);
                    newDyo.set("creator", (Object)applier);
                    newDyo.set("bfdealer", (Object)beforeDealers.toString());
                    newDyo.set("matchrule", (Object)disRuleId);
                    newDyo.set("rulepriority", (Object)priority);
                    newDyo.set("usergroup", (Object)groupId);
                    newDyo.set("predistime", (Object)new Date());
                    saveResults.add(newDyo);
                }
            }
            SaveServiceHelper.save((DynamicObject[])saveResults.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            log.error("\u9884\u5206\u914d-\u5206\u914d\u7ed3\u679c\u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    private static List<Long> getBeforeDealer(DynamicObject task) {
        Set aheadHandlerOfSSCNode;
        ArrayList<Long> beforeDealer = new ArrayList<Long>(4);
        Set<Long> persons = Distribution4Predist.getPartaskDealer(task);
        if (!persons.isEmpty()) {
            beforeDealer.addAll(persons);
        }
        if ((aheadHandlerOfSSCNode = WorkFlowInfoHelper.getAheadHandlerOfSSCNode((long)task.getLong("assignid"))) != null) {
            beforeDealer.addAll(aheadHandlerOfSSCNode);
        }
        return beforeDealer;
    }

    private static Set<Long> getPartaskDealer(DynamicObject task) {
        HashSet<Long> bfDealer = new HashSet<Long>(2);
        try {
            String wfTaskIdStr = task.getString("assignid");
            long wfTaskId = Long.parseLong(wfTaskIdStr);
            DynamicObjectCollection parTaskInfos = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"personid", (QFilter[])new QFilter[]{new QFilter("workflowid", "=", (Object)wfTaskId)});
            if (parTaskInfos != null) {
                parTaskInfos.forEach(d -> bfDealer.add(d.getLong("personid")));
            }
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u9884\u5206\u914d-\u83b7\u53d6\u524d\u7f6e\u5904\u7406\u4eba\u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        return bfDealer;
    }
}

