/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;

public class DefaultMatchRuleResult
implements MatchRuleResult {
    private boolean success;
    private long taskId;
    private long matchRuleId;
    private long matchGroupId;
    private long matchPersonId;
    private DisTypeEnum disType;
    private String message;
    private JSONObject detail;
    private Map<Long, List<Long>> matchedRuleAndGroups;
    private static String ENTITY = "task_disdetail";

    public DefaultMatchRuleResult() {
    }

    public DefaultMatchRuleResult(long taskId, DisTypeEnum disType) {
        this.taskId = taskId;
        this.success = false;
        this.matchRuleId = 0L;
        this.matchGroupId = 0L;
        this.matchPersonId = 0L;
        this.disType = disType;
        this.message = "";
        JSONObject detailJSON = new JSONObject();
        detailJSON.put("taskId", (Object)taskId);
        this.detail = detailJSON;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public long getTaskId() {
        return this.taskId;
    }

    @Override
    public long getMatchRuleId() {
        return this.matchRuleId;
    }

    @Override
    public long getMatchGroupId() {
        return this.matchGroupId;
    }

    @Override
    public long getMatchPersonId() {
        return this.matchPersonId;
    }

    @Override
    public DisTypeEnum getDisType() {
        return this.disType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public JSONObject getDetail() {
        return this.detail;
    }

    @Override
    public String jsonFormat() {
        return this.detail.toJSONString();
    }

    @Override
    public Map<Long, List<Long>> getMatchedRuleAndGroups() {
        return this.matchedRuleAndGroups;
    }

    @Override
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    @Override
    public void setMatchRuleId(long matchRuleId) {
        this.matchRuleId = matchRuleId;
    }

    @Override
    public void setMatchGroupId(long matchGroupId) {
        this.matchGroupId = matchGroupId;
    }

    @Override
    public void setMatchPersonId(long matchPersonId) {
        this.matchPersonId = matchPersonId;
    }

    @Override
    public void setDisType(DisTypeEnum disType) {
        this.disType = disType;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setDetail(JSONObject detail) {
        this.detail = detail;
    }

    @Override
    public void setMatchedRuleAndGroups(Map<Long, List<Long>> matchedRuleAndGroups) {
        this.matchedRuleAndGroups = matchedRuleAndGroups;
    }

    @Override
    public long save() {
        DynamicObject saveDyo;
        this.writeDetail();
        QFilter qFilter = new QFilter("taskid", "=", (Object)this.getTaskId());
        boolean isExist = QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{qFilter});
        if (isExist) {
            saveDyo = BusinessDataServiceHelper.loadSingle((String)ENTITY, (QFilter[])new QFilter[]{qFilter});
        } else {
            saveDyo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            saveDyo.set("createtime", (Object)new Date());
        }
        saveDyo.set("taskid", (Object)this.getTaskId());
        saveDyo.set("matchruleid", (Object)this.getMatchRuleId());
        saveDyo.set("usergroupid", (Object)this.getMatchGroupId());
        saveDyo.set("userid", (Object)this.getMatchPersonId());
        saveDyo.set("distype", (Object)this.getDisType().getValue());
        String msg = this.getMessage();
        if (msg != null && msg.length() > 100) {
            msg = msg.substring(0, 100);
        }
        saveDyo.set("message", (Object)msg);
        JSONObject detail = this.getDetail();
        if (detail != null) {
            saveDyo.set("detail_tag", (Object)detail.toJSONString());
        }
        saveDyo.set("success", (Object)this.isSuccess());
        saveDyo.set("modifytime", (Object)new Date());
        DynamicObject[] saveResults = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
        return (Long)saveResults[0].getPkValue();
    }

    private void writeDetail() {
        JSONObject info = this.getDetail();
        if (info == null) {
            info = new JSONObject();
            info.put("taskId", (Object)this.getTaskId());
            this.setDetail(info);
        }
        JSONObject detail = ResultBuildUtil.getOrDefault_Detail(info);
        detail.put("matched", (Object)this.isSuccess());
        if (this.isSuccess()) {
            detail.put("matchedRuleId", (Object)this.getMatchRuleId());
            detail.put("matchedGroupId", (Object)this.getMatchGroupId());
            detail.put("matchedUserId", (Object)this.getMatchPersonId());
        }
        detail.put("distype", (Object)this.getDisType().getValue());
        detail.put("message", (Object)this.getMessage());
    }
}

