/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.BillTypeCusFilterPojo;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;

public class SourceMatchRuleServiceImpl
implements MatchRuleService {
    private DisRequestCtx ctx;

    @Override
    public MatchRuleResult match(long taskId, MatchRuleResult result) {
        result.setSuccess(false);
        long ruleId = this.getRequestCtx().getCurrentRuleId();
        assert (ruleId != 0L);
        CusDisrulePojo ruleInfo = this.getRequestCtx().getRuleInfos().get(ruleId);
        List<BillTypeCusFilterPojo> billTypeCusFilterPojoList = ruleInfo.getBillTypeCusFilterList();
        DynamicObject task = this.getRequestCtx().getDisTask();
        BillCusFilter billCusFilter = this.getRequestCtx().getSourceBillMatch();
        for (BillTypeCusFilterPojo billTypeCusFilterPojo : billTypeCusFilterPojoList) {
            if (task.getLong("billtype.id") != billTypeCusFilterPojo.getBillType() || !billCusFilter.match(task, billTypeCusFilterPojo.getFilterrulejson(), ruleId)) continue;
            result.setSuccess(true);
            break;
        }
        this.buildDetailResult(result);
        return result;
    }

    @Override
    public DisRequestCtx getRequestCtx() {
        return this.ctx;
    }

    @Override
    public void setRequestCtx(DisRequestCtx ctx) {
        this.ctx = ctx;
    }

    private void buildDetailResult(MatchRuleResult result) {
        long ruleId = this.getRequestCtx().getCurrentRuleId();
        JSONObject r_detail = ResultBuildUtil.getOrDefault_r_detail(result.getDetail(), ruleId);
        JSONObject bill = new JSONObject();
        if (!result.isSuccess()) {
            r_detail.put("matched", (Object)false);
            bill.put("matched", (Object)false);
        } else {
            bill.put("matched", (Object)true);
        }
        r_detail.put("bill", (Object)bill);
    }
}

