/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl.after;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.entity.EventTypeEnum;
import kd.ssc.eventSend.entity.PersonChangeTypeEnum;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.helper.MessageHelper;

public class IAfterDisServiceImpl
implements IAfterDisService {
    Log log = LogFactory.getLog(IAfterDisServiceImpl.class);

    @SdkDeprecated
    public void afterDisSingle(DisTypeEnum disType, DynamicObject disTask, boolean isSuccess) {
        if (disType == null || disTask == null) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (!isSuccess || OtherUtil.isUpImageTask(disTask)) {
            return;
        }
        switch (disType) {
            case AUTO_DIS: {
                this.afterDisSingleByAutoDis(disTask);
                break;
            }
            case MANUAL_DIS: {
                break;
            }
            case MANUAL_GET: {
                this.afterDisSingleByManualGet(disTask);
                break;
            }
            case NOPASS_DIS: {
                this.afterDisSingleByNoPassDis(disTask);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
    }

    public void afterDisBatch(DisTypeEnum disType, List<DynamicObject> disTaskList) {
        if (disType == null || CollectionUtils.isEmpty(disTaskList)) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        disTaskList = disTaskList.stream().filter(d -> !OtherUtil.isUpImageTask(d)).collect(Collectors.toList());
        switch (disType) {
            case AUTO_DIS: {
                this.triggerSscEvent(EventTypeEnum.TASK_SYN, disTaskList);
                MessageHelper.sendMessage((DynamicObject[])disTaskList.toArray(new DynamicObject[0]));
                break;
            }
            case MANUAL_DIS: {
                this.triggerSscEvent(EventTypeEnum.TASK_SYN, disTaskList);
                this.triggerSscEvent(EventTypeEnum.PERSON_CHANGE, disTaskList);
                MessageHelper.sendMessage((DynamicObject[])disTaskList.toArray(new DynamicObject[0]));
                break;
            }
            case MANUAL_GET: {
                this.triggerSscEvent(EventTypeEnum.TASK_SYN, disTaskList);
                break;
            }
            case NOPASS_DIS: {
                this.triggerSscEvent(EventTypeEnum.TASK_SYN, disTaskList);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
    }

    private void triggerSscEvent(EventTypeEnum eType, List<DynamicObject> disTaskList) {
        if (CollectionUtils.isEmpty(disTaskList)) {
            return;
        }
        HashMap<Long, List> taskIdMap = new HashMap<Long, List>(8);
        for (DynamicObject dynamicObject : disTaskList) {
            String taskProperty = dynamicObject.getString("tasktypeid.qualityjudge");
            if (TaskPropertyEnum.QUACHECKTASK.getValue().equals(taskProperty)) continue;
            Long sscId = dynamicObject.getLong("sscid.id");
            Long taskId = dynamicObject.getLong("id");
            taskIdMap.computeIfAbsent(sscId, v -> new ArrayList(disTaskList.size())).add(taskId);
        }
        for (Map.Entry entry : taskIdMap.entrySet()) {
            Long sscId = (Long)entry.getKey();
            List taskIdList = (List)entry.getValue();
            if (eType == EventTypeEnum.TASK_SYN) {
                SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.UPDATE, (Long)sscId, (List)taskIdList);
                continue;
            }
            if (eType != EventTypeEnum.PERSON_CHANGE) continue;
            SscEventDistributor.personChangeNotify((Long)sscId, (List)taskIdList, (PersonChangeTypeEnum)PersonChangeTypeEnum.MANUAL_GET);
        }
    }

    private void afterDisSingleByAutoDis(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        if (!OtherUtil.isQualityTask(disTask)) {
            SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.AUTO_DIS);
        }
    }

    private void afterDisSingleByManualGet(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        if (!OtherUtil.isQualityTask(disTask)) {
            SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.MANUAL_GET);
        }
    }

    private void afterDisSingleByNoPassDis(DynamicObject disTask) {
        Long taskId = disTask.getLong("id");
        SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.NOPASS_DIS);
    }
}

