/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl.after;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.INotifyWfService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class INotifyWfServiceImpl
implements INotifyWfService {
    Log log = LogFactory.getLog(INotifyWfServiceImpl.class);

    public void notifyWf(DisTypeEnum disType, DynamicObject disTask, boolean isSuccess) {
        long begin = System.currentTimeMillis();
        if (disType == null || disTask == null) {
            this.log.error("\u5206\u914d\u7c7b\u578b\u6216\u5206\u914d\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (!isSuccess || OtherUtil.isUpImageTask(disTask)) {
            return;
        }
        switch (disType) {
            case AUTO_DIS: {
                this.notifyWfByAutoDis(disType, disTask);
                break;
            }
            case MANUAL_DIS: {
                this.notifyWfByAutoDis(disType, disTask);
                break;
            }
            case MANUAL_GET: {
                this.notifyWfByManualGet(disTask);
                break;
            }
            case NOPASS_DIS: {
                this.notifyWfByAutoDis(disType, disTask);
                break;
            }
            default: {
                this.log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disType);
            }
        }
        long end = System.currentTimeMillis();
        long taskId = disTask.getLong("id");
        String workflowIdStr = disTask.getString("assignid");
        Long workFlowId = StringUtils.isEmpty((String)workflowIdStr) ? 0L : Long.parseLong(workflowIdStr);
        this.log.info(String.format("\u5171\u4eab\u4efb\u52a1\u5206\u914d-\u901a\u77e5\u5de5\u4f5c\u6d41,\u5171\u4eab\u4efb\u52a1Id\uff1a%s,\u5de5\u4f5c\u6d41\u4efb\u52a1Id\uff1a%s,\u8017\u65f6\uff1a%s\u6beb\u79d2", taskId, workFlowId, end - begin));
    }

    private void notifyWfByAutoDis(DisTypeEnum disType, DynamicObject disTask) {
        if (disTask.getLong("qualitysamplelibrary.id") > 0L) {
            return;
        }
        DynamicObject[] normalTask = new DynamicObject[]{disTask};
        OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(normalTask, null);
        TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])normalTask, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskAutoDisTask_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private void notifyWfByManualGet(DynamicObject disTask) {
        String wfTaskId = disTask.getString("assignid");
        if (StringUtils.isNotEmpty((String)wfTaskId)) {
            DynamicObject[] normalTask = new DynamicObject[]{disTask};
            OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(normalTask, null);
            TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])new DynamicObject[]{disTask}, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskAdministrateListPlugin_46", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

