/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.IAfterDisService;
import kd.sdk.fi.ssc.extpoint.disRebuild.IDataPrepareService;
import kd.sdk.fi.ssc.extpoint.disRebuild.INotifyWfService;
import kd.sdk.fi.ssc.extpoint.disRebuild.IStateChangeService;
import kd.sdk.fi.ssc.extpoint.disRebuild.ITaskSaveService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.disenum.MatchRulePluginTypeEnum;
import kd.ssc.task.disRebuild.disenum.TaskAttributeEnum;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.pojo.ProxyPOJO;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.service.impl.after.IAfterDisServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.INotifyWfServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.IStateChangeServiceImpl;
import kd.ssc.task.disRebuild.service.impl.after.ITaskSaveServiceImpl;
import kd.ssc.task.disRebuild.service.impl.before.IDataPrepareServiceImpl;

public class OtherUtil {
    private static final Log log = LogFactory.getLog(OtherUtil.class);

    public static void afterDisBatch(DisTypeEnum disType, List<DynamicObject> disTaskList) {
        if (disTaskList == null || disTaskList.isEmpty()) {
            return;
        }
        try {
            IAfterDisServiceImpl iAfterDisService = new IAfterDisServiceImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)iAfterDisService, IAfterDisService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.afterDisExt");
            pluginProxy.callReplaceIfPresent(p -> {
                p.afterDisBatch(disType, disTaskList);
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u5206\u914d\u540e\u6279\u91cf\u5904\u7406\u62a5\u9519", (Throwable)e);
        }
    }

    public static Map<Long, WorkerStatusPojo> getWordLoad4CurUserInPerGroup(long userId) {
        DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,entryentity.curtasknum_e", (QFilter[])new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.userfield", "=", (Object)userId).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue()).toArray());
        if (userGroups == null) {
            return Collections.emptyMap();
        }
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()).and(new QFilter("personid", "=", (Object)userId));
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        DynamicObjectCollection processingTasks = QueryServiceHelper.query((String)"task_task", (String)"id,usergroup", (QFilter[])new QFilter[]{disedTKFilter});
        Map<Long, List<DynamicObject>> group2Tasks = processingTasks.stream().collect(Collectors.groupingBy(k -> k.getLong("usergroup")));
        HashMap<Long, WorkerStatusPojo> rtnMap = new HashMap<Long, WorkerStatusPojo>(userGroups.size());
        for (DynamicObject userGroup : userGroups) {
            Long gId = userGroup.getLong("id");
            WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
            workerStatusPojo.setUserGroupId(gId);
            workerStatusPojo.setTaskUpper(userGroup.getInt("entryentity.curtasknum_e"));
            List<DynamicObject> tasks = group2Tasks.get(gId);
            workerStatusPojo.setTaskTotal(tasks != null ? tasks.size() : 0);
            rtnMap.put(gId, workerStatusPojo);
        }
        return rtnMap;
    }

    public static boolean isUpImageTask(DynamicObject disTask) {
        String poolType = disTask.getString("pooltype");
        return TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(poolType);
    }

    public static boolean isQualityTask(DynamicObject disTask) {
        long sampleLibraryId = disTask.getLong("qualitysamplelibrary.id");
        return sampleLibraryId > 0L;
    }

    public static Map<String, Object> transDyn(Long matchRuleId, Long userGroupId, Long userId, DynamicObject task, boolean isRobertGroup) {
        HashMap<String, Object> oldState = new HashMap<String, Object>();
        oldState.put("usergroup", task.getLong("usergroup.id"));
        long oldPersonId = task.getLong("personid.id");
        oldState.put("personid", oldPersonId);
        oldState.put("state", task.getString("state"));
        oldState.put("pooltype", task.getString("pooltype"));
        oldState.put("allocatedpersonid", userId);
        task.set("usergroup", (Object)userGroupId);
        long sampleLib = task.getLong("qualitysamplelibrary.id");
        boolean isQuality = sampleLib > 0L;
        task.set("personid", (Object)userId);
        if (isQuality) {
            task.set("orignalperson", (Object)userId);
        }
        Date date = new Date();
        if (!userId.equals(oldPersonId)) {
            task.set("receivetime", (Object)date);
        }
        String curPoolType = task.getString("pooltype");
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
            if (isQuality) {
                task.set("state", (Object)TaskStateEnum.CHECKING.getValue());
            } else {
                task.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
                Object firstreceivetime = task.get("firstreceivetime");
                if (firstreceivetime == null) {
                    task.set("firstreceivetime", (Object)date);
                }
            }
        }
        task.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        task.set("autoprocess", (Object)isRobertGroup);
        task.set("matchrule", (Object)matchRuleId);
        return oldState;
    }

    public static void afterDisSingle(DisTypeEnum disType, DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getAdPluginProxy();
        if (pluginProxy == null) {
            IAfterDisServiceImpl iAfterDisService = new IAfterDisServiceImpl();
            pluginProxy = PluginProxy.create((Object)iAfterDisService, IAfterDisService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.afterDisExt");
        }
        if (disType == DisTypeEnum.MANUAL_DIS) {
            pluginProxy.callReplace(p -> {
                p.afterDisSingle(disType, task, true);
                return null;
            });
        } else {
            pluginProxy.callReplaceIfPresent(p -> {
                p.afterDisSingle(disType, task, true);
                return null;
            });
        }
    }

    public static void stateChange(DisTypeEnum disType, DynamicObject task, Map<String, Object> oldState, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getStPluginProxy();
        if (pluginProxy == null) {
            IStateChangeServiceImpl iStateChangeService = new IStateChangeServiceImpl();
            pluginProxy = PluginProxy.create((Object)iStateChangeService, IStateChangeService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.stateChangeExt");
        }
        if (disType == DisTypeEnum.MANUAL_DIS) {
            pluginProxy.callReplace(p -> {
                p.stateChange(disType, task, true, oldState);
                return null;
            });
        } else {
            pluginProxy.callReplaceIfPresent(p -> {
                p.stateChange(disType, task, true, oldState);
                return null;
            });
        }
    }

    public static void saveTask(DisTypeEnum disType, DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getSvPluginProxy();
        if (pluginProxy == null) {
            ITaskSaveServiceImpl iTaskSaveService = new ITaskSaveServiceImpl();
            pluginProxy = PluginProxy.create((Object)iTaskSaveService, ITaskSaveService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.saveTaskExt");
        }
        if (disType == DisTypeEnum.MANUAL_DIS) {
            pluginProxy.callReplace(p -> {
                p.saveTask(disType, task, true);
                return null;
            });
        } else {
            pluginProxy.callReplaceIfPresent(p -> {
                p.saveTask(disType, task, true);
                return null;
            });
        }
    }

    public static void notifyWf(DisTypeEnum disType, DynamicObject task, ProxyPOJO proxy) {
        PluginProxy pluginProxy = proxy.getNfPluginProxy();
        if (pluginProxy == null) {
            INotifyWfServiceImpl iNotifyWfService = new INotifyWfServiceImpl();
            pluginProxy = PluginProxy.create((Object)iNotifyWfService, INotifyWfService.class, (String)"kd.ssc.task.disRebuild.core.CoreDistribution.notifyWfExt");
        }
        pluginProxy.callReplaceIfPresent(p -> {
            p.notifyWf(disType, task, true);
            return null;
        });
    }

    public static Map<String, List<MatchRuleService>> loadMatchRuleService(DisRequestCtx disRequestCtx, TaskAttributeEnum taskAttributeEnum) {
        HashMap<String, List<MatchRuleService>> matchRuleServiceMap = new HashMap<String, List<MatchRuleService>>(8);
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.SYSTEM.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.RULE.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.GROUP.getValue(), new ArrayList(8));
        matchRuleServiceMap.put(MatchRulePluginTypeEnum.USER.getValue(), new ArrayList(8));
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("attribute", "like", (Object)("%," + taskAttributeEnum.getValue() + ",%"));
        DynamicObject[] matchRulePluginDos = BusinessDataServiceHelper.load((String)"task_matchruleplugin", (String)"id,ssc,plugintype,attribute,pluginpath", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"plugintype asc,pluginseq asc");
        if (matchRulePluginDos != null && matchRulePluginDos.length > 0) {
            for (DynamicObject matchRulePluginDo : matchRulePluginDos) {
                String pluginType = matchRulePluginDo.getString("plugintype");
                String pluginPath = matchRulePluginDo.getString("pluginpath");
                try {
                    Class<?> aClass = Class.forName(pluginPath);
                    MatchRuleService matchRuleService = (MatchRuleService)aClass.newInstance();
                    matchRuleService.setRequestCtx(disRequestCtx);
                    List matchRulePluginList = matchRuleServiceMap.computeIfAbsent(pluginType, k -> new ArrayList(8));
                    matchRulePluginList.add(matchRuleService);
                    matchRuleServiceMap.put(pluginType, matchRulePluginList);
                }
                catch (Exception e) {
                    log.error("kd.ssc.task.disRebuild.engine.Distribution.loadMatchRuleService: \u53cd\u5c04MatchRuleService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return matchRuleServiceMap;
    }

    public static String getNotExistRuleError() {
        return ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9002\u5408\u5f53\u524d\u7528\u6237\u7684\u5206\u914d\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u5206\u914d\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"Distribution_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    }

    public static List<DynamicObject> getAllTask(Long sscid, QFilter qFilter, DisTaskSourceEnum disTaskSource) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (sscid != null && sscid > 0L) {
            filter.and(new QFilter("sscid", "=", (Object)sscid));
        }
        if (qFilter != null) {
            filter.and(qFilter);
        }
        return OtherUtil.prepareData(filter, disTaskSource);
    }

    private static List<DynamicObject> prepareData(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        IDataPrepareServiceImpl iDataPrepareService = new IDataPrepareServiceImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)iDataPrepareService, IDataPrepareService.class, (String)"kd.ssc.task.disRebuild.engine.Distribution.prepareDataExt");
        List allPluginResult = pluginProxy.callReplaceIfPresent(p -> p.prepareData(unDisFilter, disTaskSource));
        ArrayList<DynamicObject> allTaskList = new ArrayList<DynamicObject>(16);
        if (!CollectionUtils.isEmpty((Collection)allPluginResult)) {
            for (List itemList : allPluginResult) {
                if (CollectionUtils.isEmpty((Collection)itemList)) continue;
                allTaskList.addAll(itemList);
            }
        }
        return allTaskList;
    }

    public static void deletePriorityLog(List<Long> jobId) {
        QFilter fjobId = new QFilter("job", "in", jobId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"ssc.deletePriorityLog", (String)"task_prioritychangerecord", (String)"id,job", (QFilter[])fjobId.toArray(), null);
        if (col != null && col.size() > 0) {
            Object[] pks = new Object[col.size()];
            int i = 0;
            for (DynamicObject obj : col) {
                pks[i++] = obj.getLong("id");
            }
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"task_prioritychangerecord"), (Object[])pks);
        }
    }

    public static DynamicObject buildTaskSateChange4ManualDis(DynamicObject disTask, Map<String, Object> disTaskOldValue) {
        if (disTaskOldValue == null || disTaskOldValue.isEmpty()) {
            return null;
        }
        String oldState = (String)disTaskOldValue.get("state");
        String newState = null;
        String curPoolType = (String)disTaskOldValue.get("pooltype");
        long operation = 6L;
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
            boolean isQualityTask;
            operation = 6L;
            newState = TaskStateEnum.TO_BE_AUDIT.getValue();
            boolean bl = isQualityTask = disTask.getLong("qualitysamplelibrary.id") > 0L;
            if (isQualityTask) {
                newState = TaskStateEnum.CHECKING.getValue();
            }
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(curPoolType)) {
            operation = 7L;
            newState = oldState;
        }
        Long allocatedpersonid = (Long)disTaskOldValue.get("allocatedpersonid");
        DynamicObject tscDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        tscDyo.set("jobid", disTask.get("id"));
        tscDyo.set("newjobstate", (Object)newState);
        tscDyo.set("oldjobstate", (Object)oldState);
        tscDyo.set("changetime", (Object)new Date());
        tscDyo.set("operatorid", (Object)RequestContext.get().getCurrUserId());
        tscDyo.set("allocatedpersonid", (Object)allocatedpersonid);
        tscDyo.set("operation", (Object)operation);
        tscDyo.set("tasktype", disTask.get("tasktypeid"));
        tscDyo.set("billtype", disTask.get("billtype"));
        return tscDyo;
    }
}

