/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BillFormListPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    public void initialize() {
        Button btn = (Button)this.getView().getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.getView().returnDataToParent(this.getCurrentSelector());
        this.getView().close();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.getView().returnDataToParent(this.getCurrentSelector());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        List formList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODELTYPE", -9, (Object)"BillFormModel"), new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN"), new SqlParameter(":FNUMBER", 12, (Object)"task_taskadministrate")};
        String sql = "select a.FID, a.FNumber,a.FNAME from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID where b.FMODELTYPE= ? AND FLOCALEID = ? AND b.FNUMBER <> ? order by fnumber";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put("number", rs.getString(2));
                        map.put("name", rs.getString(3));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (formList.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("formlist", formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue("fid", form.get("id"), i);
                model.setValue("fnumber", form.get("number"), i);
                model.setValue("fname", form.get("name"), i);
                ++i;
            }
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("formlist");
        int row = grid.getEntryState().getFocusRow();
        if (row < 0) {
            return null;
        }
        ret.put("id", (String)this.getModel().getValue("fid", row));
        ret.put("name", (String)this.getModel().getValue("fname", row));
        ret.put("number", (String)this.getModel().getValue("fnumber", row));
        return ret;
    }
}

