/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.formplugin.util.ArtiCheckPointUtil;
import kd.ssc.task.formplugin.util.TaskApproveUtil;

public class TaskApproveAssistFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String FLE_CHECK_POINT = "checkpointpanelap";
    public static final String ENTITY_CHECK_POINT = "entryentity";

    public void initialize() {
        super.initialize();
        ControlTypes.register(ApprovalRecord.class);
    }

    public void registerListener(EventObject evt) {
        String poolTypeMyTask = (String)this.getView().getFormShowParameter().getCustomParam("pooltype-mytask");
        if (StringUtils.isNotEmpty((CharSequence)poolTypeMyTask) && !"2".equals(poolTypeMyTask)) {
            AbstractGrid taskBill = (AbstractGrid)this.getView().getControl(ENTITY_CHECK_POINT);
            taskBill.addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"collapsevector", "expandvector", "collapsevector1", "expandvector1", "collapsevector2", "expandvector2"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getPageCache().get("billID") == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String billId = (String)formShowParameter.getCustomParam("billid");
            Long taskid = (Long)formShowParameter.getCustomParam("taskid");
            Long billTypeId = (Long)formShowParameter.getCustomParam("billtypeid");
            Long tasktypeid = (Long)formShowParameter.getCustomParam("tasktypeid");
            String pooltype = (String)formShowParameter.getCustomParam("pooltype");
            boolean isHist = (Boolean)formShowParameter.getCustomParam("isHist");
            this.setArtiCheckPoint(taskid, billTypeId, pooltype, tasktypeid, billId);
            this.setAuditRecord(taskid, billTypeId, isHist);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.intAnchorControl();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String fromPage = (String)showParam.getCustomParam("from");
        String pooltype = (String)showParam.getCustomParam("pooltype");
        if ("admin".equals(fromPage) || TaskPoolTypeEnum.COMPLETE.getValue().equals(pooltype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FLE_CHECK_POINT});
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
        if (arg0.getSource() instanceof CardEntry && ((CardEntry)arg0.getSource()).getKey().equals(ENTITY_CHECK_POINT)) {
            int row = arg0.getRow();
            IPageCache pageCache = this.getView().getPageCache();
            if (!"true".equals(pageCache.get("checkPass"))) {
                IDataModel model = this.getModel();
                Boolean checkboxfieldValue = (Boolean)model.getValue("checkboxfield", row);
                model.beginInit();
                model.setValue("checkboxfield", (Object)(checkboxfieldValue == false ? 1 : 0), row);
                model.endInit();
                this.getView().updateView(ENTITY_CHECK_POINT);
                this.checkBoxFieldChanged(checkboxfieldValue == false);
            }
            pageCache.remove("checkPass");
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        if ("collapsevector".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"collapsevector", ENTITY_CHECK_POINT});
            this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
        } else if ("expandvector".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"collapsevector", ENTITY_CHECK_POINT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
        }
        if ("collapsevector1".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"collapsevector1", "approvalrecordtabpage"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector1"});
        } else if ("expandvector1".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"collapsevector1", "approvalrecordtabpage"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector1"});
        }
        if ("collapsevector2".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"collapsevector2", "pauserecordpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector2"});
        } else if ("expandvector2".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"collapsevector2", "pauserecordpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector2"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object newValue = changeData.getNewValue();
        if ("checkboxfield".equals(name)) {
            this.getView().getPageCache().put("checkPass", "true");
            this.checkBoxFieldChanged((Boolean)newValue);
        } else if ("checkboxall".equalsIgnoreCase(name)) {
            int rowCnt = this.getModel().getEntryRowCount(ENTITY_CHECK_POINT);
            this.getModel().beginInit();
            for (int i = 0; i < rowCnt; ++i) {
                this.getModel().setValue("checkboxfield", newValue, i);
            }
            this.getModel().endInit();
            this.getView().updateView(FLE_CHECK_POINT);
        }
    }

    private void intAnchorControl() {
        String hide2;
        String title1;
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        anchorCtl.setHighlight(true);
        ArrayList<AnchorItems> anchorItems = new ArrayList<AnchorItems>();
        String hide1 = this.getView().getPageCache().get("hide-smartaudit");
        if (!"true".equals(hide1)) {
            title1 = ResManager.loadKDString((String)"\u667a\u5ba1\u5efa\u8bae", (String)"TaskApproveAssistFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            anchorItems.add(new AnchorItems("flex_smartaudit", title1, new ArrayList()));
        }
        if (!"true".equals(hide1 = this.getView().getPageCache().get("hide-bigdata"))) {
            title1 = ResManager.loadKDString((String)"\u5927\u6570\u636e\u5206\u6790", (String)"TaskApproveAssistFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            anchorItems.add(new AnchorItems("flex_bigdata", title1, new ArrayList()));
        }
        if (!"true".equals(hide2 = this.getView().getPageCache().get("hide-checkpointpanelap"))) {
            String title2 = ResManager.loadKDString((String)"\u4eba\u5de5\u68c0\u67e5\u9879", (String)"TaskApproveAssistFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            anchorItems.add(new AnchorItems(FLE_CHECK_POINT, title2, new ArrayList()));
        }
        String title3 = ResManager.loadKDString((String)"\u5ba1\u6279\u8bb0\u5f55", (String)"TaskApproveAssistFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        anchorItems.add(new AnchorItems("flex_approval", title3, new ArrayList()));
        String title4 = ResManager.loadKDString((String)"\u6682\u6302\u8bb0\u5f55", (String)"TaskApproveAssistFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        anchorItems.add(new AnchorItems("flex_pending", title4, new ArrayList()));
        anchorCtl.addItems(anchorItems);
    }

    private void setArtiCheckPoint(Long taskid, Long billTypeId, String pooltype, Long tasktypeid, Object billId) {
        QFilter filter = new QFilter("taskid", "=", (Object)String.valueOf(taskid));
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"articheckpoint as articheckpointid,articheckpoint.name as articheckpointname,iscontented as articheckpointselected", (QFilter[])new QFilter[]{filter});
        if (articheckpointrecords == null || articheckpointrecords.size() == 0) {
            if (TaskPoolTypeEnum.COMPLETE.getValue().equals(pooltype)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLE_CHECK_POINT});
                this.getPageCache().put("hide-checkpointpanelap", "true");
                return;
            }
            articheckpointrecords = ArtiCheckPointUtil.getArtiCheckPointByBillTypeId(billTypeId, String.valueOf(tasktypeid), billId);
            if (articheckpointrecords == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLE_CHECK_POINT});
                this.getPageCache().put("hide-checkpointpanelap", "true");
                return;
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < articheckpointrecords.size(); ++i) {
            DynamicObject articheckpointrecord = (DynamicObject)articheckpointrecords.get(i);
            vs.set("articheckpointid", (Object)articheckpointrecord.getString("articheckpointid"), i);
            vs.set("checkboxfield", (Object)articheckpointrecord.getString("articheckpointselected"), i);
            vs.set("articheckpointname", (Object)articheckpointrecord.getString("articheckpointname"), i);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTITY_CHECK_POINT, vs);
        this.checkBoxFieldChanged(true);
    }

    private void checkBoxFieldChanged(Boolean checkBox) {
        this.getModel().beginInit();
        if (checkBox.booleanValue()) {
            int rowCnt = this.getModel().getEntryRowCount(ENTITY_CHECK_POINT);
            boolean checkAll = true;
            for (int i = 0; i < rowCnt; ++i) {
                if (((Boolean)this.getModel().getValue("checkboxfield", i)).booleanValue()) continue;
                checkAll = false;
                break;
            }
            this.getModel().setValue("checkboxall", (Object)checkAll);
        } else {
            this.getModel().setValue("checkboxall", (Object)Boolean.FALSE);
        }
        this.getModel().endInit();
        this.getView().updateView(FLE_CHECK_POINT);
    }

    private void setAuditRecord(Long taskid, Long billTypeId, boolean isHist) {
        FormShowParameter parameEdit = TaskApproveUtil.setAuditRecord(taskid, billTypeId, isHist);
        this.getView().showForm(parameEdit);
        List<IApprovalRecordGroup> approvalRecordGroups = TaskApproveUtil.setPauseRecord(taskid, isHist);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("isPC", "true");
        ((ApprovalRecord)this.getControl("pauserecordap")).setParameters(params);
        ((ApprovalRecord)this.getControl("pauserecordap")).setArData(approvalRecordGroups);
    }
}

